package cn.com.duiba.tuia.ecb.center.happy.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.ecb.center.happy.dto.HappyClearBlackEventDTO;
import cn.com.duiba.tuia.ecb.center.happy.dto.HappyClearUserMissionDTO;
import cn.com.duiba.tuia.ecb.center.happy.dto.HappyClearWithdrawRecordDTO;
import cn.com.duiba.tuia.ecb.center.happy.dto.PropDto;
import cn.com.duiba.tuia.ecb.center.happy.req.HappyClearMissionReq;
import cn.com.duiba.tuia.ecb.center.happy.req.HappyClearReq;
import cn.com.duiba.tuia.ecb.center.happy.req.HappyClearStarBoxReq;
import com.alibaba.fastjson.JSONObject;

import java.util.List;
import java.util.Map;

@AdvancedFeignClient
public interface RemoteHappyClearService {
    Boolean doJoin(HappyClearReq req) throws BizException;

    JSONObject submit(HappyClearReq req) throws BizException;

    HappyClearWithdrawRecordDTO getWithdrawList(HappyClearReq req) throws BizException;

    Integer openExtraBox(HappyClearStarBoxReq req) throws BizException;

    Boolean submitStarBox(HappyClearStarBoxReq req) throws BizException;

    Boolean checkWithdraw(HappyClearReq req) throws BizException;

    Map<Integer, List<HappyClearUserMissionDTO>> getMissionList(HappyClearReq req) throws BizException;

    List<PropDto> finishMission(HappyClearMissionReq req) throws BizException;

    List<HappyClearBlackEventDTO> getBlackEventsByUserId(String userId) throws BizException;

    Boolean delBlackEventsByUserId(String userId, String remark) throws BizException;
}
