package cn.com.duiba.tuia.ecb.center.mix.dto;

import cn.com.duiba.tuia.ecb.center.mix.dto.tree.MixCashCowDto;

import java.io.Serializable;
import java.util.List;

/**
 * [工具类赚钱页]主DTO
 * <p>
 * 聚合根DTO，用来打通各个模块之间的边界的类
 * <p>
 * 各个部件的信息可以存在这个类中，防止重复查询数据一些重复操作
 *
 * @author zhangbaiqiang
 * @date 2020/1/11
 */
public class MixDto implements Serializable {
    private static final long serialVersionUID = 2468998834672638147L;

    /*
    用户基础数据
     */
    private MixBaseUserDTO baseUser;

    /**
     * 用户信息
     */
    private MixUserDto user;

    /**
     * 媒体相关信息
     */
    private MixAppDTO app;

    /**
     * 新手引导
     */
    private MixGuideDto guide;

    /**
     * 模块配置
     */
    private MixConfigTemplateDTO module;

    /*
     * 摇钱树Data
     */
    private MixCashCowDto mixCashCowDto;

    /**
     * 任务列表
     */
    private List<MixMissionDto> missions;

    /**
     * 奖励
     */
    private MixPrizeDto prize;

    /**
     * 汇率
     */
    private Integer exchangeRate;

    public MixUserDto getUser() {
        return user;
    }

    public void setUser(MixUserDto user) {
        this.user = user;
    }

    public MixConfigTemplateDTO getModule() {
        return module;
    }

    public void setModule(MixConfigTemplateDTO module) {
        this.module = module;
    }

    public List<MixMissionDto> getMissions() {
        return missions;
    }

    public void setMissions(List<MixMissionDto> missions) {
        this.missions = missions;
    }

    public MixCashCowDto getMixCashCowDto() {
        return mixCashCowDto;
    }

    public void setMixCashCowDto(MixCashCowDto mixCashCowDto) {
        this.mixCashCowDto = mixCashCowDto;
    }

    public MixBaseUserDTO getBaseUser() {
        return baseUser;
    }

    public void setBaseUser(MixBaseUserDTO baseUser) {
        this.baseUser = baseUser;
    }

    public MixPrizeDto getPrize() {
        return prize;
    }

    public void setPrize(MixPrizeDto prize) {
        this.prize = prize;
    }

    public MixGuideDto getGuide() {
        return guide;
    }

    public void setGuide(MixGuideDto guide) {
        this.guide = guide;
    }

    public MixAppDTO getApp() {
        return app;
    }

    public void setApp(MixAppDTO app) {
        this.app = app;
    }

    public Integer getExchangeRate() {
        return exchangeRate;
    }

    public void setExchangeRate(Integer exchangeRate) {
        this.exchangeRate = exchangeRate;
    }
}
