package cn.com.duiba.tuia.ecb.center.mystery.remote;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.ecb.center.mix.req.MixUserReq;
import cn.com.duiba.tuia.ecb.center.mystery.dto.MysteryUserInfoDTO;

/**
 * @ClassName RemoteMysteryService
 * @Description 翻牌子开盲盒
 * @Author zaizai
 * @Date 2021/5/8 11:00 上午
 */
@AdvancedFeignClient
public interface RemoteMysteryService {

    /**
     * 初始化用户
     * @param mixUserReq
     * @return
     */
    MysteryUserInfoDTO initUser(MixUserReq mixUserReq) throws BizException;

    /**
     * 参与活动
     * @param mixUserReq
     * @return
     */
    MysteryUserInfoDTO doJoin(MixUserReq mixUserReq) throws BizException;

    /**
     * 获取额外次数
     * @param mixUserReq
     * @return
     */
    MysteryUserInfoDTO getExtraTimes(MixUserReq mixUserReq) throws BizException;
}
