package cn.com.duiba.tuia.engine.activity.remote;

import cn.com.duiba.tuia.ssp.center.api.dto.FileCollectShieldConfigDTO;
import cn.com.duiba.tuia.ssp.center.api.dto.Result;
import cn.com.duiba.tuia.ssp.center.api.params.FileCollectShieldParam;
import cn.com.duiba.tuia.ssp.center.api.remote.RemoteFileCollectShieldConfigService;
import cn.com.duiba.tuia.ssp.center.api.tool.RemoteExcuteTemplateHandle;
import cn.com.duiba.tuia.utils.JsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

import javax.annotation.Resource;

/**
 * @author K. L. Mao
 * @create 2019-12-11
 */
@Service
public class FileCollectShieldService {

    private Logger log = LoggerFactory.getLogger(getClass());

    @Resource
    private RemoteFileCollectShieldConfigService remoteFileCollectShieldConfigService;

    public FileCollectShieldConfigDTO queryFileCollectShieldConfig(FileCollectShieldParam shieldParam) {
        Result<FileCollectShieldConfigDTO> result = RemoteExcuteTemplateHandle.execute(() -> remoteFileCollectShieldConfigService.queryFileCollectShieldConfig(shieldParam),
                log, JsonUtils.objectToString(shieldParam));
        Assert.isTrue(result != null && result.isSuccess(), "获取媒体信息，请求失败，shieldParam:" + shieldParam);
        return result.getData();
    }

}
