package cn.com.duiba.tuia.engine.activity.remote;

import cn.com.duiba.tuia.ssp.center.api.dto.Result;
import cn.com.duiba.tuia.ssp.center.api.dto.sdk.TuiaSdkPutConfigDTO;
import cn.com.duiba.tuia.ssp.center.api.remote.sdk.RemoteMediaPutConfigService;
import cn.com.duiba.tuia.ssp.center.api.tool.RemoteExcuteTemplateHandle;
import cn.com.duiba.tuia.utils.JsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

import javax.annotation.Resource;

/**
 * @author K. L. Mao
 * @create 2019-12-10
 */
@Service
public class MediaPutConfigService {

    private Logger log = LoggerFactory.getLogger(getClass());

    @Resource
    private RemoteMediaPutConfigService remoteMediaPutConfigService;

    /**
     * 获取媒体的 sdk 配置信息
     * @param appId
     * @return
     */
    public TuiaSdkPutConfigDTO querySdkPutConfigByAppId(Long appId) {
        Result<TuiaSdkPutConfigDTO> result = RemoteExcuteTemplateHandle.execute(() -> remoteMediaPutConfigService.querySdkPutConfigByAppId(appId),
                log, JsonUtils.objectToString(appId));
        Assert.isTrue(result != null && result.isSuccess(), "获取媒体的 sdk 配置信息，请求失败，appId:" + appId);
        return result.getData();
    }
}
