/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.dao.advert.impl;

import cn.com.duiba.tuia.constants.ErrorCode;
import cn.com.duiba.tuia.dao.advert.AdvertConsumeDAO;
import cn.com.duiba.tuia.dao.base.TuiaBaseDao;
import cn.com.duiba.tuia.domain.dataobject.AdvertConsumeDO;
import cn.com.duiba.tuia.exception.TuiaException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Repository;

@Repository(value="advertConsumeDAO")
public class AdvertConsumeDAOImpl
extends TuiaBaseDao
implements AdvertConsumeDAO {
    @Override
    public Long getTotalFeeByAccountId(Long accountId, String curDate) throws TuiaException {
        try {
            HashMap<String, Object> param = new HashMap<String, Object>();
            param.put("accountId", accountId);
            param.put("curDate", curDate);
            return (Long)this.getSqlSession().selectOne(this.getStamentNameSpace("getTotalFeeByAccountId"), param);
        }
        catch (Exception e) {
            logger.error("getTotalFeeByAccountId happen [DB] error!", (Throwable)e);
            throw new TuiaException(ErrorCode.E0100001, (Throwable)e);
        }
    }

    @Override
    public Long getTodayConsumeByAdvertId(Long advertId, String curDate) throws TuiaException {
        try {
            HashMap<String, Object> param = new HashMap<String, Object>();
            param.put("advertId", advertId);
            param.put("curDate", curDate);
            return (Long)this.getSqlSession().selectOne(this.getStamentNameSpace("getTodayConsumeByAdvertId"), param);
        }
        catch (Exception e) {
            logger.error("getTodayConsumeByAdvertId happen [DB] error!", (Throwable)e);
            throw new TuiaException(ErrorCode.E0100001, (Throwable)e);
        }
    }

    @Override
    public List<AdvertConsumeDO> getTotalFeeByAccountIds(List<Long> accountIds, String curDate) {
        if (CollectionUtils.isEmpty(accountIds)) {
            return Collections.emptyList();
        }
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("accountIds", accountIds);
        param.put("curDate", curDate);
        return this.getSqlSession().selectList(this.getStamentNameSpace("getTotalFeeByAccountIds"), param);
    }

    @Override
    public Long getTodayConsumeByAdvertPlanId(Long advertPlanId, String today) throws TuiaException {
        try {
            HashMap<String, Object> param = new HashMap<String, Object>();
            param.put("advertPlanId", advertPlanId);
            param.put("curDate", today);
            return (Long)this.getSqlSession().selectOne(this.getStamentNameSpace("getTodayConsumeByAdvertPlanId"), param);
        }
        catch (Exception e) {
            logger.error("getTodayConsumeByAdvertPlanId happen [DB] error!", (Throwable)e);
            throw new TuiaException(ErrorCode.E0100001, (Throwable)e);
        }
    }
}

