/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.dao.advert.impl;

import cn.com.duiba.tuia.constants.ErrorCode;
import cn.com.duiba.tuia.dao.advert.PackageBudgetConsumeDAO;
import cn.com.duiba.tuia.dao.base.TuiaBaseDao;
import cn.com.duiba.tuia.domain.dataobject.PackageBudgetConsumeDO;
import cn.com.duiba.tuia.exception.TuiaException;
import java.util.HashMap;
import java.util.List;
import org.springframework.stereotype.Repository;

@Repository
public class PackageBudgetConsumeDAOImpl
extends TuiaBaseDao
implements PackageBudgetConsumeDAO {
    @Override
    public Long getTodayConsumeByAdvertPkg(Long advertId, Long advertPackageId, String curDate) throws TuiaException {
        try {
            HashMap<String, Object> param = new HashMap<String, Object>(3);
            param.put("advertId", advertId);
            param.put("advertPackageId", advertPackageId);
            param.put("curDate", curDate);
            return (Long)this.getSqlSession().selectOne(this.getStamentNameSpace("getTodayConsumeByAdvertPkg"), param);
        }
        catch (Exception e) {
            logger.error("getTodayConsumeByAdvertPkg happen [DB] error!", (Throwable)e);
            throw new TuiaException(ErrorCode.E0100001, (Throwable)e);
        }
    }

    @Override
    public List<PackageBudgetConsumeDO> getTodayTotalConsumeByAdvert(Long advertId, String curDate) throws TuiaException {
        try {
            HashMap<String, Object> param = new HashMap<String, Object>(2);
            param.put("advertId", advertId);
            param.put("curDate", curDate);
            return this.getSqlSession().selectList(this.getStamentNameSpace("getTodayTotalConsumeByAdvert"), param);
        }
        catch (Exception e) {
            logger.error("getTodayTotalConsumeByAdvert happen [DB] error!", (Throwable)e);
            throw new TuiaException(ErrorCode.E0100001, (Throwable)e);
        }
    }

    @Override
    public PackageBudgetConsumeDO getTodayConsumeByAdvert(Long advertId, String curDate) throws TuiaException {
        try {
            HashMap<String, Object> param = new HashMap<String, Object>(2);
            param.put("advertId", advertId);
            param.put("curDate", curDate);
            return (PackageBudgetConsumeDO)this.getSqlSession().selectOne(this.getStamentNameSpace("getTodayConsumeByAdvert"), param);
        }
        catch (Exception e) {
            logger.error("getTodayConsumeByAdvert happen [DB] error!", (Throwable)e);
            throw new TuiaException(ErrorCode.E0100001, (Throwable)e);
        }
    }
}

