/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.dao.advert.impl;

import cn.com.duiba.tuia.constants.ErrorCode;
import cn.com.duiba.tuia.dao.advert.PeriodIssueCountDAO;
import cn.com.duiba.tuia.dao.base.TuiaBaseDao;
import cn.com.duiba.tuia.domain.dataobject.PeriodIssueCountDO;
import cn.com.duiba.tuia.exception.TuiaException;
import com.google.common.collect.Maps;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.springframework.stereotype.Repository;

@Repository(value="periodIssueCountDAO")
public class PeriodIssueCountDAOImpl
extends TuiaBaseDao
implements PeriodIssueCountDAO {
    @Override
    public int insertPeriodIssueCount(PeriodIssueCountDO t) throws TuiaException {
        try {
            t.setGmtCreate(new Date());
            t.setGmtModified(t.getGmtCreate());
            return this.getSqlSession().insert(this.getStamentNameSpace("insertPeriodIssueCount"), (Object)t);
        }
        catch (Exception e) {
            logger.error("PeriodIssueCountDAOImpl insertPeriodIssueCount happen [DB] error!", (Throwable)e);
            throw new TuiaException(ErrorCode.E0100001, (Throwable)e);
        }
    }

    @Override
    public int updatePeriodIssueCount(Long planPeriodId, int addCount) throws TuiaException {
        try {
            HashMap<String, Number> param = new HashMap<String, Number>(2);
            param.put("planPeriodId", planPeriodId);
            param.put("addCount", addCount);
            return this.getSqlSession().update(this.getStamentNameSpace("updatePeriodIssueCount"), param);
        }
        catch (Exception e) {
            logger.error("PeriodIssueCountDAOImpl updatePeriodIssueCount happen [DB] error!", (Throwable)e);
            throw new TuiaException(ErrorCode.E0100001, (Throwable)e);
        }
    }

    @Override
    public Long selectPeriodIssueCount(Long periodId, String periodType, String curPeriodTime) throws TuiaException {
        try {
            HashMap map = Maps.newHashMapWithExpectedSize((int)3);
            map.put("periodId", periodId);
            map.put("periodType", periodType);
            map.put("curPeriodTime", curPeriodTime);
            Long count = (Long)this.getSqlSession().selectOne(this.getStamentNameSpace("selectPeriodCount"), (Object)map);
            if (count == null) {
                return 0L;
            }
            return count;
        }
        catch (Exception e) {
            logger.error("PeriodIssueCountDAOImpl selectPeriodIssueCount happen [DB] error!", (Throwable)e);
            throw new TuiaException(ErrorCode.E0100001, (Throwable)e);
        }
    }

    @Override
    public int updatePeriodIssueCount(PeriodIssueCountDO t) throws TuiaException {
        try {
            return this.getSqlSession().update(this.getStamentNameSpace("updatePeriodIssueCountDto"), (Object)t);
        }
        catch (Exception e) {
            logger.error("PeriodIssueCountDAOImpl updatePeriodIssueCount happen [DB] error!", (Throwable)e);
            throw new TuiaException(ErrorCode.E0100001, (Throwable)e);
        }
    }

    @Override
    public List<PeriodIssueCountDO> selectPeriodIssueCountList(List<Long> periodIds, String periodType, String curPeriodTime) {
        HashMap map = Maps.newHashMapWithExpectedSize((int)3);
        map.put("periodIds", periodIds);
        map.put("periodType", periodType);
        map.put("curPeriodTime", curPeriodTime);
        return this.getSqlSession().selectList(this.getStamentNameSpace("selectPeriodIssueCountList"), (Object)map);
    }
}

