/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.dao.base;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import org.mybatis.spring.SqlSessionTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.redis.core.StringRedisTemplate;

public class TuiaBaseDao {
    protected static Logger logger = LoggerFactory.getLogger(TuiaBaseDao.class);
    @Resource
    private StringRedisTemplate stringRedisTemplate;
    @Autowired
    @Qualifier(value="tuiaAdverSqlSessionTemplate")
    protected SqlSessionTemplate tuiaAdverSqlSessionTemplate;
    @Autowired
    @Qualifier(value="tuiaSqlSessionTemplate")
    protected SqlSessionTemplate tuiaSqlSessionTemplate;
    @Autowired
    @Qualifier(value="tuiaRecordSqlSessionTemplate")
    protected SqlSessionTemplate tuiaRecordSqlSessionTemplate;
    @Autowired
    @Qualifier(value="advertStatisticsSqlSessionTemplate")
    protected SqlSessionTemplate advertStatisticsSqlSessionTemplate;

    public SqlSessionTemplate getStatisticsSqlSessionTemplate() {
        return this.advertStatisticsSqlSessionTemplate;
    }

    public void setStatisticsSqlSessionTemplate(SqlSessionTemplate advertStatisticsSqlSessionTemplate) {
        this.advertStatisticsSqlSessionTemplate = advertStatisticsSqlSessionTemplate;
    }

    protected SqlSessionTemplate getSqlSession() {
        return this.tuiaAdverSqlSessionTemplate;
    }

    protected String getStamentNameSpace(String method) {
        return this.getClass().getName() + "." + method;
    }

    public SqlSessionTemplate getWareSqlSessionTemplate() {
        return this.tuiaSqlSessionTemplate;
    }

    public SqlSessionTemplate getConsumerSqlSessionTemplate() {
        return this.tuiaRecordSqlSessionTemplate;
    }

    public void setConsumerSqlSessionTemplate(SqlSessionTemplate tuiaRecordSqlSessionTemplate) {
        this.tuiaRecordSqlSessionTemplate = tuiaRecordSqlSessionTemplate;
    }

    protected String subString(String str, int maxLen) {
        if (str == null) {
            return null;
        }
        if (str.length() > maxLen) {
            return str.substring(0, maxLen);
        }
        return str;
    }

    protected Map<String, Object> getTb1024SuffixParamsMap(Long appId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("tb_suffix", this.getTableSuffix(appId));
        return params;
    }

    protected static Map<String, Object> getTb1024SuffixParamsMap(String orderId) {
        try {
            HashMap<String, Object> params = new HashMap<String, Object>();
            String suffix = orderId.substring(orderId.length() - 4);
            Long sufLong = Long.parseLong(suffix);
            if (null == sufLong || sufLong < 0L || sufLong > 1024L) {
                return null;
            }
            params.put("tb_suffix", suffix);
            return params;
        }
        catch (Exception e) {
            return null;
        }
    }

    protected String getTableSuffix(Long appId) {
        long tbInt = appId % 1024L;
        String tb = tbInt + "";
        if (tbInt < 10L) {
            tb = "000" + tbInt;
        } else if (tbInt >= 10L && tbInt < 100L) {
            tb = "00" + tbInt;
        } else if (tbInt >= 100L && tbInt < 1000L) {
            tb = "0" + tbInt;
        }
        return tb;
    }
}

