/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.dao.engine.impl;

import cn.com.duiba.tuia.constants.ErrorCode;
import cn.com.duiba.tuia.dao.base.TuiaBaseDao;
import cn.com.duiba.tuia.dao.engine.AdvertOrderDAO;
import cn.com.duiba.tuia.dao.engine.AdvertOrderWareDAO;
import cn.com.duiba.tuia.domain.dataobject.AdvertOrderDO;
import cn.com.duiba.tuia.domain.dataobject.AdvertOrderExtDO;
import cn.com.duiba.tuia.exception.TuiaException;
import cn.com.duiba.tuia.order.AdvertOrderExtHbaseRepository;
import cn.com.duiba.tuia.order.AdvertOrderHbaseRepository;
import cn.com.duibaboot.ext.autoconfigure.core.utils.CatUtils;
import java.util.List;
import java.util.concurrent.ExecutorService;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository(value="advertOrderDAO")
public class AdvertOrderDAOImpl
extends TuiaBaseDao
implements AdvertOrderDAO {
    private static final String ORDER_RELOG_TABLE = "tuia_relog_log_info";
    @Autowired
    private AdvertOrderWareDAO advertOrderWareDAO;
    @Resource
    private ExecutorService executorService;
    @Resource
    private AdvertOrderHbaseRepository orderHbaseRepository;
    @Resource
    private AdvertOrderExtHbaseRepository advertOrderExtHbaseRepository;

    @Override
    public int insert(AdvertOrderDO advertOrderDO) throws TuiaException {
        return this.commonInsert(advertOrderDO, null);
    }

    private int commonInsert(AdvertOrderDO advertOrderDO, AdvertOrderExtDO orderExtDO) throws TuiaException {
        try {
            boolean result = (Boolean)CatUtils.executeInCatTransaction(() -> this.orderHbaseRepository.insertOrder(advertOrderDO), (String)"orderHbase", (String)"hbaseInsert");
            if (!result) {
                logger.warn("hbase insert order error, result is not true");
                return 0;
            }
            this.executorService.submit(() -> {
                try {
                    this.advertOrderWareDAO.insert(advertOrderDO);
                }
                catch (Exception e) {
                    logger.error("advertOrderWareDAO.insert error,[{}]", (Object)advertOrderDO, (Object)e);
                }
                try {
                    if (orderExtDO != null) {
                        CatUtils.executeInCatTransaction(() -> this.advertOrderExtHbaseRepository.insertOrderExt(orderExtDO), (String)"orderExtHbase", (String)"hbaseInsert");
                    }
                }
                catch (Throwable e) {
                    logger.error("hbase insert order ext error:", e);
                }
            });
            return 1;
        }
        catch (Throwable e) {
            logger.error("hbase insert order error:", e);
            throw new TuiaException(ErrorCode.E0100001, e);
        }
    }

    @Override
    public int insertForRelog(List<AdvertOrderDO> orderDOList) throws TuiaException {
        try {
            boolean result = (Boolean)CatUtils.executeInCatTransaction(() -> this.orderHbaseRepository.insertOrders(orderDOList, ORDER_RELOG_TABLE), (String)"orderHbase", (String)"hbaseBatchInsert");
            if (!result) {
                logger.warn("hbase insert orderList error, result is not true");
                return 0;
            }
            return 1;
        }
        catch (Throwable e) {
            logger.error("hbase insert order error:", e);
            throw new TuiaException(ErrorCode.E0100001, e);
        }
    }

    @Override
    public AdvertOrderDO getAdvertOrder(Long consumerId, String orderId, String tableName) throws TuiaException {
        try {
            return this.orderHbaseRepository.findAdvertOrder(consumerId, orderId, tableName);
        }
        catch (Exception ex) {
            logger.error("getAdvertOrderByOrderId happer [DB] error, the consumerId = [{}], orderId = [{}]", new Object[]{consumerId, orderId, ex});
            throw new TuiaException(ErrorCode.E0100001, (Throwable)ex);
        }
    }

    @Override
    public int insertForDsp(AdvertOrderDO advertOrderDO, AdvertOrderExtDO orderExtDO) throws TuiaException {
        return this.commonInsert(advertOrderDO, orderExtDO);
    }

    @Override
    public AdvertOrderExtDO getAdvertOrderExt(Long consumerId, String orderId) {
        try {
            return this.advertOrderExtHbaseRepository.findAdvertOrderExt(orderId);
        }
        catch (Exception ex) {
            logger.error("getAdvertOrderExt happer [DB] error, the consumerId = [{}], orderId = [{}]", new Object[]{consumerId, orderId, ex});
            return null;
        }
    }
}

