/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.dao.engine.impl;

import cn.com.duiba.tuia.constants.ErrorCode;
import cn.com.duiba.tuia.dao.base.TuiaBaseDao;
import cn.com.duiba.tuia.dao.engine.SystemConfigDAO;
import cn.com.duiba.tuia.domain.dataobject.SystemConfigDO;
import cn.com.duiba.tuia.exception.TuiaException;
import java.util.Date;
import java.util.HashMap;
import org.springframework.stereotype.Repository;

@Repository(value="systemConfigDAO")
public class SystemConfigDAOImpl
extends TuiaBaseDao
implements SystemConfigDAO {
    @Override
    public String getSystemConfig(String tuiaKey) throws TuiaException {
        try {
            return (String)this.getSqlSession().selectOne(this.getStamentNameSpace("getSystemConfig"), (Object)tuiaKey);
        }
        catch (Exception e) {
            logger.error("getSystemConfig happen [DB] error, tuiakey = [{}], the reason = [{}]", (Object)tuiaKey, (Object)e.getMessage());
            throw new TuiaException(ErrorCode.E0100001, (Throwable)e);
        }
    }

    @Override
    public int insert(SystemConfigDO systemConfigDO) throws TuiaException {
        try {
            systemConfigDO.setGmtCreate(new Date());
            systemConfigDO.setGmtModified(systemConfigDO.getGmtCreate());
            return this.getSqlSession().insert(this.getStamentNameSpace("insertSystemConfig"), (Object)systemConfigDO);
        }
        catch (Exception e) {
            logger.error("insert SystemConfig happen [DB] error", (Object)e.getMessage());
            throw new TuiaException(ErrorCode.E0100001, (Throwable)e);
        }
    }

    @Override
    public int updateSystemConfig(String tuiaKey, String tuiaValue) throws TuiaException {
        try {
            HashMap<String, String> param = new HashMap<String, String>();
            param.put("tuiaKey", tuiaKey);
            param.put("tuiaValue", tuiaValue);
            return this.getSqlSession().update(this.getStamentNameSpace("updateSystemConfig"), param);
        }
        catch (Exception e) {
            logger.error("updateSystemConfig happen [DB] error, the reason = [{}]", (Object)e.getMessage());
            throw new TuiaException(ErrorCode.E0100001, (Throwable)e);
        }
    }
}

