/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.dao.ip_library.impl;

import cn.com.duiba.tuia.dao.base.TuiaBaseDao;
import cn.com.duiba.tuia.dao.ip_library.IpLibraryDAO;
import cn.com.duiba.tuia.domain.dataobject.IpLibraryDO;
import cn.com.duiba.wolf.utils.DateUtils;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Lists;
import com.google.common.collect.Range;
import com.google.common.collect.TreeRangeMap;
import com.google.common.util.concurrent.ListenableFutureTask;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.springframework.stereotype.Repository;

@Repository(value="ipLibraryDAO")
public class IpLibraryDAOImpl
extends TuiaBaseDao
implements IpLibraryDAO {
    @Resource
    private ExecutorService executorService;
    private LoadingCache<Integer, Optional<TreeRangeMap<Long, IpLibraryDO>>> loadingCache = CacheBuilder.newBuilder().maximumSize(1000L).refreshAfterWrite(6L, TimeUnit.HOURS).build((CacheLoader)new CacheLoader<Integer, Optional<TreeRangeMap<Long, IpLibraryDO>>>(){

        public Optional<TreeRangeMap<Long, IpLibraryDO>> load(Integer key) {
            return Optional.ofNullable(IpLibraryDAOImpl.this.getIpData());
        }

        public ListenableFutureTask<Optional<TreeRangeMap<Long, IpLibraryDO>>> reload(Integer key, Optional<TreeRangeMap<Long, IpLibraryDO>> prevGraph) {
            ListenableFutureTask task = ListenableFutureTask.create(() -> Optional.ofNullable(IpLibraryDAOImpl.this.getIpData()));
            IpLibraryDAOImpl.this.executorService.submit((Runnable)task);
            return task;
        }
    });

    private TreeRangeMap<Long, IpLibraryDO> getIpData() {
        TreeRangeMap rangeMap = TreeRangeMap.create();
        List<IpLibraryDO> ipList = this.findAll();
        ipList.forEach(x -> rangeMap.put(Range.closed((Comparable)x.getStartIpNum(), (Comparable)x.getEndIpNum()), x));
        return rangeMap;
    }

    @Override
    public IpLibraryDO findByIpLong(Long ipLong) {
        Optional ipList = (Optional)this.loadingCache.getUnchecked((Object)0);
        if (ipList.isPresent()) {
            return Optional.ofNullable(((TreeRangeMap)ipList.get()).get((Comparable)ipLong)).orElse(null);
        }
        return null;
    }

    private List<IpLibraryDO> findAll() {
        try {
            HashMap<String, String> paramMap = new HashMap<String, String>();
            String yesterdayTime = DateUtils.getYesterday() + " 00:00:00";
            paramMap.put("yesterdayTime", yesterdayTime);
            return this.getSqlSession().selectList(this.getStamentNameSpace("findAll"), paramMap);
        }
        catch (Exception e) {
            logger.error("findByIpLong happen [DB] error!", (Throwable)e);
            return Lists.newArrayList();
        }
    }
}

