/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.dao.material.impl;

import cn.com.duiba.tuia.core.api.constant.RedisKeys;
import cn.com.duiba.tuia.core.api.dto.rsp.RspMaterialList;
import cn.com.duiba.tuia.dao.material.AdvertMaterialAppRelationDAO;
import cn.com.duiba.tuia.dao.material.AdvertMaterialDAO;
import cn.com.duiba.tuia.dao.material.AdvertMaterialRealtionService;
import cn.com.duiba.tuia.domain.dataobject.AdvertMaterialCacheDO;
import cn.com.duiba.tuia.domain.dataobject.AdvertMaterialDto;
import cn.com.duiba.tuia.domain.vo.AdvertMaterialVO;
import cn.com.duiba.tuia.enums.CatGroupEnum;
import cn.com.duiba.tuia.enums.NetworkTypeEnum;
import cn.com.duiba.tuia.enums.OperatorsEnum;
import cn.com.duiba.tuia.enums.PlatformTypeEnum;
import cn.com.duiba.tuia.tool.CatUtil;
import cn.com.duiba.tuia.utils.DateUtil;
import cn.com.duiba.wolf.perf.timeprofile.DBTimeProfile;
import cn.com.duiba.wolf.utils.DateUtils;
import cn.com.tuia.advert.cache.CacheKeyTool;
import cn.com.tuia.advert.model.MaterialVideoExt;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Splitter;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.common.primitives.Longs;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListenableFutureTask;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;

@Service
public class AdvertMaterialRealtionServiceImpl
implements AdvertMaterialRealtionService {
    private static final Logger log = LoggerFactory.getLogger(AdvertMaterialRealtionServiceImpl.class);
    public static final Long OLD_MATERIAL_TRAFFIC = 90L;
    public static final Long OLD_MATERIAL_RATIO = 85L;
    private static final String DYNAMIC_NAME_PLACEHOLDER = "{\u52a8\u6001\u5185\u5bb9}";
    @Autowired
    private AdvertMaterialAppRelationDAO advertMaterialAppRelationDAO;
    @Autowired
    private AdvertMaterialDAO advertMaterialDAO;
    @Resource
    protected StringRedisTemplate stringRedisTemplate;
    @Resource
    private ExecutorService executorService;
    private final LoadingCache<Long, Map<Long, List<Long>>> APP_ADVERT_MATERIAL_CACHE = CacheBuilder.newBuilder().initialCapacity(3000).maximumSize(5000L).recordStats().refreshAfterWrite(2L, TimeUnit.MINUTES).expireAfterWrite(6L, TimeUnit.HOURS).build((CacheLoader)new CacheLoader<Long, Map<Long, List<Long>>>(){

        public Map<Long, List<Long>> load(Long key) {
            return AdvertMaterialRealtionServiceImpl.this.loadAppAdvertMaterialCache(key);
        }

        public ListenableFuture<Map<Long, List<Long>>> reload(Long key, Map<Long, List<Long>> oldValue) {
            ListenableFutureTask task = ListenableFutureTask.create(() -> this.load(key));
            AdvertMaterialRealtionServiceImpl.this.executorService.submit((Runnable)task);
            return task;
        }
    });

    private Map<Long, List<Long>> loadAppAdvertMaterialCache(Long appId) {
        List<AdvertMaterialCacheDO> cacheDOList = this.advertMaterialAppRelationDAO.selectGroupByAppId(appId, 0);
        if (CollectionUtils.isEmpty(cacheDOList)) {
            return Collections.emptyMap();
        }
        HashMap<Long, List<Long>> map = new HashMap<Long, List<Long>>(cacheDOList.size());
        cacheDOList.forEach(item -> {
            if (StringUtils.isNotBlank((CharSequence)item.getMaterials())) {
                HashSet sets = Sets.newHashSet((Iterable)Iterables.transform((Iterable)Splitter.on((char)',').split((CharSequence)item.getMaterials()), v -> Longs.tryParse((String)v)));
                sets.remove(null);
                sets.remove(-1L);
                map.put(item.getAdvertId(), new ArrayList(sets));
            }
        });
        return map;
    }

    @Override
    public Map<Long, List<Long>> getAppAdvertMaterialCache(Long appId) {
        try {
            Map map = (Map)this.APP_ADVERT_MATERIAL_CACHE.get((Object)appId);
            return Objects.isNull(map) ? Collections.emptyMap() : map;
        }
        catch (Exception e) {
            CatUtil.log((String)CatGroupEnum.CAT_107011.getCode());
            log.warn("getAppAdvertMaterialCacheError appId={}", (Object)appId, (Object)e);
            return this.loadAppAdvertMaterialCache(appId);
        }
    }

    @Override
    public void updateOldStatus(Long advertId, Long materialId, Long appId) {
        int rows = this.advertMaterialAppRelationDAO.updateNewOldStatus(materialId, appId, 0);
        if (rows == 1) {
            this.updateMaterialList(advertId, appId);
        }
    }

    @Override
    public Boolean isNewOfMaterial(Long advertId, Long materialId, Long appId) {
        int status;
        String key = CacheKeyTool.getCacheKey((Object[])new Object[]{RedisKeys.K03, materialId, appId});
        String value = (String)this.stringRedisTemplate.opsForValue().get((Object)key);
        if (StringUtils.isBlank((CharSequence)value)) {
            status = this.updateNewOldStatus(advertId, materialId, appId);
        } else {
            try {
                status = Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                this.stringRedisTemplate.delete((Object)key);
                return true;
            }
        }
        return 1 == status;
    }

    @Override
    public AdvertMaterialVO getMaterialCache(Long materialId) {
        String value = (String)this.stringRedisTemplate.opsForValue().get((Object)CacheKeyTool.getCacheKey((Object[])new Object[]{RedisKeys.K06, materialId}));
        if (StringUtils.isBlank((CharSequence)value)) {
            AdvertMaterialVO advertMaterialCache = this.updateMaterialCache(materialId);
            return advertMaterialCache;
        }
        return (AdvertMaterialVO)JSONObject.parseObject((String)value, AdvertMaterialVO.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RspMaterialList getMaterialList(Long advertId, Long appId) {
        try {
            DBTimeProfile.enter((String)"getMaterialList");
            String value = (String)this.stringRedisTemplate.opsForValue().get((Object)CacheKeyTool.getCacheKey((Object[])new Object[]{RedisKeys.K04, advertId, appId}));
            if (StringUtils.isBlank((CharSequence)value)) {
                RspMaterialList rspMaterialList;
                RspMaterialList rspMaterialList2 = rspMaterialList = this.updateMaterialList(advertId, appId);
                return rspMaterialList2;
            }
            RspMaterialList rspMaterialList = (RspMaterialList)JSONObject.parseObject((String)value, RspMaterialList.class);
            return rspMaterialList;
        }
        finally {
            DBTimeProfile.release();
        }
    }

    @Override
    public String getMaterialTitle(AdvertMaterialVO advertMaterialVO, String province, Integer netWork, Integer operator, String platform, String city) {
        String productName = advertMaterialVO.getProductName();
        if (advertMaterialVO.getProductNameTag() == null || advertMaterialVO.getProductNameTag() == 0 || StringUtils.isBlank((CharSequence)productName)) {
            return advertMaterialVO.getCouponName();
        }
        StringBuilder prefixes = new StringBuilder();
        switch (advertMaterialVO.getProductNameTag()) {
            case 1: {
                if (StringUtils.isBlank((CharSequence)province)) {
                    return advertMaterialVO.getCouponName();
                }
                prefixes.append(StringUtils.replace((String)province, (String)"\u7701", (String)""));
                break;
            }
            case 2: {
                if (null == netWork) {
                    return advertMaterialVO.getCouponName();
                }
                NetworkTypeEnum networkTypeEnum = NetworkTypeEnum.getByIndex((Integer)netWork);
                if (networkTypeEnum == null || networkTypeEnum == NetworkTypeEnum.OTHER) {
                    return advertMaterialVO.getCouponName();
                }
                prefixes.append(networkTypeEnum.getName());
                break;
            }
            case 3: {
                if (null == operator) {
                    return advertMaterialVO.getCouponName();
                }
                OperatorsEnum operatorsEnum = OperatorsEnum.getByCode((Integer)operator);
                if (operatorsEnum == null || operatorsEnum == OperatorsEnum.OTHER) {
                    return advertMaterialVO.getCouponName();
                }
                prefixes.append(operatorsEnum.getName());
                break;
            }
            case 4: {
                if (StringUtils.isBlank((CharSequence)platform)) {
                    return advertMaterialVO.getCouponName();
                }
                PlatformTypeEnum platformTypeEnum = PlatformTypeEnum.getByDesc((String)platform);
                if (platformTypeEnum == null || platformTypeEnum == PlatformTypeEnum.UNKNOW) {
                    return advertMaterialVO.getCouponName();
                }
                prefixes.append(platformTypeEnum.getcName());
                break;
            }
            case 5: {
                prefixes.append(DateUtil.getWeek());
                break;
            }
            case 6: {
                if (StringUtils.isBlank((CharSequence)city) && StringUtils.isBlank((CharSequence)province)) {
                    return advertMaterialVO.getCouponName();
                }
                city = StringUtils.replace((String)city, (String)"\u5e02", (String)"");
                province = StringUtils.replace((String)province, (String)"\u7701", (String)"");
                if (StringUtils.isNotBlank((CharSequence)city) && StringUtils.length((CharSequence)city) <= 3) {
                    prefixes.append(city);
                }
                if (!StringUtils.isNotBlank((CharSequence)city) || !StringUtils.isNotBlank((CharSequence)province) || StringUtils.length((CharSequence)city) <= 3) break;
                prefixes.append(province);
                break;
            }
        }
        if (StringUtils.isBlank((CharSequence)prefixes.toString())) {
            return advertMaterialVO.getCouponName();
        }
        if (StringUtils.contains((CharSequence)productName, (CharSequence)DYNAMIC_NAME_PLACEHOLDER)) {
            return StringUtils.replace((String)productName, (String)DYNAMIC_NAME_PLACEHOLDER, (String)prefixes.toString());
        }
        prefixes.append(productName);
        return prefixes.toString();
    }

    public AdvertMaterialVO updateMaterialCache(Long materialId) {
        AdvertMaterialDto material = this.advertMaterialDAO.selectById(materialId);
        if (null == material) {
            return null;
        }
        AdvertMaterialVO advertMaterialCache = new AdvertMaterialVO(material.getId(), material.getCouponName(), material.getBannerPng(), material.getButtonText(), material.getDescription());
        advertMaterialCache.setProductName(material.getProductName());
        advertMaterialCache.setProductNameTag(material.getProductNameTag());
        advertMaterialCache.setMaterialName(material.getMaterialName());
        advertMaterialCache.setVideoCoverUrl(material.getVideoCoverUrl());
        advertMaterialCache.setVideoCompletionUrl(material.getVideoCompletionUrl());
        advertMaterialCache.setVideoDuration(material.getVideoDuration());
        advertMaterialCache.setVideoActivityId(material.getVideoActivityId());
        advertMaterialCache.setVideoCompletionUrlVertical(material.getVideoCompletionUrlVertical());
        advertMaterialCache.setVideoCompletionDirection(material.getVideoCompletionDirection());
        advertMaterialCache.setVideoCardUrl(material.getVideoCardUrl());
        try {
            advertMaterialCache.setVideoExt((MaterialVideoExt)JSON.parseObject((String)material.getVideoExt(), MaterialVideoExt.class));
        }
        catch (Exception e) {
            log.warn("\u66f4\u65b0\u7d20\u6750\u7f13\u5b58\u5f02\u5e38", (Throwable)e);
        }
        if (null != material.getPhotoId()) {
            advertMaterialCache.setAtmosphere(material.getAtmosphere());
            advertMaterialCache.setBgColour(material.getBgColour());
            advertMaterialCache.setBodyElement(material.getBodyElement());
            advertMaterialCache.setCarton(material.getCarton());
            advertMaterialCache.setInterception(material.getInterception());
            advertMaterialCache.setIsPrevalent(material.getIsPrevalent());
        }
        this.stringRedisTemplate.opsForValue().set((Object)CacheKeyTool.getCacheKey((Object[])new Object[]{RedisKeys.K06, materialId}), (Object)JSONObject.toJSONString((Object)advertMaterialCache), 1L, TimeUnit.HOURS);
        return advertMaterialCache;
    }

    private int updateNewOldStatus(Long advertId, Long materialId, Long appId) {
        Integer newOldStatus = this.advertMaterialAppRelationDAO.selectNewOldStatus(materialId, appId);
        if (newOldStatus == null) {
            newOldStatus = 1;
            this.stringRedisTemplate.opsForValue().set((Object)CacheKeyTool.getCacheKey((Object[])new Object[]{RedisKeys.K03, materialId, appId}), (Object)newOldStatus.toString(), (long)DateUtils.getToTomorrowSeconds() + (long)new Random().nextInt(10), TimeUnit.SECONDS);
            this.insert(advertId, materialId, appId);
        } else {
            this.stringRedisTemplate.opsForValue().set((Object)CacheKeyTool.getCacheKey((Object[])new Object[]{RedisKeys.K03, materialId, appId}), (Object)newOldStatus.toString(), (long)DateUtils.getToTomorrowSeconds() + (long)new Random().nextInt(10), TimeUnit.SECONDS);
        }
        return newOldStatus;
    }

    private boolean insert(Long advertId, Long materialId, Long appId) {
        boolean isSuccess;
        if (this.stringRedisTemplate.opsForValue().get((Object)CacheKeyTool.getCacheKey((Object[])new Object[]{RedisKeys.K08, materialId, appId})) != null) {
            return true;
        }
        this.stringRedisTemplate.opsForValue().set((Object)CacheKeyTool.getCacheKey((Object[])new Object[]{RedisKeys.K08, materialId, appId}), (Object)"true", 10L, TimeUnit.SECONDS);
        boolean bl = isSuccess = this.advertMaterialAppRelationDAO.insert(advertId, materialId, appId) == 1;
        if (isSuccess) {
            this.updateMaterialList(advertId, appId);
        }
        return isSuccess;
    }

    private RspMaterialList updateMaterialList(Long advertId, Long appId) {
        List<Long> activatedIds = this.advertMaterialDAO.getAvailableMaterialIdsByAdvertId(advertId);
        RspMaterialList rspMaterialList = new RspMaterialList();
        if (CollectionUtils.isNotEmpty(activatedIds)) {
            List<Long> oldIds = this.advertMaterialAppRelationDAO.selectIdsByStatus(advertId, appId, 0);
            oldIds.retainAll(activatedIds);
            rspMaterialList.setOldMaterials(oldIds);
            activatedIds.removeAll(oldIds);
            rspMaterialList.setNewMaterials(activatedIds);
        }
        rspMaterialList.setOldMaterialTraffic(OLD_MATERIAL_TRAFFIC);
        rspMaterialList.setOldMaterialRatio(OLD_MATERIAL_RATIO);
        this.stringRedisTemplate.opsForValue().set((Object)CacheKeyTool.getCacheKey((Object[])new Object[]{RedisKeys.K04, advertId, appId}), (Object)JSONObject.toJSONString((Object)rspMaterialList), 1L, TimeUnit.HOURS);
        return rspMaterialList;
    }
}

