/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.dao.slot.impl;

import cn.com.duiba.tuia.constants.ErrorCode;
import cn.com.duiba.tuia.dao.base.TuiaBaseDao;
import cn.com.duiba.tuia.dao.slot.SlotWhiteListDAO;
import cn.com.duiba.tuia.domain.dataobject.SlotWhiteListDO;
import cn.com.duiba.tuia.exception.TuiaException;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import org.springframework.stereotype.Repository;

@Repository
public class SlotWhiteListDAOImpl
extends TuiaBaseDao
implements SlotWhiteListDAO {
    @Override
    public List<Long> selectList(Long slotId) throws TuiaException {
        try {
            return this.getSqlSession().selectList(this.getStamentNameSpace("selectList"), (Object)slotId);
        }
        catch (Exception e) {
            logger.error("SlotWhiteListDAO.selectList happen [DB] error!", (Throwable)e);
            throw new TuiaException(ErrorCode.E0100001, (Throwable)e);
        }
    }

    @Override
    public List<Long> selectList(String strategyType, Long strategyId, Long slotId) throws TuiaException {
        try {
            HashMap map = Maps.newHashMap();
            map.put("strategyType", strategyType);
            map.put("strategyId", strategyId);
            map.put("slotId", slotId);
            return this.getSqlSession().selectList(this.getStamentNameSpace("selectListTow"), (Object)map);
        }
        catch (Exception e) {
            logger.error("SlotWhiteListDAO.selectList happen [DB] error!", (Throwable)e);
            throw new TuiaException(ErrorCode.E0100001, (Throwable)e);
        }
    }

    @Override
    public List<SlotWhiteListDO> selectBySlotIdAndAdvertId(Long slotId, Long advertId) throws TuiaException {
        try {
            HashMap map = Maps.newHashMap();
            map.put("advertId", advertId);
            map.put("slotId", slotId);
            return this.getSqlSession().selectList(this.getStamentNameSpace("selectBySlotIdAndAdvertId"), (Object)map);
        }
        catch (Exception e) {
            logger.error("SlotWhiteListDAO.selectBySlotIdAndAdvertId happen [DB] error!", (Throwable)e);
            throw new TuiaException(ErrorCode.E0100001, (Throwable)e);
        }
    }
}

