/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.order;

import cn.com.duiba.tuia.dao.base.TuiaBaseDao;
import cn.com.duiba.tuia.domain.dataobject.AdvertOrderExtDO;
import cn.com.duiba.tuia.enums.CatGroupEnum;
import cn.com.duiba.tuia.order.enums.OrderExtHbaseCollEnum;
import cn.com.duiba.tuia.tool.CatUtil;
import cn.com.duiba.tuia.utils.OrderRowKeyUtils;
import cn.com.duibaboot.ext.autoconfigure.core.utils.CatUtils;
import com.netflix.hystrix.contrib.javanica.annotation.DefaultProperties;
import com.netflix.hystrix.contrib.javanica.annotation.HystrixCommand;
import com.netflix.hystrix.contrib.javanica.annotation.HystrixProperty;
import java.util.stream.Stream;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.hadoop.hbase.HbaseTemplate;
import org.springframework.stereotype.Repository;

@DefaultProperties(groupKey="Engine", threadPoolKey="AdvertOrderExtHbaseRepository", threadPoolProperties={@HystrixProperty(name="coreSize", value="20"), @HystrixProperty(name="maxQueueSize", value="20")}, commandProperties={@HystrixProperty(name="execution.isolation.thread.timeoutInMilliseconds", value="200")})
@Repository
public class AdvertOrderExtHbaseRepository
extends TuiaBaseDao {
    @Autowired
    @Qualifier(value="orderHbaseTemplate")
    private HbaseTemplate hbaseTemplate;
    private static final String ORDER_EXT_TABLE = "tuia_order_ext_info";
    private static final String COLL_FAMILY = "cf";

    @HystrixCommand(commandKey="insertOrderExt")
    public boolean insertOrderExt(AdvertOrderExtDO orderExtDO) {
        return (Boolean)this.hbaseTemplate.execute(ORDER_EXT_TABLE, table -> {
            boolean result;
            try {
                Put row = this.buildRow(orderExtDO);
                table.put(row);
                result = true;
            }
            catch (Exception e) {
                logger.error("orderExtHbase insert error, orderId={}", (Object)orderExtDO.getDuibaOrderId(), (Object)e);
                CatUtil.log((String)CatGroupEnum.CAT_107020.getCode());
                result = false;
            }
            return result;
        });
    }

    private Put buildRow(AdvertOrderExtDO orderExtDO) {
        String rowKey = OrderRowKeyUtils.genRowKey((String)orderExtDO.getDuibaOrderId());
        Put row = new Put(rowKey.getBytes());
        row.addColumn(COLL_FAMILY.getBytes(), OrderExtHbaseCollEnum.COLL_EURL.getColl().getBytes(), OrderExtHbaseCollEnum.COLL_EURL.handleCollKey(orderExtDO));
        row.addColumn(COLL_FAMILY.getBytes(), OrderExtHbaseCollEnum.COLL_CURL.getColl().getBytes(), OrderExtHbaseCollEnum.COLL_CURL.handleCollKey(orderExtDO));
        return row;
    }

    @HystrixCommand(commandKey="findAdvertOrderExt")
    public AdvertOrderExtDO findAdvertOrderExt(String orderId) {
        AdvertOrderExtDO result = null;
        try {
            result = (AdvertOrderExtDO)CatUtils.executeInCatTransaction(() -> {
                String rowKey = OrderRowKeyUtils.genRowKey((String)orderId);
                AdvertOrderExtDO orderDO = (AdvertOrderExtDO)this.hbaseTemplate.get(ORDER_EXT_TABLE, rowKey, COLL_FAMILY, this::buildOrderExtDO);
                orderDO.setDuibaOrderId(orderId);
                return orderDO;
            }, (String)"orderHbase", (String)"findByOrderId");
        }
        catch (Throwable e) {
            logger.error("orderHbase findByOrderId error", e);
            CatUtil.log((String)CatGroupEnum.CAT_107013.getCode());
        }
        return result;
    }

    private AdvertOrderExtDO buildOrderExtDO(Result result, int rowNum) {
        AdvertOrderExtDO advertOrderExtDO = new AdvertOrderExtDO();
        Cell[] cells = result.rawCells();
        Stream.of(cells).forEach(cell -> {
            String collKey = new String(cell.getQualifierArray(), cell.getQualifierOffset(), cell.getQualifierLength());
            String collValue = new String(cell.getValueArray(), cell.getValueOffset(), cell.getValueLength());
            OrderExtHbaseCollEnum.getByColl(collKey).handleCollValue(advertOrderExtDO, collValue);
        });
        return advertOrderExtDO;
    }
}

