/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.order;

import cn.com.duiba.tuia.dao.base.TuiaBaseDao;
import cn.com.duiba.tuia.domain.dataobject.AdvertOrderDO;
import cn.com.duiba.tuia.enums.CatGroupEnum;
import cn.com.duiba.tuia.order.enums.OrderHbaseCollEnum;
import cn.com.duiba.tuia.tool.CatUtil;
import cn.com.duiba.tuia.utils.OrderRowKeyUtils;
import cn.com.duibaboot.ext.autoconfigure.core.utils.CatUtils;
import com.netflix.hystrix.contrib.javanica.annotation.DefaultProperties;
import com.netflix.hystrix.contrib.javanica.annotation.HystrixCommand;
import com.netflix.hystrix.contrib.javanica.annotation.HystrixProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.hadoop.hbase.HbaseTemplate;
import org.springframework.stereotype.Repository;

@DefaultProperties(groupKey="Engine", threadPoolKey="AdvertOrderHbaseRepository", threadPoolProperties={@HystrixProperty(name="coreSize", value="20"), @HystrixProperty(name="maxQueueSize", value="20")}, commandProperties={@HystrixProperty(name="execution.isolation.thread.timeoutInMilliseconds", value="200")})
@Repository
public class AdvertOrderHbaseRepository
extends TuiaBaseDao {
    @Autowired
    @Qualifier(value="orderHbaseTemplate")
    private HbaseTemplate hbaseTemplate;
    private static final String ORDER_TABLE = "tuia_order_info";
    private static final String COLL_FAMILY = "cf";

    @HystrixCommand(commandKey="insertOrder", fallbackMethod="insertWithMysql")
    public boolean insertOrder(AdvertOrderDO advertOrderDO) {
        return (Boolean)this.hbaseTemplate.execute(ORDER_TABLE, table -> {
            boolean result;
            try {
                Put row = this.buildRow(advertOrderDO);
                table.put(row);
                result = true;
            }
            catch (Exception e) {
                logger.error("orderHbase insert error, orderId={}", (Object)advertOrderDO.getDuibaOrderId(), (Object)e);
                CatUtil.log((String)CatGroupEnum.CAT_107012.getCode());
                result = false;
            }
            return result;
        });
    }

    @HystrixCommand(commandKey="insertOrders", fallbackMethod="insertBatchHbaseTimeOut")
    public boolean insertOrders(List<AdvertOrderDO> orderDOList, String tableName) {
        return (Boolean)this.hbaseTemplate.execute(tableName, table -> {
            boolean result;
            try {
                ArrayList rowList = new ArrayList(orderDOList.size());
                orderDOList.forEach(advertOrderDO -> rowList.add(this.buildRow((AdvertOrderDO)advertOrderDO)));
                table.put(rowList);
                result = true;
            }
            catch (Exception e) {
                logger.error("orderHbase insert error, orderIds={}", orderDOList.stream().map(AdvertOrderDO::getDuibaOrderId).collect(Collectors.toList()), (Object)e);
                CatUtil.log((String)CatGroupEnum.CAT_107012.getCode());
                result = false;
            }
            return result;
        });
    }

    private Put buildRow(AdvertOrderDO advertOrderDO) {
        String rowKey = OrderRowKeyUtils.genRowKey((String)advertOrderDO.getDuibaOrderId());
        Put row = new Put(rowKey.getBytes());
        row.addColumn(COLL_FAMILY.getBytes(), OrderHbaseCollEnum.COLL_ID.getColl().getBytes(), OrderHbaseCollEnum.COLL_ID.handleCollKey(advertOrderDO));
        row.addColumn(COLL_FAMILY.getBytes(), OrderHbaseCollEnum.COLL_CONSUMER.getColl().getBytes(), OrderHbaseCollEnum.COLL_CONSUMER.handleCollKey(advertOrderDO));
        row.addColumn(COLL_FAMILY.getBytes(), OrderHbaseCollEnum.COLL_APP.getColl().getBytes(), OrderHbaseCollEnum.COLL_APP.handleCollKey(advertOrderDO));
        row.addColumn(COLL_FAMILY.getBytes(), OrderHbaseCollEnum.COLL_SLOT.getColl().getBytes(), OrderHbaseCollEnum.COLL_SLOT.handleCollKey(advertOrderDO));
        row.addColumn(COLL_FAMILY.getBytes(), OrderHbaseCollEnum.COLL_ACTIVITY.getColl().getBytes(), OrderHbaseCollEnum.COLL_ACTIVITY.handleCollKey(advertOrderDO));
        row.addColumn(COLL_FAMILY.getBytes(), OrderHbaseCollEnum.COLL_ADVERT.getColl().getBytes(), OrderHbaseCollEnum.COLL_ADVERT.handleCollKey(advertOrderDO));
        row.addColumn(COLL_FAMILY.getBytes(), OrderHbaseCollEnum.COLL_MATERIAL.getColl().getBytes(), OrderHbaseCollEnum.COLL_MATERIAL.handleCollKey(advertOrderDO));
        row.addColumn(COLL_FAMILY.getBytes(), OrderHbaseCollEnum.COLL_PROMOTE_URL.getColl().getBytes(), OrderHbaseCollEnum.COLL_PROMOTE_URL.handleCollKey(advertOrderDO));
        row.addColumn(COLL_FAMILY.getBytes(), OrderHbaseCollEnum.COLL_GMT_CREATE.getColl().getBytes(), OrderHbaseCollEnum.COLL_GMT_CREATE.handleCollKey(advertOrderDO));
        row.addColumn(COLL_FAMILY.getBytes(), OrderHbaseCollEnum.COLL_GMT_MODIFIED.getColl().getBytes(), OrderHbaseCollEnum.COLL_GMT_MODIFIED.handleCollKey(advertOrderDO));
        row.addColumn(COLL_FAMILY.getBytes(), OrderHbaseCollEnum.COLL_REST.getColl().getBytes(), OrderHbaseCollEnum.COLL_REST.handleCollKey(advertOrderDO));
        row.addColumn(COLL_FAMILY.getBytes(), OrderHbaseCollEnum.COLL_JSON.getColl().getBytes(), OrderHbaseCollEnum.COLL_JSON.handleCollKey(advertOrderDO));
        if (advertOrderDO.getFilterResultLogJson() != null) {
            row.addColumn(COLL_FAMILY.getBytes(), OrderHbaseCollEnum.COLL_FILOG.getColl().getBytes(), OrderHbaseCollEnum.COLL_FILOG.handleCollKey(advertOrderDO));
        }
        return row;
    }

    private boolean insertWithMysql(AdvertOrderDO advertOrderDO) {
        logger.warn("orderHbase insert fallback with mysql orderId={}", (Object)advertOrderDO.getDuibaOrderId());
        return false;
    }

    private boolean insertBatchHbaseTimeOut(List<AdvertOrderDO> orderDOList, String tableName) {
        logger.warn("inserOrders timeout fallback  orderIds={}", orderDOList.stream().map(AdvertOrderDO::getDuibaOrderId).collect(Collectors.toList()));
        return false;
    }

    @HystrixCommand(commandKey="findAdvertOrder", fallbackMethod="findWithMysql")
    public AdvertOrderDO findAdvertOrder(Long consumerId, String orderId, String tableName) {
        AdvertOrderDO result = null;
        try {
            result = (AdvertOrderDO)CatUtils.executeInCatTransaction(() -> {
                String rowKey = OrderRowKeyUtils.genRowKey((String)orderId);
                AdvertOrderDO orderDO = (AdvertOrderDO)this.hbaseTemplate.get(tableName, rowKey, COLL_FAMILY, this::buildOrderDO);
                orderDO.setDuibaOrderId(orderId);
                return orderDO;
            }, (String)"orderHbase", (String)"findByOrderId");
        }
        catch (Throwable e) {
            logger.error("orderHbase findByOrderId error", e);
            CatUtil.log((String)CatGroupEnum.CAT_107013.getCode());
        }
        return result;
    }

    private AdvertOrderDO findWithMysql(Long consumerId, String orderId, String tableName) {
        logger.warn("orderHbase getAdvertOrderByOrderId fallback with mysql orderId={}, tableName:{}", (Object)orderId, (Object)tableName);
        return null;
    }

    private AdvertOrderDO buildOrderDO(Result result, int rowNum) {
        AdvertOrderDO advertOrderDO = new AdvertOrderDO();
        Cell[] cells = result.rawCells();
        Stream.of(cells).forEach(cell -> {
            String collKey = new String(cell.getQualifierArray(), cell.getQualifierOffset(), cell.getQualifierLength());
            String collValue = new String(cell.getValueArray(), cell.getValueOffset(), cell.getValueLength());
            OrderHbaseCollEnum.getByColl(collKey).handleCollValue(advertOrderDO, collValue);
        });
        return advertOrderDO;
    }
}

