package cn.com.duiba.tuia.adx;

import cn.com.duiba.bigdata.dmp.service.api.remoteservice.dto.DeviceTagDto;
import cn.com.duiba.boot.utils.WarningUtils;
import cn.com.duiba.nezha.engine.api.dto.ConsumerDto;
import cn.com.duiba.nezha.engine.api.dto.RcmdAdvertDto;
import cn.com.duiba.tuia.adx.meituan.MeituanAdxService;
import cn.com.duiba.tuia.cache.*;
import cn.com.duiba.tuia.constants.*;
import cn.com.duiba.tuia.dao.engine.ConsumerRecordDAO;
import cn.com.duiba.tuia.domain.dataobject.*;
import cn.com.duiba.tuia.domain.model.*;
import cn.com.duiba.tuia.domain.vo.AdvertFilterVO;
import cn.com.duiba.tuia.domain.vo.AdvertPriceVO;
import cn.com.duiba.tuia.domain.vo.AdvertVO;
import cn.com.duiba.tuia.domain.vo.ConsumerRecordJsonVO;
import cn.com.duiba.tuia.enums.*;
import cn.com.tuia.advert.enums.AdvertFilterTypeEnum;
import cn.com.duiba.tuia.enums.PlatformTypeEnum;
import cn.com.duiba.tuia.enums.adx.AdxFallbackEnum;
import cn.com.duiba.tuia.enums.adx.AdxLoadTypeEnum;
import cn.com.duiba.tuia.exception.TuiaException;
import cn.com.duiba.tuia.filter.AdvertFilterParamVO;
import cn.com.duiba.tuia.filter.service.AdvertFilterService;
import cn.com.duiba.tuia.filter.service.InterestAdvertTagFilter;
import cn.com.duiba.tuia.filter.service.impl.InterestAdvertTagFilterImpl;
import cn.com.duiba.tuia.log.*;
import cn.com.duiba.tuia.pangea.center.api.localservice.apollopangu.ApolloPanGuService;
import cn.com.duiba.tuia.service.*;
import cn.com.duiba.tuia.service.AdvertSystemConfigService.AdvertSystemConfigEnum;
import cn.com.duiba.tuia.tool.CatUtil;
import cn.com.duiba.tuia.tool.StringTool;
import cn.com.duiba.tuia.utils.ActPreUtils;
import cn.com.duiba.wolf.perf.timeprofile.DBTimeProfile;
import cn.com.duiba.wolf.utils.DateUtils;
import cn.com.duibaboot.ext.autoconfigure.core.utils.CatUtils;
import cn.com.tuia.advert.constants.CommonConstant;
import cn.com.tuia.advert.enums.*;
import cn.com.tuia.advert.model.*;
import cn.com.tuia.advert.model.SimpleAppAdvertDto.SimpleMeituanAdvertDto;
import cn.com.tuia.advert.service.IAdxService;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

import static java.util.stream.Collectors.toList;


//@RestController
@Service
public class AdxServiceImpl extends BaseService {

    private static final Logger logger = LoggerFactory.getLogger(AdxServiceImpl.class);

    /**
     * DMP 字符串 截断长度
     */
    public static final int DMP_CUT_LENGTH = 3000;

    /**
     * 活动预发券返回所有可投广告列表
     */
    public static final int PRE_LAUNCH_ALL = -1;

    // 美团这个媒体的广告位
//    @Value("${tuia.meituan.slotid:0}")
//    private Long MEITUAN_SLOT;

    @Autowired
    private AdvertPreFilterService advertPreFilterService;
    @Autowired
    private CommonService commonService;
    @Autowired
    private AdvertExposeService advertExposeService;
    @Autowired
    private ConsumerRecordDAO consumerRecordDAO;
    @Autowired
    private ServiceManager serviceManager;
    @Autowired
    private AdvertRecommendService advertRecommendService;
    @Autowired
    private MediaCacheService mediaCacheService;
    @Autowired
    private AdvertMapCacheManager advertMapCacheManager;
    @Autowired
    private ConsumerRecordSerivce consumerRecordSerivce;
    @Autowired
    private AppPrivilegeService appPrivilegeService;
    @Autowired
    private AdvertPrivilegeService advertPrivilegeService;
    @Qualifier("advertPrivilegeFilterService")
    @Autowired
    private AdvertFilterService privilegeFilterService;

    @Autowired
    private AdvertOrderCacheService advertOrderCacheService;
    @Autowired
    private AdvertWhiteService advertWhiteService;
    @Autowired
    private AdvertRealDataService advertRealDataService;
    @Resource
    protected StringRedisTemplate stringRedisTemplate;
    @Autowired
    private ConsumerService consumerService;

    @Autowired
    private  CatMonitorWarnThreshold catMonitorWarnThreshold;

    @Autowired
    private MeituanAdxService           meituanAdxService;

    @Autowired
    private InterestAdvertTagFilter interestAdvertTagFilter;
    @Resource
    private ActPreCache actPreCache;
    @Autowired
    private TransferDayuService transferDayuService;
    @Autowired
    private ApolloPanGuService apolloPanGuService;

//    @Override
    public ObtainAdvertRsp actPreLoadAdvert(ObtainAdvertReq req) {
        // 添加活动预发券标志 actPreType
        req.setActPre(Boolean.TRUE);
        return loadAdvert(req);
    }

    /**
     * 预发券
     *
     * @param req
     * @return
     */
//    @Override
    public ObtainAdvertRsp preLoadAdvert(ObtainAdvertReq req) {
        return loadAdvert(req);
    }

    /**
     * 真实发券
     *
     * @param req
     * @return
     */
//    @Override
    public ObtainAdvertRsp actLoadAdvert(ObtainAdvertReq req) {
        return loadAdvert(req);
    }

    /**
     * 日志补偿
     * <p>
     * 1、美团adx请求发券时，我方作为dsp返回广告券：请求 IAdxService#preLoadAdvert 接口返回预出的广告券
     * 2、当在美团adx成功竞价，广告券曝光时，将调用此接口进行日志补偿，将会对以下日志进行补偿：
     *      a、请求日志
     *      b、发券日志
     *      c、曝光日志
     * 3、点击及计费日志走原有的逻辑，详情：{@link ISpmService#clickLog(cn.com.tuia.advert.model.SpmlogReq)}
     *
     * @param req 请求参数
     * @return 日志补偿是否成功
     */
//    @Override
    public boolean reLog(AdxLogReq req) {
        return  meituanAdxService.reLog(req);
    }

    @SuppressWarnings("squid:S3776")
    public ObtainAdvertRsp loadAdvert(ObtainAdvertReq req) {
        DBTimeProfile.enter("AdxServiceImpl.loadAdvert");

        ObtainAdvertRsp rsp = new ObtainAdvertRsp();
        rsp.setSlotId(req.getSlotId());
        rsp.setResult(false);
        FilterResult filterResult = new FilterResult();

        // 广告过滤日志
        AdvertFilter advertFilter = new AdvertFilter();
        advertFilter.setAppId(req.getAppId());
        advertFilter.setSlotId(req.getSlotId());
        advertFilter.setOrderId(req.getOrderId());
        advertFilter.setReqSourceType(getReqSourceType(req));
        advertFilter.setActivityId(req.getActivityId());

        Map<Long, AdvertFilterVO> validAdverts;
        AdxLoadTypeEnum loadTypeEnum = null;

        // cat监控区分预发券与真实发券
        String catMonitor = "defAdxAdvert";
        if(AdxLoadTypeEnum.PRE_LOAD.getLoadType() == req.getAdxLoadType()){
            catMonitor = "preAdxAdvert";
            CatUtil.log(CatGroupEnum.CAT_104001.getCode());

        }else if(AdxLoadTypeEnum.ACT_LOAD.getLoadType() == req.getAdxLoadType()){
            catMonitor = "actAdxAdvert";
            CatUtil.log(CatGroupEnum.CAT_104002.getCode());
        }

        try {
            Map<String, String> reqMap = Optional.ofNullable(req.getLogExtMap()).orElse(new HashMap<>());

            // 1.参数组装
            AdxParameters adxParameters = CatUtil.executeInCatTransaction(() -> buildAdxParameters(req, rsp), catMonitor, "buildAdxParameters");

            AdvQueryParam advQueryParam = adxParameters.getAdvQueryParamTmp();
            AppDetail appDetail = adxParameters.getAppDetail();
            ConsumerDto consumerDto = adxParameters.getConsumerDto();
            filterResult = adxParameters.getFilterResult();
            ShieldStrategyVO shieldStrategyVO = adxParameters.getShieldStrategyVO();
            String cityId = adxParameters.getCity();

            final AdvQueryParam advQueryParamTmp = advQueryParam;
            loadTypeEnum = AdxLoadTypeEnum.findByType(req.getAdxLoadType());

            // 2.过滤合法且有效的广告,得到预过滤的广告id列表。特别注意：查询出来的有效广告列表为无序的，在推荐算法发券不成功,降级处理中实现了排序
            FilterResult finalFilterResult = filterResult;
            validAdverts = CatUtils.executeInCatTransaction(() -> advertPreFilterService.preFilterAdvertWithEsHystrix(advQueryParamTmp, req, finalFilterResult, advertFilter), catMonitor, "memoryFilter");

            if (logConfig.getInfoEnable()) {
                logger.info("adx[{}]请求过滤日志，adxId={}, advertFilter={}, adxParameters={}", catMonitor, reqMap.get(AdvertReqLogExtKeyConstant.ADX_RID), JSON.toJSONString(advertFilter), JSON.toJSONString(adxParameters));
            }
            // 无结果时降级
            if(MapUtils.isEmpty(validAdverts)){
                fallBackList(AdxFallbackEnum.FILTER_FALL_BACK, rsp);
                return rsp;
            }

            // 针对区块直投特殊处理
            if (Objects.equals(req.getActivitySceneType(), 3)) {

                // 过滤出白名单的广告
                AdvertPriceVO advertPriceVO = filterByBlockAdvertIds(validAdverts, req.getBlockAdvertIds(), advQueryParam);

                // 区块白名单过滤日志
                blockFilterLog(advertFilter, validAdverts, advertPriceVO);

                // 没有匹配的广告，直接返回
                if (null == advertPriceVO) {
                    fallBackList(AdxFallbackEnum.FILTER_FALL_BACK, rsp);
                    return rsp;
                }

                // 构造广告响应信息
                doObtainAdvertForBlockDirect(req, rsp, advertPriceVO, filterResult, advertFilter);
                return rsp;
            }

            //3.活动预出券，返回所有可投广告列表
            if (ActPreUtils.isActPre(req) && ActPreUtils.getAdvertCount(req).equals(PRE_LAUNCH_ALL)) {
                return activityPreAdvert(validAdverts, rsp);
            }

            // 4、哪吒算法推荐出券
            List<RcmdAdvertDto> rcmdAdvertDtoList = CatUtils.executeInCatTransaction(() -> adxRecommendAdvert(validAdverts, advQueryParam, finalFilterResult, req, rsp, consumerDto, advertFilter) , catMonitor, "recommendAdvert");

            // 4.1 记录nezha过滤日志
            recordNezhaFilterLog(validAdverts, rcmdAdvertDtoList, advertFilter);

            // 预发券时直接返回结果
            if(AdxLoadTypeEnum.PRE_LOAD.equals(loadTypeEnum)){
                FilterResult finalFilterResult1 = filterResult;
                return CatUtils.executeInCatTransaction(()-> packPreLoadAdvert(req, rsp, finalFilterResult1, rcmdAdvertDtoList, advertFilter),catMonitor,"packPreLoadAdvert");
            }

            // 5、如果推荐算法发券不成功，则需要降级处理，走原来的投放逻辑
            if (!rsp.isResult()) {
                /*AdxSetSceneType.SET_REQ_ADX_SCENE.setReqScene(req,AdxSceneEnum.ADX_API.getCode());*/
                CatUtils.executeInCatTransaction(() -> degradeAdxAdvert(finalFilterResult, req, rsp, validAdverts, appDetail, shieldStrategyVO, cityId, advQueryParam, advertFilter), catMonitor,"degradeAdxAdvert");
            }

        } catch (Throwable ex) {
            if (ex instanceof TuiaException) {
                //发券失败监控
                TuiaException e = (TuiaException) ex;
                CatUtil.catLog("obtainAdvertError" + e.getResultCode());
                filterResult.setResultCode(e.getResultCode());
            } else {
                //发券异常监控
                CatUtil.catLog(CatGroupEnum.CAT_102009.getCode());
                filterResult.setResultCode(ErrorCode.E9999999.getErrorCode());
                logger.error("obtainAdvert is exception ", ex);
            }

            fallBackList(AdxFallbackEnum.ERROR_FALL_BACK, rsp);
        } finally {

            filterResult.setStrategyType(rsp.getStrategyType());

            // 真实发券或者美团adx请求 打印filterResult..   加上订单集合为空，做个线上兼容
            if(AdxLoadTypeEnum.ACT_LOAD.equals(loadTypeEnum) || (req.getAdxMediaType() == 1 && req.getOrderIds() == null)){
                FilterResultLog.innerLog(filterResult);
            }

            // 非互动直投打印过滤日志
            if ((!Objects.equals(advertFilter.getReqSourceType(), ReqSourceTypeEnum.HD_DIRECT.getType())&& Objects.equals(AdxLoadTypeEnum.ACT_LOAD.getLoadType(),req.getAdxLoadType()))
            || ReqSourceTypeEnum.MEITUAN_ADX.getType().equals(advertFilter.getReqSourceType())) {
                setAdxRid(advertFilter, req);
                AdvertFilterLog.log(advertFilter);
            }

            DBTimeProfile.release();
        }
        return rsp;

    }

    public void recordNezhaFilterLog(Map<Long, AdvertFilterVO> hasValidAdverts, List<RcmdAdvertDto> rcmdAdvertDtoList, AdvertFilter advertFilter){
        try {
            if (Objects.isNull(hasValidAdverts) || Objects.isNull(advertFilter)) {
                return;
            }
            if (CollectionUtils.isEmpty(rcmdAdvertDtoList)) {
                rcmdAdvertDtoList = new ArrayList<>();
            }
            // 过滤出nezha结果里包含订单id的（不包含订单id的有可能是相同配置但是精简信息的配置）
            List<String> advertIdAndPkgIdList = rcmdAdvertDtoList.stream().filter(item -> Objects.nonNull(item.getOrderId())).map(item -> String.join("_", String.valueOf(item.getAdvertId()), String.valueOf(item.getPackageId()))).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(advertIdAndPkgIdList)) {
                advertIdAndPkgIdList = new ArrayList<>();
            }
            Set<AdvertFilterType> filterTypeSet = new HashSet<>();
            for (Map.Entry<Long, AdvertFilterVO> advertFilterVOEntry : hasValidAdverts.entrySet()) {
                SortedSet<AdvertPriceVO> advertPriceVOSortedSet = advertFilterVOEntry.getValue().getAdvertPriceVOSortedSet();
                if (Objects.isNull(advertPriceVOSortedSet)){
                    continue;
                }
                for (AdvertPriceVO advertPriceVO : advertPriceVOSortedSet) {
                    String advertIdAndPkgId = String.join("_", String.valueOf(advertPriceVO.getAdvertId()), String.valueOf(advertPriceVO.getAdvertOrientationPackageId()));
                    if (advertIdAndPkgIdList.contains(advertIdAndPkgId)) {
                        continue;
                    }
                    filterTypeSet.add(new AdvertFilterType(advertPriceVO.getAdvertId(), advertPriceVO.getAdvertOrientationPackageId(), AdvertFilterTypeEnum.RECOMMEND_FAILED.getCode()));
                }
            }
            // 记录过滤日志
            if (CollectionUtils.isNotEmpty(filterTypeSet)) {
                if (null == advertFilter.getReason()) {
                    advertFilter.setReason(filterTypeSet);
                } else {
                    advertFilter.getReason().addAll(filterTypeSet);
                }
            }
        } catch (Exception e) {
            logger.error("recordNezhaFilterLog error, hasValidAdverts = {}, rcmdAdvertDtoList = {}", JSON.toJSONString(hasValidAdverts),
                    JSON.toJSONString(rcmdAdvertDtoList), e);
        }
    }

    /**
     * 活动预发券返回所有广告列表
     * @param validAdverts
     * @param rsp
     * @return
     */
    public ObtainAdvertRsp activityPreAdvert(Map<Long, AdvertFilterVO> validAdverts, ObtainAdvertRsp rsp) {
        List<ActPreAdvertDto> actPreAdvertList = validAdverts.values().stream().map(vo -> buildActivityPreAdvertDto(vo.getAdvertId())).collect(toList());
        rsp.setActPreAdvertList(actPreAdvertList);
        rsp.setResult(true);
        return rsp;

    }

    /**
     * 构建活动预出券返回广告结果对象信息
     * @param advertId
     * @return
     */
    private ActPreAdvertDto buildActivityPreAdvertDto(Long advertId) {
        ActPreAdvertDto dto = new ActPreAdvertDto();
        dto.setAdvertId(advertId);
        dto.setActMaterialUrl(actPreCache.getActPreImageUrl(advertId));

        //获取优惠券信息
        AdvertCoupon advertCoupon = null;
        try {
            advertCoupon = serviceManager.getAdvertCouponByLocal(advertId);
        } catch (TuiaException e) {
            logger.error("serviceManager.getAdvertCouponByLocal error, advertId={}", advertId ,e);
        }
        if (null != advertCoupon) {
            dto.setCouponRemark(advertCoupon.getCouponRemark());
            dto.setThumbnailPngUrl(advertCoupon.getThumbnailPng());
            dto.setTitle(advertCoupon.getCouponName());
            dto.setViceTitle(advertCoupon.getDescription());
        }
        // 获取广告信息
        AdvertVO advertVO = advertMapCacheManager.getAdvertCache(advertId);
        if (null != advertVO && null != advertVO.getAdvertPlan()) {
            AdvertPlan advertPlan = advertVO.getAdvertPlan();
            dto.setStartValid(DateUtils.getDayStr(advertPlan.getStartDate()));
            dto.setEndValid(DateUtils.getDayStr(advertPlan.getEndDate()));
        }
        return dto;
    }

    /**
     * adx nezha 推荐降级
     *
     * @param filterResult
     * @param req
     * @param rsp
     * @param validAdverts
     * @param appDetail
     * @param shieldStrategyVO
     * @param cityId
     * @param advQueryParam
     * @throws TuiaException
     */
    public Class<Void> degradeAdxAdvert(FilterResult filterResult, ObtainAdvertReq req, ObtainAdvertRsp rsp,
        Map<Long, AdvertFilterVO> validAdverts, AppDetail appDetail, ShieldStrategyVO shieldStrategyVO, String cityId,
        AdvQueryParam advQueryParam, AdvertFilter advertFilter) throws TuiaException {

        if (FilterResult.RECMD_VAILD_LIST_TYPE != filterResult.getType()) {
            filterResult.setType(FilterResult.RECMD_DEGRADE_TYPE);
        }
        // 1、降级后的核心逻辑
        List<AdvertFilterVO> advertFilterVOList = degradeAdverts(req, rsp, filterResult, validAdverts, advertFilter);

        // 2、付费券没有中之后,降级中免费券
        if (!rsp.isResult()) {
            this.doFreeAdverts(req, rsp, advertFilterVOList, filterResult, advertFilter);
        }

        // 3、如果没有结果走特权库
        if (!rsp.isResult()) {
            filterResult.setType(FilterResultTypes.NORMAL_PRIVILEGE);
        }
        privilegeFilter(filterResult, req, shieldStrategyVO, cityId, rsp, appDetail, advQueryParam, advertFilter);

        // 4、如果最终没有匹配到广告,则记录为遍历
        if (!rsp.isResult()) {
            CatUtil.catLog(CatGroupEnum.CAT_107007.getCode());
            filterResult.setResultCode(ErrorCode.E0500003.getErrorCode());
        }
        return Void.TYPE;
    }



    /**
     * 预发券结果返回
     *
     * @param req
     * @param rsp
     * @param rcmdAdvertDtoList
     * @return
     */
    @SuppressWarnings("squid:S3776")
    public ObtainAdvertRsp packPreLoadAdvert(ObtainAdvertReq req, ObtainAdvertRsp rsp, FilterResult filterResult, List<RcmdAdvertDto> rcmdAdvertDtoList, AdvertFilter advertFilter) {

        // 推荐无结果
        if(CollectionUtils.isEmpty(rcmdAdvertDtoList)){
            fallBackList(AdxFallbackEnum.RCM_EMPTY_FALL_BACK, rsp);
            return rsp;
        }

        // nezha推荐接口超过50ms降级
        if(isRcmTimeout(rcmdAdvertDtoList)){
            fallBackList(AdxFallbackEnum.RCM_TIMEOUT_FALL_BACK, rsp);
            return rsp;
        }

        // 是活动预发券
        if (ActPreUtils.isActPre(req)) {
            Integer advertCount = ActPreUtils.getAdvertCount(req);
            List<ActPreAdvertDto> actPreAdvertList = new ArrayList<>(advertCount);
            rcmdAdvertDtoList.stream()
                    .filter(item -> !Objects.equals(req.getAdxSceneType(), AdxSceneEnum.OPTIONAL_AD.getCode())
                            || StringUtils.isNotBlank(item.getOrderId()))
                    .limit(advertCount)
                    .forEach(item -> {
                        ActPreAdvertDto dto = buildActivityPreAdvertDto(item.getAdvertId());
                        dto.setCouponPrice(item.getFee());
                        dto.setOrderId(item.getOrderId());

                        actPreAdvertList.add(dto);
                    });

            // 用户选广告活动需求，需要插入订单用于后续补打日志
            if (Objects.equals(req.getAdxSceneType(), AdxSceneEnum.OPTIONAL_AD.getCode())) {
                insertOrderToHBaseAndRedis(rcmdAdvertDtoList, req, rsp, filterResult);
            }

            rsp.setActPreAdvertList(actPreAdvertList);
            rsp.setResult(true);
            return rsp;
        }

        // 组装结果
        List<AdxLoadAdvertDto> advertDtoList = Lists.newArrayList();
        final int[] rank = { 1 };
        rcmdAdvertDtoList.forEach( rcmdAdvertDto -> {

            AdxLoadAdvertDto dto = new AdxLoadAdvertDto();
            dto.setAdvertId(rcmdAdvertDto.getAdvertId());
            dto.setOrientationId(rcmdAdvertDto.getPackageId());
            dto.setPreCtr(rcmdAdvertDto.getCtr());
            dto.setPreArpu(rcmdAdvertDto.getArpu());
            dto.setFee(rcmdAdvertDto.getFee());
            dto.setMaterialId(rcmdAdvertDto.getMaterialId());
            dto.setAdjustPriceFactor(rcmdAdvertDto.getAdjustPriceFactor());
            dto.setPreCvr(rcmdAdvertDto.getPreCvr());
            dto.setOrderId(rcmdAdvertDto.getOrderId());
            dto.setCtr(rcmdAdvertDto.getCtr());
            dto.setPriceRiseMark(rcmdAdvertDto.getPriceRiseMark());
            dto.setCvrType(rcmdAdvertDto.getCvrType());

            dto.setRank(rank[0]);
            advertDtoList.add(dto);

            rank[0]++;

        });
        rsp.setAdxAdvertList(advertDtoList);
        rsp.setResult(true);

        // 如果是美团adx的请求，则将要记录发券
        if (1 == req.getAdxMediaType()) {
            CatUtil.log(CatGroupEnum.CAT_103001.getCode());

            // 对美团adx做底价处理
                getExceedBidFloorByAdxResultDto(advertDtoList, req, rsp, filterResult, advertFilter);

            return rsp;

        }

        return rsp;
        }

    /**
     * 获取超过底价的第一个广告
     * @param advertDtoList
     * @param req
     * @param rsp
     * @param filterResult
     */
    private void getExceedBidFloorByAdxResultDto(List<AdxLoadAdvertDto> advertDtoList, ObtainAdvertReq req, ObtainAdvertRsp rsp, FilterResult filterResult, AdvertFilter advertFilter){

        //获取美团的广告底价
        Map<String, String> logExtMap = Optional.ofNullable(req.getLogExtMap()).orElse(new HashMap<>());
        String meituanAdxBidFloor = logExtMap.get(AdvertReqLogExtKeyConstant.MEITUAN_ADX_BID_FLOOR);

        // 美团的广告出价比例,媒体管理后台设置的
        String mtadxBidProportion = Optional.ofNullable(logExtMap.get(AdvertReqLogExtKeyConstant.MTADX_BID_PROPORTION)).orElse("100");
        // 因为传过来的是*100的，所以我这边除以100
        BigDecimal bBidProportion = new BigDecimal(mtadxBidProportion).divide(new BigDecimal("100"));

        // 美团流量进行算法参与给媒体出价实验标识
        boolean openMtTest = isOpenMtTest(req);

        try{
            AdxSetSceneType.SET_REQ_ADX_SCENE.setReqScene(req,AdxSceneEnum.ADX_MEITUAN.getCode());

            // 根据传过来的美团底价，进行底价过滤
            List<AdxLoadAdvertDto> exceedBidFloorDtoList = filterAdByMeituanBidFloor(advertDtoList, advertFilter, meituanAdxBidFloor, bBidProportion, openMtTest);

            if(CollectionUtils.isEmpty(exceedBidFloorDtoList)) {
                logger.info("美团adx底价放弃,请求信息:{}, 美团底价:{}, 返回竞价列表:{}", JSONObject.toJSONString(req), meituanAdxBidFloor, JSONObject.toJSONString(advertDtoList));
                CatUtil.log(CatGroupEnum.CAT_103006.getCode());
            }else {

                // 美团那边需要多个广告集合，每个都进行构建订单插入
                // simpleMtAdList 返回给adx-web的简要广告信息.
                List<SimpleMeituanAdvertDto> simpleMtAdList = new ArrayList<>(exceedBidFloorDtoList.size());
                // advertOrderDOList 订单信息集合，每个广告对应一个订单信息集合.
                List<AdvertOrderDO> advertOrderDOList = new ArrayList<>(exceedBidFloorDtoList.size());

                // 遍历广告，构建对应的返回信息，以及订单信息集合
                exceedBidFloorDtoList.forEach(exDto ->  meituanAdxService.recordLaunch(req, rsp, simpleMtAdList, filterResult, exDto, bBidProportion, advertOrderDOList, openMtTest));

                // 哎....批量插入订单
                boolean b = meituanAdxService.insertOrderToHbaseAndRedis(req.getConsumerId(), advertOrderDOList);

                // 如果不为空，则放入到rsp, 且返回成功
                if(CollectionUtils.isNotEmpty(simpleMtAdList) && b){

                    SimpleMeituanAdvertDto simpleMeituanAdvertDto = simpleMtAdList.get(0);

                    rsp.setAdvertId(simpleMeituanAdvertDto.getAdvertId());
                    rsp.setMaterialId(simpleMeituanAdvertDto.getMaterialId());
                    rsp.setAdSpecId(simpleMeituanAdvertDto.getAdSpecId());

                    rsp.setLogExtMap(simpleMeituanAdvertDto.getLogExtMap());

                    rsp.setSimpleMtAdList(simpleMtAdList);
                    rsp.setResult(true);
                }
            }

        }catch (Exception e){
            logger.error("getMaxFeeByAdxResultDto is error,传入底价为:{}", meituanAdxBidFloor, e);
            List<SimpleMeituanAdvertDto> simpleMtAdList = new ArrayList<>();
            List<AdvertOrderDO> advertOrderDOList = new ArrayList<>();
            meituanAdxService.recordLaunch(req, rsp, simpleMtAdList, filterResult, advertDtoList.get(0), bBidProportion, advertOrderDOList, openMtTest);

            // 哎....批量插入订单
            boolean b = meituanAdxService.insertOrderToHbaseAndRedis(req.getConsumerId(), advertOrderDOList);

            if(CollectionUtils.isNotEmpty(simpleMtAdList) && b){
                rsp.setSimpleMtAdList(simpleMtAdList);
                rsp.setResult(true);
            }


        }

    }

    /**
     * 美团流量进行算法参与给媒体出价实验标识
     * @param req
     * @return
     */
    private boolean isOpenMtTest(ObtainAdvertReq req) {

        Map<String, String> logExtExpMap = Optional.ofNullable(req.getLogExtExpMap()).orElse(new HashMap<>());

        // 进行解析
        String mtFlowFilterTest = logExtExpMap.get(AdvertReqLogExtKeyConstant.MT_FLOW_FILTER_TEST);
        try {

            List<FlowShuntGroup> flowShuntGroupList = JSONObject.parseArray(mtFlowFilterTest, FlowShuntGroup.class);

            // 拿到第一个
            FlowShuntGroup flowShuntGroup = flowShuntGroupList.get(0);

            // 返回
            return flowShuntGroup.getFlow_exp_id().equals(FlowShuntGroupEnum.ALG_OFFER_PRICE.getCode().toString()) && GroupTagEnum.openTest(flowShuntGroup.getGroup_tag());

        } catch (Exception e) {
            // 解析有问题，直接返回false,让adx查看格式问题
            logger.error("AdxServiceImpl.isOpenMtTest is error, mtFlowFilterTest:{}", mtFlowFilterTest, e);
            return false;
        }
    }


    /**
     * 美团底价过滤
     * @param advertDtoList 广告集合
     * @param advertFilter 过滤原因对象
     * @param meituanAdxBidFloor 美团底价
     * @param bBidProportion 分成比例
     * @param mtFlowFilterTest 美团流量实验测试
     * @return
     */
    private List<AdxLoadAdvertDto> filterAdByMeituanBidFloor(List<AdxLoadAdvertDto> advertDtoList,
                                                             AdvertFilter advertFilter,
                                                             String meituanAdxBidFloor,
                                                             BigDecimal bBidProportion,
                                                             boolean mtFlowFilterTest) {


        List<AdxLoadAdvertDto> exceedBidFloorDtoList = new ArrayList<>();

        // 如果开启了算法参与底价 实验， 不由engien进行底价判断，直接返回
        if (mtFlowFilterTest) {

            return advertDtoList.stream()
                    .filter(dto -> StringUtils.isNotBlank(dto.getOrderId())).collect(toList());
        }

        // 传过来的低价不为空，进行底价过滤
        if (StringUtils.isNotBlank(meituanAdxBidFloor)) {

            Set<AdvertFilterType> filterTypeSet = new HashSet<>();

            exceedBidFloorDtoList = advertDtoList.stream().filter(dto -> {

                // 如果订单为空，则说明该广告是多余的
                if (StringUtils.isBlank(dto.getOrderId())) {
                    return false;
                }

                // 最终给美团的价格 = 出价 * 出价比例
                BigDecimal finalFee = BigDecimal.valueOf(dto.getFee()).multiply(bBidProportion);

                // 最终价格 >= 底价，则胜出
                boolean flag = finalFee.compareTo(new BigDecimal(meituanAdxBidFloor)) >= 0;
                if (!flag) {
                    // 记录过滤日志
                    filterTypeSet.add(new AdvertFilterType(dto.getAdvertId(), dto.getOrientationId(), AdvertFilterTypeEnum.BID_FLOOR.getCode()));
                }
                return flag;
            }).collect(toList());

            // 记录过滤日志
            if (CollectionUtils.isNotEmpty(filterTypeSet)) {
                if (null == advertFilter.getReason()) {
                    advertFilter.setReason(filterTypeSet);
                } else {
                    advertFilter.getReason().addAll(filterTypeSet);
                }
            }
        }

        return exceedBidFloorDtoList;
    }

    /**
     * 推荐结果中只是一个且计划id为-1，说明发生了接口超过50ms超时降级
     *
     * @param rcmdAdvertDtoList
     * @return
     */
    private boolean isRcmTimeout(List<RcmdAdvertDto> rcmdAdvertDtoList) {
        return rcmdAdvertDtoList.size() == 1 && rcmdAdvertDtoList.get(0).getAdvertId().equals(-1L);
    }

    public void fallBackList(AdxFallbackEnum fallbackEnum, ObtainAdvertRsp rsp) {

        switch (fallbackEnum){
            // 过滤无结果
            case FILTER_FALL_BACK:
                CatUtil.log(CatGroupEnum.CAT_104004.getCode());
                rsp.setAdxAdvertList(Lists.newArrayList());
                return;
            // 参数异常
            case PARAM_FALL_BACK:
                CatUtil.log(CatGroupEnum.CAT_104006.getCode());
                // 返回降级结果
                AdxLoadAdvertDto dto = new AdxLoadAdvertDto();
                dto.setAdvertId(-1L);
                rsp.setAdxAdvertList(Lists.newArrayList(dto));
                return;

            // 推荐超时
            case RCM_TIMEOUT_FALL_BACK:
                CatUtil.log(CatGroupEnum.CAT_104007.getCode());
                AdxLoadAdvertDto timeoutDto = new AdxLoadAdvertDto();
                timeoutDto.setAdvertId(-1L);
                rsp.setAdxAdvertList(Lists.newArrayList(timeoutDto));
                return;

            // 推荐无结果
            case RCM_EMPTY_FALL_BACK:
                CatUtil.log(CatGroupEnum.CAT_104003.getCode());
                rsp.setAdxAdvertList(Lists.newArrayList());
                return;
            default:
                break;
        }
    }

    /**
     * nezha 推荐广告
     *
     * @param validAdverts
     * @param advQueryParam
     * @param filterResult
     * @param req
     * @param rsp
     * @param consumerDto
     * @return
     * @throws TuiaException
     */
    public List<RcmdAdvertDto> adxRecommendAdvert(Map<Long, AdvertFilterVO> validAdverts, AdvQueryParam advQueryParam, FilterResult filterResult, ObtainAdvertReq req, ObtainAdvertRsp rsp, ConsumerDto consumerDto, AdvertFilter advertFilter) throws Throwable {
        try {
            DBTimeProfile.enter("AdxServiceImpl.adxRecommendAdvert");

            // 第二次进行参数构建，主要是哪吒推荐的参数
            FilterResult finalFilterResult = filterResult;
            CatUtils.executeInCatTransaction(()->{
                advertPreFilterService.secondBuildAdvQueryParam(advQueryParam, req, finalFilterResult);
                return null;
            },"adxRecommendAdvert","secondBuildAdvQueryParam---");
            // 调用推荐层进行投放逻辑
            return advertRecommendService.adxRecommendAdvert(req, rsp, filterResult, validAdverts, advQueryParam, consumerDto, advertFilter);
        } finally {
            DBTimeProfile.release();
        }
    }

    public class AdxParameters{
        private FilterResult filterResult;

        private AdvQueryParam advQueryParamTmp;

        private AppDetail appDetail;

        private ShieldStrategyVO shieldStrategyVO;
        private String city;

        private ConsumerDto consumerDto;

        public AdxParameters(FilterResult filterResult, AdvQueryParam advQueryParamTmp, AppDetail appDetail, ShieldStrategyVO shieldStrategyVO, String city,ConsumerDto consumerDto) {
            this.filterResult = filterResult;
            this.advQueryParamTmp = advQueryParamTmp;
            this.appDetail = appDetail;
            this.shieldStrategyVO = shieldStrategyVO;
            this.city = city;
            this.consumerDto = consumerDto;
        }

        public FilterResult getFilterResult() {
            return filterResult;
        }

        public void setFilterResult(FilterResult filterResult) {
            this.filterResult = filterResult;
        }

        public AdvQueryParam getAdvQueryParamTmp() {
            return advQueryParamTmp;
        }

        public void setAdvQueryParamTmp(AdvQueryParam advQueryParamTmp) {
            this.advQueryParamTmp = advQueryParamTmp;
        }

        public AppDetail getAppDetail() {
            return appDetail;
        }

        public void setAppDetail(AppDetail appDetail) {
            this.appDetail = appDetail;
        }

        public ShieldStrategyVO getShieldStrategyVO() {
            return shieldStrategyVO;
        }

        public void setShieldStrategyVO(ShieldStrategyVO shieldStrategyVO) {
            this.shieldStrategyVO = shieldStrategyVO;
        }

        public String getCity() {
            return city;
        }

        public void setCity(String city) {
            this.city = city;
        }

        public ConsumerDto getConsumerDto() {
            return consumerDto;
        }

        public void setConsumerDto(ConsumerDto consumerDto) {
            this.consumerDto = consumerDto;
        }
    }


    public AdxParameters buildAdxParameters(ObtainAdvertReq req, ObtainAdvertRsp rsp) throws Throwable {

        DBTimeProfile.enter("AdxServiceImpl.buildAdxParameters");
        try {

            // 发券类型
            Integer loadType = req.getAdxLoadType();

            // 1.参数校验
            checkAdxLoadAdvertReq(req);

            boolean activityPriorityCondition = commonService.isMeetActivityPriorityCondition(req.getLogExtMap(), req.getIpAreaDto());
            //提前 remote 查询 dmp 人群包。
            final DeviceTagDto deviceTagDto = advertPreFilterService.getDmpTagData(req.getDeviceId(), activityPriorityCondition);
            FilterResult filterResult = new FilterResult(req, null);


            // 2.获取ip对应的城市id
            Integer typeGeo = Optional.ofNullable(req.getAdxMediaType()).orElse(0) == 0 ? 1 : 2;
            AdvQueryParam advQueryParam = CatUtils.executeInCatTransaction(() -> commonService.ipOrCityIdGeoAnalysis(req.getIp(), req.getCityId(), typeGeo, req.getLogExtMap(), activityPriorityCondition, deviceTagDto, filterResult), "buildAdxParameters", "ipGeoAnalysis");
            String cityId = advQueryParam.getRegionId();
            filterResult.setCityId(cityId);
            Optional.ofNullable(deviceTagDto.getRegionInfoTags()).ifPresent(temp -> filterResult.setDmpRegion(JSON.toJSONString(temp)));

            final Map<String, String> newUserDmpTagsMap = interestAdvertTagFilter.getThirdPartDmpTag(req);

            Set<String> slotSet = new HashSet<>();
            try {
                String meituanSlotStr = apolloPanGuService.getIdMapStrByKeyStr("meituan-slots");
                String[] split = meituanSlotStr.split(",");
                slotSet.addAll(Arrays.asList(split));
            } catch (Exception e) {
                logger.error("查询盘古配置并序列化过程失败",e);
            }

            // 真实发券，或者美团发券，调用大禹进行切流
            if(AdxLoadTypeEnum.ACT_LOAD.getLoadType() == loadType || slotSet.contains(String.valueOf(req.getSlotId()))){

                // 调用大禹切流
                transferDayuService.dayuCutByMajorOcpc(req, advQueryParam);

            }

            // 3.真实发券才打印请求日志
            if(AdxLoadTypeEnum.ACT_LOAD.getLoadType() == loadType){

                SpmLog.log(req, SpmType.SPM_LOG_REQUEST);
                bagCityIdInLogMap(req, cityId);
                bagDmpPackageInLogMap(req,deviceTagDto,newUserDmpTagsMap);
                StatRequestJsonLog.log(req);
            }

            // 4.获取用户领取记录
            List<ConsumerInteractiveRecordDO> consumerVOList = CatUtils.executeInCatTransaction(() -> getConsumerRecord(req.getConsumerId()),"buildAdxParameters","getConsumerRecord");
            consumerService.setFilterResultConsumeList(filterResult, consumerVOList);
            List<ConsumerInteractiveRecordDO> todayConsumeList = filterResult.getTodayConsumeList();

            // 6.获取当前请求的应用信息和屏蔽策略
            AppDetail appDetail = CatUtils.executeInCatTransaction(() -> mediaCacheService.getAppDetailCache(req.getAppId(), req.getSlotId(), rsp, req.getProxy(), cityId, req),"buildAdxParameters","getAppDetailCache");
            ShieldStrategyVO shieldStrategyVO = appDetail.getShieldStrategyVO();
            filterResult.setShieldMaterialTags(shieldStrategyVO.getShieldMaterialTags());
            filterResult.setAdvBannedTag(shieldStrategyVO.getAdvBannedTag());

            // 7.查询该用户在重复领取天数内领取过的广告ID列表
            AdvQueryParam finalAdvQueryParam = advQueryParam;
            List<Long> receiveAdvertIds = CatUtils.executeInCatTransaction(() -> advertOrderCacheService.getReceiveAdvertIds(consumerVOList, finalAdvQueryParam),"buildAdxParameters","getReceiveAdvertIds");

            ConsumerDto consumerDto = new ConsumerDto();
            consumerDto.setConsumerId(req.getConsumerId());
            consumerDto.setDeviceId(req.getDeviceId());

            // 8.封装过滤参数
            final AdvQueryParam advQueryParamTmp = advQueryParam;
            final List<ConsumerInteractiveRecordDO> consumerVOListTmp = consumerVOList;
            advQueryParam = CatUtils.executeInCatTransaction(() -> advertPreFilterService.buildAdvQueryParam(advQueryParamTmp, req, rsp, shieldStrategyVO, consumerVOListTmp, receiveAdvertIds, consumerDto, filterResult, deviceTagDto, newUserDmpTagsMap),"buildAdxParameters","buildAdvQueryParam");

            // 9.打印用户对应相似行业人群接受度
            if(AdxLoadTypeEnum.ACT_LOAD.getLoadType() == loadType) {
                SimilarAdvertStatLog.log(advQueryParam.getSimilarAdvertLogList());
            }

            // 10.丰富过滤日志参数

            CatUtils.executeInCatTransaction(() -> {
                buildFilterResult(filterResult, consumerVOList, advQueryParamTmp);
                return null;
            },"buildAdxParameters","buildFilterResult");

            return new AdxParameters(filterResult, advQueryParam, appDetail, shieldStrategyVO, cityId, consumerDto);
        }catch (Throwable e){
            if(e instanceof TuiaException){
            }else {
                logger.error("buildAdxParameters error", e);
            }
            throw e;
        }  finally {
            DBTimeProfile.release();
        }
    }

    private ObtainAdvertReq bagDmpPackageInLogMap(ObtainAdvertReq req, DeviceTagDto deviceTagDto, Map<String, String> newUserDmpTagsMap) {

        List<String> packageList = new LinkedList<>();
        Optional.ofNullable(deviceTagDto.getOfflineTagPackage()).ifPresent(tags->packageList.addAll(tags));
        Optional.ofNullable(deviceTagDto.getBusinessTagPackage()).ifPresent(tags->packageList.addAll(tags));

        newUserDmpTagsMap.forEach((key,value)->{
            if(null != value && InterestAdvertTagFilterImpl.NEW_DMP_HIT_VALUE.equals(value)){
                packageList.add(key);
            }
        });

        String packageStr = StringTool.getStringByList(packageList);
        //超过3k,截断
        if(packageStr.length() > DMP_CUT_LENGTH){
            req.getLogExtMap().put(AdvertReqLogExtKeyConstant.DMP_PACKAGE , dealStr(packageStr,DMP_CUT_LENGTH));
            req.getLogExtMap().put(AdvertReqLogExtKeyConstant.DMP_PACKAGE_IS_TOO_LONG , "1");
        }else{
            req.getLogExtMap().put(AdvertReqLogExtKeyConstant.DMP_PACKAGE , packageStr);
            req.getLogExtMap().put(AdvertReqLogExtKeyConstant.DMP_PACKAGE_IS_TOO_LONG , "0");
        }

        return req;
    }

    private String dealStr(String packageStr,int length) {
        try{
            String substring = packageStr.substring(0, length);
            int index = substring.lastIndexOf(",");
            return index>0?substring.substring(0,index):"";
        }catch (Exception e){
            logger.error("dmp 日志截断异常",e);
            return "";
        }
    }

    /**
     * 降级优先中付费券
     * manualAdvert:(). <br/>
     * @author zp
     * @param req
     * @param rsp
     * @param filterResult
     * @param validAdverts
     * @param validAdvertOrderLevelMap
     * @return
     * @throws TuiaException
     * @since JDK 1.6
     */
    private List<AdvertFilterVO> manualAdvert(ObtainAdvertReq req,ObtainAdvertRsp rsp, FilterResult filterResult,
        Map<Long, AdvertFilterVO> validAdverts,Map<Long, Integer> validAdvertOrderLevelMap, AdvertFilter advertFilter)
        throws TuiaException{
        Integer validAdvertIdsSize = validAdvertOrderLevelMap.size();
        List<AdvertFilterVO> advertFilterVOList = validAdverts.values().stream().map(dto -> {
            Integer order = Optional.ofNullable(validAdvertOrderLevelMap.get(dto.getAdvertId())).orElse(validAdvertIdsSize);
            dto.setOrder(order);
            return dto;
        }).sorted(Comparator.comparing(AdvertFilterVO::getOrder)).collect(toList());

        //后面的降级处理都把开启了扶持的广告移除掉
        advertFilterVOList.forEach(item -> item.getManualAdvertSet().removeIf(x -> (Optional.ofNullable(x.getSupportStatus()).orElse(CommonConstant.NO) == CommonConstant.YES)));

        //优先中付费券
        List<AdvertFilterVO> expenseAdverts = advertFilterVOList.stream().filter(item ->
            item.getManualAdvertSet().stream().anyMatch(x -> x.getFee() > 0)).collect(toList());

        filterResult.setType(FilterResultTypes.DEGRADE_PAY_ADVERT_TYPE);
        //人工降级需要过滤掉自动托管的配置，filterSmartShopAdvert()方法中已经移除了自动托管和弱定向的配置，此处传false，不能传true
        //发券
        doObtainAdvert(req, rsp, expenseAdverts, filterResult,  advertFilter);
        return advertFilterVOList;
    }

    /**
     * 广告降级单用户发券受限放开
     */
    private List<AdvertFilterVO> degradeAdverts(ObtainAdvertReq req,ObtainAdvertRsp rsp, FilterResult filterResult,
        Map<Long, AdvertFilterVO> validAdverts, AdvertFilter advertFilter)throws TuiaException{
        //获取有效广告排序
        Map<Long, Integer> validAdvertOrderLevelMap = serviceManager.queryValidAdvertOrderLevel();

        return manualAdvert(req,rsp,filterResult,validAdverts,validAdvertOrderLevelMap, advertFilter);
    }


    /**
     * 将当前消费者的广告主发券限制标记，修改为不受限
     * @param req
     */
    private void updateConsumerLimit(ObtainAdvertReq req){
        String limitAccountType=null;
        PlatformTypeEnum ua = PlatformTypeEnum.getByDesc(req.getUa());

        switch (ua.getCode().intValue()){
        case 1:
            limitAccountType=AccountLimitTypeEnum.ANDROID_DEGRADE_NO_LIMIT.getCode();
            break;
        case 2:
            limitAccountType=AccountLimitTypeEnum.IOS_DEGRADE_NO_LIMIT.getCode();
            break;
        default:
            limitAccountType=AccountLimitTypeEnum.UNKNOW.getCode();
            break;
        }
        req.getLogExtMap().put("limitAccountType",limitAccountType);
    }

    /**
     * 中免费券
     * @param req
     * @param rsp
     * @param advertFilterVOList
     * @param filterResult
     * @throws TuiaException
     */
    private void doFreeAdverts(ObtainAdvertReq req,ObtainAdvertRsp rsp,List<AdvertFilterVO> advertFilterVOList,
        FilterResult filterResult, AdvertFilter advertFilter) throws TuiaException {

        //免费券，前面已经排除掉了自动托管的配置了
        //获取免费券
        List<AdvertFilterVO> freeAdverts = advertFilterVOList.stream().filter(item ->
            item.getManualAdvertSet().stream().anyMatch(x -> x.getFee().equals(0L))).collect(toList());

        //优先中白名单的广告
        List<AdvertFilterVO> whiteAdverts = this.getWhiteAdverts(freeAdverts);
        filterResult.setType(FilterResultTypes.DEGRADE_FREE_ADVERT_TYPE);
        if(!whiteAdverts.isEmpty()){
            doObtainAdvert(req, rsp, whiteAdverts, filterResult,  advertFilter);
        }

        if(!rsp.isResult()){
            //如果今日谢谢参与已达到量则继续中免费券，如果未达到则切部分流量中谢谢参与
            Long todayMissCoupon = serviceManager.getTodayMissedCoupon();
            if(todayMissCoupon >= (AdvertSystemConfigEnum.thksPartakeCount.getLongValue() * 10000)) {
                doObtainAdvert(req, rsp, freeAdverts, filterResult, advertFilter);
                return;
            }

            //分别切50%的流量走谢谢参与和中免费券
            int rate = (int) (AdvertSystemConfigEnum.flowDistributionRate.getDoubleValue() * 100);
            int random = new Random().nextInt(100);
            if(random < rate){
                CatUtil.log(CatGroupEnum.CAT_107018.getCode());//降权流量达到中谢谢次数
                serviceManager.incrTodayMissedCoupon();//增加今日谢谢参与的次数
                return;
            }

            doObtainAdvert(req, rsp, freeAdverts, filterResult,  advertFilter);
        }
    }

    /**
     * 获取白名单的广告
     * @param freeAdverts
     * @return
     */
    private List<AdvertFilterVO> getWhiteAdverts(List<AdvertFilterVO> freeAdverts){

        Set<Long> whiteAdvertIds = advertWhiteService.getAllAdvertWhite();
        if(whiteAdvertIds.isEmpty()){
            return Collections.emptyList();
        }

        return freeAdverts.stream().filter(x -> whiteAdvertIds.contains(x.getAdvertId())).collect(toList());
    }

    private void buildFilterResult(FilterResult filterResult, List<ConsumerInteractiveRecordDO> consumerVOList, AdvQueryParam advQueryParam) throws TuiaException {

        int recordKeepDays = serviceManager.getIntValue(AdvertSystemConfigureConstants.ADVERT_REPEAT_RECORD_KEEP_DAYS);
        Map<Long,Integer> allUserTimesMap = consumerRecordSerivce.getHistoryAdvertTims(consumerVOList, recordKeepDays);
        filterResult.setAllUserTimesMap(allUserTimesMap);
        filterResult.setPutIndex(advQueryParam.getJoinNum());
        filterResult.setModel(advQueryParam.getPhoneModel());
        filterResult.setPriceSection(advQueryParam.getPhoneLevels());
        filterResult.setPhoneBrand(advQueryParam.getPhoneBrand());
        filterResult.setPhoneModelNum(advQueryParam.getPhoneModelNum());
        filterResult.setMultipleExposureIds(advQueryParam.getMultipleExposureIds());
        filterResult.setLimitAdvertTodayMap(advQueryParam.getLimitAdvertTodayMap());
        filterResult.setBrandName(advQueryParam.getBrandName());
        filterResult.setUa(advQueryParam.getPlatform());
        filterResult.setNetworkTypes(advQueryParam.getNetworkTypes());
        filterResult.setOperators(advQueryParam.getOperators());
        filterResult.setProvince(advQueryParam.getProvince());
        filterResult.setNewAppTestType(NewAppAdvertTradeDO.APP_TYPE_OLD.toString());
        filterResult.setCity(advQueryParam.getCity());
    }

    /**
     *
     * privilegeFilter:(特权广告发券). <br/>
     *
     * @author chencheng
     * @param filterResult
     * @param req
     * @param shieldStrategyVO
     * @param cityId
     * @param rsp
     * @param appDetail
     * @param advQueryParam
     * @throws TuiaException
     * @since JDK 1.8
     */
    private void privilegeFilter(FilterResult filterResult, ObtainAdvertReq req, ShieldStrategyVO shieldStrategyVO,String cityId, ObtainAdvertRsp rsp, AppDetail appDetail, AdvQueryParam advQueryParam, AdvertFilter advertFilter) throws TuiaException {// NOSONAR
        //1.发券已成功或媒体不是特权库媒体时，则不发券
        if (rsp.isResult() || !appPrivilegeService.isAppPrivilege(req.getAppId())) {
            return;
        }
        //2.特权库广告列表
        Set<Long> validPrivileges = advertPrivilegeService.getValidPrivileges();
        AdvertFilterParamVO advertFilterDo = new AdvertFilterParamVO(filterResult, advertFilter, req, shieldStrategyVO, cityId, appDetail, rsp);
        //3.获取特权库一个广告,命中风控可能获取多个广告
        List<AdvertFilterVO> advertFilterVOList = privilegeFilterService.foreachAdvertCheck(validPrivileges, advertFilterDo, filterResult, advQueryParam);
        Long advertId = -1L;
        AdvertPriceVO advertPriceVO = new AdvertPriceVO();
        if (!CollectionUtils.isEmpty(advertFilterVOList)) {
            for (AdvertFilterVO advertFilterVO : advertFilterVOList) {
                try {
                    advertPriceVO = advertFilterVO.getManualMaxFeeAdvert();
                    advertId = advertPriceVO.getAdvertId();
                    AdvertVO advertVO = advertMapCacheManager.getAdvertCache(advertId);
                    if (advertVO == null) {
                        logger.info("privilegeFilter error, advertVO is null the advertId = [{}]", advertId);
                        throw new TuiaException(ErrorCode.E0500003);
                    }
                    Long aFee = advertPriceVO.getFee();
                    rsp.setPrivilege(true);
                    //4.通过特权库发广告
                    advertExposeService.finishBiz(req, rsp, advertId, advertVO, filterResult, advertPriceVO, aFee, advertFilter);
                } catch (Exception e) {
                    //如果不是命中风控规则发券失败，继续抛出异常
                    if (advertFilterDo.getFilterResult().getType() != FilterResultTypes.RISK_PRIVILIGE_TYPE) {
                        throw e;
                    }
                }
                //4.如果是命中风控规则作弊发券成功，这个结束发券循环
                if (advertFilterDo.getFilterResult().getType() == FilterResultTypes.RISK_PRIVILIGE_TYPE && rsp.isResult()) {
                    break;
                }
            }
        }

        if (rsp.isResult()) {
            //特权库成功发券的次数
            CatUtil.catLog(CatGroupEnum.CAT_102007.getCode());
            WarningUtils.markThresholdWarning("privilegeAdvert", catMonitorWarnThreshold.getPrivilegeAdvert());
            filterResult.setResultCode(ErrorCode.E0000000.getErrorCode());
            filterResult.setSuccessId(advertId);
            filterResult.setAdvertOrderId(rsp.getAdvertOrderId());
            //出价
            filterResult.setFee(advertPriceVO.getFee());
            //计费方式
            filterResult.setChargeType(ChargeTypeEnum.getByCode(advertPriceVO.getChargeType()).getDesc());
            //包的类型
            filterResult.setPackageType(advertPriceVO.getPackageType());
            // 中券成功的情况需要记录过滤结果
            filterResult.setPlanId(advertPriceVO.getAdvertOrientationPackageId());
        }

    }


    /**
     * 获取广告定向包里最高单价的配置
     */
    private AdvertPriceVO getAdvertMaxFee(AdvertFilterVO advertFilterVO) {
        if (advertFilterVO == null) {
            return null;
        }
        return advertFilterVO.getManualMaxFeeAdvert();
    }

    private ObtainAdvertReq bagCityIdInLogMap(ObtainAdvertReq req, String cityId) {
        if (req.getLogExtMap() != null) {
            req.getLogExtMap().put("cityId", cityId);
            req.getLogExtMap().put(AdvertOrderJsonKeyEnum.KEY_ACTIVITY_TYPE.getCode(), Optional.ofNullable(req.getActivitySceneType()).map(type -> type.toString()).orElse(PackagePlanConstants.INTERACTION_TYPE));
            req.getLogExtMap().put(AdvertReqLogExtKeyConstant.MAIN_TYPE, String.valueOf(AdvertReqLogExtKeyConstant.INTERACT));
            req.getLogExtMap().put(AdvertReqLogExtKeyConstant.ADX_SCENE,AdxSceneEnum.ADX_API.getCode());

        } else {
            Map<String, String> logExtMap = Maps.newHashMap();
            logExtMap.put("cityId", cityId);
            logExtMap.put(AdvertOrderJsonKeyEnum.KEY_ACTIVITY_TYPE.getCode(), Optional.ofNullable(req.getActivitySceneType()).map(type -> type.toString()).orElse(PackagePlanConstants.INTERACTION_TYPE));
            logExtMap.put(AdvertReqLogExtKeyConstant.MAIN_TYPE, String.valueOf(AdvertReqLogExtKeyConstant.INTERACT));
            logExtMap.put(AdvertReqLogExtKeyConstant.ADX_SCENE,AdxSceneEnum.ADX_API.getCode());
            req.setLogExtMap(logExtMap);
        }
        return req;
    }



    /**
     * 执行发布广告操作.
     * @param req                请求广告接口的请求参数
     * @param rsp                请求广告接口的返回结果
     * @param advertFilterVOList 广告ID列表
     * @param filterResult       过滤结果对象
     * @throws TuiaException the tuia exception
     */
    @SuppressWarnings("squid:S3776")
    public void doObtainAdvert(ObtainAdvertReq req, ObtainAdvertRsp rsp, List<AdvertFilterVO> advertFilterVOList,
        FilterResult filterResult, AdvertFilter advertFilter) throws TuiaException {
        try {
            DBTimeProfile.enter("doObtainAdvert size:" + advertFilterVOList.size());
            // 获取"有效"状态广告id列表 移除被重复曝光过滤掉的广告
            advertFilterVOList = advertFilterVOList.stream().filter(x -> !filterResult.getMultipleExposureIds().contains(x.getAdvertId())).collect(toList());

            for (AdvertFilterVO advertFilterVO : advertFilterVOList) {
                Long advertId = advertFilterVO.getAdvertId();
                AdvertVO advertVO = advertMapCacheManager.getAdvertCache(advertId);
                if (advertVO == null) {
                    logger.info("serviceManager.getAdvert error, advertVO is null the advertId = [{}]", advertId);
                    filterResult.addFilterId(ErrorCode.E0500008.getErrorCode(), null, advertId);
                    continue;
                }
                //非算法投放的情况下，取不到CPC最大值，则表示无CPC配置，则该广告不可投放
                AdvertPriceVO advertPriceVO = this.getAdvertMaxFee(advertFilterVO);
                if (advertPriceVO == null) {
                    filterResult.addFilterId(ErrorCode.E0500030.getErrorCode(), null, advertId);
                    continue;
                }

                //dmp日志打印
                advertRecommendService.dmpAdvertDOS(filterResult,advertId,advertPriceVO);

                try {
                    DBTimeProfile.enter("finishBiz");
                    advertExposeService.finishBiz(req, rsp, advertId, advertVO, filterResult, advertPriceVO, advertPriceVO.getFee(), advertFilter);
                } catch (TuiaException ex) {
                    logger.warn("finishBiz happen error, duibaOrderId={}, type={}",req.getOrderId(), filterResult.getType(), ex);
                    // 过滤掉之后需要添加到过滤结果中
                    filterResult.addFilterId(ex.getResultCode(), null, advertId);
                    if(ex.getResultCode().equals(ErrorCode.E0500006.getErrorCode())){break;}
                    else { continue;}
                } finally {
                    DBTimeProfile.release();
                }

                if (rsp.isResult()) {
                    filterResult.setResultCode(ErrorCode.E0000000.getErrorCode());
                    filterResult.setSuccessId(advertId);
                    filterResult.setAdvertOrderId(rsp.getAdvertOrderId());
                    //出价
                    filterResult.setFee(advertPriceVO.getFee());
                    //计费方式
                    filterResult.setChargeType(ChargeTypeEnum.getByCode(advertPriceVO.getChargeType()).getDesc());
                    //包的类型 1-人工包 2-系统托管包
                    filterResult.setPackageType(advertPriceVO.getPackageType());
                    //记录活动类型
                    filterResult.setActivitySceneType(advertPriceVO.getActivityType());
                    // 中券成功的情况需要记录过滤结果
                    filterResult.setPlanId(advertPriceVO.getAdvertOrientationPackageId());
                    break;
                }
            }
        } finally {
            DBTimeProfile.release();
        }
    }


    /**
     * 校验兑吧请求时的输入参数 <一句话功能描述>.
     *
     * @param req the req
     * @throws TuiaException the tuia exception
     */
    @SuppressWarnings("squid:S3776")
    private void checkAdxLoadAdvertReq(ObtainAdvertReq req) throws TuiaException {
        // 1.请求为空
        if(req == null || req.getAdxLoadType() == null)  {
            throw new TuiaException(ErrorCode.E0100002);
        }

        if(AdxLoadTypeEnum.findByType(req.getAdxLoadType()) == null){
            throw new TuiaException(ErrorCode.E0100002);
        }

        // 2.针对互动广告的逻辑，展示广告不应该发券
        if(req.getActivityType() != null && req.getActivityType() == PackagePlanConstants.SHOW_ACTIVITY_TYPE) {
            throw new TuiaException(ErrorCode.E0100002);
        }

        // 3.用户id,媒体id,活动id为空验证
        if(req.getConsumerId() == null || req.getAppId() == null || req.getActivityId() == null) {
            throw new TuiaException(ErrorCode.E0100002);
        }

        // 4.请求ip为空验证
        if(StringUtils.isEmpty(req.getIp()) && (req.getAdxMediaType() == null || req.getAdxMediaType() == 0)) {
            throw new TuiaException(ErrorCode.E0100002);
        }

        // 5.判断广告用途类型，为空时给默认值0，表明推啊活动
        if(null == req.getActivityUseType()) {
            req.setActivityUseType(2);
        }

        // 6.判断DuibaActivityId和DuibaActivityType为null，暂时置为-1
        if(null == req.getDuibaActivityId() || null == req.getDuibaActivityType()) {
            req.setDuibaActivityId(-1L);
            req.setDuibaActivityType(1);
        }

        // 7.如果是插件活动，则设置活动ID 为传递过来的负数,推啊活动特殊传了activityType为1,所以得根据userType进行区分,2:推啊商业活动
        if(req.getActivityType() != null && req.getActivityUseType() != 2
            && PackagePlanConstants.PLUGIN_ACTIVITY_TYPE == req.getActivityType()) {
            req.setActivityId(0 - req.getActivityId());
        }

        // 8.UA校验和监控
        if(StringUtils.isBlank(req.getUa())) {
            req.setUa(CommonConstants.UNKNOW);
        }

        // 9.兑吧和推啊统一都会传duibaActivityType字段,活动投放场景设置
        Integer activityType = Optional.ofNullable(req.getDuibaActivityType()).orElse(0);
        if (!Objects.equals(req.getActivitySceneType(), ActivityTypeEnum.DIRECT_PAGE_ACTIVITY_TYPE.getCode())){
            if (activityType == PackagePlanConstants.TUIA_PLUGIN_ACTIVITY_TYPE
                    || activityType == PackagePlanConstants.DUIBA_PLUGIN_ACTIVITY_TYPE) {
                req.setActivitySceneType(PackagePlanConstants.PLUGIN_ACTIVITY_TYPE);
            } else {
                req.setActivitySceneType(PackagePlanConstants.ACT_ACTIVITY_TYPE);
            }
        }
        // 10.浮标投放类型
        if (req.getDeliveryType() == PackagePlanConstants.DELIVERY_TYPE_FLOAT) {
            req.setActivitySceneType(PackagePlanConstants.FLOAT_ACTIVITY_TYPE);
        }
        // 11.激励视屏类型
//        if(null != req.getAdType() && PackagePlanConstants.VEDIO_AD_TYPE.equals(req.getAdType())){
//            req.setActivitySceneType(ActivityTypeEnum.VEDIO_ADVERT_ACTIVITY_TYPE.getCode());
//        }
        if (req.getReplaceLowArpu() == null){
            req.setReplaceLowArpu(CommonConstant.NO);
        }

        //12.针对美团媒体,如果传入的城市编码为null,则报错，但有可能传"",代表为国外城市
        if(req.getCityId() == null && (req.getAdxMediaType() != null && req.getAdxMediaType() == 1)) {
            throw new TuiaException(ErrorCode.E0100002);
        }

        // 13.adx媒体类型判断，默认给 0
        if(req.getAdxMediaType() == null){
            req.setAdxMediaType(0);
        }

//        List<Integer> activityTypeExt = req.getActivityTypeExt();
//        if(null != activityTypeExt && activityTypeExt.contains(12)){
//            //开关
//            String idMapStrByKeyStr = apolloPanGuService.getIdMapStrByKeyStr("tuia-engine.activity-expand.switch");
//            if(!"1".equals(idMapStrByKeyStr)){
//                ArrayList<Integer> integers = new ArrayList<>(activityTypeExt);
//                integers.remove(12);
//                req.setActivityTypeExt(integers);
//            }
//
//        }


    }

    /**
     * 查询用户记录
     * getConsumerRecord:(这里用一句话描述这个方法的作用). <br/>
     *
     * @param consumerId
     * @return
     * @author zp
     * @since JDK 1.6
     */
    private List<ConsumerInteractiveRecordDO> getConsumerRecord(Long consumerId) {
        try{
            DBTimeProfile.enter("getConsumerRecord");
            List<ConsumerInteractiveRecordDO> record = consumerRecordDAO.selectInteractiveRecord(consumerId);
            if (CollectionUtils.isEmpty(record)) {
                return Collections.emptyList();
            }

            // 过滤出互动广告
            return record.stream().filter(this::filterAdvertType).collect(toList());
        }finally{
            DBTimeProfile.release();
        }
    }

    private boolean filterAdvertType(ConsumerInteractiveRecordDO recordDO) {
        if(recordDO == null){
            return false;
        }

        ConsumerRecordJsonVO recordJsonVO = JSON.parseObject(recordDO.getJson(), ConsumerRecordJsonVO.class);
        if(recordJsonVO == null){
            return true;
        }

        Integer advertType = recordJsonVO.getAdt();
        return advertType == null || AdvertTypeEnum.HD_ADVERT_TYPE.getCode().equals(advertType);
    }

    /**
     * 过滤出区块广告白名单中第一个有效广告
     */
    public AdvertPriceVO filterByBlockAdvertIds(Map<Long, AdvertFilterVO> validAdverts, List<Long> blockAdvertIds, AdvQueryParam advQueryParam) {
        if (CollectionUtils.isEmpty(blockAdvertIds)) {
            return null;
        }

        for (Long advertId : blockAdvertIds) {
            if (validAdverts.containsKey(advertId) && !filterKeyword(advertId, advQueryParam)) {
                AdvertFilterVO advertFilterVO = validAdverts.get(advertId);
                //非算法投放的情况下，取不到CPC最大值，则表示无CPC配置，则该广告不可投放
                AdvertPriceVO advertPriceVO = this.getAdvertMaxFee(advertFilterVO);
                if (advertPriceVO != null && !filterConfigLoadingPage(advertId, advQueryParam, advertPriceVO)) {
                    return advertPriceVO;
                }
            }
        }
        return null;
    }

    /**
     * 过滤落地页
     * @param advertId
     * @param advQueryParam
     * @return
     */
    private boolean filterKeyword(Long advertId, AdvQueryParam advQueryParam) {
        //主链接过滤
        if (!filterNormalLoadingPage(advertId, advQueryParam)) {
            return false;
        }
        //特殊广告
        if (!filterSpecialAdvert(advertId, advQueryParam)) {
            return false;
        }

        return true;
    }

    /**
     * 配置落地页过滤
     * @param advertId
     * @param advertPriceVO
     * @return
     */
    private boolean filterConfigLoadingPage(Long advertId, AdvQueryParam advQueryParam, AdvertPriceVO advertPriceVO) {
        AdvertFilterKeywordDO advertFilterKeywordDO = advQueryParam.getAdvertFilterKeywordDO();
        if (Objects.nonNull(advertFilterKeywordDO)) {
            NewTradeFilterKeywordDO newTradeFilterKeywordDO = advertFilterKeywordDO.getNewTradeFilterKeywordDO();
            if (Objects.nonNull(newTradeFilterKeywordDO) && MapUtils.isNotEmpty(newTradeFilterKeywordDO.getShieldConfigLandingPageList())) {
                Map<Long, Set<Long>> advertShieldList = newTradeFilterKeywordDO.getShieldConfigLandingPageList();
                if (null != advertShieldList && advertShieldList.containsKey(advertId)) {
                    Set<Long> configIdShieldList = advertShieldList.get(advertId);
                    if (CollectionUtils.isNotEmpty(configIdShieldList) && configIdShieldList.contains(advertPriceVO.getOriginalOrientationId())) {
                        return true;
                    }
                }
            }

            GeneralFilterKeywordDO generalFilterKeywordDO = advertFilterKeywordDO.getGeneralFilterKeywordDO();
            if (Objects.nonNull(generalFilterKeywordDO) && MapUtils.isNotEmpty(generalFilterKeywordDO.getShieldConfigLandingPageList())) {
                Map<Long, Set<Long>> advertShieldList = generalFilterKeywordDO.getShieldConfigLandingPageList();
                if (null != advertShieldList && advertShieldList.containsKey(advertId)) {
                    Set<Long> configIdShieldList = advertShieldList.get(advertId);
                    if (CollectionUtils.isNotEmpty(configIdShieldList) && configIdShieldList.contains(advertPriceVO.getOriginalOrientationId())) {
                        return true;
                    }
                }
            }
        }

        return false;
    }

    /**
     * 主链接过滤
     * @param advertId
     * @return
     */
    private boolean filterNormalLoadingPage(Long advertId, AdvQueryParam advQueryParam) {
        AdvertFilterKeywordDO advertFilterKeywordDO = advQueryParam.getAdvertFilterKeywordDO();
        if (Objects.nonNull(advertFilterKeywordDO)) {
            NewTradeFilterKeywordDO newTradeFilterKeywordDO = advertFilterKeywordDO.getNewTradeFilterKeywordDO();
            if (Objects.nonNull(newTradeFilterKeywordDO) && CollectionUtils.isNotEmpty(newTradeFilterKeywordDO.getShieldNormalLandingList())) {
                if (newTradeFilterKeywordDO.getShieldNormalLandingList().contains(advertId)) {
                    return true;
                }
            }

            GeneralFilterKeywordDO generalFilterKeywordDO = advertFilterKeywordDO.getGeneralFilterKeywordDO();
            if (Objects.nonNull(generalFilterKeywordDO) && CollectionUtils.isNotEmpty(generalFilterKeywordDO.getShieldNormalLandingList())) {
                if (generalFilterKeywordDO.getShieldNormalLandingList().contains(advertId)) {
                    return true;
                }
            }
        }
        return false;
    }

    /**
     * 特殊广告过滤
     * @param advertId
     * @return
     */
    private boolean filterSpecialAdvert(Long advertId, AdvQueryParam advQueryParam) {
        AdvertFilterKeywordDO advertFilterKeywordDO = advQueryParam.getAdvertFilterKeywordDO();

        if (Objects.nonNull(advertFilterKeywordDO)) {

            NewTradeFilterKeywordDO newTradeFilterKeywordDO = advertFilterKeywordDO.getNewTradeFilterKeywordDO();
            if (Objects.nonNull(newTradeFilterKeywordDO) && CollectionUtils.isNotEmpty(newTradeFilterKeywordDO.getShieldSpecialLandingList()) && CollectionUtils.isNotEmpty(newTradeFilterKeywordDO.getShieldSpecialMaterialList())) {
                Set<Long> advertIdShieldList = newTradeFilterKeywordDO.getShieldSpecialLandingList();
                Set<Long> advertMaterialShieldList = newTradeFilterKeywordDO.getShieldSpecialMaterialList();

                if ((CollectionUtils.isNotEmpty(advertIdShieldList) && advertIdShieldList.contains(advertId))
                        || (CollectionUtils.isNotEmpty(advertMaterialShieldList) && advertMaterialShieldList.contains(advertId))) {

                    return true;
                }
            }

            GeneralFilterKeywordDO generalFilterKeywordDO = advertFilterKeywordDO.getGeneralFilterKeywordDO();
            if (Objects.nonNull(generalFilterKeywordDO) && CollectionUtils.isNotEmpty(generalFilterKeywordDO.getShieldSpecialLandingList()) && CollectionUtils.isNotEmpty(generalFilterKeywordDO.getShieldSpecialMaterialList())) {
                Set<Long> advertIdShieldList = generalFilterKeywordDO.getShieldSpecialLandingList();
                Set<Long> advertMaterialShieldList = generalFilterKeywordDO.getShieldSpecialMaterialList();

                if ((CollectionUtils.isNotEmpty(advertIdShieldList) && advertIdShieldList.contains(advertId))
                        || (CollectionUtils.isNotEmpty(advertMaterialShieldList) && advertMaterialShieldList.contains(advertId))) {

                    return true;
                }
            }
        }

        return false;
    }

    /**
     * 执行发布广告操作(用于区块直投广告)
     */
    public void doObtainAdvertForBlockDirect(ObtainAdvertReq req, ObtainAdvertRsp rsp, AdvertPriceVO advertPriceVO,
                                             FilterResult filterResult, AdvertFilter advertFilter) {
        try {
            DBTimeProfile.enter("doObtainAdvertForBlockDirect");

            Long advertId = advertPriceVO.getAdvertId();
            AdvertVO advertVO = advertMapCacheManager.getAdvertCache(advertId);
            if (advertVO == null) {
                logger.info("serviceManager.getAdvert error, advertVO is null the advertId = [{}]", advertId);
                filterResult.addFilterId(ErrorCode.E0500008.getErrorCode(), null, advertId);
                return;
            }

            try {
                DBTimeProfile.enter("finishBiz");
                advertExposeService.finishBiz(req, rsp, advertId, advertVO, filterResult, advertPriceVO, advertPriceVO.getFee(), advertFilter);
            } catch (TuiaException ex) {
                logger.warn("finishBiz happen error, duibaOrderId={}, type={}",req.getOrderId(), filterResult.getType(), ex);
                // 过滤掉之后需要添加到过滤结果中
                filterResult.addFilterId(ex.getResultCode(), null, advertId);
            } finally {
                DBTimeProfile.release();
            }

            if (rsp.isResult()) {
                filterResult.setResultCode(ErrorCode.E0000000.getErrorCode());
                filterResult.setSuccessId(advertId);
                filterResult.setAdvertOrderId(rsp.getAdvertOrderId());
                //出价
                filterResult.setFee(advertPriceVO.getFee());
                //计费方式
                filterResult.setChargeType(ChargeTypeEnum.getByCode(advertPriceVO.getChargeType()).getDesc());
                //包的类型 1-人工包 2-系统托管包
                filterResult.setPackageType(advertPriceVO.getPackageType());
                //记录活动类型
                filterResult.setActivitySceneType(advertPriceVO.getActivityType());
                // 中券成功的情况需要记录过滤结果
                filterResult.setPlanId(advertPriceVO.getAdvertOrientationPackageId());
            }
        } finally {
            DBTimeProfile.release();
        }
    }

    /**
     * 区块过滤日志
     *
     * @param advertFilter 广告过滤
     * @param validAdverts 区块过滤前的有效广告
     * @param advertPriceVO 最终要出的广告
     */
    public void blockFilterLog(AdvertFilter advertFilter, Map<Long, AdvertFilterVO> validAdverts, AdvertPriceVO advertPriceVO) {
        if (MapUtils.isEmpty(validAdverts)) {
            return;
        }

        Set<AdvertFilterType> filterTypeSet = new HashSet<>();
        Long validAdvertId = null == advertPriceVO ? null : advertPriceVO.getAdvertId();

        for (Map.Entry<Long, AdvertFilterVO> entry : validAdverts.entrySet()) {
            try {
                if (!Objects.equals(entry.getKey(), validAdvertId)
                        && CollectionUtils.isNotEmpty(entry.getValue().getAdvertPriceVOSortedSet())) {
                    entry.getValue().getAdvertPriceVOSortedSet().forEach(priceVO ->
                            filterTypeSet.add(new AdvertFilterType(priceVO.getAdvertId(),
                                    priceVO.getAdvertOrientationPackageId(), AdvertFilterTypeEnum.BLOCK_WHITELIST.getCode())));
                }
            } catch (Exception e) {
                logger.warn("blockFilter error, advertId={}", entry.getKey(), e);
            }
        }

        if (CollectionUtils.isNotEmpty(filterTypeSet)) {
            if (null == advertFilter.getReason()) {
                advertFilter.setReason(filterTypeSet);
            } else {
                advertFilter.getReason().addAll(filterTypeSet);
            }
        }
    }

    /**
     * 判断直投类型
     *
     * @param req 请求参数
     * @return 直投类型
     */
    private Integer getReqSourceType(ObtainAdvertReq req) {
        // 区块直投
        if (Objects.equals(req.getActivitySceneType(), 3)) {
            return ReqSourceTypeEnum.BLOCK_DIRECT.getType();
        }

        // 互动直投
        if (Objects.equals(req.getAdType(), PackagePlanConstants.VEDIO_AD_TYPE)) {
            return ReqSourceTypeEnum.HD_DIRECT.getType();
        }

        // 媒体ADX
//        if (Objects.equals(req.getAdxMediaType(), 1) && req.getOrderIds() == null) {
        if (Objects.equals(req.getAdxMediaType(), 1)) {
                return ReqSourceTypeEnum.MEITUAN_ADX.getType();
        }

        // 默认
        return ReqSourceTypeEnum.UNKNOWN.getType();
    }

    /**
     * 插入订单到HBase和缓存（跳过美团相关业务逻辑）
     */
    private void insertOrderToHBaseAndRedis(List<RcmdAdvertDto> rcmdAdvertDtoList, ObtainAdvertReq req,
                                            ObtainAdvertRsp rsp, FilterResult filterResult) {
        if (CollectionUtils.isEmpty(rcmdAdvertDtoList)) {
            return;
        }

        try {
            // 组装广告发券结果
            List<AdxLoadAdvertDto> advertDtoList = Lists.newArrayList();
            final int[] rank = { 1 };
            rcmdAdvertDtoList.stream()
                    .filter(rcmdAdvertDto -> StringUtils.isNotBlank(rcmdAdvertDto.getOrderId()))
                    .limit(ActPreUtils.getAdvertCount(req))
                    .forEach(rcmdAdvertDto -> {
                        AdxLoadAdvertDto dto = new AdxLoadAdvertDto();
                        dto.setAdvertId(rcmdAdvertDto.getAdvertId());
                        dto.setOrientationId(rcmdAdvertDto.getPackageId());
                        dto.setPreCtr(rcmdAdvertDto.getCtr());
                        dto.setPreArpu(rcmdAdvertDto.getArpu());
                        dto.setFee(rcmdAdvertDto.getFee());
                        dto.setMaterialId(rcmdAdvertDto.getMaterialId());
                        dto.setAdjustPriceFactor(rcmdAdvertDto.getAdjustPriceFactor());
                        dto.setPreCvr(rcmdAdvertDto.getPreCvr());
                        dto.setOrderId(rcmdAdvertDto.getOrderId());
                        dto.setCtr(rcmdAdvertDto.getCtr());
                        dto.setRank(rank[0]);
                        advertDtoList.add(dto);
                        rank[0]++;
                    });

            // advertOrderDOList 订单信息集合，每个广告对应一个订单信息集合.
            List<AdvertOrderDO> advertOrderDOList = new ArrayList<>(advertDtoList.size());

            // 遍历广告，构建对应的返回信息，以及订单信息集合
            advertDtoList.forEach(advertDto -> meituanAdxService.recordLaunch(req, rsp, null, filterResult, advertDto, null, advertOrderDOList, false));

            // 批量插入订单
            if (CollectionUtils.isNotEmpty(advertOrderDOList)) {
                meituanAdxService.insertOrderToHbaseAndRedis(req.getConsumerId(), advertOrderDOList);
            }
        } catch (Exception e) {
            logger.error("insertOrderToHBaseAndRedis error", e);
        }
    }

    private void setAdxRid(AdvertFilter advertFilter, ObtainAdvertReq req) {
        if (req.getLogExtExpMap() != null) {
            advertFilter.setAdxRid(req.getLogExtExpMap().get(AdvertReqLogExtKeyConstant.ADX_RID));
        }
    }
}
