package cn.com.duiba.tuia.adx;

import cn.com.duiba.tuia.enums.adx.AdxLoadTypeEnum;
import cn.com.duiba.tuia.service.BaseService;
import cn.com.tuia.advert.enums.AdxSceneEnum;
import cn.com.tuia.advert.model.AdxLogReq;
import cn.com.tuia.advert.model.ObtainAdvertReq;
import cn.com.tuia.advert.model.ObtainAdvertRsp;
import cn.com.tuia.advert.service.IAdxService;
import cn.com.tuia.advert.service.IOptionalAdvertService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RestController;

/**
 * 用户选广告活动
 *
 * @author zhangbaiqiang
 * @date 2020/12/2
 */
@RestController
public class OptionalAdvertService extends BaseService implements IOptionalAdvertService {

    @Autowired
    private IAdxService adxService;

    @Override
    public ObtainAdvertRsp preLoadAdvert(ObtainAdvertReq req) {
        req.setActPre(Boolean.TRUE);
        req.setAdxLoadType(AdxLoadTypeEnum.PRE_LOAD.getLoadType());
        req.setAdxSceneType(AdxSceneEnum.OPTIONAL_AD.getCode());
        return adxService.preLoadAdvert(req);
    }

    @Override
    public void reLog(AdxLogReq req) {
        req.setAdxMediaType(AdxSceneEnum.OPTIONAL_AD.getCode());
        adxService.reLog(req);
    }
}
