package cn.com.duiba.tuia.adx.log;

import cn.com.duiba.tuia.enums.CatGroupEnum;
import lombok.Data;
import lombok.EqualsAndHashCode;

import com.alibaba.fastjson.JSONObject;

import cn.com.duiba.boot.perftest.PerfTestContext;
import cn.com.duiba.tuia.log.BaseInnerLog;
import cn.com.duiba.tuia.tool.CatUtil;
import cn.com.tuia.advert.model.AdxLogReq;

/**
 * adx 曝光日志
 * 
 * @author peanut.huang
 * @date 2019/11/16
 * @since JDK 1.8
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class AdxExposureLog extends AbstractAdxLog{

    private AdxLogReq logReq;

    public AdxExposureLog(AdxLogReq logReq) {
        this.logReq = logReq;
    }

    /**
     * 日志打印
     */
    @Override
    public void log() {

        CatUtil.log(CatGroupEnum.CAT_103004.getCode());
        if(PerfTestContext.isCurrentInPerfTestMode()){
            return;
        }
        String json = JSONObject.toJSONString(logReq);
        BaseInnerLog.log(json, BaseInnerLog.ADVERT_INNER_LOG_EXPOSURE, logReq.getTime());
    }
}
