package cn.com.duiba.tuia.adx.log;

import cn.com.duiba.tuia.enums.CatGroupEnum;
import lombok.Data;
import lombok.EqualsAndHashCode;

import cn.com.duiba.boot.perftest.PerfTestContext;
import cn.com.duiba.tuia.domain.model.SpmType;
import cn.com.duiba.tuia.log.StatLaunchJsonLog;
import cn.com.duiba.tuia.tool.CatUtil;
import cn.com.tuia.advert.model.ObtainAdvertReqLogExt;

/**
 * adx 发券日志
 *
 * @author peanut.huang
 * @date 2019/11/16
 * @since JDK 1.8
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class AdxLaunchLog extends AbstractAdxLog{


    private ObtainAdvertReqLogExt logExt;

    public AdxLaunchLog(ObtainAdvertReqLogExt reqLogExt) {
       this.logExt =  reqLogExt;
    }

    /**
     * 日志打印
     */
    @Override
    public void log() {

        // 请求数监控
        CatUtil.log(CatGroupEnum.CAT_103003.getCode());
        if(PerfTestContext.isCurrentInPerfTestMode()){
            return;
        }

        logExt.setType(SpmType.SPM_LOG_LAUNCH);
        StatLaunchJsonLog.log(logExt);

    }
}
