package cn.com.duiba.tuia.adx.log;

import cn.com.duiba.tuia.enums.CatGroupEnum;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Map;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;

import cn.com.duiba.boot.perftest.PerfTestContext;
import cn.com.duiba.tuia.constants.AdvertReqLogExtKeyConstant;
import cn.com.duiba.tuia.constants.PackagePlanConstants;
import cn.com.duiba.tuia.domain.model.SpmType;
import cn.com.duiba.tuia.log.BaseInnerLog;
import cn.com.duiba.tuia.tool.CatUtil;
import cn.com.tuia.advert.enums.AdvertOrderJsonKeyEnum;
import cn.com.tuia.advert.model.AdxLogReq;
import cn.com.tuia.advert.model.ObtainAdvertReq;

/**
 * adx 请求日志
 *
 * @author peanut.huang
 * @date 2019/11/16
 * @since JDK 1.8
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class AdxRequestLog extends AbstractAdxLog{

    /**
     * 广告日志请求参数
     */
    private  AdxLogReq adxLogReq;

    /**
     * 城市id
     */
    private String cityId;


    public AdxRequestLog(AdxLogReq req, String cityId) {
        this.adxLogReq = req;
        this.cityId = cityId;
    }

    /**
     * 请求日志打印
     */
    @Override
    public void log(){

        // 请求数监控
        CatUtil.log(CatGroupEnum.CAT_103002.getCode());
        if(PerfTestContext.isCurrentInPerfTestMode()){
            return;
        }

        // cityId处理
        bagCityIdInLogMap(adxLogReq.getCityId());

        adxLogReq.setType(SpmType.SPM_LOG_REQUEST);
        String json = JSONObject.toJSONString(adxLogReq);
        BaseInnerLog.log(json, BaseInnerLog.ADVERT_INNER_LOG_REQUEST, adxLogReq.getTime());
    }

    /**
     * cityId处理
     *
     * @param cityId
     * @return
     */
    private AdxLogReq bagCityIdInLogMap(String cityId) {
        if (adxLogReq.getLogExtMap() != null) {
            adxLogReq.getLogExtMap().put("cityId", cityId);
            adxLogReq.getLogExtMap().put(AdvertOrderJsonKeyEnum.KEY_ACTIVITY_TYPE.getCode(), PackagePlanConstants.INTERACTION_TYPE);
            adxLogReq.getLogExtMap().put(AdvertReqLogExtKeyConstant.MAIN_TYPE, String.valueOf(AdvertReqLogExtKeyConstant.INTERACT));

        } else {
            Map<String, String> logExtMap = Maps.newHashMap();
            logExtMap.put("cityId", cityId);
            logExtMap.put(AdvertOrderJsonKeyEnum.KEY_ACTIVITY_TYPE.getCode(), PackagePlanConstants.INTERACTION_TYPE);
            logExtMap.put(AdvertReqLogExtKeyConstant.MAIN_TYPE, String.valueOf(AdvertReqLogExtKeyConstant.INTERACT));
            adxLogReq.setLogExtMap(logExtMap);
        }

        return adxLogReq;
    }
}
