package cn.com.duiba.tuia.adx.meituan;

import cn.com.duiba.tuia.domain.dataobject.AdvertOrderDO;
import cn.com.duiba.tuia.domain.model.FilterResult;
import cn.com.duiba.tuia.domain.vo.AdvertVO;
import cn.com.tuia.advert.model.AdxLoadAdvertDto;
import cn.com.tuia.advert.model.AdxLogReq;
import cn.com.tuia.advert.model.ObtainAdvertReq;
import cn.com.tuia.advert.model.ObtainAdvertRsp;
import cn.com.tuia.advert.model.SimpleAppAdvertDto.SimpleMeituanAdvertDto;

import java.math.BigDecimal;
import java.util.List;

/**
 * 美团adx广告出券服务
 *
 * @author peanut.huang
 * @date 2019/11/15
 * @since JDK 1.8
 */
public interface MeituanAdxService {

    /**
     * 记录发券详情
     * @param req
     * @param rsp
     * @param simpleMtAdList 简要返回广告信息集合，这里进行组装
     * @param filterResult 过滤result
     * @param adxLoadAdvertDto nezha返回的广告列表
     * @param bBidProportion 分成比例
     * @param advertOrderDOList 订单列表，这里进行组装
     * @param openMtTest 实验
     */
    void recordLaunch(ObtainAdvertReq req, ObtainAdvertRsp rsp,
                      List<SimpleMeituanAdvertDto> simpleMtAdList,
                      FilterResult filterResult,
                      AdxLoadAdvertDto adxLoadAdvertDto,
                      BigDecimal bBidProportion,
                      List<AdvertOrderDO> advertOrderDOList,
                      boolean openMtTest);

    /**
     * 日志补偿
     *
     * 1、补打请求日志
     * 2、补打发券日志
     * 3、补打曝光日志
     * 4、追加领券记录及时段发券量
     *
     * @param req
     */
    boolean reLog(AdxLogReq req);

    boolean insertOrderToHbaseAndRedis(Long consumerId, List<AdvertOrderDO> advertOrderDOList);
}
