package cn.com.duiba.tuia.adx.meituan.impl;

import cn.com.duiba.boot.perftest.PerfTestContext;
import cn.com.duiba.nezha.engine.api.remoteservice.advert.RemoteRelogService;
import cn.com.duiba.tuia.adx.enums.AdxTypeEnum;
import cn.com.duiba.tuia.adx.log.AdxExposureLog;
import cn.com.duiba.tuia.adx.log.AdxLaunchLog;
import cn.com.duiba.tuia.adx.log.AdxRequestLog;
import cn.com.duiba.tuia.adx.meituan.MeituanAdxService;
import cn.com.duiba.tuia.cache.AdvertMapCacheManager;
import cn.com.duiba.tuia.cache.AdvertPromoteTestCacheService;
import cn.com.duiba.tuia.cache.AvertCreativeCacheService;
import cn.com.duiba.tuia.cache.ServiceManager;
import cn.com.duiba.tuia.constants.AdvertReqLogExtKeyConstant;
import cn.com.duiba.tuia.constants.ErrorCode;
import cn.com.duiba.tuia.constants.PackagePlanConstants;
import cn.com.duiba.tuia.dao.engine.AdvertOrderDAO;
import cn.com.duiba.tuia.domain.dataobject.*;
import cn.com.duiba.tuia.domain.model.*;
import cn.com.duiba.tuia.domain.model.abtest.ABResult;
import cn.com.duiba.tuia.domain.vo.AdvertPriceVO;
import cn.com.duiba.tuia.domain.vo.AdvertVO;
import cn.com.duiba.tuia.domain.vo.MaterialPromoteTestUrlsVO;
import cn.com.duiba.tuia.domain.vo.OrderJsonVO;
import cn.com.duiba.tuia.enums.AccountLimitTypeEnum;
import cn.com.duiba.tuia.enums.AdvertSubtypeEnum;
import cn.com.duiba.tuia.enums.AppFlowTypeEnum;
import cn.com.duiba.tuia.enums.MaterialTestPlanLogTypeEnum;
import cn.com.duiba.tuia.exception.TuiaException;
import cn.com.duiba.tuia.log.FilterResultLog;
import cn.com.duiba.tuia.service.*;
import cn.com.duiba.tuia.service.impl.CommonServiceImpl;
import cn.com.duiba.tuia.service.router.PromoteABTestService;
import cn.com.duiba.tuia.task.EngineSyncRealTimeService;
import cn.com.duiba.tuia.tool.StringTool;
import cn.com.duiba.tuia.utils.WeightRandomUtil;
import cn.com.duiba.wolf.perf.timeprofile.DBTimeProfile;
import cn.com.duiba.wolf.redis.RedisAtomicClient;
import cn.com.duiba.wolf.redis.RedisLock;
import cn.com.duiba.wolf.utils.BeanUtils;
import cn.com.duibaboot.ext.autoconfigure.core.utils.CatUtils;
import cn.com.tuia.advert.constants.CommonConstant;
import cn.com.tuia.advert.enums.*;
import cn.com.tuia.advert.model.*;
import cn.com.tuia.advert.model.SimpleAppAdvertDto.SimpleMeituanAdvertDto;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Joiner;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.util.*;
import java.util.concurrent.ExecutorService;

/**
 * 美团adx业务类
 *
 * @author peanut.huang
 * @date 2019/11/15
 * @since JDK 1.8
 */
@Service
@Slf4j
public class MeituanAdxServcieImpl implements MeituanAdxService {


    @Resource
    private IdWokerService                  idWokerService;
    @Resource
    private AdvertMapCacheManager           advertMapCacheManager;
    @Resource(name = "redisTemplate")
    private RedisAtomicClient               redisAtomicClient;
    @Resource
    private AdvertOrderDAO                  advertOrderDAO;
    @Resource
    private ServiceManager                  serviceManager;
    @Resource
    private AdvertRealDataService           advertRealDataService;
    @Resource
    private EngineSyncRealTimeService       engineSyncRealTimeService;
    @Resource
    private ConsumerRecordSerivce           consumerRecordSerivce;
    @Resource
    private RemoteRelogService remoteRelogService;

    @Autowired
    private AdvertPromoteTestCacheService advertPromoteTestCacheService;

    @Autowired
    private MaterialBindPromoteUrlService materialBindPromoteUrlService;

    @Autowired
    private MeituanCheckUrlService meituanCheckUrlService;

    @Autowired
    protected ExecutorService executorService;
    @Autowired
    private PromoteABTestService promoteABTestService;

    @Autowired
    private AvertCreativeCacheService avertCreativeCacheService;

    /**
     * 记录发券订单
     * @param req
     * @param rsp
     * @param filterResult
     * @param adxLoadAdvertDto
     */
    @Override
    public void recordLaunch(ObtainAdvertReq req, ObtainAdvertRsp rsp,
                             List<SimpleMeituanAdvertDto> simpleMtAdList,
                             FilterResult filterResult,
                             AdxLoadAdvertDto adxLoadAdvertDto,
                             BigDecimal bBidProportion,
                             List<AdvertOrderDO> advertOrderDOList,
                             boolean openMtTest) {

        Long advertId = adxLoadAdvertDto.getAdvertId();
        Long orientationId = adxLoadAdvertDto.getOrientationId();
        Long materialId = adxLoadAdvertDto.getMaterialId();
        Long fee = adxLoadAdvertDto.getFee();

        try {
            // 检查广告
            AdvertVO advertVO = advertMapCacheManager.getAdvertCache(advertId);
            if (advertVO == null) {
                log.error("recordLaunch getAdvert error, advertVO is null the advertId = [{}]", advertId);
                rsp.setResult(false);
                return;
            }

            // 检查配置
            AdvOrientationItem cachePkgItem = advertMapCacheManager.getValidAdvOrientation(advertId, orientationId);
            if(cachePkgItem == null){
                log.error("recordLaunch getValidAdvOrientation error, AdvOrientationItem is null,  orientationId = [{}]", orientationId);
                rsp.setResult(false);
                return;
            }

            // 检查素材
            if(materialId == null){
                log.error("recordLaunch  error, materialId is null,  orientationId = [{}]", orientationId);
                rsp.setResult(false);
                return;
            }

            // 因为新O的需求，有可能优化目标会被改变，所以这边重新赋值了nezha返回的转化目标
            AdvOrientationItem advOrientationItem = BeanUtils.copy(cachePkgItem, AdvOrientationItem.class);
            advOrientationItem.setSubtype(adxLoadAdvertDto.getCvrType());

            // 生成一个全局ID
            Long advertOrderId = idWokerService.getNextID();

            // 丰富filterResult日志
            filterResult.setAdvertOrderId(advertOrderId);
            richFilterResult(req, advertVO, advOrientationItem, adxLoadAdvertDto, filterResult);


            // 1、配置转priceVO
            AdvertPriceVO advertPriceVO = advOrientationItem.simple2PriceVO();
            // aFee
            Long aFee = advertPriceVO.getFee();

            // nezha推荐出价
            advertPriceVO.setFee(fee);

            //设置素材测试对象
            Map<String, MaterialTestPlanDO> materialTestPlanDOMap = filterResult.getMaterialTestPlanDOMap();
            if (null != materialTestPlanDOMap) {
                advertPriceVO.setMaterialTestPlanDO(materialTestPlanDOMap.get(advertPriceVO.getAdvertId()+"#"+advertPriceVO.getAdvertOrientationPackageId()));
            }

            // 2、再次验证广告有效状态
            invalidStatusFresh(advertVO, advertId);

            // 3、广告id设置
            req.setAdvertId(advertId);

            // 用户选广告活动需求，无需走下面美团的逻辑
            if (Objects.equals(req.getAdxSceneType(), AdxSceneEnum.OPTIONAL_AD.getCode())) {
                return;
            }


            AdvertCoupon advertCoupon;
            try {
                advertCoupon = CatUtils.executeInCatTransaction(() -> serviceManager.getAdvertCouponByLocal(advertVO.getAdvertPlan().getId()),"finishBizWzj","getAdvertCouponByLocal");
            } catch (Throwable t) {
                if(t instanceof TuiaException) {
                    throw (TuiaException) t;
                }else{
                    log.warn("finishBiz.getAdvertCouponByLocal error", t);
                    throw new TuiaException(ErrorCode.E9999999);
                }
            }

            SimpleMeituanAdvertDto simpleDto = new SimpleMeituanAdvertDto();
            simpleDto.setAdvertId(advertId);
            simpleDto.setAdSpecId(orientationId);
            simpleDto.setMaterialId(materialId);
            simpleDto.setOrderId(adxLoadAdvertDto.getOrderId());
            simpleDto.setCtr(adxLoadAdvertDto.getCtr());

            simpleDto.setPromoteUrl(null == advertCoupon ? null : advertCoupon.getPromoteURL());
            filterResult.setPromoteSource(PromoteSource.ADVERT_BASIC);

            List<ABResult.ABResultDTO> abResultList = new ArrayList<>();

            // 替换测试素材 和 落地页链接
            replaceMaterialAndPromoteUrl(simpleDto, filterResult, advertPriceVO, req, abResultList);

            // 4、添加一条领取记录
            AdvertOrderDO advertOrderDO = buildAdvertOrder(advertVO, req, advertOrderId, simpleDto.getMaterialId(),simpleDto.getPromoteUrl(),
                    advertPriceVO, rsp, adxLoadAdvertDto, aFee, filterResult, abResultList);

            advertOrderDOList.add(advertOrderDO);

            Map<String, Object> logExtMap = Optional.ofNullable(rsp.getLogExtMap()).orElse(new HashMap<>());
            logExtMap.put(AdvertReqLogExtKeyConstant.SCENCE_NUM, req.getLogExtMap().get(AdvertReqLogExtKeyConstant.SCENCE_NUM));

            Double finalFee = fee.doubleValue();
            // 如果非开启实验，则乘以分成比例
            if (!openMtTest) {
                finalFee = BigDecimal.valueOf(fee).multiply(bBidProportion).doubleValue();
            }

            simpleDto.setFee(finalFee);

            simpleDto.setLogExtMap(logExtMap);

            simpleMtAdList.add(simpleDto);

        }catch (Exception e){
            log.error("recordLaunch error", e);
        }

    }

    /**
     * 本次发券ID不在测试ID集里
     *
     * @param orientIds
     * @param packageId
     * @return
     */
    private boolean testOrientIdsNotContainRspOrientIds(String orientIds, Long packageId) {

        //如果为空，说明全部配置可测
        if (StringUtils.isBlank(orientIds)) {
            return false;
        }

        //不包含
        return !orientIds.contains(packageId.toString());
    }


    //TODO  美团 素材和落地页测试替换逻辑
    private void replaceMaterialAndPromoteUrl(SimpleMeituanAdvertDto simpleDto, FilterResult filterResult,
                                              AdvertPriceVO advertPriceVO, ObtainAdvertReq req,
                                              List<ABResult.ABResultDTO> abResultList) throws Exception{

        Long advertId = simpleDto.getAdvertId();
        Long materialId = simpleDto.getMaterialId();

        postHandlerTestMaterialId(materialId,advertPriceVO);

        //素材落地页ab测试替换
        doMatetialABTest(simpleDto, filterResult, advertPriceVO, req, abResultList);

        // 配置维度 多连接测试 不为空 1、填写了配置多连接测试 2、关闭使用广告维度推广链接 3、该审核通过
        if (StringUtils.isNotEmpty(advertPriceVO.getPromoteTestUrl()) &&
                meituanCheckUrlService.checkOneUrl(advertId, materialId, advertPriceVO.getPromoteTestUrl())) {
            simpleDto.setPromoteUrl(advertPriceVO.getPromoteTestUrl());
            filterResult.setPromoteSource(PromoteSource.ORIENTATION_MORE_URL);
        }

        if (null != advertPriceVO && null != advertPriceVO.getMaterialTestPlanDO() && Boolean.TRUE.equals(advertPriceVO.getMaterialTestPlanDO().getTestResult())) {
            // 广告测试素材 绑定落地页 替换
            String bindPromoteUrl = materialBindPromoteUrlService.getBindPromoteUrl(advertId, materialId);
            if (null != bindPromoteUrl && meituanCheckUrlService.checkOneUrl(advertId,materialId,bindPromoteUrl)) {
                simpleDto.setPromoteUrl(bindPromoteUrl);
                filterResult.setPromoteSource(PromoteSource.MATERIAL_BIND_URL);
            }
        }
    }


    private static void setMaterialType(Long testMaterialId, MaterialTestPlanDO materialTestPlanDO) {
        if (Objects.isNull(testMaterialId)) {
            return ;
        }
        // 获取有效的新老素材
        List<Long> newMaterials = materialTestPlanDO.getRspMaterialList().getNewMaterials();
        // 测试素材列表
        List<Long> validTestMaterial = materialTestPlanDO.getValidTestMaterial();

        if (CollectionUtils.isNotEmpty(validTestMaterial) && validTestMaterial.contains(testMaterialId)) {
            // 测试新素材
            if (CollectionUtils.isNotEmpty(newMaterials) && newMaterials.contains(testMaterialId)) {
                materialTestPlanDO.setMaterialType(MaterialTestPlanLogTypeEnum.TEST_NEW_MATERIAL.toLogString());
            }
            // 测试老素材
            else {
                materialTestPlanDO.setMaterialType(MaterialTestPlanLogTypeEnum.TEST_OLD_MATERIAL.toLogString());
            }
        } else {
            materialTestPlanDO.setPlanId(null);
            // 新素材
            if (CollectionUtils.isNotEmpty(newMaterials) && newMaterials.contains(testMaterialId)) {
                materialTestPlanDO.setMaterialType(MaterialTestPlanLogTypeEnum.NEW_MATERIAL.toLogString());
            }
            // 老素材
            else {
                materialTestPlanDO.setMaterialType(MaterialTestPlanLogTypeEnum.OLD_MATERIAL.toLogString());
            }
        }
    }

    /**
     * 素材测试打标处理
     * @param recomMaterialId
     * @param advertPriceVO
     */
    private void postHandlerTestMaterialId(Long recomMaterialId, AdvertPriceVO advertPriceVO) {
        MaterialTestPlanDO materialTestPlanDO = advertPriceVO.getMaterialTestPlanDO();

        // 没有参与测试, 不用处理
        if (Objects.isNull(materialTestPlanDO)) {
            return ;
        }

        Long testMaterialId = materialTestPlanDO.getMaterialId();

        // 设置素材类型
        setMaterialType(testMaterialId, materialTestPlanDO);
    }

    private void doMatetialABTest(SimpleMeituanAdvertDto simpleDto, FilterResult filterResult,
                                  AdvertPriceVO advertPriceVO, ObtainAdvertReq req,
                                  List<ABResult.ABResultDTO> abResultList) throws Exception {

        Long advertId = simpleDto.getAdvertId();
        Long materialId = simpleDto.getMaterialId();

        //1.查询测试落地页数据
        MaterialPromoteTestUrlsVO testUrlsVO = advertPromoteTestCacheService.getMaterialPromoteTest(advertId);

        //2.判断，如果测试落地页为null，配置ID不在测试ID内，测试URL为空，则不进行测试落地页
        if (null == testUrlsVO
                || testOrientIdsNotContainRspOrientIds(testUrlsVO.getOrientIds(), advertPriceVO.getAdvertOrientationPackageId())
                || testUrlsVO.getPromoteUrls().size() < 1) {
            return;
        }

        //3.查询素材->测试落地页关系。
        List<AdvertPromoteTestDO> materialPromoteTestDOS = advertPromoteTestCacheService.getMaterialPromoteTestRelation(materialId);

        //4.判断素材不全可投,且切量为100,走降级
        if (CollectionUtils.isEmpty(materialPromoteTestDOS)
                || materialPromoteTestDOS.size() != testUrlsVO.getPromoteUrls().size()) {
            //且切量为100%，走降级
            if (testUrlsVO.getWeight() >=1) {
                log.info("素材不全可投,且切量为100,走降级 广告ID:{}, 素材ID:{}, weight:{}", advertId, materialId, testUrlsVO.getWeight());
                throw new TuiaException(ErrorCode.E0500040);
            }
            //不为100%，不替换测试连接，走后门出券逻辑
            return;
        }


        //5.判断用户是否发过券
        Integer integer = filterResult.getLimitAdvertTodayMap().get(advertId);
        if (integer != null && integer > 0) {
            //且切量为100%，走降级
            if (testUrlsVO.getWeight() >= 1) {
                log.info("已经发过券,且切量为100,走降级 广告ID:{}, weight:{}", advertId, testUrlsVO.getWeight());
                throw new TuiaException(ErrorCode.E0500041);
            }
            //不为100%，不替换测试连接，走后门出券逻辑
            return;
        }

        //判断 所有的ab测试链接是否都通过美团审核
        if (!meituanCheckUrlService.checkAllUrl(advertId,materialId,testUrlsVO.getPromoteUrls())) {
            return;
        }

        //7.调用实验平台分流
        Long orientId = Optional.ofNullable(advertPriceVO.getOriginalOrientationId()).orElse(advertPriceVO.getAdvertOrientationPackageId());
        String promoteUrl = promoteABTestService.getPromoteUrlWithoutLog(req, advertId, orientId, abResultList);
        if (null == promoteUrl || !meituanCheckUrlService.checkOneUrl(advertId, materialId, promoteUrl)) {
            return;
        }

        //8.对rsp重新设置落地页
        simpleDto.setPromoteUrl(promoteUrl);
        filterResult.setPromoteSource(PromoteSource.AB_TEST);
    }


    /**
     * 批量插入订单到hbase和缓存中
     * @param consumerId
     * @param advertOrderDOList
     * @return
     */
    @Override
    public boolean insertOrderToHbaseAndRedis(Long consumerId, List<AdvertOrderDO> advertOrderDOList) {
        int row = 0;
        try {
            DBTimeProfile.enter("recordLaunch.insertForRelog");
            row = advertOrderDAO.insertForRelog(advertOrderDOList);
        }catch (Exception e) {
            log.error("insertForRelog 异常", e);
        } finally {
            DBTimeProfile.release();
        }

        // 9、将请求到的广告订单放入缓存中
        if(row > 0){
            advertOrderDOList.forEach(advertOrderDO -> serviceManager.setAdvertOrderDO(consumerId, advertOrderDO.getDuibaOrderId(), advertOrderDO));

            return true;
        }

        return false;
    }

    /**
     * 补充filterResult日志
     *
     * @param req
     * @param advertVO
     * @param advOrientationItem
     * @param adxLoadAdvertDto
     * @param filterResult
     */
    private void richFilterResult(ObtainAdvertReq req, AdvertVO advertVO, AdvOrientationItem advOrientationItem, AdxLoadAdvertDto adxLoadAdvertDto,
        FilterResult filterResult) {

        AdvertPlan advertPlan = advertVO.getAdvertPlan();

        filterResult.setMaterialId(String.valueOf(adxLoadAdvertDto.getMaterialId()));
        filterResult.setSuccessId(adxLoadAdvertDto.getAdvertId());
        filterResult.setPlanId(adxLoadAdvertDto.getOrientationId());
        filterResult.setFee(adxLoadAdvertDto.getFee());

        filterResult.setAccountId(advertPlan.getAccountId());
        filterResult.setPackageType(advOrientationItem.getPackageType());
        filterResult.setPreCtr(adxLoadAdvertDto.getPreCtr());
        filterResult.setSubtype(advOrientationItem.getSubtype());
        filterResult.setResultCode(ErrorCode.E0000000.getErrorCode());
        filterResult.setUa(req.getUserAgent());
    }

    private void invalidStatusFresh(AdvertVO advertVO,Long advertId) throws TuiaException{
        //压测时不判断广告状态,因为测试数据源的数据状态与内存里的不一致
        if (PerfTestContext.isCurrentInPerfTestMode()) {
            return;
        }
        //验证广告投放状态
        if (AdvertDO.VALID_STATUS != advertVO.getAdvertPlan().getValidStatus()) {
            RedisLock lock = redisAtomicClient.getLock(advertId.toString(), 3);
            if (lock != null) {
                advertMapCacheManager.pushAdvertCacheUpdate(advertId);
            }
            log.info("ObtainAdvertRsp finishBiz is not valid status=" + advertVO.getAdvertPlan().getValidStatus()
                + ",advertId=" + advertId);
            throw new TuiaException(ErrorCode.E0500015);
        }
    }

    private AdvertOrderDO buildAdvertOrder(AdvertVO advertVO, ObtainAdvertReq req,
        Long advertOrderId, Long materialId,String promoteUrl,
                                           AdvertPriceVO advertPriceVO, ObtainAdvertRsp rsp,
                                           AdxLoadAdvertDto adxLoadAdvertDto, Long aFee, FilterResult filterResult,
                                           List<ABResult.ABResultDTO> abResultList) {
        AdvertOrderDO advertOrderDO = new AdvertOrderDO();
        AdvertPlan advertPlan = advertVO.getAdvertPlan();
        //构建广告优惠券的信息
        advertOrderDO.setAdvertId(advertPlan.getId());
        // 默认普通优惠券码
        advertOrderDO.setCouponType(AdvertDO.GENERAL_PREFERENCE_CODE);

        //构建广告基本信息
        advertOrderDO.setId(advertOrderId);
        advertOrderDO.setAppId(req.getAppId());
        advertOrderDO.setConsumerId(req.getConsumerId());
        // 用从nezha那边返回的订单ID
        advertOrderDO.setDuibaOrderId(adxLoadAdvertDto.getOrderId());
        advertOrderDO.setDuibaActivityId(req.getActivityId());
        advertOrderDO.setUa(req.getUa());
        advertOrderDO.setSlotId(req.getSlotId());
        advertOrderDO.setMaterialId(materialId);
        //把落地页url放到订单里，给日志需要的时候查询订单即可
        advertOrderDO.setPromoteUrl(promoteUrl);
        advertOrderDO.setGmtCreate(new Date());
        advertOrderDO.setGmtModified(new Date());

        // 79filterResult日志
        advertOrderDO.setFilterResultLogJson(JSONObject.toJSONString(filterResult));

        if (req.getLogExtExpMap() == null) {
            req.setLogExtExpMap(new HashMap<>());
        }
        // 是否开启提价保量模式（0=不开启，1=开启）
        req.getLogExtExpMap().put(AdvertReqLogExtKeyConstant.PRICE_RISE_MARK, String.valueOf(adxLoadAdvertDto.getPriceRiseMark()));
        // 创意素材ID
        String key = Joiner.on("|").join(advertOrderDO.getAdvertId(), advertOrderDO.getMaterialId(), advertOrderDO.getPromoteUrl());
        req.getLogExtExpMap().put(AdvertReqLogExtKeyConstant.ADVERT_CREATIVE, avertCreativeCacheService.getAdvertCreativeCache(key));
        // 5、获取投放时段
        AdvertPlanPeriodDO advertPeriod = advertPriceVO.gainPeriods();
        // 6、构建广告订单json信息
        OrderJsonVO vo = buildOrderJsonInfo(advertVO,adxLoadAdvertDto, advertPriceVO, req, rsp, advertPeriod, aFee, filterResult, abResultList);
        //原始长度提取出来,进行重新赋值，避免插入订单失败，导致日志丢失
        String orignJson = JSONObject.toJSONString(vo);

        advertOrderDO.setJson(orignJson);

        return advertOrderDO;
    }


    private void handlerMaterialTestOrder(OrderJsonVO vo, AdvertPriceVO advertPriceVO) {
        MaterialTestPlanDO materialTestPlanDO = advertPriceVO.getMaterialTestPlanDO();
        if (Objects.isNull(materialTestPlanDO)) {
            return ;
        }

        if (Optional.ofNullable(materialTestPlanDO.getTestPlanMaterial()).orElseGet(() -> false)) {
            vo.setMta(1);// 参与素材测试
            vo.setMtr(getMaterialTestResult(materialTestPlanDO));
            if (Objects.nonNull(materialTestPlanDO.getPlanId())) {
                vo.setPaId(materialTestPlanDO.getPlanId());
            }
            if (Objects.nonNull(materialTestPlanDO.getMaterialType())) {
                vo.setMtp(materialTestPlanDO.getMaterialType());
            }
            if (Objects.nonNull(materialTestPlanDO.getMaterialId())) {
                vo.setMtId(materialTestPlanDO.getMaterialId());
            }
        } else {
            vo.setMta(0);// 没有参与素材测试
        }
    }

    private static int getMaterialTestResult(MaterialTestPlanDO materialTestPlanDO) {
        return Optional.ofNullable(materialTestPlanDO).map(v -> v.getTestResult()).orElseGet(() -> false) ? 1: 0;
    }

    private OrderJsonVO buildOrderJsonInfo(AdvertVO advertVO, AdxLoadAdvertDto adxLoadAdvertDto, AdvertPriceVO advertPriceVO,
                                           ObtainAdvertReq req, ObtainAdvertRsp rsp, AdvertPlanPeriodDO advertPeriod,
                                           Long aFee, FilterResult filterResult, List<ABResult.ABResultDTO> abResultList) {
        Long advertOrientationPackageId = advertPriceVO.getAdvertOrientationPackageId() == null ? 0L :
            advertPriceVO.getAdvertOrientationPackageId();

        Map<String, String> extMap = Optional.ofNullable(req.getLogExtMap()).orElse(new HashMap<>());

        OrderJsonVO vo = new OrderJsonVO();
        vo.setDeli(req.getDeliveryType());
        vo.setPid(advertOrientationPackageId);
        vo.setTp(rsp.isPrivilege());
        vo.setAppFee(advertPriceVO.getConvertTypeCost());
        vo.setTrt(advertPriceVO.getTargetRecommendType());
        vo.setAss(advertPriceVO.getSupportStatus());
        vo.setSt(rsp.getStrategyType());
        vo.setFe(advertPriceVO.getFee());
        vo.setCt(advertPriceVO.getChargeType());
        vo.setuT(String.valueOf(req.getActivityUseType()));
        vo.setAcT(String.valueOf(req.getDuibaActivityType()));
        vo.setAcI(String.valueOf(req.getActivityId()));

        //全链路日志需要打印字段，给到各个链路(新建map防止因为引用导致数据被覆盖)
        vo.setLgEp(new HashMap<>(req.getLogExtExpMap().size()));
        vo.getLgEp().putAll(req.getLogExtExpMap());

        // abtest日志
        abtestLog(vo.getLgEp(), abResultList);

        // 投放时段
        Optional.ofNullable(advertPeriod).ifPresent(period -> vo.setPeid(period.getId()));
        vo.setExps(rsp.getExps());
        vo.setPkt(advertPriceVO.getPackageType());
        vo.setAst(Optional.ofNullable(req.getActivitySceneType()).map(Object::toString).orElse(
            PackagePlanConstants.INTERACTION_TYPE));

        vo.setTsp(advertPriceVO.getTrusteeship());
        vo.setTal(advertPriceVO.getTargetAppLimit());
        vo.setSwt(advertPriceVO.getStrongTarget());
        vo.setPtt(advertPriceVO.getPutTargetType());
        vo.setFacc(advertPriceVO.getFocusAppConvertCost());
        vo.setTspFee(advertPriceVO.getConvertCost());
        vo.setDevi(req.getDeviceId());
        vo.setfTag(rsp.getFlowTag());
        vo.setEncAr(rsp.getEncArpuResult());

        vo.setSty(Optional.ofNullable(advertPriceVO.getSubtype()).orElse(AdvertSubtypeEnum.CVR.getSubtype()));
        vo.setDsty(null != advertPriceVO.getDepthSubtype() ? advertPriceVO.getDepthSubtype() : advertVO.getDepthSubtype());

        vo.setRt(advertPriceVO.getResourceTag());
        vo.setBs(advertPriceVO.getBudgetSmooth());
        vo.setHui(StringTool.getStringBySet(advertPriceVO.getHitUserInterest(), "_"));

        if (extMap.size() > 0) {

            vo.setDsm(extMap.get("dsm"));
            vo.setDsm2(extMap.get(AdvertReqLogExtKeyConstant.DSM2));
            vo.setDcm(extMap.get("dcm"));
            vo.setDpm(extMap.get("dpm"));
            vo.setDtPage(extMap.get("directpage"));
            vo.setSaw(extMap.get(AdvertReqLogExtKeyConstant.SUB_ACTIVITY_WAY));
            vo.setAp(extMap.get(AdvertReqLogExtKeyConstant.ACTIVITY_PAGE));

            vo.setIdeId(extMap.get(AdvertReqLogExtKeyConstant.IDEAL_ID));
            vo.setPte(extMap.get(AdvertReqLogExtKeyConstant.PRICE_TYPE));
            vo.setPp(extMap.get(AdvertReqLogExtKeyConstant.PAR_PRICE));
            vo.setBt(extMap.get(AdvertReqLogExtKeyConstant.BILL_TYPE));
            vo.setFt(extMap.get(AdvertReqLogExtKeyConstant.FEE_TYPE));
            vo.setArd(extMap.get(AdvertReqLogExtKeyConstant.ADX_RID));
            vo.setPt(extMap.get(AdvertReqLogExtKeyConstant.PUT_TYPE));
            vo.setIt(extMap.get(AdvertReqLogExtKeyConstant.IS_TEST_ACTIVITY_TYPE));
            vo.setPli(extMap.get(AdvertReqLogExtKeyConstant.PLAN_ID));
            vo.setNtwn(extMap.get(AdvertReqLogExtKeyConstant.CONNECTION_TYPE));
            vo.setIcg(extMap.get(AdvertReqLogExtKeyConstant.IS_COMPARE_GROUP));
            vo.setRsd(extMap.get(AdvertReqLogExtKeyConstant.RESOURCE_ID));
            vo.setApl(extMap.get(AdvertReqLogExtKeyConstant.ADX_PRICE_LEVEL));

            vo.setSat(extMap.get(AdvertReqLogExtKeyConstant.SHORT_ACTIVITY_ID));

            vo.setLvl(extMap.get(AdvertReqLogExtKeyConstant.LEVEL));
            vo.setStgy(extMap.get(AdvertReqLogExtKeyConstant.STRATEGY));

            // 设备信息
            vo.setIme(extMap.get(AdvertReqLogExtKeyConstant.IMEI));
            vo.setIme5(extMap.get(AdvertReqLogExtKeyConstant.IMEI_MD5));
            vo.setIdfa(extMap.get(AdvertReqLogExtKeyConstant.IDFA));
            vo.setIdfa5(extMap.get(AdvertReqLogExtKeyConstant.IDFA_MD5));

            // 活动素材id
            vo.setSckId(extMap.get(AdvertReqLogExtKeyConstant.SCK_ID));
            // 分流标识
            vo.setSft(extMap.get(AdvertReqLogExtKeyConstant.SCK_FORM_TYPE));
            // 虚拟广告位模拟发券标识
            vo.setImoa(extMap.get(AdvertReqLogExtKeyConstant.IMITATE_REQ));

            // 资源位
            vo.setSop(extMap.get(AdvertReqLogExtKeyConstant.SOURCE_PAGE));
            // 媒体测试打标字段
            vo.setPgt(extMap.get(AdvertReqLogExtKeyConstant.PANGE_TEST));
            vo.setBtg(extMap.get(AdvertReqLogExtKeyConstant.BELONG_TO_GROUP));
            vo.setAskt(extMap.get(AdvertReqLogExtKeyConstant.ACTIVITY_SKIN_TYPE));
            vo.setAset(extMap.get(AdvertReqLogExtKeyConstant.ACTIVITY_SECOND_TYPE));
            vo.setAsa(extMap.get(AdvertReqLogExtKeyConstant.ACTIVITY_SUB_ACTIVITY));
            vo.setMu(extMap.get(AdvertReqLogExtKeyConstant.MEDIA_UNIT));
            //1105新增
            vo.setApi(extMap.get(AdvertReqLogExtKeyConstant.ACTIVITY_PUT_INDEX));
            vo.setpType(extMap.get(AdvertReqLogExtKeyConstant.PLUGIN_TYPE));
            vo.setXf(extMap.get(AdvertReqLogExtKeyConstant.XYSCJ_FREQUENCY));
            vo.setXpt(extMap.get(AdvertReqLogExtKeyConstant.XYSCJ_PASS_TYPE));
            vo.setAdxs(extMap.get(AdvertReqLogExtKeyConstant.ADX_SCENE));

            //20200220新增
            vo.setRlr(extMap.get(AdvertReqLogExtKeyConstant.REAL_TIME_RTA));
        }
        vo.setOsv(req.getOsVersion());
        vo.setUa(req.getUa());

        //日志补全
        vo.setPi(filterResult.getPutIndex());
        vo.setCi(filterResult.getCityId());
        vo.setPs(filterResult.getPriceSection());
        vo.setBn(filterResult.getBrandName());
        // 设备类型
        if (StringUtils.isNotBlank(req.getLogExtMap().get(AdvertReqLogExtKeyConstant.EQUIPMENT_MODEL))) {
            vo.setEquipmentModel(req.getLogExtMap().get(AdvertReqLogExtKeyConstant.EQUIPMENT_MODEL));
        }

        String appFlowType = Optional.ofNullable(req.getLogExtMap())
            .map(logExtMap -> logExtMap.get(AdvertOrderJsonKeyEnum.KEY_APP_FLOW_TYPE.getCode()))
            .orElse(AppFlowPlatform.OTHER.getCode().toString());
        vo.setAft(AppFlowTypeEnum.getByName(appFlowType).getCode());
        String collRid = Optional.ofNullable(req.getLogExtMap())
            .map(logExtMap -> logExtMap.get(AdvertReqLogExtKeyConstant.COLL_RID))
            .orElse("");
        vo.setCrd(collRid);
        vo.setAid(req.getAppId());
        vo.setFtg(rsp.getFlowTag());
        // 防止过长，外面进行json的判断，截断
        vo.setUat(req.getUserAgent());
        /**
         *  设置落地页出处{@link PromoteSource}
         */
        // 分媒体出价类型
        vo.setDaft(Optional.ofNullable(advertPriceVO.getDisAppFeeType()).orElse(DisAppFeeTypeEnum.DEFULT_TYPE.getCode()));
        vo.setAcs(advertPriceVO.getAppCostStableSwitch());
        vo.setWd(rsp.getWindId());
        vo.setAmt(req.getActivityMaterialType());

        // 调价因子, ctr, cvr, aFee
        vo.setApf(adxLoadAdvertDto.getAdjustPriceFactor());
        vo.setPctr(adxLoadAdvertDto.getPreCtr());
        vo.setPcvr(adxLoadAdvertDto.getPreCvr());
        vo.setNaf(aFee);

        /**素材ctr提高测试**/
        handlerMaterialTestOrder(vo, advertPriceVO);
        /**落地页来源*/
        Optional.ofNullable(filterResult.getPromoteSource()).ifPresent(promoteSource ->vo.setPros(promoteSource.getType()));

        Map<Long,Integer> allUserTimesMap = filterResult.getAllUserTimesMap();
        if(allUserTimesMap != null){
            vo.setTs(Optional.ofNullable(allUserTimesMap.get(advertPriceVO.getAdvertId())).orElse(CommonConstant.NO) + 1);
        }

        return vo;
    }

    /**
     * 日志补偿
     *
     * 1、补打请求日志
     * 2、补打发券日志
     * 3、补打曝光日志
     * 4、追加领券记录及时段发券量
     *
     * @param req
     */
    @Override
    public boolean reLog (AdxLogReq req) {

        try {

            // 广告检查
            AdvertVO advertVO = advertMapCacheManager.getAdvertCache(req.getAdvertId());
            if(advertVO == null){
                log.error("reLog error, advertVO is null, advertId = {}", req.getAdvertId());
                return false;
            }

            // 配置检查
            AdvOrientationItem advOrientationItem = advertMapCacheManager.getValidAdvOrientation(req.getAdvertId(), req.getOrientationId());
            if(advOrientationItem == null){
                log.error("reLog error, advOrientationItem is null, orientationId = {}", req.getOrientationId());
                return false;
            }

            // 查询广告订单信息
            AdvertOrderDO advertOrderDO = serviceManager.getAdvertOrderDO(req.getConsumerId(), req.getOrderId(), req.getAdxMediaType());
            if (null == advertOrderDO) {
                log.error("buildAdxExposureLog advertOrderDO is null, req={}", JSON.toJSONString(req));
                return false;
            }

            if (Objects.equals(req.getAdxMediaType(), AdxSceneEnum.OPTIONAL_AD.getCode())) {
                AdxSetSceneType.SET_EXPOSE_ADX_SCENE.setExposeScene(req, req.getAdxMediaType());
            } else {
                AdxSetSceneType.SET_EXPOSE_ADX_SCENE.setExposeScene(req,AdxSceneEnum.ADX_MEITUAN.getCode());
            }

            // 1、补打请求日志
            OrderJsonVO vo = JSONObject.parseObject(advertOrderDO.getJson(), OrderJsonVO.class);
            req.setLogExtExpMap(vo.getLgEp());

            if(req.getLogExtMap() != null){
                req.getLogExtMap().put(AdvertReqLogExtKeyConstant.REAL_TIME_RTA, vo.getRlr());
            }else {
                Map<String, String> LogExtMap = new HashMap<>();
                LogExtMap.put(AdvertReqLogExtKeyConstant.REAL_TIME_RTA, vo.getRlr());
                req.setLogExtMap(LogExtMap);
            }

            AdxRequestLog requestLog = new AdxRequestLog(req, req.getCityId());
            requestLog.log();


            // 2、构建adx发券日志，补打日志
            AdxLaunchLog launchLog = buildAdxLaunchLog(req, advertVO, advOrientationItem, advertOrderDO);
            launchLog.log();


            // 3、构建曝光日志，补打日志
            // 用户选广告活动不用打曝光日志
            if (!Objects.equals(req.getAdxMediaType(), AdxSceneEnum.OPTIONAL_AD.getCode())) {
                AdxExposureLog exposureLog = buildAdxExposureLog(req, advertOrderDO);
                if (exposureLog == null) {
                    return false;
                }
                exposureLog.log();
            }

            // 4.补打nezha相关日志
            remoteRelogService.relog(advertOrderDO.getDuibaOrderId());

            // 5.补打filterResult日志
            if (advertOrderDO.getFilterResultLogJson() != null) {
                FilterResultLog.innerLog(JSONObject.parseObject(advertOrderDO.getFilterResultLogJson(), FilterResult.class));

            }

            // 6、追加领券记录及时段发券量
            recordAdvertLaunch(req, advertOrderDO, advertVO);

            // 7.将确认的订单数据，插回正式(tuia_order_info)表里
            executorService.submit(() -> advertOrderDAO.insert(advertOrderDO));

        }catch (Exception e){
            log.error("reLog error, advertId={} ", req.getAdvertId(), e);
            return false;
        }
        return true;
    }

    private AdxExposureLog buildAdxExposureLog(AdxLogReq req, AdvertOrderDO advertOrderDO) {

        try {
            // 广告id纠正
            req.setAdvertId(advertIdCorrect(advertOrderDO, req.getAdvertId()));

            // 获取广告信息
            AdvertVO advertVO = advertMapCacheManager.getAdvertCache(req.getAdvertId());
            if (null == advertVO || null == advertVO.getAdvertPlan()) {
                log.error("buildAdxExposureLog advert is null, req={}, advertOrderDO={}", JSON.toJSONString(req), JSON.toJSONString(advertOrderDO));
                return null;
            }

            AdvertPlan advertPlan = advertVO.getAdvertPlan();

            //1.曝光日志参数封装
            req = spmLogReqCommit(req, advertVO, advertOrderDO, SpmType.SPM_LOG_EXPOSURE);

            //记录折扣率
            this.setDiscountRate(req);

            //account表中的1和2扣除的都是杭州推啊账户余额，属于杭州主体，只有3扣除的才是霍尔果斯余额
            req.setEffectiveMainType(advertVO.getEffectMainType());

            //2.代理商平台统计曝光数据
            advertRealDataService.incrExposureAdvert(advertPlan.getAgentId(), advertPlan.getAccountId(), req.getAdvertId(), advertPlan.getAdvertPlanId(), req.getEffectiveMainType());

            //4.曝光日志打印
            return new AdxExposureLog(req);
        }catch (Exception e){
            log.error("buildAdxExposureLog error, orderId={}", req.getOrderId(), e);
            return null;
        }
    }

    /**
     * 设置折扣率
     *
     * @param req
     */
    private void setDiscountRate(SpmlogReq req) {

        ChargeTypeEnum chargeTypeEnum = ChargeTypeEnum.getByDesc(req.getChargeType());
        double discountrate = advertMapCacheManager.getAdvertBidRate(req.getAdvertId(), chargeTypeEnum.getCode());
        req.setDiscountRate(discountrate);
    }

    /**
     * 广告曝光，点击参数封装
     * spmLogReqCommit:(). <br/>
     *
     * @param advertVO
     * @param advertOrderDO
     * @param type
     * @return
     * @throws Exception
     * @author zp
     * @since JDK 1.6
     */
    private AdxLogReq spmLogReqCommit(AdxLogReq logReq, AdvertVO advertVO, AdvertOrderDO advertOrderDO, String type) {
        logReq.setAppId(appIdCorrent(advertOrderDO, logReq.getAppId()));

        logReq.setSlotId(advertOrderDO.getSlotId());
        logReq.setMaterialId(advertOrderDO.getMaterialId());
        logReq.setActivityOrderId(logReq.getOrderId());
        if (logReq.getActivityUseType() == null) {
            logReq.setActivityUseType(logReq.getSlotId() == null ? 0 : 1);
        }
        logReq.setInfo(String.valueOf(advertOrderDO.getId()));
        logReq.setOrderId(String.valueOf(advertOrderDO.getId()));
        logReq.setType(type);

        OrderJsonVO vo = JSON.parseObject(advertOrderDO.getJson(), OrderJsonVO.class);

        // 订单json字段获取塞入日志里面
        logReq = specifyConfigBagReq(vo, logReq, advertVO);
        Map<String, String> map = logReq.getLogExtMap();
        if (null == map) {
            map = new HashMap<>(10);
        }
        map.put(AdvertReqLogExtKeyConstant.LAUNCH_LOG_PROMOTE_URL, advertOrderDO.getPromoteUrl());
        return logReq;
    }

    /**
     * 从订单json字段取内容，并打在日志里面 specifyConfigBagReq:<br/>
     *
     * @param vo
     * @param req
     * @author zp
     * @since JDK 1.6
     */
    private AdxLogReq specifyConfigBagReq(OrderJsonVO vo, AdxLogReq req, AdvertVO advertVO) {
        if (null == vo) {
            // 定向配置报为空时，插入默认id
            req.setOrientationId(0L);
            return req;
        }
        // 记录定向配置包id
        req.setOrientationId(null == vo.getPid() ? 0L : vo.getPid());
        if (vo.getCt() != null) {
            req.setChargeType(ChargeTypeEnum.getDescByCode(vo.getCt()));
        }
        req.setFee(vo.getFe());

        // 记录请求来源
        if (org.apache.commons.lang3.StringUtils.isNotBlank(vo.getuT())) {
            req.setActivityUseType(Integer.parseInt(vo.getuT()));
        }
        // 记录请求活动类型
        if (org.apache.commons.lang3.StringUtils.isNotBlank(vo.getAcT())) {
            req.setDuibaActivityType(vo.getAcT());
        }
        //ua
        if (org.apache.commons.lang3.StringUtils.isNotBlank(vo.getUa())) {
            req.setUa(vo.getUa());
        }
        //设备id
        if (org.apache.commons.lang3.StringUtils.isNotBlank(vo.getDevi())) {
            req.setDeviceId(vo.getDevi());
        }

        if (null == req.getLogExtMap()) {
            req.setLogExtMap(Maps.newHashMap());
        }
        // 价格区间
        req.setPriceSection(vo.getPs());

        //点击位置，该字段只需要互动广告点击和计费日志有，其他地方不需要打印
        req.getLogExtMap().put(AdvertReqLogExtKeyConstant.CLICK_POSITION, String.valueOf(req.getClickPosition()));
        // 记录领券次数
        req.getLogExtMap().put(AdvertOrderJsonKeyEnum.KEY_TIMES.getCode(), String.valueOf(vo.getTs()));
        req.getLogExtMap().put(AdvertOrderJsonKeyEnum.KEY_STRATEGY_TYPE.getCode(), vo.getSt());
        req.getLogExtMap().put(AdvertOrderJsonKeyEnum.KEY_PRIVILEGE.getCode(), String.valueOf(vo.getTp()));
        req.getLogExtMap().put(AdvertOrderJsonKeyEnum.KEY_ACCOUNT_ID.getCode(),
            String.valueOf(advertVO.getAdvertPlan().getAccountId()));
        req.getLogExtMap().put(AdvertOrderJsonKeyEnum.KEY_AGENT_ID.getCode(),
            String.valueOf(advertVO.getAdvertPlan().getAgentId()));
        req.getLogExtMap().put(AdvertOrderJsonKeyEnum.KEY_EXPS.getCode(), String.valueOf(vo.getExps()));
        req.getLogExtMap().put(AdvertOrderJsonKeyEnum.FLOW_TAG.getCode(), String.valueOf(vo.getfTag()));
        req.getLogExtMap().put(AdvertOrderJsonKeyEnum.KEY_PACKAGE_TYPE.getCode(), String.valueOf(vo.getPkt()));
        req.getLogExtMap().put(AdvertOrderJsonKeyEnum.KEY_ACTIVITY_TYPE.getCode(), String.valueOf(vo.getAst()));
        req.getLogExtMap().put(AdvertReqLogExtKeyConstant.TRUSTEESHIP, vo.getTsp() + "");
        req.getLogExtMap().put(AdvertReqLogExtKeyConstant.TRUSTEESHIP_CONVERT_COST, vo.getTspFee() + "");
        req.getLogExtMap().put(AdvertReqLogExtKeyConstant.GAME_TAG, Optional.ofNullable(vo.getGm()).orElse(
            CommonServiceImpl.BAICHUAN_GAME_TAG));
        req.getLogExtMap().put(AdvertReqLogExtKeyConstant.RISK_CHEAT, vo.getRc());
        req.getLogExtMap().put(AdvertReqLogExtKeyConstant.APP_TYPE, Optional.ofNullable(vo.getAt()).orElse(
            NewAppAdvertTradeDO.APP_TYPE_OLD.toString()));
        req.getLogExtMap().put(AdvertReqLogExtKeyConstant.NEW_APP_TEST_FEE, String.valueOf(vo.getNbf()));
        req.getLogExtMap().put(AdvertReqLogExtKeyConstant.TARGET_PACKAGE_ID, vo.getTap() == null ? null : vo.getTap() + "");
        req.getLogExtMap().put(AdvertReqLogExtKeyConstant.TARGET_RECOMMEND_TYPE, Optional.ofNullable(vo.getTrt()).orElse(0) + "");

        req.getLogExtMap().put(AdvertReqLogExtKeyConstant.SUPPORT_STATUS, vo.getAss() + "");
        req.getLogExtMap().put(AdvertReqLogExtKeyConstant.SUPPORT_WEIGHT_STATUS, vo.getSws() + "");
        req.getLogExtMap().put(AdvertReqLogExtKeyConstant.SUPPORT_WEIGHT, vo.getSw() + "");
        req.getLogExtMap().put(AdvertReqLogExtKeyConstant.ENC_ARPU_RESULT, vo.getEncAr() + "");
        if (vo.getSty() != null) {
            req.getLogExtMap().put(AdvertReqLogExtKeyConstant.SUBTYPE, String.valueOf(vo.getSty()));
        }
        req.getLogExtMap().put(AdvertReqLogExtKeyConstant.DEPTH_SUBTYPE, String.valueOf(vo.getDsty()));
        req.getLogExtMap().put(AdvertReqLogExtKeyConstant.PUT_TARGET_TYPE, String.valueOf(vo.getPtt()));
        req.getLogExtMap().put(AdvertReqLogExtKeyConstant.TARGET_APP_LIMIT, String.valueOf(vo.getTal()));
        req.getLogExtMap().put(AdvertReqLogExtKeyConstant.STRONG_TARGET, String.valueOf(vo.getSwt()));
        req.getLogExtMap().put(AdvertReqLogExtKeyConstant.FOCUS_APP_CONVERT_COST, String.valueOf(vo.getFacc()));
        req.getLogExtMap().put(AdvertReqLogExtKeyConstant.APP_FEE, String.valueOf(vo.getAppFee()));
        req.getLogExtMap().put(AdvertReqLogExtKeyConstant.MAIN_TYPE, String.valueOf(AdvertReqLogExtKeyConstant.INTERACT));
        req.getLogExtMap().put(AdvertReqLogExtKeyConstant.REPEAT_LUNCH_TYPE, Optional.ofNullable(vo.getRlt()).map(rlt -> rlt.toString()).orElse(null));
        req.getLogExtMap().put(AdvertReqLogExtKeyConstant.TRADE_APP_LUNCH_TYPE, Optional.ofNullable(vo.getTat()).map(tat -> tat.toString()).orElse(null));
        req.getLogExtMap().put(AdvertReqLogExtKeyConstant.RESOURCE_TAG, vo.getRt());
        req.getLogExtMap().put(AdvertReqLogExtKeyConstant.BUDGET_SMOOTH, Optional.ofNullable(vo.getBs()).map(bs -> bs.toString())
            .orElse(AdvertOrientationPackageDO.BUDGET_SMOOTH_DEFULT.toString()));

        req.getLogExtMap().put(AdvertReqLogExtKeyConstant.IDEAL_ID, vo.getIdeId());
        req.getLogExtMap().put(AdvertReqLogExtKeyConstant.PRICE_TYPE, vo.getPte());
        req.getLogExtMap().put(AdvertReqLogExtKeyConstant.PAR_PRICE, vo.getPp());
        req.getLogExtMap().put(AdvertReqLogExtKeyConstant.BILL_TYPE, vo.getBt());
        req.getLogExtMap().put(AdvertReqLogExtKeyConstant.FEE_TYPE, vo.getFt());
        req.getLogExtMap().put(AdvertReqLogExtKeyConstant.ADX_RID, vo.getArd());
        req.getLogExtMap().put(AdvertReqLogExtKeyConstant.PUT_TYPE, vo.getPt());
        req.getLogExtMap().put(AdvertReqLogExtKeyConstant.DSM2, vo.getDsm2());

        req.getLogExtMap().put(AdvertReqLogExtKeyConstant.OS_VERSION, vo.getOsv());
        req.getLogExtMap().put(AdvertReqLogExtKeyConstant.UA, vo.getUa());

        //日志补全新加
        req.getLogExtMap().put(AdvertReqLogExtKeyConstant.A_FEE, vo.getNaf() + "");
        req.getLogExtMap().put(AdvertReqLogExtKeyConstant.PUT_INDEX, vo.getPi() + "");
        req.getLogExtMap().put(AdvertReqLogExtKeyConstant.CITY_ID, vo.getCi());
        req.getLogExtMap().put(AdvertReqLogExtKeyConstant.PRICE_SECTION, vo.getPs());
        req.getLogExtMap().put(AdvertReqLogExtKeyConstant.BRAND_NAME, vo.getBn());
        // 设备类型
        Optional.ofNullable(vo.getEquipmentModel()).ifPresent(equipmentModel -> req.getLogExtMap().put(AdvertReqLogExtKeyConstant.EQUIPMENT_MODEL, equipmentModel));
        req.getLogExtMap().put(AdvertReqLogExtKeyConstant.APP_FLOW_TYPE, vo.getAft());
        req.getLogExtMap().put(AdvertReqLogExtKeyConstant.MODEL, vo.getMl());
        req.getLogExtMap().put(AdvertReqLogExtKeyConstant.CONNECTION_TYPE, vo.getNtwn());
        //req.getLogExtMap().put(AdvertReqLogExtKeyConstant.USER_AGENT,vo.getUa());
        //req.getLogExtMap().put(AdvertReqLogExtKeyConstant.DEVICE_ID,vo.getDevi());

        req.getLogExtMap().put(AdvertReqLogExtKeyConstant.IS_TEST_ACTIVITY_TYPE, vo.getIt());
        req.getLogExtMap().put(AdvertReqLogExtKeyConstant.PLAN_ID, vo.getPli());
        req.getLogExtMap().put(AdvertReqLogExtKeyConstant.SHORT_ACTIVITY_ID, vo.getSat());
        // 落地页来源 标识{@link PromoteSource}
        req.getLogExtMap().put(AdvertReqLogExtKeyConstant.ADVERT_PROMOTE_SOURCE, String.valueOf(vo.getPros()));
        // 分媒体出价类型
        req.getLogExtMap().put(AdvertReqLogExtKeyConstant.DIS_APP_FEE_TYPE,Optional.ofNullable(vo.getDaft()).map(type -> type.toString())
            .orElse(DisAppFeeTypeEnum.DEFULT_TYPE.getCode().toString()));

        //素材提高测试
        Optional.ofNullable(vo.getPaId()).ifPresent(testPlanId ->req.getLogExtMap().put(AdvertReqLogExtKeyConstant.MATERIAL_TEST_PLAN_ID,String.valueOf(testPlanId)));
        Optional.ofNullable(vo.getMtp()).ifPresent(materialType ->req.getLogExtMap().put(AdvertReqLogExtKeyConstant.MATERIAL_TYPE,materialType));
        Optional.ofNullable(vo.getMta()).ifPresent(materialTest ->req.getLogExtMap().put(AdvertReqLogExtKeyConstant.MATERIAL_TEST,""+materialTest));
        Optional.ofNullable(vo.getMtId()).ifPresent(materialTestId ->req.getLogExtMap().put(AdvertReqLogExtKeyConstant.MATERIAL_TEST_ID,""+materialTestId));
        Optional.ofNullable(vo.getMtr()).ifPresent(materialTestResult ->req.getLogExtMap().put(AdvertReqLogExtKeyConstant.MATERIAL_TEST_RESULT,""+materialTestResult));


        //如何是兑吧的活动，则无广告位概念
        // 测试广告位子投放方式 :只在互动广告打印（为空时不打印）
        if (org.apache.commons.lang3.StringUtils.isNotBlank(vo.getSaw())) {
            req.getLogExtMap().put(AdvertReqLogExtKeyConstant.SUB_ACTIVITY_WAY, vo.getSaw());
        }
        // 自定义活动（活动工具）打印
        if (org.apache.commons.lang3.StringUtils.isNotBlank(vo.getAp())) {
            req.getLogExtMap().put(AdvertReqLogExtKeyConstant.ACTIVITY_PAGE, vo.getAp());
        }
        // 如何是兑吧的活动，则无广告位概念
        if (req.getActivityUseType() != null && (0 == req.getActivityUseType() || 1 == req.getActivityUseType())) {
            req.setDuibaSlotId(req.getSlotId());
            req.setSlotId(null);
        }

        // 设置设备信息
        req.getLogExtMap().put(AdvertReqLogExtKeyConstant.IMEI, vo.getIme());
        req.getLogExtMap().put(AdvertReqLogExtKeyConstant.IMEI_MD5, vo.getIme5());
        req.getLogExtMap().put(AdvertReqLogExtKeyConstant.IDFA, vo.getIdfa());
        req.getLogExtMap().put(AdvertReqLogExtKeyConstant.IDFA_MD5, vo.getIdfa5());
        req.getLogExtMap().put(AdvertReqLogExtKeyConstant.OAID, vo.getOaid());
        req.getLogExtMap().put(AdvertReqLogExtKeyConstant.OAID_MD5, vo.getOaid5());
        req.getLogExtMap().put(AdvertReqLogExtKeyConstant.PRE_ARUP,vo.getArup()+"");

        // 活动素材id
        req.getLogExtMap().put(AdvertReqLogExtKeyConstant.SCK_ID, vo.getSckId());
        // 分流标识
        req.getLogExtMap().put(AdvertReqLogExtKeyConstant.SCK_FORM_TYPE, vo.getSft());
        // 资源位
        req.getLogExtMap().put(AdvertReqLogExtKeyConstant.SOURCE_PAGE, vo.getSop());
        // 盘古测试字段
        req.getLogExtMap().put(AdvertReqLogExtKeyConstant.PANGE_TEST, vo.getPgt());
        req.getLogExtMap().put(AdvertReqLogExtKeyConstant.BELONG_TO_GROUP, vo.getBtg());
        req.getLogExtMap().put(AdvertReqLogExtKeyConstant.ACTIVITY_SKIN_TYPE, vo.getAskt());
        req.getLogExtMap().put(AdvertReqLogExtKeyConstant.ACTIVITY_SECOND_TYPE, vo.getAset());
        req.getLogExtMap().put(AdvertReqLogExtKeyConstant.ACTIVITY_SUB_ACTIVITY, vo.getAsa());
        req.getLogExtMap().put(AdvertReqLogExtKeyConstant.MEDIA_UNIT, vo.getMu());
        // ADX 参数
        setAdxParam(vo, req);

        // 虚拟广告位模拟发券请求
        req.getLogExtMap().put(AdvertReqLogExtKeyConstant.IMITATE_REQ, vo.getImoa());

        req.getLogExtMap().put(AdvertReqLogExtKeyConstant.ACTIVITY_MATERIAL_TYPE,vo.getAmt()+"");
        req.getLogExtMap().put(AdvertReqLogExtKeyConstant.WIND_ID,vo.getWd()+"");
        //201911005新增
        req.getLogExtMap().put(AdvertReqLogExtKeyConstant.ACTIVITY_PUT_INDEX,vo.getApi());
        req.getLogExtMap().put(AdvertReqLogExtKeyConstant.PLUGIN_TYPE,vo.getpType());
        req.getLogExtMap().put(AdvertReqLogExtKeyConstant.XYSCJ_FREQUENCY,vo.getXf());
        req.getLogExtMap().put(AdvertReqLogExtKeyConstant.XYSCJ_PASS_TYPE,vo.getXpt());

        //新增times字段 20191126 字段新增
        req.getLogExtMap().put(AdvertReqLogExtKeyConstant.TIMES,String.valueOf(vo.getTs()));

        req.getLogExtMap().put(AdvertReqLogExtKeyConstant.REAL_TIME_RTA, vo.getRlr());

        req.setLogExtExpMap(vo.getLgEp());
        return req;
    }

    private void setAdxParam(OrderJsonVO vo, SpmlogReq req) {

        if (org.apache.commons.lang3.StringUtils.isNotBlank(vo.getRsd())) {
            req.getLogExtMap().put(AdvertReqLogExtKeyConstant.RESOURCE_ID, vo.getRsd());
        }

        if (org.apache.commons.lang3.StringUtils.isNotBlank(vo.getApl())) {
            req.getLogExtMap().put(AdvertReqLogExtKeyConstant.ADX_PRICE_LEVEL, vo.getApl());
        }

        if (org.apache.commons.lang3.StringUtils.isNotBlank(vo.getIcg())) {
            req.getLogExtMap().put(AdvertReqLogExtKeyConstant.IS_COMPARE_GROUP, vo.getIcg());
        }

        if (org.apache.commons.lang3.StringUtils.isNotBlank(vo.getLvl())) {
            req.getLogExtMap().put(AdvertReqLogExtKeyConstant.LEVEL, vo.getLvl());
        }

        if (org.apache.commons.lang3.StringUtils.isNotBlank(vo.getStgy())) {
            req.getLogExtMap().put(AdvertReqLogExtKeyConstant.STRATEGY, vo.getStgy());
        }
    }

    /**
     * appId纠正
     * appIdCorrent:(appId纠正，以广告订单为准). <br/>
     *
     * @param advertOrderDO
     * @param appId
     * @return
     * @author zp
     * @since JDK 1.6
     */
    private Long appIdCorrent(AdvertOrderDO advertOrderDO, Long appId) {
        if (null == appId || appId.equals(0L) || !appId.equals(advertOrderDO.getAppId())) {
            return advertOrderDO.getAppId();
        }
        return appId;
    }

    /**
     * 广告Id纠正
     *
     * @param advertOrderDO
     * @param advertId
     * @return
     * @author zp
     * @since JDK 1.6
     */
    private Long advertIdCorrect(AdvertOrderDO advertOrderDO, Long advertId) {
        if (null == advertId || advertId.equals(0L) || !advertId.equals(advertOrderDO.getAdvertId())) {
            return advertOrderDO.getAdvertId();
        }
        return advertId;
    }


    /**
     *  @param req
     * @param advertOrderDO
     * @param advertVO
     */
    private void recordAdvertLaunch(AdxLogReq req, AdvertOrderDO advertOrderDO, AdvertVO advertVO) {
        AdvertPlan advertPlan = advertVO.getAdvertPlan();

        AdvOrientationItem advOrientationItem = advertMapCacheManager.getValidAdvOrientation(advertOrderDO.getAdvertId(), req.getOrientationId());
        if(advOrientationItem == null){
            log.error("recordAdvertLaunch advOrientationItem is null, orderId=[{}]", req.getOrderId());
            return;
        }


        // 1、获取投放时段
        AdvertPlanPeriodDO advertPeriod = advOrientationItem.simple2PriceVO().gainPeriods();

        // 2、通知增加该时段的发券量
        if (advertPeriod != null && advertPeriod.getId() != null) {
            engineSyncRealTimeService.addPeriodReq(advertPeriod.getId(), advertPeriod.getPeriodValue(), advertPeriod.getPeriodType());
        }

        // 临时记录流量类型，是否经过了广告主发券限制的过滤
        String limitAccountType = Optional.ofNullable(req.getLogExtMap()).map(logMap -> Optional.ofNullable(logMap.get("limitAccountType")).orElse(AccountLimitTypeEnum.UNKNOW.getCode())).orElse(AccountLimitTypeEnum.UNKNOW.getCode());


        // 3、记录用户记录
        consumerRecordSerivce.addRecordReq(advertOrderDO, this.getTagsStr(advertVO), req.getMaterialId(), advertVO.getAdvertPlan().getAccountId(), limitAccountType, "0", new FilterResult(), false, null);


        // 4、添加发券次数统计
        advertRealDataService.incrLaunchAdvert(advertPlan.getAgentId(), advertPlan.getAccountId(), advertOrderDO.getAdvertId(), advertPlan.getAdvertPlanId(), advertVO.getEffectMainType(),  null, req.getAppId(), CommonConstant.NO);

    }


    private String getTagsStr(AdvertVO advertVO) {
        AdvertTagDO advertTagDO = advertVO.getAdvertTagDO();
        if (advertTagDO == null) {
            return null;
        } else {
            return advertTagDO.getMatchTagNums();
        }
    }

    private AdxLaunchLog buildAdxLaunchLog(AdxLogReq req, AdvertVO advertVO, AdvOrientationItem advOrientationItem,
        AdvertOrderDO advertOrderDO) {

        //
        AdvertPlan advertPlan = advertVO.getAdvertPlan();

        //
        AdvertPriceVO advertPriceVO = advOrientationItem.simple2PriceVO();

        // 构建日志体
        ObtainAdvertReqLogExt reqLogExt = buildReqLogExt(advertPlan, advertVO, advertPriceVO, req, advertOrderDO);

        return new AdxLaunchLog(reqLogExt);
    }


    private ObtainAdvertReqLogExt buildReqLogExt(AdvertPlan advertPlan, AdvertVO advertVO, AdvertPriceVO advertPriceVO,
        AdxLogReq req, AdvertOrderDO advertOrderDO){

        AdvertTagDO advertTagDO = advertVO.getAdvertTagDO();
        OrderJsonVO vo = JSONObject.parseObject(advertOrderDO.getJson(), OrderJsonVO.class);

        //获取广告折扣率
        double discountrate = advertMapCacheManager.getAdvertBidRate(advertPlan.getId(), advertPriceVO.getChargeType());

        Map<String, String> extMap = Optional.ofNullable(req.getLogExtMap()).orElse(new HashMap<>());

        ObtainAdvertReqLogExt reqLogExt = BeanUtils.copy(req, ObtainAdvertReqLogExt.class);

        reqLogExt.setOrderId(req.getOrderId());
        reqLogExt.setInfo(req.getOrderId());
        reqLogExt.setMaterialId(advertOrderDO.getMaterialId());
        reqLogExt.setCityId(req.getCityId());
        if (StringUtils.isNotBlank(vo.getCi())) {
            reqLogExt.setCityId(vo.getCi());
        }
        reqLogExt.setFee(vo.getFe());
        reqLogExt.setChargeType(ChargeTypeEnum.getByCode(vo.getCt()).getDesc());
        reqLogExt.setActivityOrderId(req.getOrderId());
        reqLogExt.setHour(StringTool.getStringHourBy(req.getTimestamp()));
        reqLogExt.setOrientationId(advertPriceVO.getAdvertOrientationPackageId());
        reqLogExt.setaFee(vo.getNaf());
        //account表中的1和2扣除的都是杭州推啊账户余额，属于杭州主体，只有3扣除的才是霍尔果斯余额

        reqLogExt.setEffectiveMainType(advertVO.getEffectMainType());
        reqLogExt.setDiscountRate(discountrate);

        if (null == reqLogExt.getLogExtMap()) {
            reqLogExt.setLogExtMap(Maps.newHashMap());
        }

        //增加落地页日志打印
        reqLogExt.getLogExtMap().put(AdvertReqLogExtKeyConstant.LAUNCH_LOG_PROMOTE_URL, advertOrderDO.getPromoteUrl());
        reqLogExt.getLogExtMap().put(AdvertReqLogExtKeyConstant.TARGET_RECOMMEND_TYPE, Optional.ofNullable(advertPriceVO.getTargetRecommendType()).orElse(0) + "");
        reqLogExt.getLogExtMap().put(AdvertOrderJsonKeyEnum.KEY_ACCOUNT_ID.getCode(), String.valueOf(advertPlan.getAccountId()));
        reqLogExt.getLogExtMap().put(AdvertOrderJsonKeyEnum.KEY_AGENT_ID.getCode(), String.valueOf(advertPlan.getAgentId()));
        reqLogExt.getLogExtMap().put(AdvertOrderJsonKeyEnum.KEY_TYPE.getCode(), String.valueOf(AdxTypeEnum.MEITUAN.getCode()));
        reqLogExt.getLogExtMap().put(AdvertReqLogExtKeyConstant.IS_OPEN_REPEAT, String.valueOf(advertPlan.getRepeatExposure()));
        reqLogExt.getLogExtMap().put(AdvertOrderJsonKeyEnum.KEY_PACKAGE_TYPE.getCode(), String.valueOf(advertPriceVO.getPackageType()));
        reqLogExt.getLogExtMap().put(AdvertReqLogExtKeyConstant.REPEAT_COUNT, String.valueOf(0));
        reqLogExt.getLogExtMap().put(AdvertReqLogExtKeyConstant.TRUSTEESHIP, advertPriceVO.getTrusteeship() + "");
        reqLogExt.getLogExtMap().put(AdvertReqLogExtKeyConstant.PUT_TARGET_TYPE, advertPriceVO.getPutTargetType() + "");
        reqLogExt.getLogExtMap().put(AdvertReqLogExtKeyConstant.FOCUS_APP_CONVERT_COST, advertPriceVO.getFocusAppConvertCost() + "");
        reqLogExt.getLogExtMap().put(AdvertReqLogExtKeyConstant.TARGET_APP_LIMIT, advertPriceVO.getTargetAppLimit() + "");

        reqLogExt.getLogExtMap().put(AdvertReqLogExtKeyConstant.STRONG_TARGET, advertPriceVO.getStrongTarget() + "");
        reqLogExt.getLogExtMap().put(AdvertReqLogExtKeyConstant.TRUSTEESHIP_CONVERT_COST, advertPriceVO.getConvertCost() + "");
        reqLogExt.getLogExtMap().put(AdvertReqLogExtKeyConstant.SUPPORT_STATUS, advertPriceVO.getSupportStatus() + "");
        reqLogExt.getLogExtMap().put(AdvertReqLogExtKeyConstant.ADVERT_WEIGHT, advertPriceVO.getWeight() + "");

        reqLogExt.getLogExtMap().put(AdvertReqLogExtKeyConstant.IDEAL_ID, extMap.get(AdvertReqLogExtKeyConstant.IDEAL_ID));
        reqLogExt.getLogExtMap().put(AdvertReqLogExtKeyConstant.PRICE_TYPE, extMap.get(AdvertReqLogExtKeyConstant.PRICE_TYPE));
        reqLogExt.getLogExtMap().put(AdvertReqLogExtKeyConstant.PAR_PRICE, extMap.get(AdvertReqLogExtKeyConstant.PAR_PRICE));
        reqLogExt.getLogExtMap().put(AdvertReqLogExtKeyConstant.BILL_TYPE, extMap.get(AdvertReqLogExtKeyConstant.BILL_TYPE));
        reqLogExt.getLogExtMap().put(AdvertReqLogExtKeyConstant.FEE_TYPE, extMap.get(AdvertReqLogExtKeyConstant.FEE_TYPE));
        reqLogExt.getLogExtMap().put(AdvertReqLogExtKeyConstant.ADX_RID, vo.getArd());
        reqLogExt.getLogExtMap().put(AdvertReqLogExtKeyConstant.PUT_TYPE, extMap.get(AdvertReqLogExtKeyConstant.PUT_TYPE));
        reqLogExt.getLogExtMap().put(AdvertReqLogExtKeyConstant.DSM2, extMap.get(AdvertReqLogExtKeyConstant.DSM2));

        reqLogExt.getLogExtMap().put(AdvertReqLogExtKeyConstant.UA, vo.getUa());

        //日志补全新加
        reqLogExt.getLogExtMap().put(AdvertReqLogExtKeyConstant.PRICE_SECTION, vo.getPs());
        reqLogExt.getLogExtMap().put(AdvertReqLogExtKeyConstant.BRAND_NAME, vo.getBn());
        // 设备类型
        Optional.ofNullable(vo.getEquipmentModel()).ifPresent(equipmentModel -> req.getLogExtMap().put(AdvertReqLogExtKeyConstant.EQUIPMENT_MODEL, equipmentModel));

        reqLogExt.getLogExtMap().put(AdvertReqLogExtKeyConstant.SOURCE_PAGE, extMap.get(AdvertReqLogExtKeyConstant.SOURCE_PAGE));
        req.getLogExtMap().put(AdvertOrderJsonKeyEnum.KEY_ACTIVITY_TYPE.getCode(), String.valueOf(vo.getAst()));

        String appFlowType = Optional.ofNullable(req.getLogExtMap())
            .map(logExtMap -> logExtMap.get(AdvertOrderJsonKeyEnum.KEY_APP_FLOW_TYPE.getCode()))
            .orElse(AppFlowPlatform.OTHER.getCode().toString());
        reqLogExt.getLogExtMap().put(AdvertReqLogExtKeyConstant.APP_FLOW_TYPE, AppFlowTypeEnum.getByName(appFlowType).getCode());
        Optional.ofNullable(advertTagDO).ifPresent(dto -> {
            Optional.ofNullable(dto.getAdvertTradeId()).ifPresent(advertTradeId -> reqLogExt.getLogExtMap().put(AdvertReqLogExtKeyConstant.TRADE_ID_NUM, String.valueOf(advertTradeId)));
            Optional.ofNullable(dto.getNewAdvertTradeId()).ifPresent(newAdvertTradeId -> reqLogExt.getLogExtMap().put(AdvertReqLogExtKeyConstant.NEW_TRADE_ID, String.valueOf(newAdvertTradeId)));
            Optional.ofNullable(dto.getMatchTagNums()).ifPresent(matchTagNums -> reqLogExt.getLogExtMap().put(AdvertReqLogExtKeyConstant.MATCH_TAG_NUM, matchTagNums));
        });

        reqLogExt.getLogExtMap().put(AdvertReqLogExtKeyConstant.SUBTYPE, String.valueOf(Optional.ofNullable(vo.getSty()).orElse(AdvertSubtypeEnum.CVR.getSubtype())));
        reqLogExt.getLogExtMap().put(AdvertReqLogExtKeyConstant.DEPTH_SUBTYPE, String.valueOf(vo.getDsty()));
        reqLogExt.getLogExtMap().put(AdvertReqLogExtKeyConstant.APP_FEE, String.valueOf(advertPriceVO.getConvertTypeCost()));
        reqLogExt.getLogExtMap().put(AdvertReqLogExtKeyConstant.MAIN_TYPE, String.valueOf(AdvertReqLogExtKeyConstant.INTERACT));
        // 互动广告打印:测试广告位子投放方式
        if (StringUtils.isNotBlank(req.getLogExtMap().get(AdvertReqLogExtKeyConstant.SUB_ACTIVITY_WAY))) {
            reqLogExt.getLogExtMap().put(AdvertReqLogExtKeyConstant.SUB_ACTIVITY_WAY, req.getLogExtMap().get(AdvertReqLogExtKeyConstant.SUB_ACTIVITY_WAY));
        }
        // 自定义活动（活动工具）打印
        if (StringUtils.isNotBlank(req.getLogExtMap().get(AdvertReqLogExtKeyConstant.ACTIVITY_PAGE))) {
            reqLogExt.getLogExtMap().put(AdvertReqLogExtKeyConstant.ACTIVITY_PAGE, req.getLogExtMap().get(AdvertReqLogExtKeyConstant.ACTIVITY_PAGE));
        }

        //资源标签
        reqLogExt.getLogExtMap().put(AdvertReqLogExtKeyConstant.RESOURCE_TAG, advertPriceVO.getResourceTag());
        reqLogExt.getLogExtMap().put(AdvertReqLogExtKeyConstant.A_FEE, vo.getNaf() + "");
        reqLogExt.getLogExtMap().put(AdvertReqLogExtKeyConstant.PUT_INDEX, vo.getPi() + "");
        reqLogExt.getLogExtMap().put(AdvertReqLogExtKeyConstant.FEE, vo.getFe() + "");
        reqLogExt.getLogExtMap().put(AdvertReqLogExtKeyConstant.ADJUST_PRICE_FACTOR, vo.getApf() + "");
        reqLogExt.getLogExtMap().put(AdvertReqLogExtKeyConstant.PRE_CTR, vo.getPctr() + "");
        reqLogExt.getLogExtMap().put(AdvertReqLogExtKeyConstant.PRE_CVR, vo.getPcvr() + "");


        // 预算平滑消耗模式
        reqLogExt.getLogExtMap().put(AdvertReqLogExtKeyConstant.BUDGET_SMOOTH, Optional.ofNullable(advertPriceVO.getBudgetSmooth())
            .map(Object::toString).orElse(AdvertOrientationPackageDO.BUDGET_SMOOTH_DEFULT.toString()));

        // 分媒体出价类型
        reqLogExt.getLogExtMap().put(AdvertReqLogExtKeyConstant.DIS_APP_FEE_TYPE, Optional.ofNullable(advertPriceVO.getDisAppFeeType()).map(
            Object::toString).orElse(DisAppFeeTypeEnum.DEFULT_TYPE.getCode().toString()));

        //新增times字段 20191126 字段新增
        reqLogExt.getLogExtMap().put(AdvertReqLogExtKeyConstant.TIMES,String.valueOf(vo.getTs()));

        //20200220新增
        reqLogExt.getLogExtMap().put(AdvertReqLogExtKeyConstant.REAL_TIME_RTA, vo.getRlr());

        reqLogExt.setLogExtExpMap(vo.getLgEp());

        //素材提高测试
        Optional.ofNullable(vo.getPaId()).ifPresent(testPlanId ->req.getLogExtMap().put(AdvertReqLogExtKeyConstant.MATERIAL_TEST_PLAN_ID,String.valueOf(testPlanId)));
        Optional.ofNullable(vo.getMtp()).ifPresent(materialType ->req.getLogExtMap().put(AdvertReqLogExtKeyConstant.MATERIAL_TYPE,materialType));
        Optional.ofNullable(vo.getMta()).ifPresent(materialTest ->req.getLogExtMap().put(AdvertReqLogExtKeyConstant.MATERIAL_TEST,""+materialTest));
        Optional.ofNullable(vo.getMtId()).ifPresent(materialTestId ->req.getLogExtMap().put(AdvertReqLogExtKeyConstant.MATERIAL_TEST_ID,""+materialTestId));
        Optional.ofNullable(vo.getMtr()).ifPresent(materialTestResult ->req.getLogExtMap().put(AdvertReqLogExtKeyConstant.MATERIAL_TEST_RESULT,""+materialTestResult));

        req.setPriceSection(vo.getPs());

        //落地页来源
        req.getLogExtMap().put(AdvertReqLogExtKeyConstant.ADVERT_PROMOTE_SOURCE, String.valueOf(vo.getPros()));
        return reqLogExt;
    }

    /**
     * 打印实验评结果日志
     */
    private void abtestLog(Map<String, String> lgEp, List<ABResult.ABResultDTO> abResultList) {
        if (CollectionUtils.isEmpty(abResultList)) {
            return;
        }

        try {
            String abtest = lgEp.get("abtest");
            if (StringUtils.isNotBlank(abtest)) {
                List<ABResult.ABResultDTO> abResultDTOS = JSON.parseArray(abtest, ABResult.ABResultDTO.class);
                abResultDTOS.addAll(abResultList);
                lgEp.put("abtest", JSON.toJSONString(abResultDTOS));
            } else {
                lgEp.put("abtest", JSON.toJSONString(abResultList));
            }
        } catch (Exception e) {
            log.warn("美团adx打印实验平台结果异常", e);
        }
    }
}
