/*
 * 17-7-5 上午10:16
 * Administrator
 */

package cn.com.duiba.tuia.aop;

import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.annotation.JSONField;
import com.google.common.collect.Lists;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;


@Component
@Aspect
public class AdvertMsgSendLog {
    private Logger logger = LoggerFactory.getLogger("AdvertMsgSendLog");

    @Before("execution(* org.springframework.data.redis.core.*.convertAndSend(..))")
    public void convertAndSendAround(JoinPoint joinPoint) {
        List<StackInfo> callstack = Arrays.stream(Thread.currentThread().getStackTrace()).filter(x ->
                !Lists.newArrayList("invoke", "doFilter", "around", "controllerAround", "doing").contains(x.getMethodName()) &&
                        x.getClassName().startsWith("cn.com.duiba.tuia") && !x.getClassName().contains("Enhancer"))
                .map(x -> new StackInfo(x.getClassName() + "|" + x.getMethodName() + "|" + x.getLineNumber())).collect(Collectors.toList());
        logger.info(JSON.toJSONString(new CallInfo(callstack, joinPoint.getArgs()[0].toString(), joinPoint.getArgs()[1].toString())));
    }

    class CallInfo {
        public CallInfo(List<StackInfo> callstack, String channel, String args) {
            this.callstack = callstack;
            this.args = args;
            this.channel = channel;
            this.localDateTime = LocalDateTime.now();
        }
        @JSONField(ordinal = 1)
        private LocalDateTime localDateTime;
        @JSONField(ordinal = 2)
        private String channel;
        @JSONField(ordinal = 3)
        private String args;
        @JSONField(ordinal = 4)
        private List<StackInfo> callstack;


        public LocalDateTime getLocalDateTime() {
            return localDateTime;
        }

        public void setLocalDateTime(LocalDateTime localDateTime) {
            this.localDateTime = localDateTime;
        }

        public String getChannel() {
            return channel;
        }

        public void setChannel(String channel) {
            this.channel = channel;
        }

        public String getArgs() {
            return args;
        }

        public void setArgs(String args) {
            this.args = args;
        }

        public List<StackInfo> getCallstack() {
            return callstack;
        }

        public void setCallstack(List<StackInfo> callstack) {
            this.callstack = callstack;
        }


    }

    class StackInfo {
        public String getCallSource() {
            return callSource;
        }

        public void setCallSource(String callSource) {
            this.callSource = callSource;
        }

        private String callSource;

        public StackInfo(String callSource) {
            this.callSource = callSource;
        }
    }
}
