package cn.com.duiba.tuia.aop;

import cn.com.duiba.tuia.core.api.message.AdvertValidStatusEditMessage;
import cn.com.duiba.tuia.dao.advert.AdvertDAO;
import cn.com.duiba.tuia.exception.TuiaException;
import cn.com.duiba.tuia.log.StatusChangLog;
import com.alibaba.fastjson.JSONObject;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;

import java.util.concurrent.ExecutorService;

/**
 * Created by zhengjy on 2017/5/10.
 */
@Aspect
@Order(1)
@Component
public class UpdateAdvertValidStatusAOP {
    @Autowired
    private AdvertDAO advertsDAO;
    @Resource
    private ExecutorService executorService;

    /** The logger. */
    protected Logger logger = LoggerFactory.getLogger(getClass());


    @Pointcut("execution(* cn.com.duiba.tuia.dao.advert.impl.AdvertDAOImpl.updateValidStatus(..))")
    private void anyMethod(){
        //定义一个切入点
    }



    @Around("anyMethod()")
    public Object doBasicProfiling(ProceedingJoinPoint pjp) throws Throwable{
        String daoMethodName = pjp.getSignature().getName();
        try{
            //更新广告有效状态
            if("updateValidStatus".equals(daoMethodName)){
                return exeUpdateValidStatus(pjp);
            }
        }catch (Exception e){
            logger.warn("make edit updateAdvertValidStatus  log  error",e);
        }
        return pjp.proceed();
    }

    private Object exeUpdateValidStatus(ProceedingJoinPoint pjp) throws Throwable {
        //获取广告变更源状态
        Integer srcValidStatus = null;
        Object[] args = pjp.getArgs();
        //广告id
        Long advertId = null;
        try{
            advertId = getAdvertId(args);
            //获取广告变更源状态
            srcValidStatus = advertsDAO.getAdvertById(advertId).getValidStatus();
        }catch (TuiaException e){
            logger.warn("exeUpdateValidStatus before  error args[{}]="+args,e);
        }
        //执行方法
        Object object = pjp.proceed();

        //目标状态
        Integer newValidStatus = null;
        try{
            if(advertId == null){
                return object;
            }
            //目标状态
            newValidStatus = getAdvertValidStatus(args);
            //发送消息
            StatusChangLog.log(JSONObject.toJSONString(new AdvertValidStatusEditMessage(advertId, srcValidStatus, newValidStatus)));
        }catch (Exception e){
            logger.warn("exeUpdateValidStatus send msg error args[{}]="+advertId,srcValidStatus,newValidStatus,e);
            return object;
        }
        return object;

    }


    private Long getAdvertId(Object[] args){
        if (args != null && args.length > 0 && args[0].getClass() == Long.class) {
            return (Long) args[0];
        }
        return null;
    }

    private Integer getAdvertValidStatus(Object[] args){
        if (args != null && args.length >= 2 && args[1].getClass() == Integer.class) {
            return (Integer) args[1];
        }
        return null;
    }

}
