package cn.com.duiba.tuia.bo;

import cn.com.duiba.tuia.domain.dataobject.AdvertTagDO;
import cn.com.duiba.tuia.exception.TuiaException;

import java.util.List;

/**
 * @author ElinZhou
 * @version $Id: AdvertBannedTagBo.java , v 0.1 2017/4/13 下午1:44 ElinZhou Exp $
 */
public interface AdvertBannedTagBo {

    /**
     * 通过广告id和定向配置包id查询广告标签
     *
     * @param advertId
     * @param orientationPackageId
     * @return
     */
    List<String> selectBannedTagByAdvertIdAndOrientataionPackageId(Long advertId, Long orientationPackageId) throws
            TuiaException;

    /**
     * 通过广告id和定向配置包id删除缓存
     *
     * @param advertId
     * @param orientationPackageId
     */
    void deleteBannedCacheByAdvertIdAndOrientataionPackageId(Long advertId, Long orientationPackageId);


    void initBannedTags(List<Long> advertIds, List<AdvertTagDO> advertTagDOS) throws TuiaException;

}
