/**
 * Project Name:engine-service File Name:AdvertService.java Package Name:cn.com.duiba.tuia.bo Date:2017年4月23日下午7:05:29
 * Copyright (c) 2017, duiba.com.cn All Rights Reserved.
 */

package cn.com.duiba.tuia.bo;

import cn.com.duiba.tuia.exception.TuiaException;

import java.math.BigDecimal;
import java.util.Set;

/**
 * ClassName:AdvertService <br/>
 * Function: TODO ADD FUNCTION. <br/>
 * Reason: TODO ADD REASON. <br/>
 * Date: 2017年4月23日 下午7:05:29 <br/>
 * 
 * @author zp
 * @version
 * @since JDK 1.6
 * @see
 */
public interface AdvertService {

    /**
     * 更新广告状态 updateAdvert:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @author zp
     * @param advertId
     * @param validStatus
     * @throws TuiaException
     * @since JDK 1.6
     */
    public void updateAdvert(Long advertId, int validStatus) throws TuiaException;

    void updateValidStatus(Long advertId, int validStatus) throws TuiaException;

    void updateAdvert(Long advertId) throws TuiaException;

    /**
     * 从缓存中根据广告ID获取广告权重
     * 
     * @return
     */
    Double getWeightByIdFromCache(Long advertId, Long appId, Set<String> specialWeightAppIdList, BigDecimal advertWeight);


}
