/**
 * Project Name:engine-service File Name:AdvertServiceImpl.java Package Name:cn.com.duiba.tuia.bo.impl
 * Date:2017年4月23日下午7:05:50 Copyright (c) 2017, duiba.com.cn All Rights Reserved.
 */

package cn.com.duiba.tuia.bo.impl;

import cn.com.duiba.tuia.bo.AdvertService;
import cn.com.duiba.tuia.cache.BaseCacheService;
import cn.com.duiba.tuia.cache.MediaCacheService;
import cn.com.duiba.tuia.dao.advert.AdvertDAO;
import cn.com.duiba.tuia.domain.dataobject.AdvertDO;
import cn.com.duiba.tuia.exception.TuiaException;
import cn.com.duiba.tuia.service.AdvertInvalidHandleService;
import cn.com.tuia.advert.constants.CommonConstant;
import com.google.common.collect.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
/**
 * ClassName:AdvertServiceImpl <br/>
 * Function: TODO ADD FUNCTION. <br/>
 * Reason: TODO ADD REASON. <br/>
 * Date: 2017年4月23日 下午7:05:50 <br/>
 *
 * @author zp
 * @see
 * @since JDK 1.6
 */
@Service
public class AdvertServiceImpl extends BaseCacheService implements AdvertService {

    /**
     * 广告默认权重
     */
    public static double                                 DEFAULT_ADVERT_WEIGHT = 1.0;

    private static Logger                                logger                = LoggerFactory.getLogger(AdvertServiceImpl.class);
    @Autowired
    private AdvertDAO                                    advertDAO;
    @Resource
    private RedisTemplate<String, String>                redisTemplate;
    @Resource
    private StringRedisTemplate                          stringRedisTemplate;

    @Resource
    private ExecutorService                              executorService;
    @Autowired
    private MediaCacheService                            mediaCacheService;
    @Autowired
    private AdvertInvalidHandleService advertInvalidHandleService;

    @Override
    public void updateAdvert(Long advertId, int validStatus) throws TuiaException {
        AdvertDO advertDO = advertDAO.getAdvertById(advertId);
        if(advertDO.getAdvertPlanId()!=-1L){
            // 将同一推广计划id的广告都置为预算不足
            List<AdvertDO> advertDOs = advertDAO.getAdvertsByAdvertPlanId(advertDO.getAdvertPlanId());
            for (AdvertDO aDo : advertDOs) {

                doUpdateAdvert(aDo.getId(), validStatus, aDo);
            }
        }else {
            doUpdateAdvert(advertId, validStatus, advertDO);

        }
    }

    private void doUpdateAdvert(Long advertId, int validStatus, AdvertDO advertDO) throws TuiaException {
        if (advertDO != null && AdvertDO.VALID_STATUS == advertDO.getValidStatus()) {
            updateValidStatus(advertId, validStatus);
            updateAdvert(advertId);
            updateValidAdvertIdsCache(advertId);
        }
    }

    public void updateValidStatus(Long advertId, int validStatus) throws TuiaException {
        logger.info("updateValidStatus begin, advertId=[{}] validStatus to be set=[{}]", advertId, validStatus);
        // 更新广告有效状态
        advertDAO.updateValidStatus(advertId, validStatus);
        //发送钉钉消息通知
        advertInvalidHandleService.publishInvalidAdvertMsg(advertId, validStatus);
    }

    public void updateAdvert(Long advertId) throws TuiaException {
        // 发布更新通知
        publishUpdateAdvertsMsg(Lists.newArrayList(advertId), CommonConstant.HD_ADVERT_TYPE);
    }

    @Override
    public Double getWeightByIdFromCache(Long advertId,Long appId,Set<String> specialWeightAppIdList,BigDecimal advertWeight) {
        Double wight = DEFAULT_ADVERT_WEIGHT;
        if (null != advertWeight) {
            wight = advertWeight.doubleValue();
        }

        if (appId != null && !wight.equals(DEFAULT_ADVERT_WEIGHT)) {
            // 特殊权重app，广告权重1
            Boolean isSpecialWeightApp = mediaCacheService.isSpecialWeightApp(appId.toString(),specialWeightAppIdList);
            if (isSpecialWeightApp) {
                return DEFAULT_ADVERT_WEIGHT;
            }
        }
        return wight;
    }
}
