package cn.com.duiba.tuia.cache;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

import javax.annotation.Resource;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * ClassName: AdvertCacheQueue <br/>
 * Function: 根据队列里的广告ID列表，更新广告缓存 <br/>
 * date: 2017年1月17日 下午3:37:28 <br/>
 * 
 * @author cdm
 * @version
 * @since JDK 1.7
 */
@Service
public class AdvertCacheQueue implements InitializingBean {

    /** The logger. */
    public final Logger                           logger            = LoggerFactory.getLogger(getClass());

    // 定义一个线程池
    @Resource
    private ScheduledExecutorService scheduledExecutorService;

    // 待更新的队列，初始化大小一千
    private final ArrayBlockingQueue<Long>        updateAdvertQueue = new ArrayBlockingQueue<Long>(10000);

    private int                                   advertFlushTime   = 5;

    @Autowired
    private AdvertMapCacheManager                 advertMapCacheManager;

    // 添加数据到队列
    public void add2Queue(Long advertId) {
        updateAdvertQueue.add(advertId);
    }

    // 更新广告缓存操作
    private void updateAdvertCache(List<Long> advertIds) {

        for (Long advertId : advertIds) {
            try{
                // 更新缓存
                advertMapCacheManager.updateAdvertCache(advertId);

                advertMapCacheManager.updateValidAdvertFilterCache(advertId);
            }catch(Exception e){
                logger.warn("Advert Cache queue updateAdvertCache error!", e);
            }
        }
    }

    // 定义一个线程
    final Runnable flushQueueTask = new Runnable() {

                                      @Override
                                      public void run() {
                                          try {
                                              final List<Long> list = new ArrayList<Long>();
                                              updateAdvertQueue.drainTo(list);
                                              int size = list.size();
                                              if (size == 0) return;
                                              new Thread(){
                                                  @Override
                                                  public void run(){
                                                      updateAdvertCache(list);
                                                  }
                                              }.start();
                                          } catch (Exception e) {
                                              logger.error("flush Advert Cache queue error!", e);
                                          }
                                      }
                                  };

    // 项目启动时加载
    @Override
    public void afterPropertiesSet() throws Exception {
        scheduledExecutorService.scheduleAtFixedRate(flushQueueTask, 0, advertFlushTime, TimeUnit.SECONDS);
    }

}
