package cn.com.duiba.tuia.cache;

import cn.com.duiba.nezha.engine.api.enums.CPCAutoBiddingTypeEnum;
import cn.com.duiba.tuia.bo.AdvertBannedTagBo;
import cn.com.duiba.tuia.bo.AdvertService;
import cn.com.duiba.tuia.constants.AdvertConstants;
import cn.com.duiba.tuia.constants.AdvertSystemConfigureConstants;
import cn.com.duiba.tuia.core.api.utils.UrlBase64;
import cn.com.duiba.tuia.dao.advert.AdvertDAO;
import cn.com.duiba.tuia.dao.advert.AdvertPlanPeriodDAO;
import cn.com.duiba.tuia.dao.advert.TfUserFilterDao;
import cn.com.duiba.tuia.dao.advert_tag.AdvertTagDAO;
import cn.com.duiba.tuia.dao.dmp.AdvertTradePackageRelationDAO;
import cn.com.duiba.tuia.dao.engine.*;
import cn.com.duiba.tuia.dao.promotetest.AdvertPromoteTestDAO;
import cn.com.duiba.tuia.dao.resource_tags.ResourceTagsDAO;
import cn.com.duiba.tuia.domain.dataobject.*;
import cn.com.duiba.tuia.domain.model.*;
import cn.com.duiba.tuia.domain.vo.AdvertFilterPkgVO;
import cn.com.duiba.tuia.domain.vo.AdvertVO;
import cn.com.duiba.tuia.domain.vo.GlobalConfigFlowVO;
import cn.com.duiba.tuia.enums.CatGroupEnum;
import cn.com.duiba.tuia.enums.GlobalConfigItemEnum;
import cn.com.duiba.tuia.exception.TuiaException;
import cn.com.duiba.tuia.log.LogConfig;
import cn.com.duiba.tuia.message.rocketmq.RefreshCacheMqProducer;
import cn.com.duiba.tuia.service.*;
import cn.com.duiba.tuia.service.AdvertSystemConfigService.AdvertSystemConfigEnum;
import cn.com.duiba.tuia.service.filter.impl.TfUserFilterAccountImpl;
import cn.com.duiba.tuia.service.filter.impl.TfUserFilterAdPlanImpl;
import cn.com.duiba.tuia.service.filter.impl.TfUserFilterResourceImpl;
import cn.com.duiba.tuia.service.filter.peoplepkg.PeoplePkgPool;
import cn.com.duiba.tuia.service.impl.AdvertPeriodServiceImpl;
import cn.com.duiba.tuia.tool.CatUtil;
import cn.com.duiba.tuia.tool.StringTool;
import cn.com.duiba.tuia.utils.TuiaStringUtils;
import cn.com.duiba.tuia.utils.UrlParseUtils;
import cn.com.duiba.wolf.utils.UrlUtils;
import cn.com.duiba.wolf.utils.UrlUtils2;
import cn.com.duibaboot.ext.autoconfigure.monitor.cache.CacheMonitorExclude;
import cn.com.tuia.advert.Tool.PkgPutTargetTypeByWhite;
import cn.com.tuia.advert.cache.RedisCommonKeys;
import cn.com.tuia.advert.constants.CommonConstant;
import cn.com.tuia.advert.enums.*;
import cn.com.tuia.advert.message.RedisMessageChannel;
import cn.com.tuia.advert.model.messageDto.AdvertMsg;
import cn.com.tuia.advert.utils.DomainUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.MoreObjects;
import com.google.common.base.Splitter;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListenableFutureTask;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.concurrent.BasicThreadFactory;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.cloud.context.scope.refresh.RefreshScopeRefreshedEvent;
import org.springframework.context.event.EventListener;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import java.math.BigDecimal;
import java.util.*;
import java.util.concurrent.*;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;

import static java.util.stream.Collectors.*;

/**
 * ClassName: AdvertMapCacheManager <br/>
 * Function: 广告本地缓存. <br/>
 * date: 2017年01月15日 下午2:58:50 <br/>
 *
 * @author cdm
 * @since JDK 1.6
 */
@Service
@RefreshScope
public class AdvertMapCacheManager extends BaseCacheService  {

    @Autowired
    private ServiceManager serviceManager;
    @Autowired
    private AdvertCacheQueue advertCacheQueue;
    @Resource
    private RedisTemplate<String, String> redisTemplate;
    @Autowired
    private AdvertBannedTagBo advertBannedTagBo;
    @Autowired
    private LimitingMaximunService limitingMaximunService;
    @Autowired
    private ResourceTagsService resourceTagsService;
    @Autowired
    private AdvertOrientationService advertOrientationService;
    @Resource
    private ExecutorService executorService;
    @Autowired
    private AdvertMaterialRecommendService advertMaterialRecommendService;
    @Autowired
    private AdvertDAO advertDAO;
    @Resource
    private NewAppTestCacheService newAppTestCacheService;

    @Autowired
    private OrientationFocusAppConvertCostDAO orientationFocusAppConvertCostDAO;

    @Autowired
    private AdvertTagDAO advertTagDAO;

    @Autowired
    private ResourceTagsDAO resourceTagsDAO;

    @Autowired
    private AdvertOrientationPackageDAO orientationPackageDAO;

    @Autowired
    private AdvertPlanPeriodDAO advertPlanPeriodDAO;

    @Autowired
    private GlobalConfigFlowService globalConfigFlowService;

    @Autowired
    private AdvertPeriodService advertPeriodService;

    @Autowired
    private AdvertTargetActivityDAO advertTargetActivityDAO;

    @Autowired
    private AdvertPromoteTestDAO advertPromoteTestDAO;

    @Autowired
    private RefreshCacheMqProducer refreshCacheMqProducer;

    @Autowired
    private AdvertTradePackageRelationDAO advertTradePackageRelationDAO;

    @Autowired
    private AdvertTradePackageService advertTradePackageService;

    @Autowired
    private TfUserFilterDao tfUserFilterDao;
    @Autowired
    private LogConfig logConfig;

    @Autowired
    private DspComparePriceService dspComparePriceService;
    @Resource
    private PutLinkageConfigDAO putLinkageConfigDAO;

    @Autowired
    private AdvertABTestCacheService advertABTestCacheService;

    @Autowired
    private AvertCreativeCacheService avertCreativeCacheService;

    @Autowired
    private AdvertPkgCacheService advertPkgCacheService;

    @Resource
    private MakeTagCacheService makeTagCacheService;

    @Autowired
    private AdvertiserAuditDao advertiserAuditDao;

    @Value("${smartCompatible:-1_0}")
    private String smartCompatible;
    //投放目标升级白名单
    private Map<Long, Integer> smartCompatibleMap = new HashMap<>();

    @EventListener
    public void onRefreshScopeRefRefreshed(final RefreshScopeRefreshedEvent event){
        getClass();
    }

    @PostConstruct
    private void run() {
        List<String> smartCompatibleList = StringTool.getStringListByStr(smartCompatible);

        Map<Long, Integer> smartTemp = new HashMap<>();

        smartCompatibleList.forEach(str -> {

            if (StringUtils.isBlank(str)) {
                return;
            }

            try {
                String[] s = str.split("_");
                smartTemp.put(Long.valueOf(s[0]), Integer.valueOf(s[1]));
            } catch (Exception e) {
                logger.error("smartCompatibleMap is error", e);
            }

        });

        smartCompatibleMap = smartTemp;

    }

    private static final String INTERSECTION_NULL="-2";
    private static final String UNLIMITED="-1";

    private static final String START_HOUR="startHour";
    private static final String END_HOUR="endHour";
    private static final String SPLIT_CHAR = "|";

    /**不在托管底价白名单中*/
    public static final Integer OBCT_TAG_NOT = 0;
    /**在托管底价白名单中*/
    public static final Integer OBCT_TAG_YES = 1;

    /** 人群兴趣定向*/
    private static final Integer ORIENT_TYPE = 0;

    /** 人群星球排出*/
    private static final Integer EXCLUDE_TYPE = 1;

    /** 行业接受度*/
    private static final List<Integer> TRADE_ACCEPT = Lists.newArrayList(0,1,2,3,4);

    //有消息同步，不用设置过期时间来保证避免读取旧值
    private LoadingCache<Long, AdvertVO> advertCache = CacheBuilder.newBuilder().initialCapacity(1000).maximumSize(1200)
            .refreshAfterWrite(5, TimeUnit.MINUTES)
            .build(
                    new CacheLoader<Long, AdvertVO>() {
                        public AdvertVO load(Long advertId) {
                            return serviceManager.getAdvertByCache(advertId);
                        }

                        public ListenableFutureTask<AdvertVO> reload(final Long key, AdvertVO prevGraph) {
                            ListenableFutureTask<AdvertVO> task = ListenableFutureTask.create(() -> {
                                return serviceManager.getAdvertByCache(key);
                            });
                            executorService.submit(task);
                            return task;
                        }
                    });

    private List<Long> validAdvertIds = new ArrayList<Long>();


    /**
     * 更新广告缓存
     * updateAdvertCache:(这里用一句话描述这个方法的作用). <br/>
     * @author zp
     * @param advertId
     * @since JDK 1.6
     */
    public void updateAdvertCache(Long advertId) {
        try {
            if (null != advertId) {
                advertCache.refresh(advertId);

            }
        } catch (Exception e) {
            logger.error("update advertVO errror", e);
        }
    }
    
    /**
     * 获取广告缓存
     * getAdvertCache. <br/>
     * @author zp
     * @param advertId
     * @return
     * @since JDK 1.6
     */
    public AdvertVO getAdvertCache(Long advertId) {
        if (advertId == null) {
            return null;
        }
        AdvertVO advertVO = advertCache.getIfPresent(advertId);
        if (advertVO != null) {
            return advertVO;
        } else {
            logger.info("getAdvertCache is null,advertId=[{}]", advertId);
            advertCache.refresh(advertId);
            return null;
        }
    }

    /**
     * 获取折扣率: 如果是兑吧的CPC广告，折扣率为全局配置的折扣率，否则是1
     * @param advertId
     * @param chargeType
     * @return
     */
    public double getAdvertBidRate(Long advertId,Integer chargeType){

        AdvertVO advertVO = this.getAdvertCache(advertId);
        if(advertVO == null){
            return AdvertConstants.DEFAULT_DUIBA_CPC_RATE;
        }

        ChargeTypeEnum chargeTypeEnum = ChargeTypeEnum.getByCode(chargeType);
        //获取折扣率: 如果是兑吧的CPC广告，折扣率为全局配置的折扣率，否则是1
        return advertVO.isDuibaAdvertiser() && chargeTypeEnum == ChargeTypeEnum.TYPE_CPC ?
                AdvertSystemConfigEnum.duibaCpcBidRate.getDoubleValue() : AdvertConstants.DEFAULT_DUIBA_CPC_RATE;

    }

    public double getAdvertBidRateNoCache(Integer chargeType, AdvertVO advertVO) {
        if (advertVO == null) {
            return AdvertConstants.DEFAULT_DUIBA_CPC_RATE;
        }

        ChargeTypeEnum chargeTypeEnum = ChargeTypeEnum.getByCode(chargeType);
        //获取折扣率: 如果是兑吧的CPC广告，折扣率为全局配置的折扣率，否则是1
        return advertVO.isDuibaAdvertiser() && chargeTypeEnum == ChargeTypeEnum.TYPE_CPC ?
                AdvertSystemConfigEnum.duibaCpcBidRate.getDoubleValue() : AdvertConstants.DEFAULT_DUIBA_CPC_RATE;

    }

    /**
     * clearAll:清除所有广告缓存. <br/>
     *
     * @author cdm
     * @since JDK 1.7
     */
    public synchronized void clearAdvertCacheAll() {
        advertCache.invalidateAll();
    }

    /**
     * 获取广告有效列表
     * getValidAdvertIds. <br/>
     * @author zp
     * @return
     * @throws TuiaException 
     * @since JDK 1.6
     */
    public List<Long> getValidAdvertIds() {
        try {
            Map<Long, Integer> validMap = serviceManager.queryValidAdvertOrderLevel();
            return validMap.keySet().stream().collect(Collectors.toList());
        } catch (Exception e) {
            logger.error("serviceManager.queryValidAdvertOrderLevel error", e);
            try {
                return serviceManager.queryValidAdvertIds();
            } catch (Exception e1) {
                logger.error("serviceManager.queryValidAdvertIds error", e1);
                return Lists.newArrayList();
            }
        }
    }


    // 项目启动时加载
    @EventListener(cn.com.duiba.boot.event.MainContextRefreshedEvent.class)
    public void init() throws Exception {
        logger.info("AdvertMapCacheManager.initAdvertCache started.");
        // 初始化有效广告列表
        initValidAdvertIds();
        logger.info("initValidAdvertIds  end.");
        // 初始化广告信息
        initAllAdvertCache();
        logger.info("initAllAdvertCache  end.");
        //初始化广告推广链接之外的链接的落地页标签信息
        makeTagCacheService.init(validAdvertIds);
        logger.info("initMakeTagCache  end.");

        // 初始化广告定向配置列表
        advertOrientationService.initAdvertOrirntationList(validAdvertIds);
        logger.info("advertOrientationService.initAdvertOrirntationList  end.");
        //查询默认过滤标签
        List<AdvertTagDO> advertTagDOS = advertTagDAO.seletByAdvertIds(validAdvertIds);

        // 初始化所有有效广告配置过滤缓存
        initAllValidAdvertFilterCache();
        // 开启定时任务刷新 有效广告配置
        openJob();
        logger.info("initAllValidAdvertFilterCache  end.");

        // 初始化广告过滤标签
        advertBannedTagBo.initBannedTags(validAdvertIds, advertTagDOS);
        logger.info("advertBannedTagBo.initBannedTags  end.");

        //更新限流媒体
        limitingMaximunService.initLimiting(validAdvertIds);
        logger.info("limitingMaximunService.initLimiting  end.");

        //初始化广告素材列表
        advertMaterialRecommendService.init(validAdvertIds);
        logger.info("advertMaterialRecommendService.init  end.");

        //初始化广告/素材标签
        resourceTagsService.init();
        logger.info("resourceTagsService.init  end.");

        // 初始化新媒体对应的投放广告关系
        newAppTestCacheService.initAdvertTestToApp();
        logger.info("newAppTestCacheService.initAdvertTestToApp  end.");
        // 初始化配置的时段投放缓存
        advertPeriodService.initPeriodCache(validAdvertIds);
        logger.info("advertPeriodService.initPeriodCache  end.");

        //初始化adx广告信息
        dspComparePriceService.init();

        //初始化广告ABTest缓存
        advertABTestCacheService.init(validAdvertIds);
        //初始化广告配置爱奇艺缓存
        advertPkgCacheService.init(validAdvertIds);
        //初始化创意缓存
        avertCreativeCacheService.init();


        logger.info("AdvertMapCacheManager.initAdvertCache end.");
    }

    /**
     * 初始化有效列表
     * initValidAdvertIds:(). <br/>
     * @author zp
     * @return
     * @since JDK 1.6
     */
    public List<Long> initValidAdvertIds() {
        try {
            //获取有效广告排序
            validAdvertIds = advertDAO.queryValidAdvertIds().stream().map(AdvertDO::getId).collect(Collectors.toList());
        } catch (Exception e) {
            logger.error("update Valid AdvertIds errror ", e);
        }
        return validAdvertIds;
    }

    
    /**
     * <li>初始化所有的广告缓存</li>
     *
     * @author : chengdeman
     * @Date : 17/1/1
     */
    public void initAllAdvertCache() {
        // 1.查询所有有效的广告ID
        if (CollectionUtils.isEmpty(validAdvertIds)) {
            logger.warn("初始化有限广告列表为空");
            return;
        }
        // 2.清除已存在的缓存
        clearAdvertCacheAll();
        for (Long advertId : validAdvertIds) {
            try {
                AdvertVO advertVO = serviceManager.getAdvertVOInfo(advertId);
                if (advertVO == null) {
                    continue;
                }
                // 3.查询广告缓存对象(map缓存无失效时间，所以去除guava缓存，避免更新无效果)
                advertCache.put(advertId,advertVO);
                if (advertVO.getCouponBase() != null) {
                    makeTagCacheService.builderPromoteTags(advertVO.getCouponBase().getPromoteURL());
                }
            } catch (Exception e) {
                logger.error("initAllAdvertCache errror", e);
            }
        }
    }

    public void pushAdvertCacheUpdate(Long advertId) {
        logger.info("update advert cache, tag=KC104, advertId = {}", advertId);
        List<Long> ids = new ArrayList<>();
        ids.add(advertId);
        AdvertMsg msg = new AdvertMsg(AdvertMsg.UPDATE_TRAGET, ids, CommonConstant.HD_ADVERT_TYPE, "engine-pushAdvertCacheUpdate");
        //这里没有删除缓存，因为在调用该方法之前民经设置了最新对象
        refreshCacheMqProducer.sendMsg(RedisCommonKeys.KC104.toString(),JSON.toJSONString(msg));
        JSONObject jsonObj = new JSONObject();
        jsonObj.put("advertType", String.valueOf(advertId));
        jsonObj.put("thisAdvertType", String.valueOf(CommonConstant.HD_ADVERT_TYPE));
        logger.info("publish update valid adverts message channel, the advertId=[{}]", advertId);
        redisTemplate.convertAndSend(RedisMessageChannel.UPDATE_VALID_ADVERTS_MSG.getChannel(), jsonObj.toString());

    }


    /**
     * 配置维度的过滤缓存
     */
    @CacheMonitorExclude
    private LoadingCache<String, Optional<AdvOrientationItem>> validPkgFilterCache = CacheBuilder.newBuilder().initialCapacity(3000).maximumSize(4000)
            .refreshAfterWrite(10, TimeUnit.MINUTES)
            .build(
                    new CacheLoader<String, Optional<AdvOrientationItem>>() {
                        public Optional<AdvOrientationItem> load(String key) {
                            return Optional.ofNullable(buildValidAdvertOrientationFilterCache(key));
                        }
                    });

    private final Long allPkgKey = 1L;
    private LoadingCache<Long, List<AdvOrientationItem>> allPkgCache = CacheBuilder.newBuilder()
            .refreshAfterWrite(10, TimeUnit.MINUTES).build(new CacheLoader<Long, List<AdvOrientationItem>>() {
                public List<AdvOrientationItem> load(Long key) {
                    if(chacheLoding.get()==1){
                        return oldValidPkgFilterCache;
                    }
                    return getAllValidPkg();
                }
            });

    @NotNull
    private List<AdvOrientationItem> getAllValidPkg() {
        return validPkgFilterCache.asMap().entrySet().stream()
                .filter(map -> map.getValue().isPresent())
                .map(map -> map.getValue().get()).collect(toList());
    }

    /**
     * 转化类型联动配置缓存
     * key: 新行业
     * value: 优化目标-深度优化目标, 优化目标-深度优化目标..
     */
    private final LoadingCache<String, String> putLinkageConfigCache = CacheBuilder.newBuilder()
            .initialCapacity(100)
            .refreshAfterWrite(60, TimeUnit.MINUTES)
            .expireAfterWrite(120,TimeUnit.MINUTES)
            .build(new CacheLoader<String, String>() {

                @Override
                public String load(String key) throws Exception {

                    return getConfigByNewTrade(key);
                }

                @Override
                public ListenableFuture<String> reload(String key, String oldValue) throws Exception {
                    ListenableFutureTask<String> task = ListenableFutureTask.create(() -> load(key));
                    executorService.submit(task);
                    return task;
                }
            });

    /**
     * 根据新行业获取转化类型联动配置数据
     * @param key
     * @return
     */
    private String getConfigByNewTrade(String key) {
        String result = "";
        List<PutLinkageConfigDO> configs = putLinkageConfigDAO.getConfigByNewTrade(key);
        if (CollectionUtils.isEmpty(configs)) {
            return result;
        }

        List<String> subTypes = configs.stream()
                .map(dto -> {
                    List<String> list = new ArrayList<>();
                    String[] array = dto.getDepthSubTypes().split(",");
                    for (String s : array) {
                        list.add(dto.getSubType() + "-" + s);
                    }
                    return list;
                })
                .flatMap(Collection::stream)
                .collect(Collectors.toList());
        return StringTool.getStringByList(subTypes);
    }

    /**
     * 根据新行业刷新转化类型联动配置缓存
     * @param newTrade
     */
    public void refreshPutLinkageConfig(String newTrade){
        putLinkageConfigCache.refresh(newTrade);
    }

    /**
     * 根据新行业查询转化类型联动配置缓存
     * @param newTrade
     */
    public String getPutLinkageConfig(String newTrade){
        try {
            return putLinkageConfigCache.get(newTrade);
        } catch (ExecutionException e) {
            logger.error("查询转化类型联动配置失败！newTrade:{}",newTrade);
        }
        return "";
    }




    /**
     *
     * buildValidAdvertOrientation:(有效配置的过滤缓存组装). <br/>
     *
     * @author chencheng
     * @param cacheId
     * @return
     * @since JDK 1.8
     */
    private AdvOrientationItem buildValidAdvertOrientationFilterCache(String cacheId) {
        AdvOrientationItem advOrientationItem = null;
        try {
            // key分解 advertId|orientId
            List<String> strs= Splitter.on(SPLIT_CHAR).splitToList(cacheId);
            Long advertId=Long.parseLong(strs.get(0));
            Long orientId=Long.parseLong(strs.get(1));
            // 获取广告相关的信息
            AdvertFilterPkgVO advertFilterPkgVO = getAdvertFilterPkgVO(advertId);
            if (advertFilterPkgVO == null){
                return advOrientationItem;
            }

            // 从数据库获取配置
            AdvertOrientationPackageDO advertOrientationPackageDO;
            if(orientId.equals(AdvertConstants.DEFAULT_ORIENTATION_ID)){
                advertOrientationPackageDO = orientationPackageDAO.selectDefaultByAdvertId(advertId);
            }else {
                advertOrientationPackageDO = orientationPackageDAO.selectById(orientId);
            }
            // 校验配置有效性
            if(null == advertOrientationPackageDO || advertOrientationPackageDO.getEnableStatus().equals(0)){
                return advOrientationItem;
            }

            // 默认配置的id构建
            Long orientationId = advertOrientationPackageDO.getId();
            if (advertOrientationPackageDO.getIsDefault().equals(CommonConstant.YES)) {
                orientationId = AdvertConstants.DEFAULT_ORIENTATION_ID;
            }

            // 获取配置的定向活动
            AdvertTargetActivityDO advertTargetActivityDO = advertTargetActivityDAO.selectBindActivityByAdvertIdPkgId(advertId, advertOrientationPackageDO.getId());
            String activityIds = null;
            if(advertTargetActivityDO != null){
                activityIds = advertTargetActivityDO.getActivityIds();
            }
            //获取 托管底价白名单开关状态
            Boolean obctTag = getObctTag(advertOrientationPackageDO.getId());
            // 构建配置的缓存信息
            advOrientationItem = getAdvOrientationItem(advertId, advertOrientationPackageDO, orientationId, advertFilterPkgVO, activityIds , obctTag);
            // 构建拓展信息
            getAdverOrientPackageExtItem(advOrientationItem, advertId, advertOrientationPackageDO.getId());

        } catch (Exception e) {
            logger.error("buildValidAdvertOrientationFilterCache error，cacheId=[{}]", cacheId, e);
        }

        return advOrientationItem;
    }

    /**
     * // 构建拓展信息  AdvertOrientationPackageDAOImpl
     * @param advOrientationItem
     * @param advertId
     * @param orientId
     */
    private void getAdverOrientPackageExtItem(AdvOrientationItem advOrientationItem, Long advertId, Long orientId) {

        OrientPkgExpandDO orientPkgExpandDO = Optional.ofNullable(orientationPackageDAO.selectPkgExpand(advertId, orientId)).orElse(new OrientPkgExpandDO());
        Integer deviceOrientType = orientPkgExpandDO.getDeviceOrientType();
        if (null != deviceOrientType && Objects.equals(deviceOrientType, 1)) {
            advOrientationItem.setDeviceOrientType(true);
        }

        // 如果配置的深度优化目标为出单，则设置出单率
        if(AdvertSubtypeEnum.OUT_ORDER.getSubtype().equals(advOrientationItem.getDepthSubtype())){

            advOrientationItem.setOutOrderRate(orientPkgExpandDO.getOutOrderRate());
        }
    }

    /**
     * 托管底价白名单开关
     * @param id
     * @return
     */
    private Boolean getObctTag(Long id) {
        Integer status = orientationPackageDAO.selectOcbtTagById(id);
        return (null != status) && OBCT_TAG_YES.equals(status);
    }

    private List<AdvertPlanPeriodDO> getOrientPeriodDOS(Long advertId, List<String> promoteUrlTags, Long orientId) {

        List<AdvertPlanPeriodDO> advertPlanPeriodDOS = advertPlanPeriodDAO.selectByAdvertId(advertId,orientId);

        if(CollectionUtils.isEmpty(advertPlanPeriodDOS)){
            return advertPlanPeriodDOS;
        }

        //全局流量配置只考虑微信加粉
        if(!CollectionUtils.isEmpty(promoteUrlTags) && promoteUrlTags.contains(AdvertPeriodServiceImpl.WEI_XIN_JIA_FEN)){
            List<GlobalConfigFlowVO> globalConfigFlowVOS=globalConfigFlowService.queryAll();

            //获取微信加粉的投放时段配置
            List<GlobalConfigFlowVO> periodConfig=globalConfigFlowVOS.stream().filter(vo-> AdvertPeriodServiceImpl.IS_PERIOD.equals(vo.getConfigItem())
                                    && vo.getConfigConditionValue().containsValue(AdvertPeriodServiceImpl.WEI_XIN_JIA_FEN)).collect(Collectors.toList());

            if(!CollectionUtils.isEmpty(periodConfig)){
                JSONArray periodArr =periodConfig.get(0).getConfigItemValue();

                advertPlanPeriodDOS= advertPeriodService.buildPeriodList(periodArr,advertId,orientId);
            }
        }
        return advertPlanPeriodDOS;
    }

    /**
     *
     * getAdvertFilterPkgVO:(获取构建配置过滤缓存时的广告信息). <br/>
     *
     * @author chencheng
     * @param advertId
     * @return
     * @throws TuiaException
     * @since JDK 1.8
     */
    private AdvertFilterPkgVO getAdvertFilterPkgVO(Long advertId) throws TuiaException {

        AdvertDO advertDO = advertDAO.getAdvertNoRegionIdsById(advertId);
        // 无效的广告
        if (advertDO.getValidStatus() != 1 || advertDO.getCheckStatus() != AdvertDO.CHECK_STATUS_PASS ||
                advertDO.getEnableStatus() != AdvertDO.ENABLE || advertDO.getAdvertType() != CommonConstant.HD_ADVERT_TYPE) {
            CatUtil.catLog(CatGroupEnum.CAT_107006.getCode());
            return null;
        }

        //查询广告主 审核 (广告主链接 id 为 0L),若有审核记录 且 未审核通过 则不加载
        AdvertiserCheckAdvertDO advertiserCheckAdvertDO = advertiserAuditDao.selectByUniqueKey(advertId,0L);
        if(null != advertiserCheckAdvertDO && !Objects.equals(3,advertiserCheckAdvertDO.getCheckStatus())){
            return null;
        }

        // 查询广告标签数据
        AdvertTagDO advertTagDO = advertTagDAO.selectByAdvertId(advertId);
        if (null == advertTagDO) {
            logger.error("get advertTagDO is null,advertId=[{}]", advertId);
            return null;
        }

        //广告落地页标签数据
        ResoureTagsDO promoteUrlTagsDO = resourceTagsDAO.selectResoureTagsDOById(advertId, ResourceTagsTypeEnum.AD.getCode());
        List<String> promoteUrlTags = StringTool.getStringListByStr(Optional.ofNullable(promoteUrlTagsDO).map(ResoureTagsDO::getTagNums).orElse(null));
        advertTagDO.setPromoteUrlTags(promoteUrlTags);

        //设置广告资源标签
        ResoureTagsDO advertResourceTag = resourceTagsDAO.selectResoureTagsDOById(advertId, ResourceTagsTypeEnum.ADVERT_RESOURCE_TAG.getCode());
        if (null != advertResourceTag) {
            advertTagDO.setResourceTag(advertResourceTag.getTagNums());
        }

        // 查询优惠券信息
        CouponBase couponBase = serviceManager.buildCouponBaseData(advertDO.getId(), advertDO.getAdvertType());
        if (null == couponBase) {
            logger.error("getCouponBaseData is null advertId={} advertType={}", advertId, advertDO.getAdvertType());
            return null;
        }
        return new AdvertFilterPkgVO(advertDO, advertTagDO, couponBase);
    }

    /**
     *
     * getAdvOrientationItem:(根据广告、配置等构建配置过滤用的属性信息). <br/>
     *
     * @author chencheng
     * @param advertId
     * @param advertOrientationPackageDO
     * @param orientationId
     * @param advertFilterPkgVO
     * @return
     * @throws Exception
     * @since JDK 1.8
     */
    private AdvOrientationItem getAdvOrientationItem(Long advertId,  AdvertOrientationPackageDO advertOrientationPackageDO, Long orientationId, AdvertFilterPkgVO advertFilterPkgVO, String bindActivityIdStr, Boolean obctTag) throws Exception {

        //  构建多连接测试连接
        String orientationPromoteUrl = advertOrientationService.getOrientPromoteUrl(advertOrientationPackageDO.getId());

        // 获取广告信息
        AdvertDO advertDO = advertFilterPkgVO.getAdvertDO();
        AdvertTagDO advertTagDO = advertFilterPkgVO.getAdvertTagDO();
        CouponBase couponBase = advertFilterPkgVO.getCouponBase();

        AdvOrientationItem advOrientationItem = new AdvOrientationItem();
        //不使用广告本身的推广链接
        if(advertOrientationPackageDO.getEnableAdvertUrl()!= 1){
            advOrientationItem.setPromoteTestUrl(orientationPromoteUrl);
        }
        advOrientationItem.setEnableAdvertUrl(advertOrientationPackageDO.getEnableAdvertUrl());
        advOrientationItem.setAdvertId(advertId);
        advOrientationItem.setOrientationId(orientationId);
        advOrientationItem.setInitialOrientationId(advertOrientationPackageDO.getId());
        advOrientationItem.setAccountId(advertDO.getAccountId());
        advOrientationItem.setCpcPrice(MoreObjects.firstNonNull(advertOrientationPackageDO.getFee(), 0L));
        advOrientationItem.setCpaPrice(MoreObjects.firstNonNull(advertOrientationPackageDO.getaFee(), 0L));
        // 报价类型
        advOrientationItem.setChargeType(advertOrientationPackageDO.getChargeType());
        // 每日预算
        advOrientationItem.setBudgetPerDay(advertOrientationPackageDO.getBudgetPerDay());
        advOrientationItem.setAdvertBudgetPerDay(advertDO.getBudgetPerDay());
        // 包的类型 1-人工生成的包 2-智能生成的策略包
        advOrientationItem.setPackageType(advertOrientationPackageDO.getPackageType());
        //投放目标
        advOrientationItem.setPutTargetType(advertOrientationPackageDO.getPutTargetType());
        // 默认年龄区间
        advOrientationItem.setAgeStart(0);
        advOrientationItem.setAgeEnd(100);
        List<Integer> ageRegion = TuiaStringUtils.getIntegerListByStr(advertOrientationPackageDO.getAgeRegion(), "-");
        if (CollectionUtils.isNotEmpty(ageRegion)) {
            advOrientationItem.setAgeStart(ageRegion.get(0));
            advOrientationItem.setAgeEnd(ageRegion.get(1));
        }

        advOrientationItem.setBannedTags(StringTool.getStringSetByStr(advertTagDO.getAdvertBannedTagNums()));

        // 广告标签
        Set<String> advtags = StringTool.getStringSetByStr(advertTagDO.getMatchTagNums());
        advOrientationItem.setAdvertTags(advtags);
        // 落地页标签
        advOrientationItem.setPromoteUrlTags(Optional.ofNullable(advertTagDO.getPromoteUrlTags()).map(list -> new HashSet<>(list)).orElse(Sets.newHashSet()));
        // 资源标签
        advOrientationItem.setResourceTag(advertTagDO.getResourceTag());
        // 所有配置的屏蔽标签
        setAllShieldTags(advOrientationItem, advOrientationItem.getBannedTags(), advtags, advOrientationItem.getPromoteUrlTags());
         // 平台
        advOrientationItem.setPlatform(StringTool.getStringSetByStr(advertOrientationPackageDO.getPlatform()));
        // 地域
        advOrientationItem.setRegionIds(StringTool.getStringSetByStr(advertOrientationPackageDO.getRegionIds()));
        // 参与次数
        advOrientationItem.setJoinNums(StringTool.getIntegerSetByStr(advertOrientationPackageDO.getDirectionalNum()));
        // 报价类型
        advOrientationItem.setChargeType(advertOrientationPackageDO.getChargeType());
        // 推广url
        advOrientationItem.setPromoteUrl(couponBase.getPromoteURL());
        //判断推广链接是否是百奇或积木落地页链接，并设置标记信息
        setMakeTagSign(advOrientationItem);
        // 配置包绑定素材
        advOrientationItem.setMaterialIds(TuiaStringUtils.getLongSetByStr(advertOrientationPackageDO.getMaterialIds(), ","));
        // 网络类型
        advOrientationItem.setNetworkTypes(StringTool.getIntegerSetByStr(advertOrientationPackageDO.getNetworkType()));
        // 运营商
        advOrientationItem.setOperators(StringTool.getIntegerSetByStr(advertOrientationPackageDO.getOperators()));
        // 手机价格区间
        advOrientationItem.setPhoneLevels(StringTool.getStringSetByStr(advertOrientationPackageDO.getPhoneLevel()));
        //屏蔽流量类型
        Set<String> bannedAppFlowType = StringTool.getStringSetByStr(advertOrientationPackageDO.getBannedAppFlowType());
        if (CollectionUtils.isNotEmpty(bannedAppFlowType)) {
            // 如果屏蔽流量中选择了其他,则屏蔽其他所有的流量(ios,android,其他)
            if (bannedAppFlowType.contains(AppFlowPlatform.OTHER.getCode().toString())) {
                Stream.of(AppFlowOS.values()).forEach(appFlowOS -> bannedAppFlowType.add(AppFlowPlatform.OTHER.getCode() + "." + appFlowOS.getCode()));
                bannedAppFlowType.remove(AppFlowPlatform.OTHER.getCode().toString());
            }
        }
        advOrientationItem.setBannedAppFlowType(bannedAppFlowType);
        // 查询投放时段信息
        List<AdvertPlanPeriodDO> advertPlanPeriodDOS = getOrientPeriodDOS(advertId,
                           advertFilterPkgVO.getAdvertTagDO().getPromoteUrlTags(),
                           orientationId.equals(AdvertConstants.DEFAULT_ORIENTATION_ID) ? null : orientationId);

        // 投放时段。提到缓存中
        advOrientationItem.setPeriodList(advertPlanPeriodDOS);

        // 品牌名称
        advOrientationItem.setBrandName(StringTool.getStringSetByStr(advertOrientationPackageDO.getBrandName()));

        //设置人群包过滤（包括定向 和 排除）
        Map<Integer, List<PeoplePkgPool>> peoplePkgPoolsMap = buildPeoplePkgFilter(advertOrientationPackageDO.getId(), advtags);
        if(MapUtils.isNotEmpty(peoplePkgPoolsMap)) {
            List<? extends CustomMemFilter> peoplePkgPools = peoplePkgPoolsMap.get(PeoplePkgPool.ORIENT_TYPE);
            List<? extends CustomMemFilter> excludePeoplePkgPools = peoplePkgPoolsMap.get(PeoplePkgPool.EXCLUDE_TYPE);
            advOrientationItem.setPeoplePkgPools(peoplePkgPools);
            advOrientationItem.setExcludePeoplePkgPools(excludePeoplePkgPools);
        }

        List<AdvertUserInterestItem> tempAdvdertOrientPackageDOs = buildUserInterstAndNotInterestParam(advertOrientationPackageDO.getId(),advtags);
        AdvertUserInterestItem advertUserInterestItem = tempAdvdertOrientPackageDOs.get(0);
        AdvertUserInterestItem advertUserNotInterestItem = tempAdvdertOrientPackageDOs.get(1);
        // 人群兴趣点
        advOrientationItem.setUserInterest(advertUserInterestItem.getAllCrowdInterestTag());
        // 人群不感兴趣点
        advOrientationItem.setUserNotInterest(advertUserNotInterestItem.getAllCrowdInterestTag());

        // 活动类型
        advOrientationItem.setActivityType(buildActivityType(advertOrientationPackageDO.getActivityType()));

        // 定向活动
        if(StringUtils.isNotEmpty(bindActivityIdStr)){
            advOrientationItem.setBinActivityId(new HashSet<>(StringTool.getLongListByStr(bindActivityIdStr)));
        }

        //统一替换全局流量
        setGlobalHitValue(advOrientationItem,advertOrientationPackageDO,advertDO);
        //是否开启KA广告扶持
        advOrientationItem.setSupportStatus(advertOrientationPackageDO.getSupportStatus());
        //
        advOrientationItem.setTargetAppLimit(Optional.ofNullable(advertOrientationPackageDO.getTargetAppLimit()).orElse(1));
        // 是否开启智能采买
        advOrientationItem.setAutoMatch(advertOrientationPackageDO.getAutoMatch());
        // 调整因子
        advOrientationItem.setSubtype(advertOrientationPackageDO.getSubtype());
        // 深度调整因子
        advOrientationItem.setDepthSubtype(advertOrientationPackageDO.getDepthSubtype());
        advOrientationItem.setDepthTargetPrice(advertOrientationPackageDO.getDepthTargetPrice());
        //设置重点媒体转化出价
        setFocusConvertCost(advOrientationItem, advertOrientationPackageDO);
        //消耗速度，0：加速投放，1：匀速投放
        advOrientationItem.setBudgetSmooth(advertOrientationPackageDO.getBudgetSmooth());
        //新增托管底价白名单 开关状态
        advOrientationItem.setIsObctTag(obctTag);
        //自动竞价开关
        advOrientationItem.setAutoBiddingType(advertOrientationPackageDO.getAutoBiddingType());

        //已转化人群过滤
        advOrientationItem.setTfUserFilter(buildTfUserFilter(advOrientationItem));

        advOrientationItem.setAssessType(advertDO.getAssessType());

        // 覆盖CPC部分配置的subType
        coverPackageCvrTypeByAssessType(advOrientationItem);

        //如果在白名单内且是优投模式（人工定向），替换投放目标
        Integer finalPutTargetType = PkgPutTargetTypeByWhite.coverPkgPutTargetTypeByWhite(smartCompatibleMap, advOrientationItem.getTargetAppLimit(), advOrientationItem.getInitialOrientationId(), advOrientationItem.getPutTargetType());
        advOrientationItem.setPutTargetType(finalPutTargetType);

        return advOrientationItem;
    }

    /**
     * 判断推广链接判断是否百奇积木域名，并设置标记
     * @param advOrientationItem
     */
    public void setMakeTagSign(AdvOrientationItem advOrientationItem) {
        try {
            MakeTagDO makeTag = makeTagCacheService.getMakeTagSign(advOrientationItem.getPromoteUrl());
            if (makeTag != null) {
                advOrientationItem.setSourceId(makeTag.getSourceId());
                advOrientationItem.setSourceType(makeTag.getSourceType());
            }
        } catch (Exception e) {
            logger.error("推广链接设置百奇积木域名标识失败:{}", advOrientationItem.getPromoteUrl());
        }
    }

    private Map<Integer,List<PeoplePkgPool>> buildPeoplePkgFilter(Long orientPackageId, Set<String> advtags) {

        //获取人群包关系表中的数据
        List<AdvertTradePackageRelationDO> advertTradePackageRelationDOS = advertTradePackageRelationDAO.selectAdvertTradePackageRelationByOrientId(orientPackageId);
        Map<String,PeoplePkgPool> poolMap = new HashMap<>();
        advertTradePackageRelationDOS.forEach(advertTradePackageRelationDO -> {
            //池子编号
            Integer poolNum = advertTradePackageRelationDO.getPoolNum();
            //定向类型，排除or定向
            Integer orientType = advertTradePackageRelationDO.getOrientType();

            String peoplePkg = advertTradePackageRelationDO.getPeoplePkgId();

            if(null == poolNum){
                logger.error("数据库中存在脏数据，字段poolNum，关系id=" + advertTradePackageRelationDO.getId());
                return;
            }

            if(null == orientType || PeoplePkgPool.checkOrientTypeFail(orientType)){
                logger.error("数据库中存在脏数据，字段orientType，关系id=" + advertTradePackageRelationDO.getId());
                return;
            }

            String key = poolNum + "#" +orientType;
            PeoplePkgPool peoplePkgPool = poolMap.get(key);
            if(null == peoplePkgPool){
                peoplePkgPool = new PeoplePkgPool(poolNum, orientType);
                poolMap.put(key,peoplePkgPool);
            }

            //0 为 行业接受度 标签需要特殊处理
            if (advertTradePackageRelationDO.getSource() == 0) {
                peoplePkgPool.addTags(advertOrientationService.getAdvertTradeAccept(advtags, Arrays.asList(peoplePkg)));
            } else {
                peoplePkgPool.addTag(peoplePkg);
            }
        });

        return poolMap.values().stream().collect(groupingBy(PeoplePkgPool::getOrientType));
    }


    /**
     * 根据考核指标-覆盖CPC部分配置的subType
     * @param advOrientationItem
     */
    private void coverPackageCvrTypeByAssessType(AdvOrientationItem advOrientationItem){
        // 只对人工投放cpc生效
        if (!Objects.equals(advOrientationItem.getPackageType(), PackageTypeEnum.INTERACTIVE_TYPE.getCode())) {
            return;
        }

        //如果是CPC计费模式且无开启自动竞价,则将该配置的考核目标放到优化目标.
        if(advOrientationItem.getChargeType() != null
                && ChargeTypeEnum.TYPE_CPC.getCode() == advOrientationItem.getChargeType()
                && CPCAutoBiddingTypeEnum.UN_OPENED.getCode().equals(advOrientationItem.getAutoBiddingType())){

            // 目前只将激活和注册进行映射，其他的全部映射为落地页目标
            Integer subType = AssessTypeMapSubTypeEnum.getSubTypeByAssessType(advOrientationItem.getAssessType());
            advOrientationItem.setSubtype(subType);
        }

    }

    /**
     * 构建已转化人群过滤
     * @param advOrientationItem
     * @return
     */
    private TfUserFilter buildTfUserFilter(AdvOrientationItem advOrientationItem) {

        UserTfFilterDto userTfFilterDto = tfUserFilterDao.findByOrinetPkgId(advOrientationItem.getInitialOrientationId());
        if(null == userTfFilterDto){
            return null;
        }
        String filterType = userTfFilterDto.getFilterType();

        //广告计划
        if("1".equals(filterType)){
            return new TfUserFilterAdPlanImpl(String.valueOf(advOrientationItem.getAdvertId()),buildTarget(userTfFilterDto.getTarget()));
        }
        //广告主
        if("2".equals(filterType)){
            return new TfUserFilterAccountImpl(String.valueOf(advOrientationItem.getAccountId()),buildTarget(userTfFilterDto.getTarget()));
        }
        //资源
        if("3".equals(filterType)){
            return new TfUserFilterResourceImpl(advOrientationItem.getResourceTag(), buildTarget(userTfFilterDto.getTarget()),
                    buildTarget(userTfFilterDto.getTargetPeriod()), logConfig.getInfoEnable());
        }

        return null;
    }

    private List<String> buildTarget(String target) {
        if(null == target){
            return Collections.emptyList();
        }

        try {
            return Arrays.asList(target.split(","));
        }catch (Exception e){
            return Collections.emptyList();
        }
    }


    /**
     * 构建感兴趣和不感兴趣的人群信息
     * @return
     */
    public List<AdvertUserInterestItem> buildUserInterstAndNotInterestParam(Long orientPackageId,Set<String> advertTags){


        List<AdvertUserInterestItem> advertUserInterestItems = new ArrayList<>(2);
        AdvertUserInterestItem advertUserInterestItem = new AdvertUserInterestItem();
        AdvertUserInterestItem advertUserNotInterestItem = new AdvertUserInterestItem();

        advertUserInterestItems.add(advertUserInterestItem);
        advertUserInterestItems.add(advertUserNotInterestItem);

        //获取人群包关系表中的数据
        List<AdvertTradePackageRelationDO> advertTradePackageRelationDOS = advertTradePackageRelationDAO.selectAdvertTradePackageRelationByOrientId(orientPackageId);

        if(CollectionUtils.isEmpty(advertTradePackageRelationDOS)){
            return advertUserInterestItems;
        }


        Map<Integer,List<AdvertTradePackageRelationDO>> advertTradePackageRelationDOMap = advertTradePackageRelationDOS.stream().collect(Collectors.groupingBy(AdvertTradePackageRelationDO::getOrientType));

        getAdvertUserInterest(advertTradePackageRelationDOMap,advertUserInterestItems,advertTags);

        return advertUserInterestItems;
    }


    /**
     * 按照来源对构建感兴趣和不感兴趣标签
     * 目前    不限，定向，排斥，每次缀有一个生效       如果 定向和排出的list 都为空则不限      不限则跳过当前过滤逻辑进入下一个过滤条件
     * @param advertTradePackageRelationDOMap
     * @param advertUserInterestItems
     * @return
     */
    private void getAdvertUserInterest(Map<Integer, List<AdvertTradePackageRelationDO>> advertTradePackageRelationDOMap,List<AdvertUserInterestItem> advertUserInterestItems,Set<String> advertTags) {



        List<AdvertTradePackageRelationDO> orientAdvertTradePackageRelationDOS = advertTradePackageRelationDOMap.get(ORIENT_TYPE);
        List<AdvertTradePackageRelationDO> excludeAdvertTradePackageRelationDOS = advertTradePackageRelationDOMap.get(EXCLUDE_TYPE);


        //存在不限
        if(CollectionUtils.isEmpty(orientAdvertTradePackageRelationDOS) && CollectionUtils.isEmpty(excludeAdvertTradePackageRelationDOS)){
            return;
        }


        //构建感兴趣的标签
        if(CollectionUtils.isNotEmpty(orientAdvertTradePackageRelationDOS)){
            setInterestValue(advertUserInterestItems.get(0), orientAdvertTradePackageRelationDOS,advertTags);
        }

        //构建不感兴趣标签
        if(CollectionUtils.isNotEmpty(excludeAdvertTradePackageRelationDOS)){
            setInterestValue(advertUserInterestItems.get(1), excludeAdvertTradePackageRelationDOS,advertTags);
        }
    }

    /**
     * 设置兴趣标签
     * @param advertUserInterestItem
     * @param orientAdvertTradePackageRelationDOS
     */
    private void setInterestValue(AdvertUserInterestItem advertUserInterestItem, List<AdvertTradePackageRelationDO> orientAdvertTradePackageRelationDOS,Set<String> advertTags) {

        Set<String> interestSetResult = new HashSet<>();

        Map<Boolean,List<AdvertTradePackageRelationDO>> acceptTradesMap= orientAdvertTradePackageRelationDOS.stream().collect(Collectors.partitioningBy(dto->getTradeAccept(dto)));


        Set<String> interestSet = acceptTradesMap.get(Boolean.FALSE).stream().map(AdvertTradePackageRelationDO::getPeoplePkgId).collect(toSet());
        List<String> acceptTrades = acceptTradesMap.get(Boolean.TRUE).stream().map(AdvertTradePackageRelationDO::getPeoplePkgId).collect(toList());

        interestSetResult.addAll(interestSet);
        interestSetResult.addAll(advertOrientationService.getAdvertTradeAccept(advertTags,acceptTrades));


        advertUserInterestItem.setAllCrowdInterestTag(interestSetResult);
    }


    /**
     * source 为 1 并且 值为 （0到4） 则为人群兴趣
     * @param dto
     * @return
     */
    private Boolean getTradeAccept(AdvertTradePackageRelationDO dto){

        try {
            if (dto.getSource() != 0) {
                return false;
            }

            Integer tradeAccept = Integer.valueOf(dto.getPeoplePkgId());

            return TRADE_ACCEPT.contains(tradeAccept);
        }catch (Exception e){
            return false;
        }
    }



    /**
     * 
     * getFocusConvertCost:(查询配置的分媒体转化出价). <br/>
     *
     * @author chencheng
     * @param advOrientationItem 
     * @param advertOrientationPackageDO
     * @return
     * @since JDK 1.8
     */
    private void setFocusConvertCost(AdvOrientationItem advOrientationItem, AdvertOrientationPackageDO advertOrientationPackageDO) {
        // 获取类型
        DisAppFeeTypeEnum disAppFeeType = DisAppFeeTypeEnum.getByType(advertOrientationPackageDO.getSubtype(), advertOrientationPackageDO.getPackageType(),
                                                                      advertOrientationPackageDO.getChargeType(), advertOrientationPackageDO.getTargetAppLimit(),
                                                                      0);
        advOrientationItem.setDisAppFeeType(disAppFeeType);
        // 如果不属于分媒体出价，或是签收的分媒体出价，则不需要查询
        if (DisAppFeeTypeEnum.DEFULT_TYPE.equals(disAppFeeType) || DisAppFeeTypeEnum.SIGN_FOR_APP_TYPE.equals(disAppFeeType)) {
            advOrientationItem.setAppCostStableSwitch(0);
            return ;
        }
        
        // 查询分媒体出价
        OrientationFocusAppConvertCostDO query = new OrientationFocusAppConvertCostDO(advertOrientationPackageDO.getAdvertId(), advertOrientationPackageDO.getId(),
                                                                                      advertOrientationPackageDO.getSubtype(), advertOrientationPackageDO.getPackageType(),
                                                                                      advertOrientationPackageDO.getChargeType(), advertOrientationPackageDO.getPutTargetType());
        // 重点媒体转化出价，兼容方案。PutTargetType为0，多种投放方式使用一条数据
        if (disAppFeeType.equals(DisAppFeeTypeEnum.IMPORTANT_APP_TYPE)) {
            query.setPutTargetType(PutTargetTypeEnum.default_type.getPutTargetType());
        }
        // 如果是人工定向CPC,则默认subType为0;
        if(PackageTypeEnum.INTERACTIVE_TYPE.getCode().equals(advertOrientationPackageDO.getPackageType())){
            query.setSubtype(0);
        }

        //todo 7878 如果是优投模式(优投模式)，则投放目标设为4，
        if(PutTargetTypeEnum.manual_target.getTargetAppLimit().equals(advertOrientationPackageDO.getTargetAppLimit())){
            query.setPutTargetType(PutTargetTypeEnum.manual_target.getPutTargetType());
        }

        List<OrientationFocusAppConvertCostDO> advertFocusAppList = orientationFocusAppConvertCostDAO.selectByOrientationIdAndSubtype(query);

        if (CollectionUtils.isEmpty(advertFocusAppList)) {
            advOrientationItem.setAppCostStableSwitch(0);
            return;
        }
        
        // 分媒体对应的出价
        Map<Long, Long> focusAppConvertCost = advertFocusAppList.stream().filter(dto -> null != dto && dto.getConvertCost() != null).collect(Collectors
                .toMap(OrientationFocusAppConvertCostDO::getAppId, OrientationFocusAppConvertCostDO::getConvertCost, (oldVal, newVal) -> newVal));
        advOrientationItem.setFocusAppConvertCost(focusAppConvertCost);
        // 分媒体成本维稳开关
        advOrientationItem.setAppCostStableSwitch(advertFocusAppList.get(0).getAppCostStableSwitch());
    }

    /**
     *
     * getActivityType:(构建活动类型). <br/>
     *
     * @author chencheng
     * @param activityType
     * @return
     * @since JDK 1.8
     */
    private Set<String> buildActivityType(String activityType) {
        // 不限返回空set
        if (StringUtils.isNotBlank(activityType) && UNLIMITED.equals(activityType)) {
            return Sets.newHashSet();
        }
        return StringTool.getStringSetByStr(activityType);
    }

    @SuppressWarnings("squid:S3776")
    public void setGlobalHitValue(AdvOrientationItem advOrientationItem,AdvertOrientationPackageDO advertOrientationPackageDO,AdvertDO advertDO) throws Exception{
        try {
            JSONArray pushDate=null;
            String pushDateStr;
            Set<String> advertPlatform = StringTool.getStringSetByStr(advertOrientationPackageDO.getPlatform());
            if(advertOrientationPackageDO.getHitStatus()==1){
                JSONObject hitValue=JSONObject.parseObject(advertOrientationPackageDO.getHitValue());

                BigDecimal advertWeight=null;
                String advertWeightStr=getGlobalFlowHitValue(hitValue,GlobalConfigItemEnum.ADVERT_WEIGHT.getCode());
                if(StringUtils.isNotBlank(advertWeightStr)){
                    JSONObject advertWeightJson=(JSONObject) JSON.parseArray(advertWeightStr).get(0);
                    advertWeight=advertWeightJson.getBigDecimal("weight");
                }

                Set<Integer> joinNums=null;
                String joinNumsStr=getGlobalFlowHitValue(hitValue,GlobalConfigItemEnum.JOIN_NUMS.getCode());
                if(StringUtils.isNotBlank(joinNumsStr)){
                    JSONObject joinNumsJson=(JSONObject) JSON.parseArray(joinNumsStr).get(0);
                    joinNums=StringTool.getIntegerSetByStr(joinNumsJson.getString("pushOrder"));
                }
                Set<String> platForm=null;
                String platFormStr=getGlobalFlowHitValue(hitValue,GlobalConfigItemEnum.PLAT_FORM.getCode());
                if(StringUtils.isNotBlank(platFormStr)){
                    JSONObject platFormJson=(JSONObject) JSON.parseArray(platFormStr).get(0);
                    platForm=StringTool.getStringSetByStr(platFormJson.getString("operateSystem"));
                }

                pushDateStr=getGlobalFlowHitValue(hitValue,GlobalConfigItemEnum.PUSH_DATE.getCode());
                if(StringUtils.isNotBlank(pushDateStr)){
                    pushDate=JSON.parseArray(pushDateStr);
                }

                Set<String> regions=null;
                String regionsStr=getGlobalFlowHitValue(hitValue,GlobalConfigItemEnum.REGION_IDS.getCode());
                if(StringUtils.isNotBlank(regionsStr)){
                    JSONObject regionsJson=(JSONObject) JSONArray.parseArray(regionsStr).get(0);
                    regions=StringTool.getStringSetByStr(regionsJson.getString("regions"));
                }

                advOrientationItem.setAdvertWeight(advertWeight==null? advertDO.getAdvertWeight():advertWeight);
                advOrientationItem.setPlatform(CollectionUtils.isEmpty(platForm)? advertPlatform : platForm);
                advOrientationItem.setRegionIds(CollectionUtils.isEmpty(regions) ?
                    StringTool.getStringSetByStr(advertOrientationPackageDO.getRegionIds()) : regions);
                advOrientationItem.setJoinNums(CollectionUtils.isEmpty(joinNums) ?
                    StringTool.getIntegerSetByStr(advertOrientationPackageDO.getDirectionalNum()) : joinNums);
                //投放时段
                if(INTERSECTION_NULL.equals(pushDateStr)){
                    advOrientationItem.setIsChangePeriodList(-2);
                }else if(StringUtils.isNotBlank(pushDateStr)){
                    List<AdvertPlanPeriodDO> periodListEs = buildPeriodList(pushDate,advertDO.getId(), advOrientationItem.getOrientationId());
                    if (CollectionUtils.isNotEmpty(periodListEs)) {
                        advOrientationItem.setPeriodList(periodListEs);
                    }
                    advOrientationItem.setIsChangePeriodList(1);
                }else{
                    advOrientationItem.setIsChangePeriodList(0);
                }
            }else{
                advOrientationItem.setAdvertWeight(advertDO.getAdvertWeight());
                advOrientationItem.setPlatform(advertPlatform);
                advOrientationItem.setRegionIds(StringTool.getStringSetByStr(advertOrientationPackageDO.getRegionIds()));
                advOrientationItem.setJoinNums(StringTool.getIntegerSetByStr(advertOrientationPackageDO.getDirectionalNum()));
                advOrientationItem.setIsChangePeriodList(0);
            }

        } catch (Exception e) {
            logger.warn("setGlobalHitValue error, advertId=[{}], orientationId=[{}]", advertDO.getId(), advertOrientationPackageDO.getId(), e);
        }

    }

    public List<AdvertPlanPeriodDO> buildPeriodList(JSONArray pushDate,Long advertId,Long orientationId){
        List<AdvertPlanPeriodDO> periodListEs = Lists.newArrayList();
        for(Object item:pushDate){
            JSONObject pushDateJson=(JSONObject) item;
            AdvertPlanPeriodDO advertPlanPeriodEsDto=new AdvertPlanPeriodDO(null,
                    pushDateJson.getString(START_HOUR),
                    pushDateJson.getString(END_HOUR),
                    null,
                     advertId,
                     orientationId,
                    "countCoupon",
                    null
            );
            periodListEs.add(advertPlanPeriodEsDto);
        }
        return periodListEs;
    }

    /**
     * 获取全局流量替换后的值
     * @param hitValue
     * @param type
     * @return
     */
    public String getGlobalFlowHitValue(JSONObject hitValue,Integer type){
       return hitValue.getString(String.valueOf(type));
    }


    private void setAllShieldTags(AdvOrientationItem advOrientationItem, Set<String> bannedTags, Set<String> advtags,
                                  Set<String> promoteUrlTagNums) {

        //将广告的屏蔽标签放入一起压入过滤
        Set<String> allShieldTags = Sets.newHashSet();
        AdvBannedTag advBannedTag = AdvBannedTag.build();
        //这个tag不压入ES，只给全局流量判断
        Set<String> globalShieldTags = Sets.newHashSet();
        if (CollectionUtils.isNotEmpty(bannedTags)) {
            allShieldTags.addAll(bannedTags);
            advBannedTag.getAttributeTags().addAll(new HashSet<>(bannedTags));
        }
        if (CollectionUtils.isNotEmpty(advtags)) {
            allShieldTags.addAll(advtags);
            globalShieldTags.addAll(advtags);
            advBannedTag.getIndustryTags().addAll(new HashSet<>(advtags));
        }
        if (CollectionUtils.isNotEmpty(promoteUrlTagNums)) {
            allShieldTags.addAll(promoteUrlTagNums);
            globalShieldTags.addAll(promoteUrlTagNums);
            advBannedTag.getPromoteUrlTags().addAll(new HashSet<>(promoteUrlTagNums));
        }
        if (StringUtils.isNotBlank(advOrientationItem.getResourceTag())) {
            advBannedTag.getResourceTags().addAll(new HashSet<>(Arrays.asList(advOrientationItem.getResourceTag().split(","))));
        }
        advOrientationItem.setAllShieldTags(allShieldTags);
        advOrientationItem.setAdvBannedTag(advBannedTag);
        advOrientationItem.setGlobalShieldTags(globalShieldTags);
    }

    /**
     *
     * getValidPkgFilterCache:(所有有效的配置过滤属性信息缓存). <br/>
     *
     * @author chencheng
     * @return
     * @since JDK 1.8
     */
    public List<AdvOrientationItem> getValidPkgFilterCache() {
        //获取所有的有效配置信息
        return allPkgCache.getUnchecked(allPkgKey);
    }

    /**
     *
     * getValidPkgFilterCache:(所有有效的配置过滤属性信息缓存). <br/>
     *
     * @author chencheng
     * @return
     * @since JDK 1.8
     */
    public AdvOrientationItem getValidAdvOrientation(Long advertId, Long orientationId) {
        if(advertId == null || orientationId == null){
            return null;
        }

        //获取所有的有效配置信息
        try {
            return validPkgFilterCache.get(getCacheKey(advertId, orientationId)).orElse(null);
        } catch (Exception e) {
            logger.error("getValidAdvOrientation error, advertId={}, orientationId={}", advertId, orientationId, e);
            return null;
        }
    }

    /**
     *
     * updateValidAdvertFilterCache:(更新有效广告的过滤配置缓存). <br/>
     *
     * @author chencheng
     * @param advertId
     * @since JDK 1.8
     */
    @SuppressWarnings("squid:S3776")
    public void updateValidAdvertFilterCache(Long advertId) {
        try {
            // 获取广告相关的信息
            AdvertFilterPkgVO advertFilterPkgVO = getAdvertFilterPkgVO(advertId);

            // 查询广告下所有有效的配置
            List<AdvertOrientationPackageDO> listOrientations = orientationPackageDAO.selectByAdvertIdList(advertId);
            if (CollectionUtils.isEmpty(listOrientations)){
                return;
            }

            // 获取广告下的所有配置的定向活动
            List<AdvertTargetActivityDO> advertTargetActivityDO = advertTargetActivityDAO.selectBindActivityByAdvertId(advertId);
            Map<Long, String> pckIdTargetActivityMap = advertTargetActivityDO.stream()
                    .filter(dto -> null != dto && StringUtils.isNotBlank(dto.getActivityIds()))
                    .collect(Collectors.toMap(AdvertTargetActivityDO::getOrientPkgId, AdvertTargetActivityDO::getActivityIds, (oldVal, newVal) -> newVal));


            for (AdvertOrientationPackageDO advertOrientationPackageDO : listOrientations) {
                // 默认配置的id构建
                Long orientationId = advertOrientationPackageDO.getId();
                if (advertOrientationPackageDO.getIsDefault().equals(CommonConstant.YES)) {
                    orientationId = 0L;
                }
                // 广告失效或不存在，将缓存失效
                if (advertFilterPkgVO == null){
                    validPkgFilterCache.invalidate(getCacheKey(advertId, orientationId));
                    continue;
                }
                // 配置无效，将缓存失效
                if(null == advertOrientationPackageDO || advertOrientationPackageDO.getEnableStatus().equals(0)){
                    validPkgFilterCache.invalidate(getCacheKey(advertId, orientationId));
                    continue;
                }

                String targetActivityIds = pckIdTargetActivityMap.get(advertOrientationPackageDO.getId());

                //获取 托管底价白名单开关状态
                Boolean obctTag = getObctTag(advertOrientationPackageDO.getId());

                // 构建配置的缓存信息
                AdvOrientationItem advOrientationItem = getAdvOrientationItem(advertId,advertOrientationPackageDO, orientationId, advertFilterPkgVO, targetActivityIds, obctTag);
                // 构建拓展信息
                getAdverOrientPackageExtItem(advOrientationItem, advertId, advertOrientationPackageDO.getId());
                // 覆盖缓存
                validPkgFilterCache.put(getCacheKey(advertId, orientationId), Optional.ofNullable(advOrientationItem));
            }

            allPkgCache.refresh(allPkgKey);

        } catch (Exception e) {
            logger.error("updateValidAdvertFilterCache errror, advertId=[{}]", advertId, e);
        }
    }

    /**
     *
     * updateValidPkgFilterCache:(更新有效的过滤配置缓存). <br/>
     *
     * @author chencheng
     * @param advertId 广告id
     * @param orientId 配置id
     * @since JDK 1.8
     */
    public void updateValidPkgFilterCache(Long advertId, Long orientId) {
        try {
            validPkgFilterCache.refresh(getCacheKey(advertId, orientId));
            allPkgCache.refresh(allPkgKey);
        } catch (Exception e) {
            logger.error("updateValidPkgFilterCache by advertId|orientId errror, advertId=[{}], orientId=[{}]", advertId, orientId, e);
        }
    }

    /**
     *
     * updateValidPkgFilterCache:(更新有效的过滤配置缓存). <br/>
     *
     * @author chencheng
     * @param id : advertId|orientId
     * @since JDK 1.8
     */
    public void updateValidPkgFilterCache(String id) {
        try {
            validPkgFilterCache.refresh(id);
            allPkgCache.refresh(allPkgKey);
        } catch (Exception e) {
            logger.error("updateValidPkgFilterCache by advertId|orientId errror, id=[{}]", id, e);
        }
    }

    private String getCacheKey(Long advertId, Long orientId){
        StringBuilder sb = new StringBuilder();
        return sb.append(advertId).append(SPLIT_CHAR).append(orientId).toString();
    }

    /**
     * 初始化标识 线程刷新缓存前，
     */
    private  AtomicInteger chacheLoding = new AtomicInteger(0);
    private volatile List<AdvOrientationItem> oldValidPkgFilterCache;

    /**
     *
     * initAllValidAdvertCache:(初始化所有有效广告的过滤配置缓存). <br/>
     *
     * @author chencheng
     * @throws TuiaException
     * @since JDK 1.8
     */
    public void initAllValidAdvertFilterCache() {
        if(!chacheLoding.compareAndSet(0,1)){
            return;
        }
        try {
            initValidAdvertIds();
            // 如果cas失败 直接返回
            // 1.查询所有有效的广告ID
            if (CollectionUtils.isEmpty(validAdvertIds)) {
                logger.warn("初始化有限广告列表为空");
                return;
            }
            oldValidPkgFilterCache = getAllValidPkg();
            // 2.清除已存在的缓存
            validPkgFilterCache.invalidateAll();

            validAdvertIds.forEach(this::updateValidAdvertFilterCache);

            allPkgCache.refresh(allPkgKey);
        } finally {
            // 执行完 返回
            chacheLoding.set(0);
            // 辅助GC 回收
            oldValidPkgFilterCache = null;
        }
    }

    /**
     * 测试使用失效全部缓存
     */
    public void invalidateAll() {
        validPkgFilterCache.invalidateAll();
        allPkgCache.invalidateAll();
    }

    /**
     * 项目启动后开启定时线程池刷新
     */
    public void openJob(){
        ScheduledExecutorService executorService = new ScheduledThreadPoolExecutor(1,
                new BasicThreadFactory.Builder().namingPattern("validAdvertFilterCache-schedule-pool-%d").daemon(true).build());

        executorService.scheduleAtFixedRate(() -> {
            try {
                //执行的任务
//                initAllValidAdvertFilterCache();
            }catch (Exception ex){
                logger.error("validAdvertFilterCache-schedule-pool error",ex);
            }
        },10,10, TimeUnit.MINUTES);
    }
}
