package cn.com.duiba.tuia.cache;

import cn.com.duiba.tuia.dao.advert.AdvertMaterialTestPlanDAO;
import cn.com.duiba.tuia.domain.dataobject.AdvertMaterialTestPlanDO;
import com.alibaba.fastjson.JSONObject;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListenableFutureTask;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;

@Service
@Slf4j
public class AdvertMaterialTestPlanCacheService {

    @Resource
    private ExecutorService executorService;

    @Autowired
    private AdvertMaterialTestPlanDAO advertMaterialTestPlanDAO;

    //修改数据库 并 过期缓存
    public void changeAndExpire(){

        executorService.execute(()->{
            //key->planId 此处存在问题 ： 数据库 会多次 重复 更新 值 不过 不影响业务
            ADVERT_MATERIAL_TEST_PLAN_ALL_CACHE.refresh(1L);
        });

    }

    private final LoadingCache<Long, Map<Long, AdvertMaterialTestPlanDO>> ADVERT_MATERIAL_TEST_PLAN_ALL_CACHE = CacheBuilder.newBuilder().initialCapacity(1)
            .recordStats()
            .refreshAfterWrite(10, TimeUnit.SECONDS)
            .expireAfterWrite(5, TimeUnit.MINUTES)
            .build(new CacheLoader<Long, Map<Long, AdvertMaterialTestPlanDO>>() {

        @Override
        public Map<Long, AdvertMaterialTestPlanDO> load(Long key) {
            List<AdvertMaterialTestPlanDO> doList = advertMaterialTestPlanDAO.selectVaildPlanAll();
            if (CollectionUtils.isEmpty(doList)) {
                return Collections.emptyMap();
            }

            Map<Long, AdvertMaterialTestPlanDO> map = new HashMap<>();

            doList.stream().forEach(item -> {
                if (StringUtils.isNotBlank(item.getMaterialIdStr())) {
                    String[] arr = StringUtils.split(item.getMaterialIdStr(), ",");
                    List<Long> materialIds = new ArrayList<>(arr.length);
                    for (String s : arr) {
                        materialIds.add(Long.valueOf(s));
                    }
                    item.setGmtCreate(null);
                    item.setGmtModified(null);
                    item.setMaterialIds(materialIds);
                }

                map.put(item.getAdvertId(), item);
            });
            if (log.isInfoEnabled()) {
                log.info("ADVERT_MATERIAL_TEST_PLAN_ALL_CACHE {}", JSONObject.toJSONString(map));
            }
            return map;
        }

        @Override
        public ListenableFuture<Map<Long, AdvertMaterialTestPlanDO>> reload(final Long key, Map<Long, AdvertMaterialTestPlanDO> oldValue) {
            ListenableFutureTask<Map<Long, AdvertMaterialTestPlanDO>> task = ListenableFutureTask.create(() -> load(key));
            executorService.submit(task);
            return task;
        }
    });

    public Map<Long, AdvertMaterialTestPlanDO> getAdvertMaterialTestPlanDoNew() {
        try {
            return ADVERT_MATERIAL_TEST_PLAN_ALL_CACHE.get(1L);
        } catch (ExecutionException e) {
            return Collections.emptyMap();
        }
    }

}
