package cn.com.duiba.tuia.cache;

import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;

import javax.annotation.Resource;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListenableFutureTask;

import cn.com.duiba.tuia.dao.appArpu.AppArpuDao;

@Service
public class AppLowArpuCacheService extends BaseCacheService {

    @Resource
    private ExecutorService executorService;

    @Autowired
    private AppArpuDao appArpuDao;

    private LoadingCache<Long, Optional<Double>> appLowArpuCache = CacheBuilder.newBuilder()
            .refreshAfterWrite(5, TimeUnit.MINUTES).expireAfterWrite(1, TimeUnit.HOURS).build(new CacheLoader<Long, Optional<Double>>() {
                @Override
                public Optional<Double> load(Long key) throws Exception {
                    return Optional.ofNullable(appArpuDao.getAppArpuByAppId(key));
                }

                @Override
                public ListenableFuture<Optional<Double>> reload(Long appId, Optional<Double> oldValue) throws Exception {
                    ListenableFutureTask<Optional<Double>> task = ListenableFutureTask.create(() -> load(appId));
                    executorService.submit(task);
                    return task;
                }
            });

    public Double getAppLowArpu(Long appId){
        try{
            return appLowArpuCache.get(appId).orElse(null);
        }catch (ExecutionException e) {
            logger.error("getAppLowArpu error", e);
            return null;
        }
    }

}
