/**
 * Project Name:engine-service<br>
 * File Name:BaseCacheService.java<br>
 * Package Name:cn.com.duiba.tuia.cache<br>
 * Date:2016年11月23日下午2:24:47<br>
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.<br>
 */

package cn.com.duiba.tuia.cache;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;

import javax.annotation.Resource;

import cn.com.duiba.tuia.message.rocketmq.RefreshCacheMqProducer;
import cn.com.tuia.advert.cache.RedisCommonKeys;
import cn.com.tuia.advert.constants.CommonConstant;
import cn.com.duiba.nezha.engine.api.dto.FusingOrientationPackageDto;

import cn.com.tuia.advert.model.messageDto.AdvertMsg;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;

import cn.com.duiba.tuia.domain.model.UpdateNewAppTestCacheMsg;
import cn.com.duiba.tuia.service.BaseService;
import cn.com.duiba.wolf.cache.AdvancedCacheClient;
import cn.com.tuia.advert.message.RedisMessageChannel;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;

/**
 * ClassName: BaseCacheService <br/>
 * Function: 缓存广告服务. <br/>
 * date: 2016年11月23日 下午2:24:47 <br/>
 *
 * @author leiliang
 * @version
 * @since JDK 1.6
 */
@Service
public class BaseCacheService extends BaseService {

    /** 从redis 队列中取出所有值的标识. */
    protected static final int                        GET_ALL_IDS            = -1;

    /** redis 默认列表长度的标识. */
    public static final int                           DEFAULT_IDS_SIZE       = 1;

    /** 在redis缓存列队中塞入默认的ID(-1). */
    protected static final String                     DEFAULT_ID_STRING      = "-1";

    /** 在redis缓存列队中塞入默认的ID(-2). */
    protected static final String                     RECEIVE_ADVERT_DEFAULT = "-2";

    /** 在redis缓存列队中塞入默认的ID(-1). */
    public static final long                          DEFAULT_ID_LONG        = -1;

    /** 通知该广告该时段状态修改 */
    public static final String                        UPDATE_ADVERTS_IS_PUT  = "updateAdvertIsPut";

    /** 一周. */
    protected static final int                        ONE_WEEK               = 60 * 60 * 24 * 7;

    /** 一天. */
    protected static final int                        ONE_DAY                = 60 * 60 * 24;

    /** 一小时. */
    protected static final int                        ONE_HOUR               = 60 * 60;

    /** The default ids. */
    protected static final List<String>               DEFAULT_IDS            = new ArrayList<String>(1) {

                                                                                 private static final long serialVersionUID = 1L;

                                                                                 {
                                                                                     add(RECEIVE_ADVERT_DEFAULT);
                                                                                 }
                                                                             };

    /**
     * map size
     */
    protected static int maxCapacity = 2000;

    // 这个redisTemplate你可以替换成任意的其他名字的RedisTemplate，你的RedisTemplate内部使用了什么序列化方式不重要，我们内部会用Hessian2来序列化
    @Resource(name = "redisTemplate")
    protected AdvancedCacheClient advancedCacheClient;

    @Resource
    protected StringRedisTemplate                     stringRedisTemplate;

    @Resource
    private RedisTemplate<String, String>  redisTemplate;

    @Autowired
    private RefreshCacheMqProducer refreshCacheMqProducer;
    /**
     * 
     * updateValidAdvertIdsCache:(更新有效广告排序列表). <br/>
     *
     * @author chencheng
     * @param advertType 广告id，或者特殊值 @AdvertSortTypeEnum
     * @since JDK 1.8
     */
    public void updateValidAdvertIdsCache(Long advertType) {
        // 更新广告有效列表频道
        JSONObject jsonObj = new JSONObject();
        jsonObj.put("advertType", String.valueOf(advertType));
        jsonObj.put("thisAdvertType", String.valueOf(CommonConstant.HD_ADVERT_TYPE));
        logger.info("publish update valid adverts message channel, the advertType=[{}]", advertType);
        redisTemplate.convertAndSend(RedisMessageChannel.UPDATE_VALID_ADVERTS_MSG.getChannel(), jsonObj.toString());
    }

    /**
     * 广告缓存更新消息
     * @param advertIds 广告id
     * @param advertType 广告类型
     */
    public void publishUpdateAdvertsMsg(List<Long> advertIds, Integer advertType) {
        logger.info("update advert cache, tag=KC104, the advertIds=[{}],advertType=[{}]", advertIds, advertType);
        AdvertMsg msg = new AdvertMsg(AdvertMsg.UPDATE_TRAGET, advertIds, advertType, "engine-publishUpdateAdvertsMsg");
        refreshCacheMqProducer.sendMsg(RedisCommonKeys.KC104.toString(),JSON.toJSONString(msg));
    }

    public void publishFusingOrientPackage(Set<FusingOrientationPackageDto> fusingPackageList) {
        if (CollectionUtils.isEmpty(fusingPackageList)) {
            return;
        }
        logger.info("send publishFusingOrientPackage, the fusingPackageList=[{}]", JSON.toJSONString(fusingPackageList));

        redisTemplate.convertAndSend(RedisMessageChannel.FUSING_ORIENTATION_PACKAGE.getChannel(), JSON.toJSONString(fusingPackageList));
    }

    /**
     * 
     * updateNewAppTestCacheMsg:(更新新媒体试投缓存). <br/>
     *
     * @author chencheng
     * @param appId
     * @param type
     * @since JDK 1.8
     */
    public void updateNewAppTestCacheMsg(Long appId, Long advertId, Integer type) {

        logger.info("update new App Test Cache Msg cahce, the appId=[{}], advertId=[{}], type=[{}]", appId, advertId, type);
        UpdateNewAppTestCacheMsg msg = new UpdateNewAppTestCacheMsg(appId, advertId, type);
        redisTemplate.convertAndSend(RedisMessageChannel.UPDATE_NEW_APP_TEST_CACHE_MSG.getChannel(), JSON.toJSONString(msg));
    }
}
