
package cn.com.duiba.tuia.cache;

import cn.com.duiba.tuia.domain.dataobject.AdvertDO;
import cn.com.duiba.tuia.domain.dataobject.AdvertOrientationPackageDO;
import cn.com.duiba.tuia.domain.model.AdvertPlan;
import cn.com.duiba.tuia.domain.vo.AdvertOrientationPackageVO;
import org.springframework.cglib.beans.BeanCopier;

/**
 * ClassName: BeanCopierUtil <br/>
 * Function: 实体对象拷贝工具类 <br/>
 * Reason: TODO ADD REASON(可选). <br/>
 * date: 2017年1月5日 上午11:03:44 <br/>
 *
 * @author cdm
 * @since JDK 1.7
 */
public class BeanCopierManager {


    //广告计划拷贝对象
    private static BeanCopier obtainAdvertReqBeanCopier = null;

    //拷贝对象
    private static BeanCopier beanCopier = null;

    //广告计划拷贝对象
    private static BeanCopier advertPlanBeanCopier = null;

    //广告定向包拷贝对象
    private static BeanCopier advertPackageBeanCopier = null;

    //广告计划转为广告定向包拷贝对象
    private static BeanCopier planToOrientationBeanCopier = null;

    /**
     * getAdvertPlanBeanCopier:(这里用一句话描述这个方法的作用). <br/>
     * 获取拷贝对象.<br/>
     *
     * @return
     * @author cdm
     * @since JDK 1.7
     */
    public static BeanCopier getBeanCopier(Class<?> fromClass, Class<?> toClass) {
        if (beanCopier == null) {
            beanCopier = BeanCopier.create(fromClass, toClass, false);
        }
        return beanCopier;
    }

    /**
     * getAdvertPlanBeanCopier:(这里用一句话描述这个方法的作用). <br/>
     * 获取广告请求拷贝对象.<br/>
     *
     * @return
     * @author cdm
     * @since JDK 1.7
     */
    public static BeanCopier getAdvertReqBeanCopier(Class<?> fromClass, Class<?> toClass) {
        if (obtainAdvertReqBeanCopier == null) {
            obtainAdvertReqBeanCopier = BeanCopier.create(fromClass, toClass, false);
        }
        return obtainAdvertReqBeanCopier;
    }


    /**
     * 获取广告计划的拷贝对象:(这里用一句话描述这个方法的作用). <br/>
     *
     * @return
     * @author cdm
     * @since JDK 1.6
     */
    public static BeanCopier getAdvertPlanBeanCopier() {
        if (advertPlanBeanCopier == null) {
            advertPlanBeanCopier = BeanCopier.create(AdvertDO.class, AdvertPlan.class, false);
        }
        return advertPlanBeanCopier;
    }

    /**
     * 获取广告定向包的拷贝对象
     *
     * @return
     * @author cdm
     * @since JDK 1.6
     */
    public static BeanCopier getAdvertPackageBeanCopier() {
        if (advertPackageBeanCopier == null) {
            advertPackageBeanCopier = BeanCopier.create(AdvertOrientationPackageDO.class, AdvertOrientationPackageVO.class, false);
        }
        return advertPackageBeanCopier;
    }

    /**
     * 获取计划转为广告定向包的拷贝对象
     *
     * @return
     * @author cdm
     * @since JDK 1.6
     */
    public static BeanCopier getPlanToOrientationBeanCopier() {
        if (planToOrientationBeanCopier == null) {
            planToOrientationBeanCopier = BeanCopier.create(AdvertPlan.class, AdvertOrientationPackageVO.class, false);
        }
        return planToOrientationBeanCopier;
    }

}
