package cn.com.duiba.tuia.cache;

/**
 * Created by pc on 2016/8/26.
 */

import java.util.List;
import java.util.concurrent.TimeUnit;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.ValueOperations;

import com.alibaba.fastjson.JSON;
import org.springframework.stereotype.Component;

/**
 * redis cache 工具类
 */
@Component
public class RedisUtil {
    private static final Logger logger = LoggerFactory.getLogger(RedisUtil.class);

    @Autowired
    @Qualifier("stringRedisTemplate")
    private RedisTemplate<String, String> stringRedisTemplate;


    /**
     * 写入缓存
     *
     * @param key
     * @param value
     * @return
     */
    public boolean set(final String key, String value, Long expireTime) {
        boolean result = false;
        try {
            ValueOperations<String, String> operations = stringRedisTemplate
                    .opsForValue();
            operations.set(key, value);
            stringRedisTemplate.expire(key, expireTime, TimeUnit.SECONDS);
            result = true;
        } catch (Exception e) {
            logger.warn("set object  happend error", e);
        }
        return result;
    }


    /**
     * @param key
     * @param list
     * @param expireTime
     * @return
     */
    public boolean setList(final String key, Object list, Long expireTime) {
        boolean result = false;
        try {
            String value = JSON.toJSONString(list);

            if (key != null) {
                result = set(key, value, expireTime);
            }
        } catch (Exception e) {
            logger.warn("setList happend error", e);
        }
        return result;
    }



    /**
     * 获取list
     *
     * @param key
     * @param clazz
     * @param <T>
     * @return
     */
    public <T> List<T> getList(final String key, Class clazz) {
        List<T> result = null;
        try {
            Object value = get(key);
            result = JSON.parseArray((String) value, clazz);
        } catch (Exception e) {
            logger.warn("getList happend error", e);
        }
        return result;
    }


    /**
     * 读取缓存
     *
     * @param key
     * @return
     */
    public Object get(final String key) {

        ValueOperations<String, String> operations = stringRedisTemplate
                .opsForValue();
        return operations.get(key);
    }

    /**
     * 读取缓存
     *
     * @param key
     * @return
     */
    public  <T> T  get(final String key, Class clazz) {
        T result = null;
        Object value = get(key);
        if(value!=null){
            result = (T)JSON.parseObject((String)value, clazz);
        }

        return result;
    }


    /**
     * 写入缓存
     *
     * @param key
     * @param value
     * @return
     */
    public boolean set(final String key, String value) {
        boolean result = false;
        try {
            ValueOperations<String, String> operations = stringRedisTemplate.opsForValue();
            operations.set(key, value);
            result = true;
        } catch (Exception e) {
            logger.error("set happend error", e);
        }
        return result;
    }




}