package cn.com.duiba.tuia.cache;

import cn.com.duiba.tuia.domain.model.UpdateNewAppTestCacheMsg;
import cn.com.duiba.tuia.message.rocketmq.RefreshCacheMqProducer;
import cn.com.duiba.tuia.tool.CatUtil;
import cn.com.tuia.advert.constants.ConfigRocketMqTags;
import cn.com.tuia.advert.message.RedisMessageChannel;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * @author huangruodan
 * @version 创建时间：2020/10/15 11:57 上午
 */
@Service
@Slf4j
public class RefreshCacheMqService {

    @Autowired
    private RefreshCacheMqProducer refreshCacheMqProducer;

    /**
     * 新媒体试投缓存更新消息
     * @param appId
     * @param advertId
     * @param type
     */
    public void updateNewAppTestCacheMsg(Long appId, Long advertId, Integer type) {

        log.info("update new App Test Cache Msg cahce, the appId=[{}], advertId=[{}], type=[{}]", appId, advertId, type);
        UpdateNewAppTestCacheMsg msg = new UpdateNewAppTestCacheMsg(appId, advertId, type);
        refreshCacheMqProducer.sendMsgWithId(ConfigRocketMqTags.UPDATE_NEW_APP_TEST_CACHE_MSG, JSON.toJSONString(msg));
    }


}
