package cn.com.duiba.tuia.dubbo.service.impl;

import cn.com.duiba.boot.utils.WarningUtils;
import cn.com.duiba.tuia.cache.AdvertKeywordCacheService;
import cn.com.duiba.tuia.cache.AdvertMapCacheManager;
import cn.com.duiba.tuia.cache.ServiceManager;
import cn.com.duiba.tuia.constants.AdvertConstants;
import cn.com.duiba.tuia.constants.AdvertReqLogExtKeyConstant;
import cn.com.duiba.tuia.constants.PackagePlanConstants;
import cn.com.duiba.tuia.dao.engine.AdvertOrderDAO;
import cn.com.duiba.tuia.dao.ip_library.IpLibraryDAO;
import cn.com.duiba.tuia.dao.material.AdvertMaterialRealtionService;
import cn.com.duiba.tuia.domain.dataobject.*;
import cn.com.duiba.tuia.domain.model.AdvOrientationItem;
import cn.com.duiba.tuia.domain.model.AdvQueryParam;
import cn.com.duiba.tuia.domain.model.AdvertCoupon;
import cn.com.duiba.tuia.domain.model.AdvertNewCouponDto;
import cn.com.duiba.tuia.domain.model.AdvertPlan;
import cn.com.duiba.tuia.domain.model.AsynReq;
import cn.com.duiba.tuia.domain.model.AsynReqType;
import cn.com.duiba.tuia.domain.model.CatMonitorWarnThreshold;
import cn.com.duiba.tuia.domain.model.CouponBase;
import cn.com.duiba.tuia.domain.model.FilterResultTypes;
import cn.com.duiba.tuia.domain.model.PhoneInfo;
import cn.com.duiba.tuia.domain.model.SpmType;
import cn.com.duiba.tuia.domain.vo.AdvertFilterVO;
import cn.com.duiba.tuia.domain.vo.AdvertMaterialVO;
import cn.com.duiba.tuia.domain.vo.AdvertPriceVO;
import cn.com.duiba.tuia.domain.vo.AdvertVO;
import cn.com.duiba.tuia.domain.vo.OrderJsonVO;
import cn.com.duiba.tuia.enums.CatGroupEnum;
import cn.com.duiba.tuia.enums.NetworkTypeEnum;
import cn.com.duiba.tuia.enums.OperatorsEnum;
import cn.com.duiba.tuia.exception.TuiaException;
import cn.com.duiba.tuia.filter.service.DirectAdvertFilterService;
import cn.com.duiba.tuia.log.StatClickJsonLog;
import cn.com.duiba.tuia.log.StatExposureJsonLog;
import cn.com.duiba.tuia.log.StatLaunchJsonLog;
import cn.com.duiba.tuia.message.rocketmq.DeviceApiRocketMqProducer;
import cn.com.duiba.tuia.message.rocketmq.DirectPracFeeRocketMqProducer;
import cn.com.duiba.tuia.service.AdvertMaterialRecommendService;
import cn.com.duiba.tuia.service.AdvertOrientationService;
import cn.com.duiba.tuia.service.AdvertRealDataService;
import cn.com.duiba.tuia.service.CommonService;
import cn.com.duiba.tuia.service.IdWokerService;
import cn.com.duiba.tuia.service.impl.CommonServiceImpl;
import cn.com.duiba.tuia.tool.CatUtil;
import cn.com.duiba.tuia.tool.StringTool;
import cn.com.duiba.wolf.dubbo.DubboResult;
import cn.com.duiba.wolf.perf.timeprofile.DBTimeProfile;
import cn.com.duibaboot.ext.autoconfigure.core.utils.CatUtils;
import cn.com.tuia.advert.constants.CommonConstant;
import cn.com.tuia.advert.enums.AdvertOrderJsonKeyEnum;
import cn.com.tuia.advert.enums.ChargeTypeEnum;
import cn.com.tuia.advert.enums.PackageTypeEnum;
import cn.com.tuia.advert.model.AdvertDirectDto;
import cn.com.tuia.advert.model.DirectAdvertLogReq;
import cn.com.tuia.advert.model.DirectObtainAdvertReq;
import cn.com.tuia.advert.model.ObtainAdvertReqLogExt;
import cn.com.tuia.advert.model.SpmlogReq;
import cn.com.tuia.advert.service.IAdvertDirectService;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListenableFutureTask;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.context.event.EventListener;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.util.*;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

/**
 * @author: <a href="http://www.panaihua.com">panaihua</a>
 * @date: 2017年08月01日 11:27
 * @descript:
 * @version: 1.0
 */
@RestController
public class DirectAdvertServiceImpl implements IAdvertDirectService {

    private final Logger logger = LoggerFactory.getLogger(DirectAdvertServiceImpl.class);

    @Autowired
    private AdvertMapCacheManager advertMapCacheManager;


    @Autowired
    private AdvertRealDataService advertRealDataService;

    @Autowired
    private AdvertOrientationService advertOrientationService;

    @Autowired
    private ServiceManager serviceManager;

    @Autowired
    private CommonService commonService;

    @Autowired
    private DirectPracFeeRocketMqProducer directPracFeeRocketMqProducer;

    @Resource
    private ExecutorService executorService;

    @Autowired
    private DirectAdvertFilterService advertFilterService;

    @Autowired
    private AdvertMaterialRecommendService advertMaterialRecommendService;

    @Autowired
    private AdvertMaterialRealtionService advertMaterialRealtionService;

    @Autowired
    private IpLibraryDAO ipLibraryDAO;

    @Autowired
    private  CatMonitorWarnThreshold catMonitorWarnThreshold;

    @Autowired
    private AdvertOrderDAO advertOrderDAO;

    @Autowired
    private IdWokerService idWokerService;

    @Autowired
    private DeviceApiRocketMqProducer deviceApiRocketMqProducer;

    @Autowired
    private AdvertKeywordCacheService advertKeywordCacheService;

    private final AdvertNewCouponDto emptyAdvertCoupon = new AdvertNewCouponDto();

    private final BeanCopier beanCopier = BeanCopier.create(SpmlogReq.class, ObtainAdvertReqLogExt.class, false);


    /**
     * key:广告ID value:广告券的信息
     */
    private final LoadingCache<Long, AdvertNewCouponDto> ADVERT_COUPON_CACHE = CacheBuilder.newBuilder().initialCapacity(300).
            recordStats().refreshAfterWrite(15, TimeUnit.MINUTES).expireAfterWrite(2, TimeUnit.HOURS).build(new CacheLoader<Long, AdvertNewCouponDto>() {
        @Override
        public AdvertNewCouponDto load(Long advertId) throws Exception {
            return findAdvertCoupon(advertId);
        }

        @Override
        public ListenableFuture<AdvertNewCouponDto> reload(final Long key, AdvertNewCouponDto oldValue) throws Exception {

            ListenableFutureTask<AdvertNewCouponDto> task = ListenableFutureTask.create(new Callable<AdvertNewCouponDto>() {
                public AdvertNewCouponDto call() throws Exception {
                    return load(key);
                }
            });
            executorService.submit(task);
            return task;
        }
    });

    @Override
    @SuppressWarnings("squid:S3776")
    public DubboResult<List<AdvertDirectDto>> getValidAdverts(List<Long> advertIds) {
        CatUtil.log(CatGroupEnum.CAT_102019.getCode());
        List<Long> validAdvertIds = advertMapCacheManager.getValidAdvertIds();
        advertIds.retainAll(validAdvertIds);
        List<AdvertDirectDto> advertDirectDtoList = Lists.newArrayList();
        for (Long advertId : advertIds) {

            AdvertVO advertVO = advertMapCacheManager.getAdvertCache(advertId);
            if (advertVO == null || advertVO.getCouponBase() == null || advertVO.getAdvertPlan() == null){
                continue;
            }

            //只取互动广告
            if (Optional.ofNullable(advertVO.getAdvertPlan().getAdvertType()).orElse(1) != CommonConstant.HD_ADVERT_TYPE) {
                continue;
            }

            AdvertMaterialDto material = getAdvertMaterial(advertId);
            AdvertDirectDto advertDirectDto = new AdvertDirectDto();
            Map<String, String> logExtMap = Maps.newHashMap();
            logExtMap.put(AdvertOrderJsonKeyEnum.KEY_EFFECTIVE_MAIN_TYPE.getCode(), Integer.toString(advertVO.getEffectMainType()));
            advertDirectDto.setLogExtMap(logExtMap);
            advertDirectDto.setAdvertId(advertId);
            advertDirectDto.setBannerImageUrl(material == null ? null : material.getBannerPng());
            advertDirectDto.setAcgId(advertVO.getCouponBase().getAcgId());
            advertDirectDto.setAdvertCouponType(advertVO.getCouponBase().getCouponType());
            advertDirectDto.setMaterialTitle(material == null ? null : material.getCouponName());
            advertDirectDto.setMaterialDes(material == null ? null : material.getDescription());
            advertDirectDto.setMaterialButton(material != null && material.getButtonText() != null ? material.getButtonText() : AdvertCoupon.DEFAULT_BTN_TEXT);
            advertDirectDto.setPromoteURL(advertVO.getCouponBase().getPromoteURL());
            advertDirectDto.setAdvertName(advertVO.getAdvertPlan().getName());
            advertDirectDto.setAgentId(advertVO.getAdvertPlan().getAgentId());
            advertDirectDtoList.add(advertDirectDto);
        }

        return DubboResult.successResult(advertDirectDtoList);
    }

    @SuppressWarnings("squid:S3776")
    @Override
    public DubboResult<List<AdvertDirectDto>> getValidAdverts(DirectObtainAdvertReq directObtainAdvertReq) {
        //老区块直投接口下线，返回结果默认为空列表
        CatUtil.log(CatGroupEnum.CAT_102012.getCode());
        logger.info("directLog filter no advert,directObtainAdvertReq:[{}]", JSON.toJSONString(directObtainAdvertReq));
        return DubboResult.successResult(Lists.newArrayList());
    }

    @Override
    public DubboResult<Boolean> directAdvert(DirectAdvertLogReq req) {
        try {
            CatUtil.log(CatGroupEnum.CAT_102018.getCode());
            DBTimeProfile.enter("DirectAdvertServiceImpl.directAdvert");
            AdvertVO advertVO = advertMapCacheManager.getAdvertCache(req.getAdvertId());
                if(advertVO == null || req.getOrientationId() == null){
                    logger.error("directAdvert error, advertVO is null the req is = [{}]", req);
                    return DubboResult.failResult("广告已不在有效列表中");
                }
                AdvertPlan advertPlan = advertVO.getAdvertPlan();

                AdvertPriceVO advertPriceVO = this.getByOrientationId(req.getOrientationId(),advertVO.getAdvertPlan());;
                if(null == advertPriceVO){
                    return DubboResult.failResult("配置id失效");
            }
            req.setFee(advertPriceVO.getFee());

            //初始化日志信息
            this.initSpmlogReq(advertPlan, advertPriceVO, req);

            //打点点击日志以及发送扣费消息
            try {
                this.clickLog(advertVO, req);
            } catch (TuiaException e) {
                logger.error("直投广告打点日志异常", e);
            }
            //account表中的1和2扣除的都是杭州推啊账户余额，属于杭州主体，只有3扣除的才是霍尔果斯余额
            req.setEffectiveMainType(advertVO.getEffectMainType());
            //打点曝光日志
            this.exposureLog(advertPlan, req);
            //打点发券日志
            try {
                this.sendCouponLog(advertPlan, advertPriceVO, req);
            } catch (TuiaException e) {
                logger.error("直投广告打点发券日志异常",e);
            }
            return DubboResult.successResult(true);

        } finally {
            DBTimeProfile.release();
        }
    }


    @Override
    public Boolean showLog(DirectAdvertLogReq req) {

        //发券后 日志打印 参数验证
        if (null == req.getAdvertId() || null == req.getAppId() || null == req.getConsumerId()) {
            return false;
        }

        //获取广告信息
        AdvertVO advertVO = advertMapCacheManager.getAdvertCache(req.getAdvertId());
        if (null == advertVO || null == advertVO.getAdvertPlan()) {
            return false;
        }

        AdvertPlan advertPlan = advertVO.getAdvertPlan();

        AdvertPriceVO advertPriceVO = this.getByOrientationIdAdVedio(req.getOrientationId(),advertVO.getAdvertPlan());
        if(null == advertPriceVO){
            return false;
        }

        //放入数据
        req.setFee(advertPriceVO.getFee());
        this.initSpmlogReq(advertPlan, advertPriceVO, req);


        //TODO hbase 存储订单
        //2.生成一个全局ID
        AdvertOrderDO advertOrderDO = buildAdvertOrder(advertVO,req);//buildAdvertOrder(advertVO, couponCode, req, advertOrderId, rsp.getMaterialId(), rsp.getPromoteUrl());
        //查询广告订单信息
        if (null == advertOrderDO) {
            return false;
        }
        Long advertOrderId = advertOrderDO.getId();

        OrderJsonVO vo = buildOrderJsonInfo(req);//buildOrderJsonInfo(advertPriceVO,req,rsp,advertPeriod,aFee,times,filterResult,materialTestPlanHelper);

        //原始长度提取出来,进行重新赋值，避免插入订单失败，导致日志丢失
        String orignJson = JSONObject.toJSONString(vo);
        advertOrderDO.setJson(orignJson);

        //插入订单
        int row = 0;
        try {
            DBTimeProfile.enter("showLog.insertOrder");
            row = CatUtils.executeInCatTransaction(() -> advertOrderDAO.insert(advertOrderDO), "finishBizWzj", "insert");
        }catch (Throwable throwable) {
            logger.error("showLog.insert 异常",throwable);
        } finally {
            DBTimeProfile.release();
        }

        advertOrderDO.setJson(orignJson);
        //将请求到的广告订单放入缓存中
        serviceManager.setAdvertOrderDO(req.getConsumerId(), req.getOrderId(), advertOrderDO);

        //TODO （发券日志）
        try {
            this.sendCouponLogAdVedio(advertPlan, advertPriceVO, req);
        } catch (TuiaException e) {
            logger.error("直投广告打点发券日志异常",e);
        }
        //TODO （曝光日志）
        //发送曝光统计服务消息
        advertRealDataService.incrExposureAdvert(advertPlan.getAgentId(), advertPlan.getAccountId(), req.getAdvertId(), advertPlan.getAdvertPlanId(), req.getEffectiveMainType());
        req.setType(SpmType.SPM_LOG_EXPOSURE);
        StatExposureJsonLog.log(req);
        return true;
    }

    private OrderJsonVO buildOrderJsonInfo(DirectAdvertLogReq reqLogExt) {
        Map<String, String> extMap = Optional.ofNullable(reqLogExt.getLogExtMap()).orElse(new HashMap<>());

        OrderJsonVO vo = new OrderJsonVO();
        vo.setPid(reqLogExt.getOrientationId());
        vo.setAid(reqLogExt.getAppId());
        vo.setCt(ChargeTypeEnum.TYPE_CPC.getCode());
        //TODO cityId
//        vo.setCi(reqLogExt.getCityId());
        //TODO
//        vo.setDeli(PackagePlanConstants.DELIVERY_TYPE_DIRECT);
        vo.setDevi(reqLogExt.getDeviceId());
        vo.setFe(reqLogExt.getFee());
        vo.setPkt(PackageTypeEnum.INTERACTIVE_TYPE.getCode());
        vo.setAst(PackagePlanConstants.DIRECT_PAGE_ACTIVITY_TYPE);
        //TODO
//        vo.setMl(reqLogExt.getModel());
        //TODO
//        vo.setPs(reqLogExt.getPriceSection());
        vo.setUa(reqLogExt.getUa());
        vo.setUat(reqLogExt.getUserAgent());

        //全链路日志需要打印字段，给到各个链路
        vo.setLgEp(reqLogExt.getLogExtExpMap());

        // logExtMap 拓展。从活动传参过来，写到订单里，全链路日志打印
        vo.setGm(extMap.get(AdvertReqLogExtKeyConstant.GAME_TAG));
        vo.setBn(extMap.get(AdvertReqLogExtKeyConstant.BRAND_NAME));
        vo.setDsm(extMap.get(AdvertReqLogExtKeyConstant.DSM));
        vo.setDsm2(extMap.get(AdvertReqLogExtKeyConstant.DSM2));
        vo.setDcm(extMap.get(AdvertReqLogExtKeyConstant.DCM));
        vo.setDpm(extMap.get(AdvertReqLogExtKeyConstant.DPM));
        vo.setDtPage(extMap.get(AdvertReqLogExtKeyConstant.DIRECTPAGE));
        vo.setSaw(extMap.get(AdvertReqLogExtKeyConstant.SUB_ACTIVITY_WAY));
        vo.setAp(extMap.get(AdvertReqLogExtKeyConstant.ACTIVITY_PAGE));
        vo.setIdeId(extMap.get(AdvertReqLogExtKeyConstant.IDEAL_ID));
        vo.setPte(extMap.get(AdvertReqLogExtKeyConstant.PRICE_TYPE));
        vo.setPp(extMap.get(AdvertReqLogExtKeyConstant.PAR_PRICE));
        vo.setBt(extMap.get(AdvertReqLogExtKeyConstant.BILL_TYPE));
        vo.setFt(extMap.get(AdvertReqLogExtKeyConstant.FEE_TYPE));
        vo.setArd(extMap.get(AdvertReqLogExtKeyConstant.ADX_RID));
        vo.setPt(extMap.get(AdvertReqLogExtKeyConstant.PUT_TYPE));
        vo.setIt(extMap.get(AdvertReqLogExtKeyConstant.IS_TEST_ACTIVITY_TYPE));
        vo.setPli(extMap.get(AdvertReqLogExtKeyConstant.PLAN_ID));
        vo.setNtwn(extMap.get(AdvertReqLogExtKeyConstant.CONNECTION_TYPE));
        vo.setIcg(extMap.get(AdvertReqLogExtKeyConstant.IS_COMPARE_GROUP));
        vo.setRsd(extMap.get(AdvertReqLogExtKeyConstant.RESOURCE_ID));
        vo.setApl(extMap.get(AdvertReqLogExtKeyConstant.ADX_PRICE_LEVEL));
        vo.setSat(extMap.get(AdvertReqLogExtKeyConstant.SHORT_ACTIVITY_ID));
        vo.setLvl(extMap.get(AdvertReqLogExtKeyConstant.LEVEL));
        vo.setStgy(extMap.get(AdvertReqLogExtKeyConstant.STRATEGY));
        // 设备信息
        vo.setIme(extMap.get(AdvertReqLogExtKeyConstant.IMEI));
        vo.setIme5(extMap.get(AdvertReqLogExtKeyConstant.IMEI_MD5));
        vo.setIdfa(extMap.get(AdvertReqLogExtKeyConstant.IDFA));
        vo.setIdfa5(extMap.get(AdvertReqLogExtKeyConstant.IDFA_MD5));
        // 活动素材id
        vo.setSckId(extMap.get(AdvertReqLogExtKeyConstant.SCK_ID));
        // 分流标识
        vo.setSft(extMap.get(AdvertReqLogExtKeyConstant.SCK_FORM_TYPE));
        // 虚拟广告位模拟发券标识
        vo.setImoa(extMap.get(AdvertReqLogExtKeyConstant.IMITATE_REQ));
        // 资源位
        vo.setSop(extMap.get(AdvertReqLogExtKeyConstant.SOURCE_PAGE));
        // 媒体测试打标字段
        vo.setPgt(extMap.get(AdvertReqLogExtKeyConstant.PANGE_TEST));
        vo.setBtg(extMap.get(AdvertReqLogExtKeyConstant.BELONG_TO_GROUP));

        //20191231新增
        vo.setAlgV(extMap.get(AdvertReqLogExtKeyConstant.ALGO_VERSION));
        vo.setAlgTp(extMap.get(AdvertReqLogExtKeyConstant.ALGO_TEST_PLANID));
        vo.setSeI(extMap.get(AdvertReqLogExtKeyConstant.SEQ_INDEX));

        return vo;
    }


    private AdvertOrderDO buildAdvertOrder(AdvertVO advertVO,DirectAdvertLogReq req) {
        AdvertOrderDO advertOrderDO = new AdvertOrderDO();
        AdvertPlan advertPlan = advertVO.getAdvertPlan();
        CouponBase couponBase = advertVO.getCouponBase();
        //构建广告优惠券的信息
        advertOrderDO.setAdvertId(advertPlan.getId());
//        Integer codeType = couponBase.getCouponType().intValue() == 0 ? AdvertDO.GENERAL_PREFERENCE_CODE : couponBase.getCouponType();
//        advertOrderDO.setCouponCode(couponCode.getCode());
//        advertOrderDO.setCouponPasswd(couponCode.getPasswd());
        advertOrderDO.setCouponType(AdvertDO.PROMOTION_WEB_SITE);
//        advertOrderDO.setOverDue(new DateTime(couponCode.getOverDue()).toString("yyyy-MM-dd"));

        //构建广告基本信息
        advertOrderDO.setId(idWokerService.getNextID());
        advertOrderDO.setAppId(req.getAppId());
        advertOrderDO.setConsumerId(req.getConsumerId());
        advertOrderDO.setDuibaOrderId(req.getOrderId());
        advertOrderDO.setDuibaActivityId(req.getActivityId());
        advertOrderDO.setUa(req.getUa());
        advertOrderDO.setSlotId(req.getSlotId());
        advertOrderDO.setMaterialId(req.getMaterialId());
        //把落地页url放到订单里，给日志需要的时候查询订单即可
        advertOrderDO.setPromoteUrl(advertVO.getCouponBase().getPromoteURL());
        advertOrderDO.setGmtCreate(new Date());
        advertOrderDO.setGmtModified(new Date());

        return advertOrderDO;
    }

    /**
     * 打印点击日志-激励视屏直投广告
     *
     * @param req
     */
    @Override
    public Boolean clickLog(DirectAdvertLogReq req) {
//        CatUtil.log("directClickCount");
        DBTimeProfile.enter("DirectAdvertServiceImpl.clickLog");
        try {
            AdvertVO advertVO = advertMapCacheManager.getAdvertCache(req.getAdvertId());
            if(advertVO == null || req.getOrientationId() == null){
                logger.error("directAdvert error, advertVO is null the req is = [{}]", req);
                return false;
            }
            AdvertPlan advertPlan = advertVO.getAdvertPlan();

            AdvertPriceVO advertPriceVO = this.getByOrientationIdAdVedio(req.getOrientationId(),advertVO.getAdvertPlan());
            if(null == advertPriceVO){
                return false;
            }
            req.setFee(advertPriceVO.getFee());


            //查询广告订单信息
            AdvertOrderDO advertOrderDO = null;
            try {
                advertOrderDO = serviceManager.getAdvertOrderDO(req.getConsumerId(), req.getOrderId(), null);
            } catch (TuiaException e) {
                logger.error("serviceManager.getAdvertOrderDO error",e);
            }
            if (null == advertOrderDO) {
                return false;
            }
            OrderJsonVO vo = JSON.parseObject(advertOrderDO.getJson(), OrderJsonVO.class);
            //将设备id存入 hbase 此处@zhangmeng
            saveDeviceToHbase(req, advertVO, vo);


            this.initSpmlogReq(advertPlan, advertPriceVO, req);

            //打点点击日志以及发送扣费消息
            try {
                this.clickLog(advertVO, req);
            } catch (TuiaException e) {
                logger.error("激励视屏调用直投广告打印日志异常", e);
            }
        } finally {
            DBTimeProfile.release();
        }
        return true;
    }

    /**
     * 将设备id 存入到hbase
     * @param req
     * @param advertVO
     * @param vo
     */
    private void saveDeviceToHbase(SpmlogReq req, AdvertVO advertVO, OrderJsonVO vo) {

        String imeMd5 = vo.getIme5();
        String idfMd5 = vo.getIdfa5();
        //发送消息给活动存入hbase
        if (org.apache.commons.lang3.StringUtils.isNotBlank(imeMd5) || org.apache.commons.lang3.StringUtils.isNotBlank(idfMd5)) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("deviceId", org.apache.commons.lang3.StringUtils.isNotBlank(imeMd5)? imeMd5:idfMd5);
            jsonObject.put("accountId", advertVO.getAdvertPlan().getAccountId());
            jsonObject.put("orderId", req.getActivityOrderId());
            try {
                deviceApiRocketMqProducer.sendMsg(jsonObject.toJSONString(), null);
            } catch (Exception e) {
                logger.info("spmLogReqCommit exception.", e);
            }
        }
    }

    @EventListener(cn.com.duiba.boot.event.MainContextRefreshedEvent.class)
    public void init() throws Exception {

        List<Long> validAdvertIds = advertMapCacheManager.getValidAdvertIds();
        for (Long advertId : validAdvertIds) {
            ADVERT_COUPON_CACHE.put(advertId, this.findAdvertCoupon(advertId));
        }
    }
    /**
     * 初始化日志信息
     *
     * @param advertPlan
     * @param advertPriceVO
     * @param req
     */
    private void initSpmlogReq(AdvertPlan advertPlan, AdvertPriceVO advertPriceVO, DirectAdvertLogReq req) {

        if("unknown".equals(req.getUa())){
            req.setUa("unknow");
        }

        req.setFee(advertPriceVO.getFee());
        req.setOrientationId(advertPriceVO.getAdvertOrientationPackageId());
        req.setChargeType(ChargeTypeEnum.getByCode(advertPriceVO.getChargeType()).getDesc());
        if (req.getLogExtMap() == null) {
            req.setLogExtMap(Maps.newConcurrentMap());
        }

        //设置折扣率
        double discountrate = advertMapCacheManager.getAdvertBidRate(req.getAdvertId(),advertPriceVO.getChargeType());
        req.setDiscountRate(discountrate);

        Map<String, String> map = req.getLogExtMap();
        //直投类型
        map.put(AdvertOrderJsonKeyEnum.KEY_PRIVILEGE.getCode(), String.valueOf(false));
        map.put(AdvertOrderJsonKeyEnum.KEY_ACCOUNT_ID.getCode(), String.valueOf(advertPlan.getAccountId()));
        map.put(AdvertOrderJsonKeyEnum.KEY_AGENT_ID.getCode(), String.valueOf(advertPlan.getAgentId()));
        map.put(AdvertOrderJsonKeyEnum.KEY_PACKAGE_TYPE.getCode(),String.valueOf(advertPriceVO.getPackageType()));
        map.put(AdvertOrderJsonKeyEnum.KEY_ACTIVITY_TYPE.getCode(),PackagePlanConstants.DIRECT_PAGE_ACTIVITY_TYPE);
        map.put(AdvertOrderJsonKeyEnum.BAICHUAN_GAME_TAG_TYPE.getCode(), CommonServiceImpl.BAICHUAN_GAME_TAG);
        map.put(AdvertReqLogExtKeyConstant.MAIN_TYPE, String.valueOf(AdvertReqLogExtKeyConstant.INTERACT));
    }

    /**
     * 打点曝光日志
     *
     * @param advertPlan
     * @param req
     */
    private void exposureLog(AdvertPlan advertPlan, DirectAdvertLogReq req) {

        //发送曝光统计服务消息
        advertRealDataService.incrExposureAdvert(advertPlan.getAgentId(), advertPlan.getAccountId(), req.getAdvertId(), advertPlan.getAdvertPlanId(), req.getEffectiveMainType());

        req.setType(SpmType.SPM_LOG_EXPOSURE);
        StatExposureJsonLog.log(req);
    }

    /**
     * 打点点击日志以及发送扣费消息
     *
     * @param advertVO
     * @param req
     * @throws TuiaException
     */
    private void clickLog(AdvertVO advertVO, DirectAdvertLogReq req) throws TuiaException {
        AdvertPlan advertPlan = advertVO.getAdvertPlan();

        String date = new DateTime().toString("yyyy-MM-dd");
        boolean isClickVaild = serviceManager.checkClickVaild(req.getAppId(), req.getAdvertId(), req.getConsumerId(), date);
        if (isClickVaild){
            try{
                //帐号余额判断
                if (!commonService.isEnoughBudget(advertVO, req.getFee())) {
                    return;
                }
                req.setEffectiveMainType(advertVO.getEffectMainType());
                // 给扣费服务发计费消息
                req.setType(SpmType.SPM_LOG_CHARGE);
                AsynReq asynReq = new AsynReq();
                asynReq.setReqType(AsynReqType.CONSUMER_DIRECT);
                asynReq.setAdvertId(advertPlan.getId());
                asynReq.setAppId(req.getAppId());
                //asynReq.setAdvertOrderId(advertOrderDO.getId());
                asynReq.setReqTime(date);
                asynReq.setFee(req.getFee());
                asynReq.setAdvertPackageId(req.getOrientationId());
                asynReq.setCurrentMainStatus(advertVO.getCurrentMainStatus());
                directPracFeeRocketMqProducer.sendMsg(req, asynReq);
            }catch(Exception e){
                logger.error("direct valid",e);
            }
        }
        req.setEffectiveMainType(advertVO.getEffectMainType());
        //记录点击次数
        advertRealDataService.incrClickAdvert(advertPlan.getAgentId(), advertPlan.getAccountId(), advertPlan.getId(),advertPlan.getAdvertPlanId(), req.getEffectiveMainType(), null);

        req.setType(SpmType.SPM_LOG_CLICK);

        StatClickJsonLog.log(req);
    }

    private void sendCouponLogAdVedio(AdvertPlan advertPlan, AdvertPriceVO advertPriceVO, DirectAdvertLogReq req) throws TuiaException {

        AdvQueryParam advQueryParam = commonService.ipGeoAnalysis(req.getIp());
        String cityId = advQueryParam.getRegionId();

        ObtainAdvertReqLogExt reqLogExt = new ObtainAdvertReqLogExt();
        beanCopier.copy(req, reqLogExt, null);
        reqLogExt.setCityId(cityId);
        reqLogExt.setPageId(req.getPageId());
        reqLogExt.setMediaId(req.getMediaId());
        reqLogExt.setPositionId(req.getPositionId());
        reqLogExt.setDiscountRate(req.getDiscountRate());
        reqLogExt.setaFee(advertPriceVO.getFee());
        reqLogExt.setType(SpmType.SPM_LOG_LAUNCH);
        reqLogExt.setHour(StringTool.getStringHourBy(req.getTimestamp()));
        PhoneInfo phoneInfo = commonService.getPhoneInfo(reqLogExt.getUa(), reqLogExt.getUserAgent());
        reqLogExt.setModel(phoneInfo.getPhoneModel());
        if (null == reqLogExt.getLogExtMap()) {
            reqLogExt.setLogExtMap(Maps.newHashMap());
        }
        Optional.ofNullable(phoneInfo.getPhoneBrand()).ifPresent(value->reqLogExt.getLogExtMap().put(AdvertReqLogExtKeyConstant.PHONE_BRAND, value));
        Optional.ofNullable(phoneInfo.getBrandName()).ifPresent(value->reqLogExt.getLogExtMap().put(AdvertReqLogExtKeyConstant.BRAND_NAME, value));
        Optional.ofNullable(phoneInfo.getPhoneModelNum()).ifPresent(value->reqLogExt.getLogExtMap().put(AdvertReqLogExtKeyConstant.PHONE_MODEL_NUM, value));

        reqLogExt.getLogExtMap().put(AdvertOrderJsonKeyEnum.KEY_TYPE.getCode(), String.valueOf(FilterResultTypes.DIRECT_ADVERT_TYPE));
        reqLogExt.getLogExtMap().put(AdvertReqLogExtKeyConstant.MAIN_TYPE, String.valueOf(AdvertReqLogExtKeyConstant.INTERACT));
        reqLogExt.setPriceSection(phoneInfo.getPriceLevel());

        //添加发券次数统计
        advertRealDataService.incrLaunchAdvert(advertPlan.getAgentId(), advertPlan.getAccountId(), advertPlan.getId(), advertPlan.getAdvertPlanId(),req.getEffectiveMainType(), null, req.getAppId(), 0);

        StatLaunchJsonLog.log(reqLogExt);

    }


    private void sendCouponLog(AdvertPlan advertPlan, AdvertPriceVO advertPriceVO, DirectAdvertLogReq req) throws TuiaException {

        AdvQueryParam advQueryParam = commonService.ipGeoAnalysis(req.getIp());
        String cityId = advQueryParam.getRegionId();

        ObtainAdvertReqLogExt reqLogExt = new ObtainAdvertReqLogExt();
        beanCopier.copy(req, reqLogExt, null);
        reqLogExt.setCityId(cityId);
        reqLogExt.setPageId(req.getPageId());
        reqLogExt.setMediaId(req.getMediaId());
        reqLogExt.setPositionId(req.getPositionId());
        reqLogExt.setDiscountRate(req.getDiscountRate());
        reqLogExt.setaFee(advertPriceVO.getFee());
        reqLogExt.setType(SpmType.SPM_LOG_LAUNCH);
        reqLogExt.setHour(StringTool.getStringHourBy(req.getTimestamp()));
        PhoneInfo phoneInfo = commonService.getPhoneInfo(reqLogExt.getUa(), reqLogExt.getUserAgent());
        reqLogExt.setModel(phoneInfo.getPhoneModel());
        if (null == reqLogExt.getLogExtMap()) {
            reqLogExt.setLogExtMap(Maps.newHashMap());
        }
        reqLogExt.getLogExtMap().put(AdvertReqLogExtKeyConstant.PHONE_BRAND, phoneInfo.getPhoneBrand());
        reqLogExt.getLogExtMap().put(AdvertReqLogExtKeyConstant.BRAND_NAME, phoneInfo.getBrandName());
        reqLogExt.getLogExtMap().put(AdvertReqLogExtKeyConstant.PHONE_MODEL_NUM, phoneInfo.getPhoneModelNum());
        reqLogExt.getLogExtMap().put(AdvertOrderJsonKeyEnum.KEY_TYPE.getCode(), String.valueOf(FilterResultTypes.DIRECT_ADVERT_TYPE));
        reqLogExt.getLogExtMap().put(AdvertReqLogExtKeyConstant.MAIN_TYPE, String.valueOf(AdvertReqLogExtKeyConstant.INTERACT));
        reqLogExt.setPriceSection(phoneInfo.getPriceLevel());

        //添加发券次数统计
        advertRealDataService.incrLaunchAdvert(advertPlan.getAgentId(), advertPlan.getAccountId(), advertPlan.getId(), advertPlan.getAdvertPlanId(),req.getEffectiveMainType(), null, req.getAppId(), 0);

        StatLaunchJsonLog.log(reqLogExt);

    }

    private AdvertPriceVO getByOrientationIdAdVedio(Long orientationId,AdvertPlan advertPlan){

        AdvertOrientationPackageDO packageDO = advertOrientationService.getOrientation(advertPlan.getId(),orientationId);

        if(null == packageDO || null == packageDO.getId()){
            return null;
        }

        if(packageDO.getIsDefault() == CommonConstant.YES){
            packageDO.setId(AdvertConstants.DEFAULT_ORIENTATION_ID);
        }

        //如果包中设置了活动类型，则直投只取直投页活动
        Set<String> activityType = StringTool.getStringSetByStr(packageDO.getActivityType());
        if (CollectionUtils.isNotEmpty(activityType) && !activityType.contains(PackagePlanConstants.PACKAGE_PLAN_DEFAULT_TYPE)
                && !activityType.contains(PackagePlanConstants.VEDIO_AD_ACTIVITY_TYPE)) {
            return null;
        }
        //如果是CPA的配置则不点击
        if(packageDO.getChargeType().equals(ChargeTypeEnum.TYPE_CPA.getCode())){
            return null;
        }
        AdvertPriceVO advertPriceVO = new AdvertPriceVO(packageDO.getAdvertId(), packageDO.getId(), packageDO.getFee(),
                ChargeTypeEnum.TYPE_CPC.getCode(), packageDO.getPackageType());
        advertPriceVO.setActivityType(activityType);
        return advertPriceVO;
    }

    private AdvertPriceVO getByOrientationId(Long orientationId,AdvertPlan advertPlan){

        AdvertOrientationPackageDO packageDO = advertOrientationService.getOrientation(advertPlan.getId(),orientationId);

        if(null == packageDO || null == packageDO.getId()){
            return null;
        }

        if(packageDO.getIsDefault() == CommonConstant.YES){
            packageDO.setId(AdvertConstants.DEFAULT_ORIENTATION_ID);
        }

        //如果包中设置了活动类型，则直投只取直投页活动
        Set<String> activityType = StringTool.getStringSetByStr(packageDO.getActivityType());
        if (CollectionUtils.isNotEmpty(activityType) && !activityType.contains(PackagePlanConstants.PACKAGE_PLAN_DEFAULT_TYPE)
                && !activityType.contains(PackagePlanConstants.DIRECT_PAGE_ACTIVITY_TYPE)) {
           return null;
        }
        //如果是CPA的配置则不点击
        if(packageDO.getChargeType().equals(ChargeTypeEnum.TYPE_CPA.getCode())){
            return null;
        }
        AdvertPriceVO advertPriceVO = new AdvertPriceVO(packageDO.getAdvertId(), packageDO.getId(), packageDO.getFee(),
                ChargeTypeEnum.TYPE_CPC.getCode(), packageDO.getPackageType());
        advertPriceVO.setActivityType(activityType);
        return advertPriceVO;
    }

    /**
     * 获取缓存里的广告券信息
     *
     * @param advertId
     * @return
     */
    public AdvertNewCouponDto getAdvertCoupon(Long advertId) {

        try {
            AdvertNewCouponDto advertDirectDto = ADVERT_COUPON_CACHE.get(advertId);
            return advertDirectDto;
        } catch (ExecutionException e) {
            logger.error(e.getMessage(),e);
        }

        return emptyAdvertCoupon;
    }


    public AdvertMaterialDto getAdvertMaterial(Long advertId) {
        try{
            List<AdvertMaterialDto> materialList = advertMaterialRecommendService.getMaterialListByAdvertId(advertId);
            List<Long> materialIds = Lists.newArrayList();
            Map<Long,AdvertMaterialDto> materialMap = Maps.newHashMap();
            for(int i = 0 ; i < materialList.size(); i++){
                AdvertMaterialDto dto = materialList.get(i);
                String imgUrl = dto.getBannerPng();
                if(StringUtils.isBlank(imgUrl)){
                    continue;
                }

                materialIds.add(dto.getId());
                materialMap.put(dto.getId(), dto);
            }
            if(!materialIds.isEmpty()){
                Long id = Collections.max(materialIds);
                AdvertMaterialDto material = materialMap.get(id);
                return material;
            }

        }catch(Exception e){
            logger.error("getAdvertMaterial error",e);
        }
        return null;
    }

    /**
     * 构建素材标题
     * @param advertMaterialDto
     * @param directObtainAdvertReq
     * @return
     */
    private String buildMaterialTitle(AdvertMaterialDto advertMaterialDto,DirectObtainAdvertReq directObtainAdvertReq){

        if(StringUtils.isBlank(advertMaterialDto.getProductName()) || advertMaterialDto.getProductNameTag() == null){
            return advertMaterialDto.getCouponName();
        }

        AdvertMaterialVO advertMaterialVO = new AdvertMaterialVO();
        advertMaterialVO.setProductNameTag(advertMaterialDto.getProductNameTag());
        advertMaterialVO.setProductName(advertMaterialDto.getProductName());
        advertMaterialVO.setCouponName(advertMaterialDto.getCouponName());

        NetworkTypeEnum networkTypeEnum = this.getNetworkType(directObtainAdvertReq);

        Long ipLong = IpLibraryDO.convertIpLong(directObtainAdvertReq.getIp());
        IpLibraryDO ipLibraryDO=ipLibraryDAO.findByIpLong(ipLong);
        String provinceName = ipLibraryDO==null?null:ipLibraryDO.getProvince();
        String city = ipLibraryDO==null?null:ipLibraryDO.getCity();
        String operatorsName = ipLibraryDO==null?null:ipLibraryDO.getIsp();
        Integer operatorsIndex = OperatorsEnum.getByName(operatorsName).getCode();

        return advertMaterialRealtionService.getMaterialTitle(advertMaterialVO,provinceName,
                networkTypeEnum == null ? null : networkTypeEnum.getIndex(),operatorsIndex,directObtainAdvertReq.getUa(), city);
    }

    /**
     * 获取网络类型
     * @param directObtainAdvertReq
     * @return
     */
    private NetworkTypeEnum getNetworkType(DirectObtainAdvertReq directObtainAdvertReq){

        String connectionType = "";
        if (directObtainAdvertReq.getLogExtMap() != null && directObtainAdvertReq.getLogExtMap().containsKey("connection_type")) {//优先使用活动传递的网络类型
            connectionType = directObtainAdvertReq.getLogExtMap().get("connection_type");
        }

        NetworkTypeEnum networkTypeEnum = NetworkTypeEnum.getByName(connectionType);
        if(networkTypeEnum == null){
            return null;
        }

        switch (networkTypeEnum){
            case ETHERNET:networkTypeEnum = NetworkTypeEnum.WIFI;break;
            case CELLULAR:networkTypeEnum = NetworkTypeEnum.G3;break;
            default:break;
        }

        return networkTypeEnum;
    }


    /**
     * 获取单个广告券信息
     *
     * @param advertId
     * @return
     */
    private AdvertNewCouponDto findAdvertCoupon(Long advertId) {


        AdvertVO advertVO = advertMapCacheManager.getAdvertCache(advertId);
        if (advertVO == null)
            return emptyAdvertCoupon;
        CouponBase couponBase = advertVO.getCouponBase();
        if (couponBase == null)
            return emptyAdvertCoupon;

        AdvertNewCouponDto advertNewCouponDto = serviceManager.getAdvertCouponBackFromCache(advertId);

        if (advertNewCouponDto == null) {
            return emptyAdvertCoupon;
        }
        return advertNewCouponDto;
    }
}
