package cn.com.duiba.tuia.filter.service;

import java.util.List;
import java.util.Map;

import cn.com.duiba.tuia.domain.model.AdvOrientationItem;
import cn.com.duiba.tuia.domain.vo.AdvertFilterVO;
import cn.com.tuia.advert.model.DirectObtainAdvertReq;

/**
 * @author: <a href="http://www.panaihua.com">panaihua</a>
 * @date: 2017年08月22日 11:15
 * @descript: 直投广告过滤逻辑
 * @version: 1.0
 */
public interface DirectAdvertFilterService {

    /**
     * 直投广告过滤
     * @param directObtainAdvertReq
     * @return
     */
    List<AdvOrientationItem> filter(DirectObtainAdvertReq directObtainAdvertReq) throws Exception;
    
    /**
     * 根据可投配置包获取可投广告列表
     * getValidAdvertPrice. <br/>
     * @author zp
     * @param validAdvertIds
     * @param paramsAdvertIds
     * @return
     * @since JDK 1.6
     */
    Map<Long, AdvertFilterVO> getValidAdvertPrice(List<AdvOrientationItem> validAdvertIds,List<Long> paramsAdvertIds);
}
