package cn.com.duiba.tuia.filter.service;

import cn.com.duiba.bigdata.dmp.service.api.remoteservice.dto.DeviceTagDto;
import cn.com.duiba.nezha.engine.api.dto.ConsumerDto;
import cn.com.duiba.tuia.domain.model.FilterResult;
import cn.com.tuia.advert.model.ObtainAdvertReq;

import java.util.List;
import java.util.Map;

/**
 * @author: <a href="http://www.panaihua.com">panaihua</a>
 * @date: 2018年03月02日 11:33
 * @descript: 广告感兴趣标签过滤
 * @version: 1.0
 */
public interface InterestAdvertTagFilter {

    /**
     * 
     * getUserCrowdInterest:(社会属性人群兴趣点). <br/>
     *
     * @author chencheng
     * @param isLog 是否打印日志
     * @param consumerId
     * @return
     * @since JDK 1.8
     */
    List<String> getUserCrowdInterest(String deviceId, ConsumerDto consumerDto, FilterResult filterResult, ObtainAdvertReq req, DeviceTagDto deviceTagDto, Map<String,String> newUserDmpTagsMap);


    /**
     * 获取第3方dmp人群包
     * @param req
     * @return
     */
    Map<String, String> getThirdPartDmpTag(ObtainAdvertReq req);
}
