package cn.com.duiba.tuia.filter.service.impl;

import cn.com.duiba.tuia.bo.AdvertBannedTagBo;
import cn.com.duiba.tuia.cache.*;
import cn.com.duiba.tuia.constants.AdvertSystemConfigureConstants;
import cn.com.duiba.tuia.constants.ErrorCode;
import cn.com.duiba.tuia.constants.PackagePlanConstants;
import cn.com.duiba.tuia.constants.TrusteeshipConstants;
import cn.com.duiba.tuia.domain.dataobject.*;
import cn.com.duiba.tuia.domain.flow.MediaList;
import cn.com.duiba.tuia.domain.flow.SlotChooseAdverttVO;
import cn.com.duiba.tuia.domain.model.*;
import cn.com.duiba.tuia.domain.vo.AdvertFilterVO;
import cn.com.duiba.tuia.domain.vo.AdvertOrientationPackageVO;
import cn.com.duiba.tuia.domain.vo.AdvertPriceVO;
import cn.com.duiba.tuia.domain.vo.AdvertVO;
import cn.com.tuia.advert.enums.AdvertFilterTypeEnum;
import cn.com.duiba.tuia.enums.PlatformTypeEnum;
import cn.com.tuia.advert.enums.ResourceTagsTypeEnum;
import cn.com.duiba.tuia.exception.TuiaException;
import cn.com.duiba.tuia.filter.AdvertFilterParamVO;
import cn.com.duiba.tuia.filter.service.AdvertFilterService;
import cn.com.duiba.tuia.service.*;
import cn.com.duiba.tuia.strategy.StrategyBeans;
import cn.com.duiba.tuia.tool.StringTool;
import cn.com.duiba.tuia.utils.CollectionUtil;
import cn.com.tuia.advert.constants.CommonConstant;
import cn.com.tuia.advert.constants.SystemConfigKeyConstant;
import cn.com.tuia.advert.enums.ActivityTypeEnum;
import cn.com.tuia.advert.enums.AdvertOrderJsonKeyEnum;
import cn.com.tuia.advert.enums.AppFlowPlatform;
import cn.com.tuia.advert.enums.ChargeTypeEnum;
import cn.com.tuia.advert.model.ObtainAdvertReq;
import cn.com.tuia.advert.model.ObtainAdvertRsp;
import cn.hutool.core.collection.ConcurrentHashSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @author: <a href="http://www.panaihua.com">panaihua</a>
 * @date: 2017年06月01日 14:18
 * @descript:
 * @version: 1.0
 */
@Service("advertPrivilegeFilterService")
public class AdvertPrivilegeFilterServiceImpl implements AdvertFilterService {

    private Logger logger = LoggerFactory.getLogger(AdvertPrivilegeFilterServiceImpl.class);

    @Resource
    private AdvertMapCacheManager advertMapCacheManager;

    @Resource
    private ServiceManager serviceManager;

    @Autowired
    private ResourceTagsService resourceTagsService;

    @Resource
    private AdvertOrientationService advertOrientationService;

    @Autowired
    private AdvertBannedTagBo advertBannedTagBo;

    @Autowired
    private AdvertMaterialRecommendService advertMaterialRecommendService;
    
    @Autowired
    private MediaCacheService mediaCacheService;

    @Autowired
    private AdvertQueryService advertQueryService;

    @Autowired
    private AdvertPkgCacheService advertPkgCacheService;

    @Autowired
    private IQiyiService iQiyiService;

    @Resource
    private MakeTagCacheService makeTagCacheService;

    @Override
    public List<AdvertFilterVO> foreachAdvertCheck(Set<Long> advertIds, AdvertFilterParamVO advertFilterDo, FilterResult filterResult, AdvQueryParam advQueryParam) throws TuiaException {

        ShieldStrategyVO shieldStrategyVO = advertFilterDo.getShieldStrategyVO();
        ObtainAdvertReq req = advertFilterDo.getReq();
        String cityId = advertFilterDo.getCityId();
        AppDetail appDetail = advertFilterDo.getAppDetail();
        ObtainAdvertRsp rsp = advertFilterDo.getRsp();
        AdvertFilter advertFilter = advertFilterDo.getAdvertFilter();
        Set<AdvertFilterType> resultSets = advertFilter.getReason() == null ? new HashSet<>() : advertFilter.getReason();
        List<AdvertFilterVO> fundableList = Lists.newArrayListWithCapacity(advertIds.size());
        for (Long advertId : advertIds) {

            AdvertVO advertVO = advertMapCacheManager.getAdvertCache(advertId);
            //可投素材
            Set<Long> materialsCache = advertMaterialRecommendService.getMaterialSetByAdvertId(advertId);
            Set<Long> advertMaterials = CollectionUtils.isEmpty(materialsCache) ? Sets.newHashSet() : Sets.newHashSet(materialsCache);

            //激励视频广告过滤
            advertMaterials = advertMaterialRecommendService.filterByMaterialType(advertMaterials,advertId,advQueryParam,req);

            boolean isCheck = this.check(advertVO, shieldStrategyVO, req, rsp, appDetail, advertId, advQueryParam,advertMaterials);
            if (!isCheck){
                continue;
            }

            SortedSet<AdvertPriceVO> priceVOSortedSet = this.filterPackages(req, advertId,
                    cityId, shieldStrategyVO.getAppBannedTags(), filterResult, resultSets, advertMaterials);
            if (priceVOSortedSet.size() == 0)
                continue;

            AdvertFilterVO advertFilterVO = new AdvertFilterVO();
            advertFilterVO.setAdvertPriceVOSortedSet(priceVOSortedSet);
            advertFilterVO.setManualAdvertSet(priceVOSortedSet);
            //非算法投放的情况下，取不到CPC最大值，则表示无CPC配置，则该广告不可投放
            if (advertFilterVO.getManualMaxFeeAdvert() == null)
                continue;

            fundableList.add(advertFilterVO);
        }
        advertFilter.setReason(resultSets);
        if(fundableList.size() > 0){
            return getResultAdvert(fundableList,advertFilterDo);
        }
        return null;
    }
    
    private List<AdvertFilterVO> getResultAdvert(List<AdvertFilterVO> advertFilterVOS,AdvertFilterParamVO advertFilterDo) {
        List<AdvertFilterVO> resultList = Lists.newArrayList();
        if (advertFilterDo.getFilterResult().getType() == FilterResultTypes.RISK_SLOT_DIRCTION_TYPE) {

            //获取特权库广告
            Map<Long, AdvertFilterVO> advertMap = advertFilterVOS.stream()
                    .filter(advert -> advert != null && CollectionUtils.isNotEmpty(advert.getAdvertPriceVOSortedSet()))
                    .collect(Collectors.toMap(dto -> dto.getAdvertPriceVOSortedSet().first().getAdvertId(), Function.identity(), (p, q) -> p));
            // 风控广告位定向导量出券
            List<Long> slotDirectionAdvertIds = getSlotDirectionAdvertId();
            if (CollectionUtils.isEmpty(slotDirectionAdvertIds)) {
                return null;
            }
            resultList = slotDirectionAdvertIds.stream().filter(advertId -> advertMap.get(advertId) != null)
                    .map(advertId -> advertMap.get(advertId)).collect(Collectors.toList());
        } else if (advertFilterDo.getFilterResult().getType() == FilterResultTypes.RISK_PRIVILIGE_TYPE) {
            //获取特权库广告
            Map<Long, AdvertFilterVO> advertMap = advertFilterVOS.stream()
                    .filter(advert -> advert != null && CollectionUtils.isNotEmpty(advert.getAdvertPriceVOSortedSet()))
                    .collect(Collectors.toMap(dto -> dto.getAdvertPriceVOSortedSet().first().getAdvertId(), Function.identity(), (p, q) -> p));
            //获取风控作弊流量出券
            String[] advertIds = AdvertSystemConfigureConstants.riskAdvertId.split(",");
            for (String advertIdStr : advertIds) {
                Long advertId = Long.valueOf(advertIdStr);
                AdvertFilterVO advertFilterVO = advertMap.get(Long.valueOf(advertId));
                if (advertFilterVO != null) {
                    resultList.add(advertFilterVO);
                }
            }
        } else {
            resultList.add(advertFilterVOS.get(new Random().nextInt(advertFilterVOS.size())));
        }
        return resultList;
    }

    /**
     * 获取用于广告位定向导量的特定广告id
     * @return
     */
    private List<Long> getSlotDirectionAdvertId(){
        try {
            String value = serviceManager.getStrValue(SystemConfigKeyConstant.RISK_DIRECTION_ADVERT_ID);
            if (StringUtils.isBlank(value)) {
                return null;
            }
            return Arrays.asList(value.split(",")).stream().filter(val->StringUtils.isNotBlank(val))
                    .map(val->Long.valueOf(val)).collect(Collectors.toList());
        } catch (TuiaException e) {
            logger.error("AdvertPrivilegeFilterServiceImpl.getSlotDirectionAdvertId error!", e);
            return null;
        }
    }


    private boolean check(AdvertVO advertVO, ShieldStrategyVO shieldStrategyVO, ObtainAdvertReq req,
                          ObtainAdvertRsp rsp, AppDetail appDetail, Long advertId, AdvQueryParam advQueryParam,Set<Long> advertMaterials) {
        // 1.如果广告数据为空， 则校验失败
        if (advertVO == null || advertVO.getAdvertPlan() == null) {
            return false;
        }
        // 2. 白名单过滤  09.19回滚代码，风控会出
        if (!this.doAppWhiteList(rsp, appDetail, advertVO.getAdvertPlan().getId())) {
            return false;
        }

        // 3.如果广告的特征标签和app禁用标签有重复， 则校验失败
        List<String> appBannedTagIds = shieldStrategyVO.getAppBannedTags();
        List<String> advertTagIds = getTags(advertVO);
        //如果是百奇或积木域名，添加独有的落地页标签
        if (advertVO.getSourceId() != null && advertVO.getSourceType() != null) {
            List<String> makeTags = makeTagCacheService.getMakeTagByKey(advertVO.getSourceId(), advertVO.getSourceType());
            if (CollectionUtils.isNotEmpty(makeTags)) {
                advertTagIds.addAll(makeTags);
            }
        }
        if (CollectionUtils.isNotEmpty(advertTagIds) && CollectionUtil.haveSame(appBannedTagIds, advertTagIds)) {
            return false;
        }

        // 5.广告位屏蔽策略
        // 如果广告位禁用广告主URL与广告推广网址一致，则校验失败
        Set<String> shieldUrls = shieldStrategyVO.getShieldUrls();
        if (serviceManager.isNeedShield(advertVO.getCouponBase().getPromoteURL(), shieldUrls)) {
            return false;
        }
        //只取互动广告类型
        if (Optional.ofNullable(advertVO.getAdvertPlan().getAdvertType()).orElse(CommonConstant.HD_ADVERT_TYPE) != CommonConstant.HD_ADVERT_TYPE) {
            return false;
        }
        //关键词屏蔽
        if (filterKeyword(advertId, advQueryParam)) {
            return false;
        }

        //媒体端黑名单校验
        if(slotBlackListFilter(advertVO,advQueryParam)){
            return false;
        }

        //定制 可投广告列表过滤
        if(!chooseAdvertFilter(advertVO,advQueryParam)){
            return false;
        }

        // 互选过滤
        return advertQueryService.appSelectAdvertCheck(advQueryParam,advertMaterials, advertId, advertVO);
    }

    private boolean chooseAdvertFilter(AdvertVO advertVO, AdvQueryParam advQueryParam) {

        AdvertPlan advertPlan = advertVO.getAdvertPlan();
        AdvertTagDO advertTagDO = advertVO.getAdvertTagDO();

        MediaList mediaWhiteList = advQueryParam.getMediaWhiteList();
        if(mediaWhiteList != null && mediaWhiteList.isAdvertInList(advertPlan.getId(),advertPlan.getAccountId())){
            //在白名单中 直接可投
            return true;
        }

        //资源标签
        String resourceTag = advertTagDO.getResourceTag();
        //行业标签
        Set<String> advertTags = new HashSet<>(advertTagDO.getMatchTagList());
        //定制的可投广告列表
        SlotChooseAdverttVO slotChooseAdverttVO = advQueryParam.getSlotChooseAdverttVO();

        return null == slotChooseAdverttVO || slotChooseAdverttVO.chooseItem(resourceTag,advertTags,advertPlan.getId(),advertPlan.getAccountId());
    }

    /**
     * 广告为黑名单过滤，判断是否在黑名单中
     * @param advertVO
     * @param advQueryParam
     * @return
     */
    private boolean slotBlackListFilter(AdvertVO advertVO, AdvQueryParam advQueryParam) {

        MediaList mediaBlackList = advQueryParam.getMediaBlackList();
        if(null == mediaBlackList){
            return false;
        }
        AdvertPlan advertPlan = advertVO.getAdvertPlan();
        return mediaBlackList.isAdvertInList(advertPlan.getId(),advertPlan.getAccountId());
    }

    private boolean doAppWhiteList(ObtainAdvertRsp rsp, AppDetail appDetail, Long advertId) {

        ShieldingStrategyService shieldingStrategy = StrategyBeans.shieldingStrategyMap.get(rsp.getStrategyType());

        try {
            // 是否开启福袋开关
            boolean sendLuckybag = shieldingStrategy.isSendLuckybag(appDetail.getObjParam());
            if (sendLuckybag) {
                return true;
            }
            //查询该应用的白名单列表
            List<Long> appWhiteList = mediaCacheService.getWhiteList(appDetail, shieldingStrategy);
            if (CollectionUtils.isEmpty(appWhiteList))
                return true;

            return appWhiteList.contains(advertId);
        } catch (TuiaException e) {
            logger.error("获取白名单异常", e);
        }

        return false;
    }

    /**
     * 关键词屏蔽
     * @param advertId
     * @param advQueryParam
     * @return
     */
    private boolean filterKeyword(Long advertId, AdvQueryParam advQueryParam) {
        AdvertFilterKeywordDO advertFilterKeywordDO = advQueryParam.getAdvertFilterKeywordDO();
        if (Objects.nonNull(advertFilterKeywordDO)) {
            NewTradeFilterKeywordDO newTradeFilterKeywordDO = advertFilterKeywordDO.getNewTradeFilterKeywordDO();
            if (Objects.nonNull(newTradeFilterKeywordDO) && CollectionUtils.isNotEmpty(newTradeFilterKeywordDO.getAdvertIdList())) {
                if (newTradeFilterKeywordDO.getAdvertIdList().contains(advertId)) {
                    return true;
                }
            }

            GeneralFilterKeywordDO generalFilterKeywordDO = advertFilterKeywordDO.getGeneralFilterKeywordDO();
            if (Objects.nonNull(generalFilterKeywordDO) && CollectionUtils.isNotEmpty(generalFilterKeywordDO.getAdvertIdList())) {
                if (generalFilterKeywordDO.getAdvertIdList().contains(advertId)) {
                    return true;
                }
            }

        }
        return false;
    }


    /**
     * 过滤定向配置包
     *
     * @param req
     * @param advertId
     * @param cityId
     * @return
     * @throws TuiaException
     */
    @SuppressWarnings("squid:S3776")
    private SortedSet<AdvertPriceVO> filterPackages(ObtainAdvertReq req, Long advertId, String cityId,
                                                    List<String> appBannedTagIds, FilterResult filterResult, Set<AdvertFilterType> resultSets, Set<Long> advertMaterials) throws TuiaException {

        SortedSet<AdvertPriceVO> advertPriceVOSet = Sets.newTreeSet();
        List<AdvertOrientationPackageVO> orientationPackages = advertOrientationService.getOrientationList(advertId);

        List<Integer> activityTypeExt = req.getActivityTypeExt();
        Boolean autoBindMaterialSet = (null != activityTypeExt && activityTypeExt.contains(12));

        for (AdvertOrientationPackageVO orientationPackageVO : orientationPackages) {

            //如果为空则是空的
            if (orientationPackageVO.getId() == null) {
                continue;
            }
            ErrorCode errorCode = directionalFilter(req, orientationPackageVO, advertId, cityId, appBannedTagIds);
            if (errorCode != ErrorCode.E0000000) {
                continue;
            }

            //特权库过滤掉系统托管的配置
            Integer packageType = Optional.ofNullable(orientationPackageVO.getPackageType()).orElse(1);
            if (packageType == TrusteeshipConstants.TRUSTEESHIP_PACKAGE) {
                continue;
            }

            //如果 获取的是激励视屏投放类型，则只能投放"8"类型的配置
//            String adType = req.getAdType();
//            if(null != adType && PackagePlanConstants.VEDIO_AD_TYPE.equals(adType)
//                    && !ActivityTypeEnum.VEDIO_ADVERT_ACTIVITY_TYPE.getCodeStr().equals(orientationPackageVO.getActivityType())){
//                continue;
//            }

            String activityType = Optional.ofNullable(req.getActivitySceneType()).map(type -> type.toString()).orElse("0");
            Set<String> activityTypeSet = getActivityTypeSet(orientationPackageVO.getActivityType());

            if(autoBindMaterialSet){
                //12类型 = 类型2 + 类型=9
                if (!checkStrContains(activityTypeSet, String.valueOf(PackagePlanConstants.ACT_ACTIVITY_TYPE))){
//                        && !checkStrContains(activityTypeSet, PackagePlanConstants.NEW_VEDIO_AD_ACTIVITY_TYPE)) {
                    continue;
                }
            }else {
                //新视频广告 和 dp广告 过滤
                if ((PackagePlanConstants.NEW_VEDIO_AD_ACTIVITY_TYPE.equals(activityType) || ActivityTypeEnum.DP_ADVERT_ACTIVITY_TYPE.getCodeStr().equals(activityType))
                        && !activityTypeSet.contains(activityType)) {
                    continue;
                }

                // 增值过滤
                if (isActivityTypeContainsEncourage(activityType, req.getActivityTypeExt())) {
                    if (CollectionUtils.isNotEmpty(activityTypeSet)
                            && !activityTypeSet.contains(activityType)
                            && !activityTypeSet.contains(ActivityTypeEnum.ENC_ACTIVITY_TYPE.getCodeStr())) {
                        continue;
                    }
                }

                //其他活动类型判断 有不限逻辑
                if (!checkStrContains(activityTypeSet, activityType)) {
                    continue;
                }
            }

            AdvertPriceVO priceVO = new AdvertPriceVO(null, getFee(orientationPackageVO), orientationPackageVO.getChargeType());
            priceVO.setAdvertId(orientationPackageVO.getAdvertId());
            priceVO.setAdvertOrientationPackageId(orientationPackageVO.getId());
            priceVO.setOriginalOrientationId(orientationPackageVO.getId());
            priceVO.setPackageType(orientationPackageVO.getPackageType());
            //获取广告的有效素材列表 配置包的素材和广告素材取交集就是配置包的有效素材列表
            //互选广告一期优化，添加 可投素材过滤，此处逻辑移到了 外面
//            Set<Long> advertMaterials = advertMaterialRecommendService.getMaterialSetByAdvertId(advertId);

            //过滤特权库素材ID，过滤掉被屏蔽的素材
            filterPrivilegeMaterialIds(advertMaterials, filterResult, resultSets, advertId, orientationPackageVO.getId());

            //根据活动类型过滤广告配置
            advertMaterials = advertMaterialRecommendService.filterByActivityType(req.getActivityMaterialType(),advertId,advertMaterials);

            if (CollectionUtils.isEmpty(advertMaterials)) {
                continue;
            }

            //爱奇艺流量判断
            if (iQiyiService.isIQiyiFlow(req)) {
                String key = advertId + "|" + orientationPackageVO.getId();
                OrientPkgFilterUrlDO orientPkgFilterUrlDO = advertPkgCacheService.getAdvertOrientPkgCache(key);
                priceVO.setOrientPkgFilterUrlDO(orientPkgFilterUrlDO);
                if (Objects.isNull(orientPkgFilterUrlDO) || (!orientPkgFilterUrlDO.isAdvertSupport() && !orientPkgFilterUrlDO.isPkgSupport())) {
                    continue;
                }
            }

            if(CollectionUtils.isEmpty(orientationPackageVO.getMaterialIds())){
//                if(autoBindMaterialSet){
//                    //新增逻辑
//                    Set<Long> advertVideoMaterialSet = advertMaterialRecommendService.getAdvertVideoMaterialSet(orientationPackageVO.getAdvertId());
//                    //根据配置类型
//                    Set<Long> bindMaterials = new HashSet<>(advertMaterials);
//                    if (null != activityTypeSet && activityTypeSet.contains(PackagePlanConstants.NEW_VEDIO_AD_ACTIVITY_TYPE)) {
//                        //定向激励视频的配置
//                        bindMaterials.retainAll(advertVideoMaterialSet);
//                    } else {
//                        //其他配置
//                        bindMaterials.removeAll(advertVideoMaterialSet);
//                    }
//                    if(CollectionUtils.isEmpty(bindMaterials)){
//                        continue;
//                    }
//                    priceVO.setMaterialsBind(bindMaterials);
//                }else{
                    priceVO.setMaterialsBind(advertMaterials);
//                }
            }else {
                Set<Long> packageMaterials = Sets.newHashSet(orientationPackageVO.getMaterialIds());
                packageMaterials.retainAll(advertMaterials);
                //如果没有素材可投，配置不可投
                if(CollectionUtils.isEmpty(packageMaterials)){
                    continue;
                }
                priceVO.setMaterialsBind(packageMaterials);
            }
            advertPriceVOSet.add(priceVO);
        }

        return advertPriceVOSet;
    }

    private Boolean checkStrContains(Set<String> list, String value) {
        // 请求参数或者广告属性为空，返回true
        if (list == null || list.size() == 0 || StringUtils.isBlank(value)) {
            return true;
        }
        return list.contains(value);
    }

    private Set<String> getActivityTypeSet(String activityType) {
        // 不限返回空set
        if (StringUtils.isNotBlank(activityType) && "-1".equals(activityType)) {
            return Sets.newHashSet();
        }
        return StringTool.getStringSetByStr(activityType);
    }

    private void filterPrivilegeMaterialIds(Set<Long> advertMaterials, FilterResult filterResult, Set<AdvertFilterType> resultSets, Long advertId, Long orientationId) {
        Set<String> shieldMaterialTags = filterResult.getShieldMaterialTags();
        List<Long> shieldMaterialIds = Lists.newArrayList();

        for (Long materialId : advertMaterials) {
            Set<String> materialTags = resourceTagsService.getResoureTagsDOById(materialId, ResourceTagsTypeEnum.MATERIAL);

            if (CollectionUtils.isNotEmpty(materialTags) && CollectionUtils.isNotEmpty(CollectionUtils.intersection(shieldMaterialTags, materialTags))) {
                shieldMaterialIds.add(materialId);
            }
        }

        if (CollectionUtils.isNotEmpty(shieldMaterialIds)) {
            advertMaterials.removeAll(shieldMaterialIds);
        }
        if(CollectionUtils.isEmpty(advertMaterials)){
            // 添加素材标签过滤日志
            resultSets.add(new AdvertFilterType(advertId, orientationId, AdvertFilterTypeEnum.BANNED_MATERIAL_TAG.getCode()));
            return;
        }
        //关键词过滤
        filterKeyword(advertMaterials, filterResult, advertId);
    }

    /**
     * 媒体广告位关键词屏蔽
     * @param advertMaterials
     * @param filterResult
     */
    private void filterKeyword(Set<Long> advertMaterials, FilterResult filterResult, Long advertId) {
        if (CollectionUtils.isNotEmpty(advertMaterials) && null != filterResult) {
            AdvertFilterKeywordDO advertFilterKeywordDO = filterResult.getAdvertFilterKeywordDO();
            if (Objects.nonNull(advertFilterKeywordDO)) {
                NewTradeFilterKeywordDO newTradeFilterKeywordDO = advertFilterKeywordDO.getNewTradeFilterKeywordDO();
                if (Objects.nonNull(newTradeFilterKeywordDO) && MapUtils.isNotEmpty(newTradeFilterKeywordDO.getShieldMaterialList())) {
                    Map<Long, Set<Long>> shieldMaterList = newTradeFilterKeywordDO.getShieldMaterialList();
                    if (shieldMaterList.containsKey(advertId)) {
                        Set<Long> shieldList = shieldMaterList.get(advertId);
                        if (CollectionUtils.isNotEmpty(shieldList)) {
                            advertMaterials.removeAll(shieldList);
                        }
                    }
                }

                GeneralFilterKeywordDO generalFilterKeywordDO = advertFilterKeywordDO.getGeneralFilterKeywordDO();
                if (Objects.nonNull(generalFilterKeywordDO) && MapUtils.isNotEmpty(generalFilterKeywordDO.getShieldMaterialList())) {
                    Map<Long, Set<Long>> shieldMaterList = generalFilterKeywordDO.getShieldMaterialList();
                    if (shieldMaterList.containsKey(advertId)) {
                        Set<Long> shieldList = shieldMaterList.get(advertId);
                        if (CollectionUtils.isNotEmpty(shieldList)) {
                            advertMaterials.removeAll(shieldList);
                        }
                    }
                }

            }
        }
    }

    private ErrorCode directionalFilter(ObtainAdvertReq req, AdvertOrientationPackageVO orientationPackageVO, Long advertId, String cityId, List<String> appBannedTagIds)
            throws TuiaException {

        Long orientationPackageId = orientationPackageVO.getId();

        // 1.如果广告过滤标签和app禁用标签有重复， 则校验失败
        List<String> advertTagIds = advertBannedTagBo.selectBannedTagByAdvertIdAndOrientataionPackageId(advertId,
                orientationPackageId);
        if (CollectionUtils.isNotEmpty(advertTagIds) && CollectionUtil.haveSame(appBannedTagIds, advertTagIds)) {
            return ErrorCode.E0500010;
        }

        // 2.如果投放平台类型不符合， 则校验失败
        if(!CollectionUtils.isEmpty(orientationPackageVO.getPlatform()) && !orientationPackageVO.getPlatform().contains(req.getUa())){
            return ErrorCode.E0500011;
        }
        
        // 3.屏蔽流量，如果匹配到则校验失败
        String appFlowType = Optional.ofNullable(req.getLogExtMap())
                .map(logExtMap -> logExtMap.get(AdvertOrderJsonKeyEnum.KEY_APP_FLOW_TYPE.getCode()))
                .orElse(AppFlowPlatform.OTHER.getCode().toString());
        String bannedAppFlowType = appFlowType +"." +PlatformTypeEnum.getByDesc(req.getUa()).getCode();
        if (CollectionUtils.isNotEmpty(orientationPackageVO.getBannedAppFlowType()) && orientationPackageVO.getBannedAppFlowType().contains(bannedAppFlowType)) {
            return ErrorCode.E0500035;
        }
        
        // 4.如果用户不在广告的投放区域，则校验失败
        String areaIds =  advertOrientationService.getOrientation(advertId,orientationPackageVO.getId()).getRegionIds();

        if (StringUtils.isNotBlank(areaIds) && !areaIds.equals("-1")) {

            // TODO 注释： 缓存广告地域信息的时候直接转换为list，避免循环转换，影响性能
            List<String> areaIdList = Arrays.asList(areaIds.split(","));
            if (StringUtils.isNotEmpty(cityId) && !areaIdList.contains(cityId)) {
                return ErrorCode.E0500012;
            }

        }

        return ErrorCode.E0000000;
    }

    /**
     * 
     * getTags:(获取广告特征标签，落地页标签). <br/>
     *
     * @author chencheng
     * @param advertVO
     * @return
     * @since JDK 1.8
     */
    private List<String> getTags(AdvertVO advertVO) {
        List<String> advertTagIds;
        AdvertTagDO advertTagDO = advertVO.getAdvertTagDO();
        if (advertTagDO == null) {
            advertTagIds = new ArrayList<>();
        } else {
            advertTagIds = advertTagDO.getMatchTagList();
            advertTagIds.addAll(advertTagDO.getPromoteUrlTags());
            advertTagIds.addAll(StringTool.getStringListByStr(advertTagDO.getResourceTag()));
        }
        return advertTagIds;
    }

    private Long getFee(AdvertOrientationPackageVO orientationPackageVO) {
        if (orientationPackageVO != null && ChargeTypeEnum.TYPE_CPA.getCode() == orientationPackageVO.getChargeType()) {
            return orientationPackageVO.getaFee();
        }
        if (orientationPackageVO == null) {
            return null;
        }
        return orientationPackageVO.getFee();
    }

    /**
     * 判断场景是否包含增值，用于后续判断配置的投放类型是否勾选增值
     *
     * @param activityType 活动类型
     * @param activityTypeExt 活动类型补充
     * @return true.包含,false.不包含
     */
    private boolean isActivityTypeContainsEncourage(String activityType, List<Integer> activityTypeExt) {
        return ActivityTypeEnum.ENC_ACTIVITY_TYPE.getCodeStr().equals(activityType)
                || (CollectionUtils.isNotEmpty(activityTypeExt) && activityTypeExt.contains(ActivityTypeEnum.ENC_ACTIVITY_TYPE.getCode()));
    }
}
