package cn.com.duiba.tuia.filter.service.impl;

import cn.com.duiba.bigdata.dmp.service.api.remoteservice.dto.AttributeTagDto;
import cn.com.duiba.bigdata.dmp.service.api.remoteservice.dto.DeviceTagDto;
import cn.com.duiba.nezha.engine.api.dto.ConsumerDto;
import cn.com.duiba.tuia.constants.AdvertReqLogExtKeyConstant;
import cn.com.duiba.tuia.domain.model.CatMonitorWarnThreshold;
import cn.com.duiba.tuia.domain.model.FilterResult;
import cn.com.duiba.tuia.enums.CatGroupEnum;
import cn.com.duiba.tuia.enums.TagInterestScoreEnum;
import cn.com.duiba.tuia.filter.service.InterestAdvertTagFilter;
import cn.com.duiba.tuia.repository.QueryDeviceIdDmpRepository;
import cn.com.duiba.tuia.tool.CatUtil;
import cn.com.tuia.advert.model.ObtainAdvertReq;
import com.google.common.collect.Lists;
import com.hazelcast.util.MD5Util;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.*;
import java.util.stream.Collectors;

/**
 * @author: <a href="http://www.panaihua.com">panaihua</a>
 * @date: 2018年03月02日 11:34
 * @descript:
 * @version: 1.0
 */
@Service
@RefreshScope
public class InterestAdvertTagFilterImpl implements InterestAdvertTagFilter{

    private Logger logger = LoggerFactory.getLogger(InterestAdvertTagFilterImpl.class);

    //设定标签更新时间与当前时间的阈值
    @Value("${tuia.dmpTag.difftime:5}")
    private int TAGTIME_DIFF_NOW;

    //工作者
    private static final String WORK = "work";

    //学生
    private static final String STUDENT = "student";

    //其它
    private static final String WORK_OTHER = "workother";

    private static final String HIT_VALUE = "1";

    private static final String HIT_LOG_VALUE = "-1";

    private static final String DMP_TYPE = "dmp";

    private static final String DMP_TYPE_SUFFIX = "-t";

    private static final String DMP_REASON_SUFFIX = "-r";
    //dmp(行业人群包)标签值为1的key
    private static final String DMP_VALUE_HIT_KEY = "tags+1";
    //dmp(行业人群包)标签值为-1的key
    private static final String DMP_VALUE_NOT_HIT_KEY = "tags-1";
    //新dmp命中
    public static final String NEW_DMP_HIT_VALUE = "1";


    @Autowired
    private QueryDeviceIdDmpRepository queryDeviceIdDmpRepository;

    @Autowired
    private  CatMonitorWarnThreshold catMonitorWarnThreshold;
    
    /**
     * 构建用户的数据传给nezha
     * @param integertagList
     * @param consumerDto
     */
    private void buildConsume(List<String> integertagList,ConsumerDto consumerDto){

        List<String> interests = Lists.newArrayListWithCapacity(integertagList.size());
        consumerDto.setIntersetList(interests);
        integertagList.forEach(integerTag -> {

            if(StringUtils.isBlank(integerTag)){
                return;
            }

            TagInterestScoreEnum scoreEnum = TagInterestScoreEnum.getType(integerTag);
            if(scoreEnum == null){
                return;
            }

            switch (scoreEnum){
                case work:consumerDto.setWorkStatus(integerTag);break;
                case student:consumerDto.setWorkStatus(integerTag);break;
                case workother:consumerDto.setWorkStatus(integerTag);break;
                case college:consumerDto.setStudentStatus(integerTag);break;
                case milldleschool:consumerDto.setStudentStatus(integerTag);break;
                case male:consumerDto.setSex(integerTag);break;
                case female:consumerDto.setSex(integerTag);break;
                case young:consumerDto.setAge(integerTag);break;
                case old:consumerDto.setAge(integerTag);break;
                case single:consumerDto.setMarriageStatus(integerTag);break;
                case married:consumerDto.setMarriageStatus(integerTag);break;
                case bear:consumerDto.setBear(integerTag);break;
                case finance:interests.add(integerTag);break;
                case poker:interests.add(integerTag);break;
                case biggame:interests.add(integerTag);break;
                case health:interests.add(integerTag);break;
                case shopping:interests.add(integerTag);break;

                case financialproduct:interests.add(integerTag);break;
                case share_fund:interests.add(integerTag);break;
                case earnonline:interests.add(integerTag);break;
                case lottery:interests.add(integerTag);break;
                case debit:interests.add(integerTag);break;
                case video:interests.add(integerTag);break;
                case news:interests.add(integerTag);break;
                case ecommerce:interests.add(integerTag);break;
                case COD:interests.add(integerTag);break;
                case digitalproduct:interests.add(integerTag);break;
                case autocar:interests.add(integerTag);break;
                case socialonline:interests.add(integerTag);break;
                case dateonline:interests.add(integerTag);break;
                case puzzlegame:interests.add(integerTag);break;
                case roleplaygame:interests.add(integerTag);break;
                case pokergame:interests.add(integerTag);break;
                case adventuregame:interests.add(integerTag);break;
                case MOBA:interests.add(integerTag);break;
                case teeneducation:interests.add(integerTag);break;
                case adulteducation:interests.add(integerTag);break;
                case reading:interests.add(integerTag);break;
                case live:interests.add(integerTag);break;
                default:break;
            }
        });
    }

    @Override
    public List<String> getUserCrowdInterest(String deviceId, ConsumerDto consumerDto, FilterResult filterResult, ObtainAdvertReq req, DeviceTagDto deviceTagDto,Map<String,String> newUserDmpTagsMap) {
        
        try {

            //获取用户感兴趣标签的得分
            List<String> userCrowdInterest = Lists.newArrayList();
            if(StringUtils.isNotBlank(deviceId)){

                userCrowdInterest = contributInterest(deviceTagDto);

                userCrowdInterest = getUserCrowdInterestFromHbase(userCrowdInterest);

                //给nezha构建需要的数据
                this.buildConsume(userCrowdInterest,consumerDto);

                //设置dmp标签(行业人群包)
                setFormalDmp(filterResult,deviceTagDto.getBusinessTagPackage());
            }

            //设置新的dmp标签（行业人群包、商业兴趣标签）
            if(null != newUserDmpTagsMap && !newUserDmpTagsMap.isEmpty()) {
                setNewHitDmp(newUserDmpTagsMap, userCrowdInterest);
            }

            if (CollectionUtils.isEmpty(userCrowdInterest)) {
                CatUtil.catLog(CatGroupEnum.CAT_102023.getCode());
            }

            return userCrowdInterest;
        } catch (Exception e) {
            logger.error("用户社会属性过滤异常", e);
            return Lists.newArrayList();
        }
    }

    @Override
    public Map<String, String> getThirdPartDmpTag(ObtainAdvertReq req) {
        Map<String, String> rtnMap;

        List<Long> tagTimestamp = new ArrayList<>();

        String deviceKey = getDeviceKey(req);
        if(null != deviceKey) {
            try {
                rtnMap = queryDeviceIdDmpRepository.getDeviceIdDmpData(deviceKey, new StringBuilder(), tagTimestamp);

                //设置标签更新与当前时间差
                setRealTimeRTA(req, tagTimestamp);
            }catch (Exception e){
                //超时熔断，不打印日志
                rtnMap = new HashMap<>();
            }
        }else{
            rtnMap = new HashMap<>();
        }

        return rtnMap == null ? new HashMap<>():rtnMap;
    }

    /**
     * 设置标签更新与当前时间差
     * @param req
     * @param tagTimestamp
     */
    private void setRealTimeRTA(ObtainAdvertReq req, List<Long> tagTimestamp) {
        if(!CollectionUtils.isEmpty(tagTimestamp)){
            long maxTagtimestap = tagTimestamp.stream().max(Long::compareTo).get();
            long nowTime = new Date().getTime();

            long diffTime = nowTime - maxTagtimestap;

            //60000指将时间换算成毫秒
            if (diffTime > (TAGTIME_DIFF_NOW * 60000)) {
                //超过阈值
                String overThreshold = "1";
                req.getLogExtMap().put(AdvertReqLogExtKeyConstant.REAL_TIME_RTA, overThreshold);
            } else {
                //没有超过阈值
                String nonThreshold = "0";
                req.getLogExtMap().put(AdvertReqLogExtKeyConstant.REAL_TIME_RTA, nonThreshold);
            }

        }
    }

    /**
     * 将行业人群包，基础属性标签，商业兴趣标签 组装为map
     * @param deviceTagDto
     * @return
     */
    private List<String> contributInterest(DeviceTagDto deviceTagDto){

        List<String> userInterest = new ArrayList<>();

        if(deviceTagDto == null){
            return userInterest;
        }

        //基础属性标签
        AttributeTagDto attributeTag = Optional.ofNullable(deviceTagDto.getAttributeTag()).orElse(new AttributeTagDto());

        //商业兴趣标签
        List<String> interestTag = Optional.ofNullable(deviceTagDto.getInterestTag()).orElse(new ArrayList<>());

        //离线dmp
        List<String> offLineDmp = Optional.ofNullable(deviceTagDto.getOfflineTagPackage()).orElse(new ArrayList<>());

        //老dmp
        List<String> businessTagPackage = Optional.ofNullable(deviceTagDto.getBusinessTagPackage()).orElse(new ArrayList<>());

        userInterest.addAll(interestTag);
        userInterest.addAll(offLineDmp);
        userInterest.addAll(businessTagPackage);

        userInterest.add(attributeTag.getAge());
        userInterest.add(attributeTag.getBear());
        userInterest.add(attributeTag.getMarriageStatus());
        userInterest.add(attributeTag.getSex());
        userInterest.add(attributeTag.getWorkStatus());
        userInterest.add(attributeTag.getStudentStatus());

        //第三方 外部dmp
        List<String> thirdPartDmp = Optional.ofNullable(deviceTagDto.getExternalPackage()).orElse(new ArrayList<>());
        userInterest.addAll(thirdPartDmp);

        //算法推荐定向人群包
        List<String> algDirectionalPackages = Optional.ofNullable(deviceTagDto.getAlgDirectionalPackage()).orElse(new ArrayList<>());
        userInterest.addAll(algDirectionalPackages);

        //算法推荐排除人群包
        List<String> algExcludePackages = Optional.ofNullable(deviceTagDto.getAlgExcludePackage()).orElse(new ArrayList<>());
        userInterest.addAll(algExcludePackages);

        //算法测试人群包
        List<String> algTestPackages = Optional.ofNullable(deviceTagDto.getAlgTestPackage()).orElse(new ArrayList<>());
        userInterest.addAll(algTestPackages);

        return userInterest;
    }

    private void setNewHitDmp(Map<String, String> newUserDmpTagsMap, List<String> userCrowdInterest) {
        newUserDmpTagsMap.forEach((key,value)->{
            if(null != value && NEW_DMP_HIT_VALUE.equals(value)){
                userCrowdInterest.add(key);
            }
        });
    }

    private String getDeviceKey(ObtainAdvertReq req) {
        Map<String, String> logExtMap = Optional.ofNullable(req.getLogExtMap()).orElse(new HashMap<>());
        String deviceId;

        //用于校验logExtMap 中的 IMEI 是否有有效值，
        deviceId = logExtMap.get(AdvertReqLogExtKeyConstant.IMEI);
        if(StringUtils.isNotBlank(deviceId)){
            return getRowKey(deviceId,false);
        }

        deviceId = logExtMap.get(AdvertReqLogExtKeyConstant.IDFA);
        if(StringUtils.isNotBlank(deviceId)){
            return getRowKey(deviceId,false);
        }

        deviceId = logExtMap.get(AdvertReqLogExtKeyConstant.OAID);
        if(StringUtils.isNotBlank(deviceId)){
            return getRowKey(deviceId,false);
        }

        deviceId = logExtMap.get(AdvertReqLogExtKeyConstant.IMEI_MD5);
        if(StringUtils.isNotBlank(deviceId)){
            return getRowKey(deviceId,true);
        }

        deviceId = logExtMap.get(AdvertReqLogExtKeyConstant.IDFA_MD5);
        if(StringUtils.isNotBlank(deviceId)){
            return getRowKey(deviceId,true);
        }

        deviceId = logExtMap.get(AdvertReqLogExtKeyConstant.OAID_MD5);
        if(StringUtils.isNotBlank(deviceId)){
            return getRowKey(deviceId,true);
        }
        return null;
    }

    private String getRowKey(String key,Boolean isMd5) {
        String md5DeviceId = isMd5 ? key : MD5Util.toMD5String(key);
        if(md5DeviceId.length() < 5){
            return null;
        }
        return md5DeviceId.substring(0, 4) + "-" + md5DeviceId;
    }

    private List<String> getUserCrowdInterestFromHbase(List<String> userInterest){

        List<String> userInterests = new ArrayList<>(userInterest);
        userInterests = userInterests.stream().filter(Objects::nonNull).collect(Collectors.toList());

        if(CollectionUtils.isEmpty(userInterests)){
            userInterests.add(WORK_OTHER);
            return userInterests;
        }

        //判断有没有工作状态，没有就设置其它
        if ((!userInterests.contains(WORK)) && (!userInterests.contains(STUDENT))) {
            userInterests.add(WORK_OTHER);
        }

        return userInterests;
    }

    private void setFormalDmp(FilterResult filterResult,List<String> hitDmpTags){

        Map<String,Object> logMap = new HashMap<>();

        logMap.put(DMP_VALUE_HIT_KEY,hitDmpTags);

        filterResult.setDmpTagMap(logMap);
    }
}
