package cn.com.duiba.tuia.log;

import java.time.Instant;
import java.util.Date;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.alibaba.fastjson.JSON;

import cn.com.duiba.boot.perftest.PerfTestContext;
import cn.com.duiba.tuia.domain.model.AdvertFilter;
import cn.com.duiba.wolf.utils.DateUtils;
import cn.com.duiba.wolf.utils.UUIDUtils;
import cn.com.tuia.advert.model.BaseInnerRuleDto;

/**
 *  广告过滤日志打印
 *
 * @author peanut.huang
 * @date 2019/4/10
 * @since JDK 1.8
 */
public class AdvertFilterLog {

    /** The logger. */
    private static Logger log = LoggerFactory.getLogger(AdvertFilterLog.class);

    public static void log(AdvertFilter advertFilter) {
        if(PerfTestContext.isCurrentInPerfTestMode()){
            return;
        }

        BaseInnerRuleDto ruleDto = new BaseInnerRuleDto();
        ruleDto.setGroup(BaseInnerLog.ADVERT_INNER_LOG_GROUP);
        ruleDto.setJson(JSON.toJSONString(advertFilter));
        ruleDto.setTime(DateUtils.getSecondStr(new Date()));
        ruleDto.setType(BaseInnerLog.ADVERT_FILTER_LOG);
        ruleDto.setTimeStamp(String.valueOf(Instant.now().toEpochMilli()));
        ruleDto.setUuid(UUIDUtils.createUUID().toLowerCase());

        log.info(JSON.toJSONString(ruleDto));
    }
}
