package cn.com.duiba.tuia.log;

import cn.com.duiba.boot.perftest.PerfTestContext;
import cn.com.duiba.wolf.utils.UUIDUtils;
import cn.com.tuia.advert.model.BaseInnerRuleDto;
import com.alibaba.fastjson.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.time.Instant;

public class BaseInnerExt01Log {

    protected static Logger log = LoggerFactory.getLogger(BaseInnerExt01Log.class);

    public static String localIp;

    static {
        try {
            localIp = InetAddress.getLocalHost().getHostAddress();
        } catch (UnknownHostException e) {
            localIp = "127.0.0.1";
        }
    }

    /** 广告平台日志统一分组 */
    public static String ADVERT_INNER_LOG_GROUP =  "1";

    public static void log(String json, String type, String time) {
        if(PerfTestContext.isCurrentInPerfTestMode())return;
        BaseInnerRuleDto ruleDto = new BaseInnerRuleDto();
        ruleDto.setGroup(ADVERT_INNER_LOG_GROUP);
        ruleDto.setJson(json);
        ruleDto.setTime(time);
        ruleDto.setType(type);
        ruleDto.setTimeStamp(String.valueOf(Instant.now().toEpochMilli()));
        ruleDto.setUuid(UUIDUtils.createUUID().toLowerCase());
        ruleDto.setMip(localIp);
        log.info(format(ruleDto));
    }

    protected static String format(BaseInnerRuleDto ruleDto) {
        return JSONObject.toJSONString(ruleDto);
    }

}
