package cn.com.duiba.tuia.log;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.time.Instant;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.alibaba.fastjson.JSONObject;

import cn.com.duiba.boot.perftest.PerfTestContext;
import cn.com.duiba.wolf.utils.UUIDUtils;
import cn.com.tuia.advert.model.BaseInnerRuleDto;
import cn.com.tuia.advert.model.ObtainAdvertReq;
import cn.com.tuia.advert.model.ObtainAdvertReqLogExt;


/**
 * ClassName: BaseInnerLog <br/>
 * Function: 统一日志基础类 ADD FUNCTION. <br/>
 * Reason: 所有的日志统一处理 ADD REASON(可选). <br/>
 * date: 2017年3月1日 下午5:28:04 <br/>
 *
 * @author cdm
 * @version 
 * @since JDK 1.7
 */
public class BaseInnerLog {
    
    /** The logger. */
    protected static Logger log = LoggerFactory.getLogger(BaseInnerLog.class);
    
    /** 广告平台日志统一分组 */
    public static String ADVERT_INNER_LOG_GROUP =  "1";

    /**
     * 广告平台虚拟发券统一分组
     */
    public static String IMITATE_ADVERT_INNER_LOG_GROUP =  "13";


    /** 发券日志 */
    public static String ADVERT_INNER_LOG_LAUNCH =  "20";
    
    /** 点击日志 */
    public static String ADVERT_INNER_LOG_CLICK =  "21";
    
    /** 曝光日志 */
    public static String ADVERT_INNER_LOG_EXPOSURE  =  "22";
    
    /** 请求日志 */
    public static String ADVERT_INNER_LOG_REQUEST  =  "23";
    
    /** 计费日志 */
    public static String ADVERT_INNER_LOG_CONSUME  =  "25";

    /** 广告过滤日志 */
    public static String ADVERT_FILTER_LOG  =  "128";



    /** 广告状态变更日志 */
    public static String ADVERT_INNER_LOG_UPDATE_ADVERT_STATUS  =  "32";
    
    public static String ADVERT_INNER_LOG_VIP_RESPONSE = "60";

    public static String ADVERT_INNER_LOG_SIMILAR_ADVERT = "73";
    
    /** filterResult日志 */
    public static String ADVERT_INNER_LOG_FILTER_RESULT = "79";

    /** 可以被替换的低arpu值券发券日志 */
    public static String ADVERT_INNER_LOG_LOW_ARPU_LAUNCH =  "116";

    /** 可以被替换的低arpu值券曝光日志 */
    public static String ADVERT_INNER_LOG_LOW_ARPU_EXPOSURE  =  "117";

    /** 可以被替换的低arpu值券点击日志 */
    public static String ADVERT_INNER_LOG_LOW_ARPU_CLICK  =  "118";

    public static String localIp;

    static {
        try {
            localIp = InetAddress.getLocalHost().getHostAddress();
        } catch (UnknownHostException e) {
            localIp = "127.0.0.1";
        }
    }

    public static void log(String json , String type, String time) {
        if(PerfTestContext.isCurrentInPerfTestMode())return;
        BaseInnerRuleDto ruleDto = new BaseInnerRuleDto();
        ruleDto.setGroup(ADVERT_INNER_LOG_GROUP);
        ruleDto.setJson(json);
        ruleDto.setTime(time);
        ruleDto.setType(type);
        ruleDto.setTimeStamp(String.valueOf(Instant.now().toEpochMilli()));
        ruleDto.setUuid(UUIDUtils.createUUID().toLowerCase());
        ruleDto.setMip(localIp);
        log.info(format(ruleDto));
    }

    public static void setSlotIdToNull(ObtainAdvertReqLogExt reqLogExt) {
        Long slotId = reqLogExt.getSlotId();
        if (null != reqLogExt.getActivityUseType() &&
                (0 == reqLogExt.getActivityUseType() || 1 == reqLogExt.getActivityUseType())) {
            reqLogExt.setSlotId(null);
            reqLogExt.setDuibaSlotId(slotId);
        }
    }

    public static Long setSlotIdToNull(ObtainAdvertReq req) {
        Long slotId = req.getSlotId();
        if (null != req.getActivityUseType() &&
                (0 == req.getActivityUseType() || 1 == req.getActivityUseType())) {
            req.setSlotId(null);
            req.setDuibaSlotId(slotId);
        }
        return slotId;
    }

    protected static String format(BaseInnerRuleDto ruleDto) {
        return JSONObject.toJSONString(ruleDto);
    }

}
