/**
 * Project Name:engine-service File Name:FilterResultLog.java Package Name:cn.com.duiba.tuia.log
 * Date:2016年9月24日下午3:52:34 Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 */

package cn.com.duiba.tuia.log;

import cn.com.duiba.wolf.utils.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import cn.com.duiba.boot.perftest.PerfTestContext;
import cn.com.duiba.tuia.domain.model.FilterResult;

import com.alibaba.fastjson.JSON;

import java.util.Date;

/**
 * 过滤结果日志打印工具 <br/>
 * Date: 2016年9月24日 下午3:52:34 <br/>
 * 
 * @author sunjiangrong
 * @version
 * @since JDK 1.6
 * @see
 */
public final class FilterResultLog {

    /** The logger. */
    private  static Logger log = LoggerFactory.getLogger(FilterResultLog.class);

    public static void log(FilterResult filterResult) {
        try{
            if(PerfTestContext.isCurrentInPerfTestMode())return;
            log.info(format(filterResult));
        }catch(Exception e){
            log.error("",e);
        }
    }

    public static void innerLog(FilterResult filterResult) {
        if (PerfTestContext.isCurrentInPerfTestMode()) {
            return;
        }
        String json = format(filterResult);
        BaseInnerExt01Log.log(json, BaseInnerLog.ADVERT_INNER_LOG_FILTER_RESULT, DateUtils.getSecondStr(new Date()));
    }
    
    private static String format(FilterResult filterResult) {
        return JSON.toJSONString(filterResult);
    }
}
