package cn.com.duiba.tuia.log;

import java.time.Instant;

import cn.com.duiba.boot.perftest.PerfTestContext;
import cn.com.duiba.wolf.utils.UUIDUtils;
import cn.com.tuia.advert.model.BaseInnerRuleDto;

/**
 * 虚拟发券BaseInnerLog
 *
 * @author peanut.huang
 * @date 2019/9/20
 * @since JDK 1.8
 */
public class ImitateBaseInnerLog extends BaseInnerLog {

    /**
     * log
     *
     * @param json
     * @param type
     * @param time
     */
    public static void imitateLog(String json, String type, String time) {
        if(PerfTestContext.isCurrentInPerfTestMode()){
            return;
        }
        BaseInnerRuleDto ruleDto = new BaseInnerRuleDto();
        ruleDto.setGroup(IMITATE_ADVERT_INNER_LOG_GROUP);
        ruleDto.setJson(json);
        ruleDto.setTime(time);
        ruleDto.setType(type);
        ruleDto.setTimeStamp(String.valueOf(Instant.now().toEpochMilli()));
        ruleDto.setUuid(UUIDUtils.createUUID().toLowerCase());
        log.info(format(ruleDto));
    }
}
