package cn.com.duiba.tuia.log;

import cn.com.duiba.boot.perftest.PerfTestContext;
import cn.com.duiba.tuia.tool.CatUtil;
import cn.com.duiba.wolf.utils.UUIDUtils;
import cn.com.tuia.advert.model.BaseInnerRuleDto;
import com.alibaba.fastjson.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.time.Instant;


/**
 * ClassName: InnerExtTwoLog <br/>
 * Function: 统一日志基础类 ADD FUNCTION. <br/>
 * Reason: 所有的日志统一处理 ADD REASON(可选). <br/>
 * date: 2020年4月13日 下午5:28:04 <br/>
 *
 * @author lijian
 * @since JDK 1.8
 */
public class InnerExtTwoLog {

    /**
     * The logger.
     */
    protected static Logger log = LoggerFactory.getLogger(InnerExtTwoLog.class);

    /**
     * 广告平台日志统一分组
     */
    public static String INNER_EXT2_LOG_GROUP = "1";

    /**
     * 发券日志
     */
    public static String INNER_EXT2_LOG_LAUNCH = "20";

    /**
     * 点击日志
     */
    public static String INNER_EXT2_LOG_CLICK = "21";

    /**
     * 曝光日志
     */
    public static String INNER_EXT2_LOG_EXPOSURE = "22";

    /**
     * 请求日志 DSP请求响应/竞价日志
     */
    public static String INNER_EXT2_LOG_REQUEST = "23";

    /**
     * 计费日志
     */
    public static String INNER_EXT2_LOG_CONSUME = "25";

    /**
     * DSP ADX请求下发日志
     */
    public static String INNER_EXT2_LOG_DSP_REQUEST = "26";

    /**
     * DSP 竞价失败日志
     */
    public static String INNER_EXT2_LOG_COMPARE_PRICE = "28";

    /**
     * DSP 返回超时日志
     */
    public static String INNER_EXT2_LOG_TIME_OUT = "27";


    public static void log(String json, String type, String time) {
        if (PerfTestContext.isCurrentInPerfTestMode()) {
            return;
        }
        BaseInnerRuleDto ruleDto = new BaseInnerRuleDto();
        ruleDto.setGroup(INNER_EXT2_LOG_GROUP);
        ruleDto.setTime(time);
        ruleDto.setType(type);
        ruleDto.setTimeStamp(String.valueOf(Instant.now().toEpochMilli()));
        ruleDto.setUuid(UUIDUtils.createUUID().toLowerCase());
        ruleDto.setJson(json);
        log.info(format(ruleDto));
    }

    protected static String format(Object dto) {
        return JSONObject.toJSONString(dto);
    }

    /**
     * ADX请求下发日志
     *
     * @param param
     */
    public static void requestDspLog(JSONObject param) {
        CatUtil.log("dspRequestLog");
        if (PerfTestContext.isCurrentInPerfTestMode()) {
            return;
        }
        String json = format(param);
        log(json, INNER_EXT2_LOG_DSP_REQUEST, param.getString("time"));
    }

    /**
     * DSP请求响应/竞价日志
     *
     * @param param
     */
    public static void responseLog(JSONObject param) {
        CatUtil.log("dspResponseLog");
        if (PerfTestContext.isCurrentInPerfTestMode()) {
            return;
        }
        String json = format(param);
        log(json, INNER_EXT2_LOG_REQUEST, param.getString("time"));
    }

    /**
     * DSP竞价失败日志
     *
     * @param param
     */
    public static void dspCompareFalseLog(JSONObject param) {
        CatUtil.log("dspCompareFalseLog");
        if (PerfTestContext.isCurrentInPerfTestMode()) {
            return;
        }
        String json = format(param);
        log(json, INNER_EXT2_LOG_COMPARE_PRICE, param.getString("time"));
    }

    /**
     * dsp 发券日志
     *
     * @param param
     */
    public static void launchLog(JSONObject param) {
        CatUtil.log("dspLaunchAdvert");
        if (PerfTestContext.isCurrentInPerfTestMode()) {
            return;
        }
        String json = format(param);
        log(json, INNER_EXT2_LOG_LAUNCH, param.getString("time"));
    }


    /**
     * dsp adx曝光日志
     *
     * @param param
     */
    public static void exposureLog(JSONObject param) {
        CatUtil.log("dspExposureAdvert");
        if (PerfTestContext.isCurrentInPerfTestMode()) {
            return;
        }
        String json = format(param);
        log(json, INNER_EXT2_LOG_EXPOSURE, param.getString("time"));
    }

    /**
     * dsp adx点击日志
     *
     * @param param
     */
    public static void clickLog(JSONObject param) {
        CatUtil.log("dspClickAdvert");
        if (PerfTestContext.isCurrentInPerfTestMode()) {
            return;
        }
        String json = format(param);
        log(json, INNER_EXT2_LOG_CLICK, param.getString("time"));
    }


    /**
     * dsp adx计费日志
     *
     * @param param
     */
    public static void consumeLog(JSONObject param) {
        CatUtil.log("dspConsumeAdvert");
        if (PerfTestContext.isCurrentInPerfTestMode()) {
            return;
        }
        String json = format(param);
        log(json, INNER_EXT2_LOG_CONSUME, param.getString("time"));
    }

    /**
     * dsp 获取结果超时
     *
     * @param param
     */
    public static void timeOutLog(JSONObject param) {
        CatUtil.log("dspTimeOutAdvert");
        if (PerfTestContext.isCurrentInPerfTestMode()) {
            return;
        }
        String json = format(param);
        log(json, INNER_EXT2_LOG_TIME_OUT, param.getString("time"));
    }


}
