package cn.com.duiba.tuia.log;

import cn.com.duiba.boot.perftest.PerfTestContext;
import cn.com.duiba.tuia.domain.vo.SimilarAdvertLogVO;
import cn.com.duiba.wolf.utils.DateUtils;

import com.alibaba.fastjson.JSONObject;

import org.apache.commons.collections.CollectionUtils;

import java.util.Date;
import java.util.List;

/**
 * Created by huangch on 2018/6/4 19:34
 * description: 相似广告统计日志
 *
 * @since JDK 1.6
 */
public class SimilarAdvertStatLog extends BaseInnerLog {

    public static void log(List<SimilarAdvertLogVO> logList) {
        if (CollectionUtils.isEmpty(logList)) {
            return;
        }
        if (PerfTestContext.isCurrentInPerfTestMode()) return;
        String json = format(logList);
        BaseInnerLog.log(json, BaseInnerLog.ADVERT_INNER_LOG_SIMILAR_ADVERT, DateUtils.getSecondStr(new Date()));
    }

    private static String format(List<SimilarAdvertLogVO> logList) {
        return JSONObject.toJSONString(logList);
    }

}
