/**
 * 文件名： StatExposureLog.java 此类描述的是： 作者: sunjiangrong 创建时间: 2016年4月26日 下午4:10:00
 */
package cn.com.duiba.tuia.log;

import cn.com.duiba.boot.perftest.PerfTestContext;
import cn.com.duiba.tuia.enums.CatGroupEnum;
import cn.com.duiba.tuia.service.filter.impl.AutoFlowbackFilterImpl;
import cn.com.duiba.tuia.tool.CatUtil;
import cn.com.tuia.advert.model.ObtainAdvertReqLogExt;
import cn.com.tuia.advert.model.SpmlogReq;

import com.alibaba.fastjson.JSONObject;

/**
 * 记录曝光日志 <功能详细描述>
 * 
 * @author: sunjiangrong
 * @创建时间: 2016年4月26日 下午4:10:00
 * @version:
 */
public final class StatExposureJsonLog  extends BaseInnerLog{
    
    public static void log(SpmlogReq req) {
        if (AutoFlowbackFilterImpl.isAutoFlowback(req.getLogExtExpMap())) {
            CatUtil.log(CatGroupEnum.CAT_108003.getCode());
        }else {
            CatUtil.log(CatGroupEnum.CAT_101_EXPOSURE.getCode());
        }
        if(PerfTestContext.isCurrentInPerfTestMode())return;
        String json = format(req);
        BaseInnerLog.log(json, BaseInnerLog.ADVERT_INNER_LOG_EXPOSURE,req.getTime());
    }

    public static void lowArpulog(SpmlogReq req) {
        CatUtil.log(CatGroupEnum.CAT_102014.getCode());
        if(PerfTestContext.isCurrentInPerfTestMode())return;
        String json = format(req);
        BaseInnerLog.log(json, BaseInnerLog.ADVERT_INNER_LOG_LOW_ARPU_EXPOSURE,req.getTime());
    }

    private static String format(SpmlogReq req) {
        return JSONObject.toJSONString(req);
    }

    /**
     * 虚拟发券曝光日志
     *
     * @param req
     */
    public static void imitateLog(SpmlogReq req) {

        // 请求数监控
        CatUtil.log(CatGroupEnum.CAT_106003.getCode());
        if(PerfTestContext.isCurrentInPerfTestMode()){
            return;
        }

        String json = format(req);
        ImitateBaseInnerLog.imitateLog(json, BaseInnerLog.ADVERT_INNER_LOG_EXPOSURE,req.getTime());
    }

}
