/**
 * 文件名： StatRequestLog.java 此类描述的是： 作者: sunjiangrong 创建时间: 2016年4月26日 上午11:48:19
 */
package cn.com.duiba.tuia.log;

import cn.com.duiba.boot.perftest.PerfTestContext;
import cn.com.duiba.tuia.enums.CatGroupEnum;
import cn.com.duiba.tuia.service.filter.impl.AutoFlowbackFilterImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import cn.com.duiba.tuia.tool.CatUtil;
import cn.com.tuia.advert.model.ObtainAdvertReq;
import cn.com.tuia.advert.model.ObtainAdvertReqLogExt;

import com.alibaba.fastjson.JSONObject;

/**
 * 发券日志记录格式 <功能详细描述>
 * 
 * @author: sunjiangrong
 * @创建时间: 2016年4月26日 上午11:48:19
 * @version:
 */
public final class StatLaunchJsonLog  extends BaseInnerLog{
    
    /** The logger. */
    private static Logger log = LoggerFactory.getLogger(StatLaunchJsonLog.class);


    public static void log(ObtainAdvertReqLogExt reqLogExt) {

        if (AutoFlowbackFilterImpl.isAutoFlowback(reqLogExt.getLogExtExpMap())) {
            CatUtil.log(CatGroupEnum.CAT_108002.getCode());
        }else {
            CatUtil.log(CatGroupEnum.CAT_101_LAUNCH.getCode());
        }
        if(PerfTestContext.isCurrentInPerfTestMode())return;
        setSlotIdToNull(reqLogExt);
        String json = format(reqLogExt);
        log.info(json);
        BaseInnerLog.log(json, BaseInnerLog.ADVERT_INNER_LOG_LAUNCH,reqLogExt.getTime());
    }

    public static void lowArpulog(ObtainAdvertReqLogExt reqLogExt) {
        CatUtil.log(CatGroupEnum.CAT_102015.getCode());
        if(PerfTestContext.isCurrentInPerfTestMode())return;
        setSlotIdToNull(reqLogExt);
        String json = format(reqLogExt);
        log.info(json);
        BaseInnerLog.log(json, BaseInnerLog.ADVERT_INNER_LOG_LOW_ARPU_LAUNCH,reqLogExt.getTime());
    }


    private static String format(ObtainAdvertReqLogExt reqLogExt) {
        return JSONObject.toJSONString(reqLogExt);
    }

    /**
     * 虚拟发券请求日志
     *
     * @param reqLogExt
     */
    public static void imitateLog(ObtainAdvertReqLogExt reqLogExt) {

        // 请求数监控
        CatUtil.log(CatGroupEnum.CAT_106001.getCode());
        if(PerfTestContext.isCurrentInPerfTestMode()){
            return;
        }

        setSlotIdToNull(reqLogExt);
        String json = format(reqLogExt);
        log.info(json);
        ImitateBaseInnerLog.imitateLog(json, BaseInnerLog.ADVERT_INNER_LOG_LAUNCH,reqLogExt.getTime());
    }
}
